/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFluid;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import powercrystals.core.position.Area;
import powercrystals.core.position.BlockPosition;
import powercrystals.minefactoryreloaded.api.IUpgrade;
import powercrystals.minefactoryreloaded.core.FluidFillingManager;
import powercrystals.minefactoryreloaded.core.HarvestAreaManager;
import powercrystals.minefactoryreloaded.core.IHarvestManager;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiUpgradable;
import powercrystals.minefactoryreloaded.gui.container.ContainerFountain;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityFountain
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    private IHarvestManager _fillingManager;

    public TileEntityFountain() {
        super(Machine.Fountain);
        this._areaManager = new HarvestAreaManager(this, 0, 0, 0, 1.0f, false);
        this._areaManager.setOverrideDirection(ForgeDirection.UP);
        this._areaManager.setUpgradeVertical(true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiUpgradable(this.getContainer(inventoryPlayer), (TileEntityFactoryPowered)this);
    }

    @Override
    public ContainerFountain getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerFountain(this, inventoryPlayer);
    }

    @Override
    protected boolean activateMachine() {
        int n = 5;
        if (this._tanks[0].getFluidAmount() >= 1000 && this._tanks[0].getFluid().getFluid().canBePlacedInWorld()) {
            BlockPosition blockPosition;
            int n2 = this.field_70329_l;
            int n3 = this.field_70330_m + 1;
            int n4 = this.field_70327_n;
            if (this._fillingManager != null) {
                if (this._fillingManager.getIsDone()) {
                    this.onFactoryInventoryChanged();
                }
                blockPosition = this._fillingManager.getNextBlock();
                n2 = blockPosition.x;
                n3 = blockPosition.y;
                n4 = blockPosition.z;
                this._fillingManager.moveNext();
            }
            if (!((blockPosition = Block.field_71973_m[this.field_70331_k.func_72798_a(n2, n3, n4)]) != null && !blockPosition.isBlockReplaceable(this.field_70331_k, n2, n3, n4) || blockPosition != null && blockPosition.field_72018_cp.func_76224_d() && (!(blockPosition instanceof BlockFluidClassic) ? blockPosition instanceof BlockFluid && this.field_70331_k.func_72805_g(n2, n3, n4) == 0 : ((BlockFluidClassic)blockPosition).isSourceBlock((IBlockAccess)this.field_70331_k, n2, n3, n4)))) {
                int n5 = this._tanks[0].getFluid().getFluid().getBlockID();
                if (n5 > 0 && this.field_70331_k.func_94575_c(n2, n3, n4, n5)) {
                    this.field_70331_k.func_72821_m(n2, n3, n4, n5);
                    this.drain(this._tanks[0], 1000, true);
                    this.setIdleTicks(1);
                    return true;
                }
            }
        } else if (this._fillingManager != null) {
            this._fillingManager.free();
        } else {
            n = this.getIdleTicksMax();
        }
        this.setIdleTicks(n);
        return false;
    }

    @Override
    protected FluidTank[] createTanks() {
        return new FluidTank[]{new FluidTank(32000)};
    }

    @Override
    public void onFactoryInventoryChanged() {
        if (this._inventory[0] != null && this._inventory[0].func_77973_b() instanceof IUpgrade) {
            int n;
            IUpgrade iUpgrade = (IUpgrade)this._inventory[0].func_77973_b();
            if (iUpgrade.isApplicableFor(IUpgrade.UpgradeType.RADIUS, this._inventory[0]) && (n = iUpgrade.getUpgradeLevel(IUpgrade.UpgradeType.RADIUS, this._inventory[0])) > 0) {
                this._areaManager.setUpgradeLevel(n);
                Area area = new Area(new BlockPosition(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n), n, 0, n * 2);
                if (this._fillingManager == null) {
                    this._fillingManager = new FluidFillingManager(this.field_70331_k, area);
                } else {
                    this._fillingManager.reset(this.field_70331_k, area, null);
                }
            }
        } else {
            this._fillingManager = null;
        }
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack != null) {
            for (FluidTank fluidTank : (FluidTank[])this.getTanks()) {
                if (fluidTank.getFluidAmount() != 0 && !fluidStack.isFluidEqual(fluidTank.getFluid())) continue;
                return fluidTank.fill(fluidStack, bl);
            }
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        for (FluidTank fluidTank : (FluidTank[])this.getTanks()) {
            if (fluidTank.getFluidAmount() <= 0) continue;
            return fluidTank.drain(n, bl);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack != null) {
            for (FluidTank fluidTank : (FluidTank[])this.getTanks()) {
                if (!fluidStack.isFluidEqual(fluidTank.getFluid())) continue;
                return fluidTank.drain(fluidStack.amount, bl);
            }
        }
        return null;
    }

    @Override
    public boolean allowBucketDrain() {
        return true;
    }

    @Override
    public boolean allowBucketFill() {
        return true;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public int func_70302_i_() {
        return 1;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 10;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        if (itemStack != null && n == 0) {
            return itemStack.func_77973_b() instanceof IUpgrade;
        }
        return false;
    }
}

