/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.util.UtilInventory;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;
import powercrystals.minefactoryreloaded.core.BlockNBTManager;
import powercrystals.minefactoryreloaded.gui.client.GuiDeepStorageUnit;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerDeepStorageUnit;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryInventory;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public class TileEntityDeepStorageUnit
extends TileEntityFactoryInventory
implements IDeepStorageUnit {
    private int _storedQuantity;
    private ItemStack _storedItem = null;
    private boolean _ignoreChanges = true;
    private boolean _shouldTick = true;

    public TileEntityDeepStorageUnit() {
        super(Machine.DeepStorageUnit);
        this.setManageSolids(true);
    }

    @Override
    public void func_70312_q() {
        super.func_70312_q();
        this._ignoreChanges = false;
    }

    @Override
    public void func_70313_j() {
        super.func_70313_j();
        this._ignoreChanges = true;
    }

    @Override
    protected void writeItemNBT(NBTTagCompound nBTTagCompound) {
        if (this.getQuantityAdjusted() > 0) {
            BlockNBTManager.setForBlock(this);
        } else {
            super.writeItemNBT(nBTTagCompound);
        }
    }

    @Override
    public boolean shouldDropSlotWhenBroken(int n) {
        return n < 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiDeepStorageUnit((ContainerFactoryInventory)this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerDeepStorageUnit getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerDeepStorageUnit(this, inventoryPlayer);
    }

    public int getQuantity() {
        return this._storedQuantity;
    }

    public int getQuantityAdjusted() {
        int n = this._storedQuantity;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this._inventory[i] != null && this._storedQuantity == 0) {
                n += this._inventory[i].field_77994_a;
                continue;
            }
            if (this._inventory[i] == null || !UtilInventory.stacksEqual((ItemStack)this._storedItem, (ItemStack)this._inventory[i])) continue;
            n += this._inventory[i].field_77994_a;
        }
        return n;
    }

    public void setQuantity(int n) {
        this._storedQuantity = n;
    }

    public void clearSlots() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this._inventory[i] = null;
        }
    }

    @Override
    public ForgeDirection getDropDirection() {
        return ForgeDirection.UP;
    }

    public boolean func_70309_m() {
        return this._shouldTick & this.field_70331_k != null;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        this._shouldTick = false;
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        this.onFactoryInventoryChanged();
    }

    @Override
    protected void onFactoryInventoryChanged() {
        if (this._ignoreChanges | this.field_70331_k == null || this.field_70331_k.field_72995_K) {
            return;
        }
        if (this._inventory[2] == null & this._storedItem != null & this._storedQuantity == 0) {
            this._storedItem = null;
        }
        this.checkInput(0);
        this.checkInput(1);
        if (this._inventory[2] == null & this._storedItem != null) {
            this._inventory[2] = this._storedItem.func_77946_l();
            this._inventory[2].field_77994_a = Math.min(this._storedQuantity, Math.min(this._storedItem.func_77976_d(), this.func_70297_j_()));
            this._storedQuantity -= this._inventory[2].field_77994_a;
        } else if (this._inventory[2] != null & this._storedQuantity > 0 && this._inventory[2].field_77994_a < this._inventory[2].func_77976_d() && UtilInventory.stacksEqual((ItemStack)this._storedItem, (ItemStack)this._inventory[2])) {
            int n = Math.min(this._inventory[2].func_77976_d() - this._inventory[2].field_77994_a, this._storedQuantity);
            this._inventory[2].field_77994_a += n;
            this._storedQuantity -= n;
        }
    }

    private void checkInput(int n) {
        if (this._inventory[n] != null) {
            if (this._storedQuantity == 0 && (this._storedItem == null || UtilInventory.stacksEqual((ItemStack)this._inventory[n], (ItemStack)this._storedItem))) {
                this._storedItem = this._inventory[n].func_77946_l();
                this._storedItem.field_77994_a = 1;
                this._storedQuantity = this._inventory[n].field_77994_a;
                this._inventory[n] = null;
            } else if (UtilInventory.stacksEqual((ItemStack)this._inventory[n], (ItemStack)this._storedItem) && this.getMaxStoredCount() - this._storedItem.func_77976_d() - this._inventory[n].field_77994_a > this._storedQuantity) {
                this._storedQuantity += this._inventory[n].field_77994_a;
                this._inventory[n] = null;
            } else {
                this._inventory[n] = !UtilInventory.stacksEqual((ItemStack)this._inventory[n], (ItemStack)this._storedItem) ? UtilInventory.dropStack((TileEntity)this, (ItemStack)this._inventory[n], (ForgeDirection)this.getDropDirection()) : UtilInventory.dropStack((TileEntity)this, (ItemStack)this._inventory[n], (ForgeDirection)this.getDropDirection());
            }
        }
    }

    public int func_70302_i_() {
        return 3;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return entityPlayer.func_70092_e((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n) <= 64.0;
    }

    @Override
    public int getStartInventorySide(ForgeDirection forgeDirection) {
        return 0;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection forgeDirection) {
        return this.func_70302_i_();
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        if (n >= 2) {
            return false;
        }
        ItemStack itemStack2 = this._storedItem;
        if (itemStack2 == null) {
            itemStack2 = this._inventory[2];
        }
        return itemStack2 == null || UtilInventory.stacksEqual((ItemStack)itemStack2, (ItemStack)itemStack);
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return true;
    }

    @Override
    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        int n = 0;
        ItemStack itemStack = this._inventory[2];
        if (itemStack != null) {
            n = itemStack.field_77994_a;
            this._inventory[2] = null;
        }
        super.func_70310_b(nBTTagCompound);
        this._inventory[2] = itemStack;
        if (this._storedItem != null) {
            nBTTagCompound.func_74766_a("storedStack", this._storedItem.func_77955_b(new NBTTagCompound()));
            nBTTagCompound.func_74768_a("storedQuantity", this._storedQuantity + n);
        } else {
            nBTTagCompound.func_74768_a("storedQuantity", 0);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        this._ignoreChanges = true;
        super.func_70307_a(nBTTagCompound);
        this._storedQuantity = nBTTagCompound.func_74762_e("storedQuantity");
        this._storedItem = null;
        if (nBTTagCompound.func_74764_b("storedId")) {
            if (this._storedQuantity != 0) {
                int n = nBTTagCompound.func_74762_e("storedId");
                if (n < Item.field_77698_e.length && Item.field_77698_e[n] != null) {
                    this._storedItem = new ItemStack(n, 1, nBTTagCompound.func_74762_e("storedMeta"));
                }
            } else if (this._inventory[2] != null) {
                this._storedItem = this._inventory[2].func_77946_l();
                this._storedItem.field_77994_a = 1;
            }
            nBTTagCompound.func_82580_o("storedId");
            nBTTagCompound.func_82580_o("storedMeta");
        } else if (nBTTagCompound.func_74764_b("storedStack")) {
            this._storedItem = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)nBTTagCompound.func_74781_a("storedStack")));
        }
        if (this._storedItem == null & this._storedQuantity > 0) {
            this._storedQuantity = 0;
        }
        this._ignoreChanges = false;
    }

    @Override
    public ItemStack getStoredItemType() {
        int n = this.getQuantityAdjusted();
        if (n != 0 & this._storedItem != null) {
            ItemStack itemStack = this._storedItem.func_77946_l();
            itemStack.field_77994_a = n;
            return itemStack;
        }
        return null;
    }

    @Override
    public void setStoredItemCount(int n) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!UtilInventory.stacksEqual((ItemStack)this._inventory[i], (ItemStack)this._storedItem)) continue;
            if (n == 0) {
                this._inventory[i] = null;
                continue;
            }
            if (n >= this._inventory[i].field_77994_a) {
                n -= this._inventory[i].field_77994_a;
                continue;
            }
            if (n >= this._inventory[i].field_77994_a) continue;
            this._inventory[i].field_77994_a = n;
            n = 0;
        }
        this._storedQuantity = n;
        this.func_70296_d();
    }

    @Override
    public void setStoredItemType(ItemStack itemStack, int n) {
        this.clearSlots();
        this._storedQuantity = n;
        this._storedItem = null;
        if (itemStack == null) {
            return;
        }
        this._storedItem = itemStack.func_77946_l();
        this._storedItem.field_77994_a = 1;
        this.func_70296_d();
    }

    @Override
    public int getMaxStoredCount() {
        return Integer.MAX_VALUE;
    }
}

