/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.render.block;

import codechicken.lib.lighting.LightModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.render.IconTransformation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import java.io.InputStream;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.rednet.RedNetConnectionType;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetCable;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetEnergy;

public class RedNetCableRenderer
implements ISimpleBlockRenderingHandler {
    protected static CCModel base;
    protected static CCModel cage;
    protected static CCModel[] cable;
    protected static CCModel[] iface;
    protected static CCModel[] band;
    protected static CCModel[] plate;
    protected static CCModel[] platef;
    protected static CCModel[] grip;
    protected static CCModel[] wire;
    protected static CCModel[] caps;
    public static IUVTransformation uvt;
    public static boolean brightBand;

    private static void calculateNormals(CCModel[] cCModelArray) {
        for (CCModel cCModel : cCModelArray) {
            RedNetCableRenderer.compute(cCModel);
        }
    }

    private static void compute(CCModel cCModel) {
        cCModel.computeNormals();
        cCModel.apply((Transformation)new Translation(0.5, 0.5, 0.5));
        cCModel.computeLighting(LightModel.standardLightModel);
    }

    public static void updateUVT(Icon icon) {
        uvt = new IconTransformation(icon);
        brightBand = MFRConfig.brightRednetBand.getBoolean(true);
    }

    public void renderInventoryBlock(Block block, int n, int n2, RenderBlocks renderBlocks) {
        CCRenderState.reset();
        CCRenderState.useNormals((boolean)true);
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        base.render(null, uvt);
        cable[2].render(null, uvt);
        cable[3].render(null, uvt);
        if (n == 3 | n == 2) {
            cage.render(null, uvt);
            wire[2].render(null, uvt);
            wire[3].render(null, uvt);
            caps[2].render(null, uvt);
            caps[3].render(null, uvt);
        }
        tessellator.func_78381_a();
    }

    public boolean renderWorldBlock(IBlockAccess iBlockAccess, int n, int n2, int n3, Block block, int n4, RenderBlocks renderBlocks) {
        CCRenderState.reset();
        CCRenderState.useNormals((boolean)true);
        CCRenderState.useModelColours((boolean)true);
        TileEntityRedNetCable tileEntityRedNetCable = (TileEntityRedNetCable)iBlockAccess.func_72796_p(n, n2, n3);
        TileEntityRedNetEnergy tileEntityRedNetEnergy = null;
        int n5 = block.func_71874_e(iBlockAccess, n, n2, n3);
        int n6 = brightBand ? 0xD00070 : n5;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        tessellator.func_78380_c(n5);
        Translation translation = new Translation(new Vector3((double)n, (double)n2, (double)n3));
        base.render((Transformation)translation, uvt);
        if (tileEntityRedNetCable instanceof TileEntityRedNetEnergy) {
            cage.render((Transformation)translation, uvt);
            tileEntityRedNetEnergy = (TileEntityRedNetEnergy)tileEntityRedNetCable;
        }
        for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
            int n7 = forgeDirection.ordinal();
            RedNetConnectionType redNetConnectionType = tileEntityRedNetCable.getConnectionState(forgeDirection);
            switch (redNetConnectionType.flags & 0x1F) {
                case 11: {
                    tessellator.func_78380_c(n6);
                    band[n7].setColour(tileEntityRedNetCable.getSideColorValue(forgeDirection));
                    band[n7].render((Transformation)translation, uvt);
                    tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                    tessellator.func_78380_c(n5);
                }
                case 19: {
                    if (redNetConnectionType.isSingleSubnet) {
                        iface[n7].render((Transformation)translation, uvt);
                        grip[n7].render((Transformation)translation, uvt);
                        break;
                    }
                    cable[n7].render((Transformation)translation, uvt);
                    break;
                }
                case 13: {
                    tessellator.func_78380_c(n6);
                    band[n7].setColour(tileEntityRedNetCable.getSideColorValue(forgeDirection));
                    band[n7].render((Transformation)translation, uvt);
                    platef[n7].setColour(tileEntityRedNetCable.getSideColorValue(forgeDirection));
                    platef[n7].render((Transformation)translation, uvt);
                    tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                    tessellator.func_78380_c(n5);
                }
                case 21: {
                    iface[n7].render((Transformation)translation, uvt);
                    plate[n7].render((Transformation)translation, uvt);
                    if (!redNetConnectionType.isAllSubnets) break;
                    platef[n7].setColour(-1);
                    platef[n7].render((Transformation)translation, uvt);
                }
            }
            if (tileEntityRedNetEnergy == null || !tileEntityRedNetEnergy.isInterfacing(forgeDirection)) continue;
            wire[n7].render((Transformation)translation, uvt);
            if (tileEntityRedNetEnergy.interfaceMode(forgeDirection) == 4) continue;
            caps[n7].render((Transformation)translation, uvt);
        }
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return MineFactoryReloadedCore.renderIdRedNet;
    }

    static {
        cable = new CCModel[6];
        iface = new CCModel[6];
        band = new CCModel[6];
        plate = new CCModel[6];
        platef = new CCModel[6];
        grip = new CCModel[6];
        wire = new CCModel[6];
        caps = new CCModel[6];
        try {
            Map map = CCModel.parseObjModels((InputStream)MineFactoryReloadedCore.class.getResourceAsStream("/powercrystals/minefactoryreloaded/models/RedNetCable.obj"), (int)7, (Transformation)new Scale(0.0625));
            Vector3 vector3 = new Vector3(0.0, 0.0, 0.0);
            base = ((CCModel)map.get("base")).backfacedCopy();
            RedNetCableRenderer.compute(base);
            cage = ((CCModel)map.get("cage")).backfacedCopy();
            RedNetCableRenderer.compute(cage);
            RedNetCableRenderer.cable[5] = ((CCModel)map.get("cable")).backfacedCopy();
            CCModel.generateSidedModels((CCModel[])cable, (int)5, (Vector3)vector3);
            RedNetCableRenderer.calculateNormals(cable);
            RedNetCableRenderer.iface[5] = ((CCModel)map.get("interface")).backfacedCopy();
            CCModel.generateSidedModels((CCModel[])iface, (int)5, (Vector3)vector3);
            RedNetCableRenderer.calculateNormals(iface);
            RedNetCableRenderer.band[5] = ((CCModel)map.get("band")).backfacedCopy();
            CCModel.generateSidedModels((CCModel[])band, (int)5, (Vector3)vector3);
            RedNetCableRenderer.calculateNormals(band);
            RedNetCableRenderer.plate[5] = ((CCModel)map.get("plate")).backfacedCopy();
            CCModel.generateSidedModels((CCModel[])plate, (int)5, (Vector3)vector3);
            RedNetCableRenderer.calculateNormals(plate);
            RedNetCableRenderer.platef[5] = ((CCModel)map.get("plateface")).backfacedCopy();
            CCModel.generateSidedModels((CCModel[])platef, (int)5, (Vector3)vector3);
            RedNetCableRenderer.calculateNormals(platef);
            RedNetCableRenderer.grip[5] = ((CCModel)map.get("grip")).backfacedCopy();
            CCModel.generateSidedModels((CCModel[])grip, (int)5, (Vector3)vector3);
            RedNetCableRenderer.calculateNormals(grip);
            RedNetCableRenderer.wire[5] = ((CCModel)map.get("wire")).backfacedCopy();
            CCModel.generateSidedModels((CCModel[])wire, (int)5, (Vector3)vector3);
            RedNetCableRenderer.calculateNormals(wire);
            RedNetCableRenderer.caps[5] = ((CCModel)map.get("cap")).backfacedCopy();
            CCModel.generateSidedModels((CCModel[])caps, (int)5, (Vector3)vector3);
            RedNetCableRenderer.calculateNormals(caps);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

