/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.pam;

import cpw.mods.fml.common.FMLLog;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;
import powercrystals.minefactoryreloaded.api.IFactoryPlantable;
import powercrystals.minefactoryreloaded.modhelpers.pam.Pam;

public class PlantablePamCrop
implements IFactoryPlantable {
    protected int _blockId;
    protected int _itemId;
    protected int _plantableBlockId;
    protected int _cropId;
    protected Method _setCrop;
    protected Method _setStage;

    public PlantablePamCrop(int n, int n2, int n3) throws NoSuchMethodException, ClassNotFoundException {
        this(n, n2, n3, Block.field_72050_aA.field_71990_ca);
    }

    public PlantablePamCrop(int n, int n2, int n3, int n4) throws NoSuchMethodException, ClassNotFoundException {
        this._blockId = n;
        this._itemId = n2;
        this._plantableBlockId = n4;
        this._cropId = n3;
        this._setCrop = Pam.pamTESetCropId;
        this._setStage = Pam.pamTESetGrowthStage;
    }

    @Override
    public int getSeedId() {
        return this._itemId;
    }

    @Override
    public int getPlantedBlockId(World world, int n, int n2, int n3, ItemStack itemStack) {
        return this._blockId;
    }

    @Override
    public int getPlantedBlockMetadata(World world, int n, int n2, int n3, ItemStack itemStack) {
        return 0;
    }

    @Override
    public boolean canBePlantedHere(World world, int n, int n2, int n3, ItemStack itemStack) {
        int n4 = world.func_72798_a(n, n2 - 1, n3);
        if (!world.func_72799_c(n, n2, n3)) {
            return false;
        }
        return n4 == Block.field_71979_v.field_71990_ca || n4 == Block.field_71980_u.field_71990_ca || n4 == Block.field_72050_aA.field_71990_ca || Block.field_71973_m[this._blockId] instanceof IPlantable && Block.field_71973_m[n4] != null && Block.field_71973_m[n4].canSustainPlant(world, n, n2, n3, ForgeDirection.UP, (IPlantable)Block.field_71973_m[this._blockId]);
    }

    @Override
    public void prePlant(World world, int n, int n2, int n3, ItemStack itemStack) {
        int n4 = world.func_72798_a(n, n2 - 1, n3);
        if (n4 == Block.field_71979_v.field_71990_ca || n4 == Block.field_71980_u.field_71990_ca) {
            world.func_94575_c(n, n2 - 1, n3, Block.field_72050_aA.field_71990_ca);
        }
    }

    @Override
    public void postPlant(World world, int n, int n2, int n3, ItemStack itemStack) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        try {
            if (tileEntity != null) {
                this._setCrop.invoke((Object)tileEntity, this._cropId);
                this._setStage.invoke((Object)tileEntity, 0);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            FMLLog.warning((String)"Error with planting a crop from Pams mods", (Object[])new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FMLLog.warning((String)"Error with planting a crop from Pams mods, this should not happen", (Object[])new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            FMLLog.warning((String)"Error with planting a crop from Pams mods,this should not happen", (Object[])new Object[0]);
        }
    }
}

