/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.power;

import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.power.IPowerReceptor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;

public final class PowerHandler {
    public static final PerditionCalculator DEFAULT_PERDITION = new PerditionCalculator();
    private float minEnergyReceived;
    private float maxEnergyReceived;
    private float maxEnergyStored;
    private float activationEnergy;
    private float energyStored = 0.0f;
    private final SafeTimeTracker doWorkTracker = new SafeTimeTracker();
    private final SafeTimeTracker sourcesTracker = new SafeTimeTracker();
    private final SafeTimeTracker perditionTracker = new SafeTimeTracker();
    public final int[] powerSources = new int[6];
    public final IPowerReceptor receptor;
    private PerditionCalculator perdition;
    private final PowerReceiver receiver;
    private final Type type;

    public PowerHandler(IPowerReceptor iPowerReceptor, Type type) {
        this.receptor = iPowerReceptor;
        this.type = type;
        this.receiver = new PowerReceiver();
        this.perdition = DEFAULT_PERDITION;
    }

    public PowerReceiver getPowerReceiver() {
        return this.receiver;
    }

    public float getMinEnergyReceived() {
        return this.minEnergyReceived;
    }

    public float getMaxEnergyReceived() {
        return this.maxEnergyReceived;
    }

    public float getMaxEnergyStored() {
        return this.maxEnergyStored;
    }

    public float getActivationEnergy() {
        return this.activationEnergy;
    }

    public float getEnergyStored() {
        return this.energyStored;
    }

    public void configure(float f, float f2, float f3, float f4) {
        if (f > f2) {
            f2 = f;
        }
        this.minEnergyReceived = f;
        this.maxEnergyReceived = f2;
        this.maxEnergyStored = f4;
        this.activationEnergy = f3;
    }

    public void configurePowerPerdition(int n, int n2) {
        if (n == 0 || n2 == 0) {
            this.perdition = new PerditionCalculator(0.0f);
            return;
        }
        this.perdition = new PerditionCalculator((float)n / (float)n2);
    }

    public void setPerdition(PerditionCalculator perditionCalculator) {
        if (perditionCalculator == null) {
            perditionCalculator = DEFAULT_PERDITION;
        }
        this.perdition = perditionCalculator;
    }

    public PerditionCalculator getPerdition() {
        if (this.perdition == null) {
            return DEFAULT_PERDITION;
        }
        return this.perdition;
    }

    public void update() {
        this.applyPerdition();
        this.applyWork();
        this.validateEnergy();
    }

    private void applyPerdition() {
        if (this.perditionTracker.markTimeIfDelay(this.receptor.getWorld(), 1L) && this.energyStored > 0.0f) {
            float f = this.getPerdition().applyPerdition(this, this.energyStored, this.perditionTracker.durationOfLastDelay());
            this.energyStored = f == 0.0f || f < this.energyStored ? f : DEFAULT_PERDITION.applyPerdition(this, this.energyStored, this.perditionTracker.durationOfLastDelay());
            this.validateEnergy();
        }
    }

    private void applyWork() {
        if (this.energyStored >= this.activationEnergy && this.doWorkTracker.markTimeIfDelay(this.receptor.getWorld(), 1L)) {
            this.receptor.doWork(this);
        }
    }

    private void updateSources(ForgeDirection forgeDirection) {
        if (this.sourcesTracker.markTimeIfDelay(this.receptor.getWorld(), 1L)) {
            for (int i = 0; i < 6; ++i) {
                int n = i;
                this.powerSources[n] = (int)((long)this.powerSources[n] - this.sourcesTracker.durationOfLastDelay());
                if (this.powerSources[i] >= 0) continue;
                this.powerSources[i] = 0;
            }
        }
        if (forgeDirection != null) {
            this.powerSources[forgeDirection.ordinal()] = 10;
        }
    }

    public float useEnergy(float f, float f2, boolean bl) {
        this.applyPerdition();
        float f3 = 0.0f;
        if (this.energyStored >= f) {
            if (this.energyStored <= f2) {
                f3 = this.energyStored;
                if (bl) {
                    this.energyStored = 0.0f;
                }
            } else {
                f3 = f2;
                if (bl) {
                    this.energyStored -= f2;
                }
            }
        }
        this.validateEnergy();
        return f3;
    }

    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        this.readFromNBT(nBTTagCompound, "powerProvider");
    }

    public void readFromNBT(NBTTagCompound nBTTagCompound, String string) {
        NBTTagCompound nBTTagCompound2 = nBTTagCompound.func_74775_l(string);
        this.energyStored = nBTTagCompound2.func_74760_g("storedEnergy");
    }

    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        this.writeToNBT(nBTTagCompound, "powerProvider");
    }

    public void writeToNBT(NBTTagCompound nBTTagCompound, String string) {
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        nBTTagCompound2.func_74776_a("storedEnergy", this.energyStored);
        nBTTagCompound.func_74766_a(string, nBTTagCompound2);
    }

    public float addEnergy(float f) {
        this.energyStored += f;
        if (this.energyStored > this.maxEnergyStored) {
            f -= this.energyStored - this.maxEnergyStored;
            this.energyStored = this.maxEnergyStored;
        } else if (this.energyStored < 0.0f) {
            f -= this.energyStored;
            this.energyStored = 0.0f;
        }
        this.applyPerdition();
        return f;
    }

    public void setEnergy(float f) {
        this.energyStored = f;
        this.validateEnergy();
    }

    public boolean isPowerSource(ForgeDirection forgeDirection) {
        return this.powerSources[forgeDirection.ordinal()] != 0;
    }

    private void validateEnergy() {
        if (this.energyStored < 0.0f) {
            this.energyStored = 0.0f;
        }
        if (this.energyStored > this.maxEnergyStored) {
            this.energyStored = this.maxEnergyStored;
        }
    }

    public final class PowerReceiver {
        private PowerReceiver() {
        }

        public float getMinEnergyReceived() {
            return PowerHandler.this.minEnergyReceived;
        }

        public float getMaxEnergyReceived() {
            return PowerHandler.this.maxEnergyReceived;
        }

        public float getMaxEnergyStored() {
            return PowerHandler.this.maxEnergyStored;
        }

        public float getActivationEnergy() {
            return PowerHandler.this.activationEnergy;
        }

        public float getEnergyStored() {
            return PowerHandler.this.energyStored;
        }

        public Type getType() {
            return PowerHandler.this.type;
        }

        public void update() {
            PowerHandler.this.update();
        }

        public float powerRequest() {
            this.update();
            return Math.min(PowerHandler.this.maxEnergyReceived, PowerHandler.this.maxEnergyStored - PowerHandler.this.energyStored);
        }

        public float receiveEnergy(Type type, float f, ForgeDirection forgeDirection) {
            float f2 = f;
            if (type == Type.ENGINE) {
                if (f2 < PowerHandler.this.minEnergyReceived) {
                    return 0.0f;
                }
                if (f2 > PowerHandler.this.maxEnergyReceived) {
                    f2 = PowerHandler.this.maxEnergyReceived;
                }
            }
            PowerHandler.this.updateSources(forgeDirection);
            f2 -= f2 * PowerHandler.this.getPerdition().getTaxPercent();
            f2 = PowerHandler.this.addEnergy(f2);
            PowerHandler.this.applyWork();
            if (type == Type.ENGINE && PowerHandler.this.type.eatsEngineExcess()) {
                return Math.min(f, PowerHandler.this.maxEnergyReceived);
            }
            return f2;
        }
    }

    public static class PerditionCalculator {
        public static final float DEFAULT_POWERLOSS = 1.0f;
        public static final float MIN_POWERLOSS = 0.01f;
        private final float powerLoss;

        public PerditionCalculator() {
            this.powerLoss = 1.0f;
        }

        public PerditionCalculator(float f) {
            if (f < 0.01f) {
                f = 0.01f;
            }
            this.powerLoss = f;
        }

        public float applyPerdition(PowerHandler powerHandler, float f, long l) {
            if ((f -= this.powerLoss * (float)l) < 0.0f) {
                f = 0.0f;
            }
            return f;
        }

        public float getTaxPercent() {
            return 0.0f;
        }
    }

    public static enum Type {
        ENGINE,
        GATE,
        MACHINE,
        PIPE,
        STORAGE;


        public boolean canReceiveFromPipes() {
            switch (this) {
                case MACHINE: 
                case STORAGE: {
                    return true;
                }
            }
            return false;
        }

        public boolean eatsEngineExcess() {
            switch (this) {
                case MACHINE: 
                case STORAGE: {
                    return true;
                }
            }
            return false;
        }
    }
}

