/*
 * Decompiled with CFR 0.152.
 */
package appeng.tech1.block;

import appeng.common.AppEng;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngMultiBlock;
import appeng.common.base.AppEngSubBlock;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockQuartzGlass
extends AppEngSubBlock {
    public BlockQuartzGlass(AppEngMultiBlock mb) {
        super(mb, true);
        this.unlocalizedName = "QuartzGlass";
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public void onNeighborBlockChange(World w, int x, int y, int z, int blockid) {
        if (Platform.isClient()) {
            w.func_72845_h(x, y, z);
        }
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    @Override
    public Icon getBlockTextureFromSide(int side) {
        return AppEngTextureRegistry.Blocks.BlockQuartzGlass.get();
    }

    @Override
    public boolean hasSpecialRender() {
        return true;
    }

    boolean isFlush(IBlockAccess world, int x, int y, int z) {
        return this.isGlass(world, x, y, z);
    }

    boolean isGlass(IBlockAccess world, int x, int y, int z) {
        if (world.func_72798_a(x, y, z) == this.imb.field_71990_ca) {
            int meta = world.func_72805_g(x, y, z);
            return meta == AppEng.getInstance().registration.blkQuartzGlass.metaData || meta == AppEng.getInstance().registration.blkQuartzLamp.metaData;
        }
        return false;
    }

    void renderEdge(IBlockAccess world, int x, int y, int z, RenderBlocks renderer, ForgeDirection side, ForgeDirection direction) {
        if (!this.isFlush(world, x + side.offsetX, y + side.offsetY, z + side.offsetZ) && !this.isFlush(world, x + direction.offsetX, y + direction.offsetY, z + direction.offsetZ)) {
            float minX = 0.5f + (float)(side.offsetX + direction.offsetX) / 2.0f;
            float minY = 0.5f + (float)(side.offsetY + direction.offsetY) / 2.0f;
            float minZ = 0.5f + (float)(side.offsetZ + direction.offsetZ) / 2.0f;
            float maxX = 0.5f + (float)(side.offsetX + direction.offsetX) / 2.0f;
            float maxY = 0.5f + (float)(side.offsetY + direction.offsetY) / 2.0f;
            float maxZ = 0.5f + (float)(side.offsetZ + direction.offsetZ) / 2.0f;
            if (0 == side.offsetX && 0 == direction.offsetX) {
                minX = 0.0f;
                maxX = 1.0f;
            }
            if (0 == side.offsetY && 0 == direction.offsetY) {
                minY = 0.0f;
                maxY = 1.0f;
            }
            if (0 == side.offsetZ && 0 == direction.offsetZ) {
                minZ = 0.0f;
                maxZ = 1.0f;
            }
            if (maxX <= 0.001f) {
                maxX += 0.05625f;
            }
            if (maxY <= 0.001f) {
                maxY += 0.05625f;
            }
            if (maxZ <= 0.001f) {
                maxZ += 0.05625f;
            }
            if (minX >= 0.999f) {
                minX -= 0.05625f;
            }
            if (minY >= 0.999f) {
                minY -= 0.05625f;
            }
            if (minZ >= 0.999f) {
                minZ -= 0.05625f;
            }
            renderer.func_83020_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            switch (side) {
                case WEST: {
                    renderer.func_78573_e((Block)this.imb, (double)x, (double)y, (double)z, AppEngTextureRegistry.Blocks.BlockQuartzGlassFrame.get());
                    break;
                }
                case EAST: {
                    renderer.func_78605_f((Block)this.imb, (double)x, (double)y, (double)z, AppEngTextureRegistry.Blocks.BlockQuartzGlassFrame.get());
                    break;
                }
                case NORTH: {
                    renderer.func_78611_c((Block)this.imb, (double)x, (double)y, (double)z, AppEngTextureRegistry.Blocks.BlockQuartzGlassFrame.get());
                    break;
                }
                case SOUTH: {
                    renderer.func_78622_d((Block)this.imb, (double)x, (double)y, (double)z, AppEngTextureRegistry.Blocks.BlockQuartzGlassFrame.get());
                    break;
                }
                case DOWN: {
                    renderer.func_78613_a((Block)this.imb, (double)x, (double)y, (double)z, AppEngTextureRegistry.Blocks.BlockQuartzGlassFrame.get());
                    break;
                }
                case UP: {
                    renderer.func_78617_b((Block)this.imb, (double)x, (double)y, (double)z, AppEngTextureRegistry.Blocks.BlockQuartzGlassFrame.get());
                    break;
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean specialRenderer(IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        AppEngMultiBlock b = this.imb;
        b.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        renderer.func_83020_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        b.dontrender = new boolean[]{this.isFlush(world, x, y - 1, z), this.isFlush(world, x, y + 1, z), this.isFlush(world, x, y, z - 1), this.isFlush(world, x, y, z + 1), this.isFlush(world, x - 1, y, z), this.isFlush(world, x + 1, y, z)};
        renderer.field_78664_d = AppEngTextureRegistry.Blocks.BlockQuartzGlass.get();
        boolean result = renderer.func_78570_q((Block)b, x, y, z);
        renderer.field_78664_d = null;
        this.renderEdge(world, x, y, z, renderer, ForgeDirection.UP, ForgeDirection.EAST);
        this.renderEdge(world, x, y, z, renderer, ForgeDirection.UP, ForgeDirection.WEST);
        this.renderEdge(world, x, y, z, renderer, ForgeDirection.UP, ForgeDirection.NORTH);
        this.renderEdge(world, x, y, z, renderer, ForgeDirection.UP, ForgeDirection.SOUTH);
        this.renderEdge(world, x, y, z, renderer, ForgeDirection.DOWN, ForgeDirection.EAST);
        this.renderEdge(world, x, y, z, renderer, ForgeDirection.DOWN, ForgeDirection.WEST);
        this.renderEdge(world, x, y, z, renderer, ForgeDirection.DOWN, ForgeDirection.NORTH);
        this.renderEdge(world, x, y, z, renderer, ForgeDirection.DOWN, ForgeDirection.SOUTH);
        this.renderEdge(world, x, y, z, renderer, ForgeDirection.EAST, ForgeDirection.UP);
        this.renderEdge(world, x, y, z, renderer, ForgeDirection.EAST, ForgeDirection.DOWN);
        this.renderEdge(world, x, y, z, renderer, ForgeDirection.EAST, ForgeDirection.NORTH);
        this.renderEdge(world, x, y, z, renderer, ForgeDirection.EAST, ForgeDirection.SOUTH);
        this.renderEdge(world, x, y, z, renderer, ForgeDirection.WEST, ForgeDirection.UP);
        this.renderEdge(world, x, y, z, renderer, ForgeDirection.WEST, ForgeDirection.DOWN);
        this.renderEdge(world, x, y, z, renderer, ForgeDirection.WEST, ForgeDirection.NORTH);
        this.renderEdge(world, x, y, z, renderer, ForgeDirection.WEST, ForgeDirection.SOUTH);
        this.renderEdge(world, x, y, z, renderer, ForgeDirection.NORTH, ForgeDirection.EAST);
        this.renderEdge(world, x, y, z, renderer, ForgeDirection.NORTH, ForgeDirection.WEST);
        this.renderEdge(world, x, y, z, renderer, ForgeDirection.NORTH, ForgeDirection.UP);
        this.renderEdge(world, x, y, z, renderer, ForgeDirection.NORTH, ForgeDirection.DOWN);
        this.renderEdge(world, x, y, z, renderer, ForgeDirection.SOUTH, ForgeDirection.EAST);
        this.renderEdge(world, x, y, z, renderer, ForgeDirection.SOUTH, ForgeDirection.WEST);
        this.renderEdge(world, x, y, z, renderer, ForgeDirection.SOUTH, ForgeDirection.UP);
        this.renderEdge(world, x, y, z, renderer, ForgeDirection.SOUTH, ForgeDirection.DOWN);
        b.dontrender = null;
        return result;
    }
}

