/*
 * Decompiled with CFR 0.152.
 */
package appeng.proxy;

import appeng.api.IAEItemStack;
import appeng.api.exceptions.AppEngException;
import appeng.api.me.util.IMEInventory;
import appeng.proxy.IProxyLP;
import appeng.proxy.helpers.LPInventory;
import appeng.util.AEItemStack;
import appeng.util.Platform;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeTile;
import java.util.ArrayList;
import java.util.List;
import logisticspipes.api.IRequestAPI;
import logisticspipes.api.IRoutedPowerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class ProxyLP
implements IProxyLP {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ProxyLP() throws AppEngException {
        if (!Platform.isModLoaded("BuildCraft|Core")) {
            throw new AppEngException("Buildcraft is not available.");
        }
        if (!Platform.isModLoaded("LogisticsPipes|Main")) {
            throw new AppEngException("Logistics Pipes is not available.");
        }
        try {
            if (!(this instanceof IRequestAPI)) return;
        }
        catch (NoClassDefFoundError e) {
            throw new AppEngException("Logistics Pipes API is not available.");
        }
        catch (Exception e) {
            throw new AppEngException("Logistics Pipes API is not available.");
        }
    }

    @Override
    public IMEInventory getInv(TileEntity te) {
        AEItemStack x;
        ArrayList<IAEItemStack> out = new ArrayList<IAEItemStack>();
        for (ItemStack o : this.getProvidedItems(te)) {
            for (IAEItemStack l : out) {
                if (!l.equals(o)) continue;
                l.incCountRequestable(o.field_77994_a);
                break;
            }
            x = AEItemStack.create(o);
            x.setStackSize(0L);
            x.setCountRequestable(o.field_77994_a);
            out.add(x);
        }
        for (ItemStack o : this.getCraftedItems(te)) {
            for (IAEItemStack l : out) {
                if (!l.equals(o)) continue;
                l.setCraftable(true);
                break;
            }
            x = AEItemStack.create(o);
            x.setCraftable(true);
            x.setStackSize(0L);
            out.add(x);
        }
        return new LPInventory(out, te);
    }

    @Override
    public boolean isRequestPipe(TileEntity te) {
        if (te instanceof IPipeTile) {
            return ((IPipeTile)te).getPipe() instanceof IRequestAPI;
        }
        return false;
    }

    @Override
    public Object getGetPowerPipe(TileEntity te) {
        IPipe p;
        if (te instanceof IPipeTile && (p = ((IPipeTile)te).getPipe()) instanceof IRoutedPowerProvider) {
            return (IRoutedPowerProvider)p;
        }
        return null;
    }

    @Override
    public List<ItemStack> getProvidedItems(TileEntity te) {
        IRequestAPI r = this.getRequestPipe(te);
        if (r == null) {
            return new ArrayList<ItemStack>();
        }
        return r.getProvidedItems();
    }

    @Override
    public List<ItemStack> getCraftedItems(TileEntity te) {
        IRequestAPI r = this.getRequestPipe(te);
        if (r == null) {
            return new ArrayList<ItemStack>();
        }
        return r.getCraftedItems();
    }

    @Override
    public List<ItemStack> performRequest(TileEntity te, ItemStack wanted) {
        IRequestAPI r = this.getRequestPipe(te);
        if (r == null) {
            return new ArrayList<ItemStack>();
        }
        return r.performRequest(wanted);
    }

    public IRequestAPI getRequestPipe(TileEntity te) {
        IPipe p;
        if (te instanceof IPipeTile && (p = ((IPipeTile)te).getPipe()) instanceof IRequestAPI) {
            return (IRequestAPI)p;
        }
        return null;
    }

    @Override
    public boolean isPowerSource(TileEntity tt) {
        return tt instanceof IRoutedPowerProvider;
    }

    @Override
    public boolean canUseEnergy(Object pp, int ceil, List<Object> providersToIgnore) {
        return ((IRoutedPowerProvider)pp).canUseEnergy(ceil, providersToIgnore);
    }

    @Override
    public boolean useEnergy(Object pp, int ceil, List<Object> providersToIgnore) {
        return ((IRoutedPowerProvider)pp).useEnergy(ceil, providersToIgnore);
    }
}

