/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile;

import appeng.api.WorldCoord;
import appeng.api.events.GridTileConnectivityEvent;
import appeng.api.me.tiles.IDirectionalMETile;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.tiles.IOrientableTile;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventoryHandler;
import appeng.common.AppEng;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngMultiBlock;
import appeng.common.network.IAppEngNetworkTile;
import appeng.common.network.packets.PacketTransitionPlane;
import appeng.interfaces.ICustomCollision;
import appeng.me.basetiles.TileME;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.FakePlayerFactory;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileTransitionPlane
extends TileME
implements IOrientableTile,
ICustomCollision,
IAppEngNetworkTile,
IGridMachine,
IDirectionalMETile {
    public ForgeDirection orientation;
    List<ItemStack> Buffer = new ArrayList<ItemStack>();
    int delay = 0;
    int trys = 0;
    boolean wasPulse = false;
    static Set<Integer> unbreakables = new HashSet<Integer>();

    public TileTransitionPlane() {
        this.hasPower = false;
        this.orientation = ForgeDirection.NORTH;
    }

    @Override
    public void setOrientationBySide(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        super.setOrientationBySide(player, side, hitX, hitY, hitZ);
        ForgeDirection orientation = ForgeDirection.getOrientation((int)side);
        WorldCoord pos = new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        pos.add(orientation, -1);
        TileEntity te = this.field_70331_k.func_72796_p(pos.x, pos.y, pos.z);
        MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(this, this.field_70331_k, this.getLocation()));
    }

    @Override
    public boolean syncStyle(IAppEngNetworkTile.SyncTime st) {
        return true;
    }

    @Override
    public void updateTileEntity() {
        if (this.isMachineActive() && this.delay++ > 320) {
            IMEInventoryHandler ca;
            IGridInterface gi;
            if (this.EatBlock()) {
                this.delay = 0;
            }
            if (this.Buffer.size() > 0 && (gi = this.getGrid()) != null && (ca = gi.getCellArray()) != null) {
                while (!this.Buffer.isEmpty()) {
                    ItemStack b = this.Buffer.get(0);
                    if ((b = Platform.addItems(ca, b)) != null) break;
                    this.Buffer.remove(0);
                    if (!this.Buffer.isEmpty()) continue;
                    this.markForUpdate();
                }
                if (this.Buffer.isEmpty()) {
                    this.reqEat();
                }
            }
        }
    }

    public void addItem(EntityItem entitiy) {
        if (this.isAccepting()) {
            IMEInventoryHandler ca;
            int howMany;
            IGridInterface gi;
            ItemStack is = entitiy.func_92059_d();
            if (this.Buffer.isEmpty() && this.isMachineActive() && Platform.isServer() && is != null && (gi = this.getGrid()) != null && !entitiy.field_70128_L && (howMany = gi.usePowerForAddition(is.field_77994_a, 1)) > 0 && (ca = gi.getCellArray()) != null) {
                ItemStack toAdd = is.func_77979_a(howMany);
                if ((toAdd = Platform.refundEnergy(gi, Platform.addItems(ca, toAdd), "Transiton Plane")) != null) {
                    is.field_77994_a += toAdd.field_77994_a;
                }
                try {
                    AppEng.getInstance().SideProxy.sendToAllNearExcept(null, entitiy.field_70165_t, entitiy.field_70163_u, entitiy.field_70161_v, 64.0, this.field_70331_k, (Packet)new PacketTransitionPlane((float)entitiy.field_70165_t, (float)entitiy.field_70163_u, (float)entitiy.field_70161_v, this.orientation, false).getPacket());
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (is.field_77994_a > 0) {
                    this.Buffer.add(is.func_77946_l());
                    this.markForUpdate();
                }
                entitiy.func_70106_y();
            }
        }
    }

    public boolean isAccepting() {
        this.wasPulse = false;
        return true;
    }

    public static void blacklist(int itemID, int damageValue) {
        unbreakables.add(damageValue << 16 | itemID);
    }

    public boolean notUnbreakable(int itemID, int damageValue) {
        if (Block.field_71973_m[itemID] != null && (Block.field_71973_m[itemID].field_72018_cp == Material.field_76249_a || Block.field_71973_m[itemID].field_72018_cp == Material.field_76256_h || Block.field_71973_m[itemID].field_72018_cp == Material.field_76244_g)) {
            return false;
        }
        return !unbreakables.contains(damageValue << 16 | itemID);
    }

    public boolean EatBlock() {
        if (this.isAccepting() && this.isMachineActive() && Platform.isServer() && this.isValid()) {
            float hardness;
            int x = this.field_70329_l + this.orientation.offsetX;
            int y = this.field_70330_m + this.orientation.offsetY;
            int z = this.field_70327_n + this.orientation.offsetZ;
            int bid = this.field_70331_k.func_72798_a(x, y, z);
            int meta = this.field_70331_k.func_72805_g(x, y, z);
            IGridInterface gi = this.getGrid();
            if (gi != null && !this.field_70331_k.func_72799_c(x, y, z) && this.field_70331_k.func_72899_e(x, y, z) && this.Buffer.isEmpty() && bid > 0 && this.notUnbreakable(bid, meta) && bid != Block.field_71986_z.field_71990_ca && this.field_70331_k.func_72962_a((EntityPlayer)FakePlayerFactory.getMinecraft((World)this.field_70331_k), x, y, z) && (double)(hardness = Block.field_71973_m[bid].func_71934_m(this.field_70331_k, x, y, z)) >= 0.0) {
                IMEInventoryHandler ca = gi.getCellArray();
                ItemStack[] out = Platform.getBlockDrops(this.field_70331_k, x, y, z);
                float total = 1.0f + hardness;
                for (ItemStack is : out) {
                    total += (float)is.field_77994_a;
                }
                boolean hasPower = gi.useMEEnergy(total, "TransitionPlane");
                if (ca != null && hasPower) {
                    this.field_70331_k.func_72832_d(x, y, z, 0, 0, 3);
                    this.trys = 0;
                    try {
                        AppEng.getInstance().SideProxy.sendToAllNearExcept(null, x, y, z, 64.0, this.field_70331_k, (Packet)new PacketTransitionPlane(x, y, z, this.orientation, true).getPacket());
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    for (ItemStack is : out) {
                        if ((is = Platform.addItems(ca, is)) == null) continue;
                        this.Buffer.add(is);
                        this.markForUpdate();
                    }
                }
            }
        }
        return true;
    }

    void reqEat() {
        this.delay += 9999;
    }

    @Override
    public void onNeighborBlockChange() {
        this.reqEat();
        this.trys = 0;
    }

    @Override
    public void setPowerStatus(boolean _hasPower) {
        super.setPowerStatus(_hasPower);
        this.reqEat();
    }

    @Override
    public void onUpdateRedstone() {
        super.onUpdateRedstone();
        this.reqEat();
    }

    @Override
    public void pulseRedStone() {
        super.pulseRedStone();
        this.wasPulse = true;
        this.reqEat();
    }

    boolean linesUp(int x, int y, int z) {
        TileEntity te = this.field_70331_k.func_72796_p(x, y, z);
        if (te instanceof TileTransitionPlane) {
            return ((TileTransitionPlane)te).orientation == this.orientation;
        }
        return false;
    }

    @Override
    public void placedBy(EntityLivingBase entityliving) {
        int rotation = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3;
        if (entityliving.field_70125_A > 65.0f) {
            rotation = 4;
        } else if (entityliving.field_70125_A < -65.0f) {
            rotation = 5;
        }
        this.orientation = this.getDirectionFromAERotation((byte)rotation);
    }

    private Icon defTextures(ForgeDirection side) {
        if (side == this.orientation.getOpposite()) {
            return AppEngTextureRegistry.Blocks.GenericBottom.get();
        }
        if (side == ForgeDirection.DOWN) {
            return AppEngTextureRegistry.Blocks.GenericTop.get();
        }
        if (side == ForgeDirection.UP) {
            return AppEngTextureRegistry.Blocks.GenericTop.get();
        }
        return AppEngTextureRegistry.Blocks.GenericSide.get();
    }

    @Override
    public Icon getBlockTextureFromSide(ForgeDirection side) {
        Icon frontFace;
        Icon icon = frontFace = this.isMachineActive() ? AppEngTextureRegistry.Blocks.BlockTransPlane.get() : AppEngTextureRegistry.Blocks.BlockTransPlaneOff.get();
        if (this.orientation == side) {
            return frontFace;
        }
        return this.defTextures(side);
    }

    @Override
    public void func_70310_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70310_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74774_a("r", this.getAERotationFromDirection(this.orientation));
        par1nbtTagCompound.func_74768_a("buf", this.Buffer.size());
        for (int x = 0; x < this.Buffer.size(); ++x) {
            NBTTagCompound item = new NBTTagCompound();
            this.Buffer.get(x).func_77955_b(item);
            par1nbtTagCompound.func_74766_a("#" + x, item);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70307_a(par1nbtTagCompound);
        this.orientation = this.getDirectionFromAERotation(par1nbtTagCompound.func_74771_c("r"));
        int num = par1nbtTagCompound.func_74762_e("buf");
        for (int x = 0; x < num; ++x) {
            this.Buffer.add(ItemStack.func_77949_a((NBTTagCompound)par1nbtTagCompound.func_74775_l("#" + x)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderTexturedPlate(float[] offset, float[] Left, float[] Up, float[] texOffset, float[] texDiff, Icon icon, int lightX, int lightY, int lightZ, boolean rev) {
        Tessellator tess = Tessellator.field_78398_a;
        float[] p1 = new float[5];
        float[] p2 = new float[5];
        float[] p3 = new float[5];
        float[] p4 = new float[5];
        p1[0] = offset[0];
        p1[1] = offset[1];
        p1[2] = offset[2];
        p1[3] = icon.func_94214_a((double)texOffset[0]);
        p1[4] = icon.func_94207_b((double)texOffset[1]);
        p2[0] = offset[0] + Left[0];
        p2[1] = offset[1] + Left[1];
        p2[2] = offset[2] + Left[2];
        p2[3] = icon.func_94214_a((double)(texOffset[0] + texDiff[0]));
        p2[4] = icon.func_94207_b((double)texOffset[1]);
        p3[0] = offset[0] + Left[0] + Up[0];
        p3[1] = offset[1] + Left[1] + Up[1];
        p3[2] = offset[2] + Left[2] + Up[2];
        p3[3] = icon.func_94214_a((double)(texOffset[0] + texDiff[0]));
        p3[4] = icon.func_94207_b((double)(texOffset[1] + texDiff[1]));
        p4[0] = offset[0] + Up[0];
        p4[1] = offset[1] + Up[1];
        p4[2] = offset[2] + Up[2];
        p4[3] = icon.func_94214_a((double)texOffset[0]);
        p4[4] = icon.func_94207_b((double)(texOffset[1] + texDiff[1]));
        tess.func_78380_c(this.func_70311_o().func_71874_e((IBlockAccess)this.field_70331_k, lightX, lightY, lightZ));
        if (rev) {
            tess.func_78374_a((double)p4[0], (double)p4[1], (double)p4[2], (double)p4[3], (double)p4[4]);
            tess.func_78374_a((double)p3[0], (double)p3[1], (double)p3[2], (double)p3[3], (double)p3[4]);
            tess.func_78374_a((double)p2[0], (double)p2[1], (double)p2[2], (double)p2[3], (double)p2[4]);
            tess.func_78374_a((double)p1[0], (double)p1[1], (double)p1[2], (double)p1[3], (double)p1[4]);
        } else {
            tess.func_78374_a((double)p1[0], (double)p1[1], (double)p1[2], (double)p1[3], (double)p1[4]);
            tess.func_78374_a((double)p2[0], (double)p2[1], (double)p2[2], (double)p2[3], (double)p2[4]);
            tess.func_78374_a((double)p3[0], (double)p3[1], (double)p3[2], (double)p3[3], (double)p3[4]);
            tess.func_78374_a((double)p4[0], (double)p4[1], (double)p4[2], (double)p4[3], (double)p4[4]);
        }
    }

    public float[] p(float a, float b, float c) {
        float[] t = new float[]{a, b, c};
        return t;
    }

    public float[] t(float a, float b) {
        float[] t = new float[]{a, b};
        return t;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        float zX;
        boolean rev;
        renderer.func_83020_a(this.orientation == ForgeDirection.WEST ? (double)1.0E-4f : 0.0, this.orientation == ForgeDirection.DOWN ? (double)1.0E-4f : 0.0, this.orientation == ForgeDirection.NORTH ? (double)1.0E-4f : 0.0, this.orientation == ForgeDirection.EAST ? (double)0.9999f : 1.0, this.orientation == ForgeDirection.UP ? (double)0.9999f : 1.0, this.orientation == ForgeDirection.SOUTH ? (double)0.9999f : 1.0);
        renderer.field_78681_k = 0;
        renderer.field_78675_l = 3;
        renderer.field_78662_g = 1;
        renderer.field_78679_j = 2;
        renderer.field_78685_i = 1;
        renderer.field_78683_h = 2;
        renderer.func_78570_q(block, x, y, z);
        renderer.field_78683_h = 0;
        renderer.field_78681_k = 0;
        renderer.field_78685_i = 0;
        renderer.field_78679_j = 0;
        renderer.field_78662_g = 0;
        renderer.field_78675_l = 0;
        renderer.func_83020_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        Icon icon = AppEngTextureRegistry.Blocks.BlockFrame.get();
        float offsetPerPixel = 0.0625f;
        if (this.orientation == ForgeDirection.NORTH || this.orientation == ForgeDirection.SOUTH) {
            rev = this.orientation == ForgeDirection.NORTH;
            zX = 1.0f;
            if (rev) {
                zX = 0.0f;
            }
            if (!this.linesUp(x - 1, y, z)) {
                this.renderTexturedPlate(this.p(x, y, (float)z + zX), this.p(offsetPerPixel, 0.0f, 0.0f), this.p(0.0f, 1.0f, 0.0f), this.t(0.0f, 0.0f), this.t(1.0f, 16.0f), icon, x, y, z + (rev ? -1 : 1), rev);
            }
            if (!this.linesUp(x + 1, y, z)) {
                this.renderTexturedPlate(this.p((float)x + 15.0f * offsetPerPixel, y, (float)z + zX), this.p(offsetPerPixel, 0.0f, 0.0f), this.p(0.0f, 1.0f, 0.0f), this.t(15.0f, 0.0f), this.t(1.0f, 16.0f), icon, x, y, z + (rev ? -1 : 1), rev);
            }
            if (!this.linesUp(x, y - 1, z)) {
                this.renderTexturedPlate(this.p(x, y, (float)z + zX), this.p(1.0f, 0.0f, 0.0f), this.p(0.0f, offsetPerPixel, 0.0f), this.t(0.0f, 0.0f), this.t(16.0f, 1.0f), icon, x, y, z + (rev ? -1 : 1), rev);
            }
            if (!this.linesUp(x, y + 1, z)) {
                this.renderTexturedPlate(this.p(x, (float)y + 15.0f * offsetPerPixel, (float)z + zX), this.p(1.0f, 0.0f, 0.0f), this.p(0.0f, offsetPerPixel, 0.0f), this.t(0.0f, 15.0f), this.t(16.0f, 1.0f), icon, x, y, z + (rev ? -1 : 1), rev);
            }
        }
        if (this.orientation == ForgeDirection.EAST || this.orientation == ForgeDirection.WEST) {
            rev = this.orientation == ForgeDirection.EAST;
            zX = 0.0f;
            if (rev) {
                zX = 1.0f;
            }
            if (!this.linesUp(x, y, z - 1)) {
                this.renderTexturedPlate(this.p((float)x + zX, y, z), this.p(0.0f, 0.0f, offsetPerPixel), this.p(0.0f, 1.0f, 0.0f), this.t(0.0f, 0.0f), this.t(1.0f, 16.0f), icon, x + (rev ? 1 : -1), y, z, rev);
            }
            if (!this.linesUp(x, y, z + 1)) {
                this.renderTexturedPlate(this.p((float)x + zX, y, (float)z + 15.0f * offsetPerPixel), this.p(0.0f, 0.0f, offsetPerPixel), this.p(0.0f, 1.0f, 0.0f), this.t(15.0f, 0.0f), this.t(1.0f, 16.0f), icon, x + (rev ? 1 : -1), y, z, rev);
            }
            if (!this.linesUp(x, y - 1, z)) {
                this.renderTexturedPlate(this.p((float)x + zX, y, z), this.p(0.0f, 0.0f, 1.0f), this.p(0.0f, offsetPerPixel, 0.0f), this.t(0.0f, 0.0f), this.t(16.0f, 1.0f), icon, x + (rev ? 1 : -1), y, z, rev);
            }
            if (!this.linesUp(x, y + 1, z)) {
                this.renderTexturedPlate(this.p((float)x + zX, (float)y + 15.0f * offsetPerPixel, z), this.p(0.0f, 0.0f, 1.0f), this.p(0.0f, offsetPerPixel, 0.0f), this.t(0.0f, 15.0f), this.t(16.0f, 1.0f), icon, x + (rev ? 1 : -1), y, z, rev);
            }
        }
        if (this.orientation == ForgeDirection.UP || this.orientation == ForgeDirection.DOWN) {
            rev = this.orientation == ForgeDirection.UP;
            zX = 1.0f;
            if (!rev) {
                zX = 0.0f;
            }
            if (!this.linesUp(x - 1, y, z)) {
                this.renderTexturedPlate(this.p(x, (float)y + zX, z), this.p(offsetPerPixel, 0.0f, 0.0f), this.p(0.0f, 0.0f, 1.0f), this.t(0.0f, 0.0f), this.t(1.0f, 16.0f), icon, x, y + (rev ? 1 : -1), z, rev);
            }
            if (!this.linesUp(x + 1, y, z)) {
                this.renderTexturedPlate(this.p((float)x + 15.0f * offsetPerPixel, (float)y + zX, z), this.p(offsetPerPixel, 0.0f, 0.0f), this.p(0.0f, 0.0f, 1.0f), this.t(15.0f, 0.0f), this.t(1.0f, 16.0f), icon, x, y + (rev ? 1 : -1), z, rev);
            }
            if (!this.linesUp(x, y, z - 1)) {
                this.renderTexturedPlate(this.p(x, (float)y + zX, z), this.p(1.0f, 0.0f, 0.0f), this.p(0.0f, 0.0f, offsetPerPixel), this.t(0.0f, 0.0f), this.t(16.0f, 1.0f), icon, x, y + (rev ? 1 : -1), z, rev);
            }
            if (!this.linesUp(x, y, z + 1)) {
                this.renderTexturedPlate(this.p(x, (float)y + zX, (float)z + 15.0f * offsetPerPixel), this.p(1.0f, 0.0f, 0.0f), this.p(0.0f, 0.0f, offsetPerPixel), this.t(0.0f, 15.0f), this.t(16.0f, 1.0f), icon, x, y + (rev ? 1 : -1), z, rev);
            }
        }
        return true;
    }

    @Override
    public boolean isBlockNormalCube() {
        return true;
    }

    @Override
    public boolean handleTilePacket(DataInputStream stream) throws IOException {
        ForgeDirection oldOrientation = this.orientation;
        boolean oldHasPower = this.hasPower;
        byte rotation = stream.readByte();
        this.orientation = this.getDirectionFromAERotation(rotation);
        byte flags = stream.readByte();
        boolean bl = this.hasPower = (flags & 1) == 1;
        if ((flags & 2) == 2) {
            if (this.Buffer.isEmpty()) {
                this.Buffer.add(new ItemStack(Item.field_77669_D));
            }
        } else {
            this.Buffer.clear();
        }
        return oldHasPower != this.hasPower || oldOrientation != this.orientation;
    }

    @Override
    public void configureTilePacket(DataOutputStream data) throws IOException {
        data.writeByte(this.getAERotationFromDirection(this.orientation));
        byte flags = 0;
        flags = (byte)(flags | (this.hasPower ? 1 : 0));
        flags = (byte)(flags | (this.Buffer.isEmpty() ? 0 : 2));
        data.writeByte(flags);
    }

    @Override
    public float getPowerDrainPerTick() {
        return 1.0f;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != this.orientation;
    }

    @Override
    public void addCollidingBlockToList(World world, int x, int y, int z, AxisAlignedBB axisalignedbb, List arraylist, Entity par7Entity) {
        AppEngMultiBlock blk = (AppEngMultiBlock)this.func_70311_o();
        if (par7Entity instanceof EntityItem && this.isMachineActive() && this.Buffer.isEmpty()) {
            blk.func_71905_a(this.orientation == ForgeDirection.WEST ? 0.005f : 0.0f, this.orientation == ForgeDirection.DOWN ? 0.005f : 0.0f, this.orientation == ForgeDirection.NORTH ? 0.005f : 0.0f, this.orientation == ForgeDirection.EAST ? 0.995f : 1.0f, this.orientation == ForgeDirection.UP ? 0.995f : 1.0f, this.orientation == ForgeDirection.SOUTH ? 0.995f : 1.0f);
            blk.configureCollidingBlockToList(world, x, y, z, axisalignedbb, arraylist, par7Entity);
            blk.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            blk.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            blk.configureCollidingBlockToList(world, x, y, z, axisalignedbb, arraylist, par7Entity);
        }
    }

    @Override
    public AxisAlignedBB[] getSelectedBoundingBoxsFromPool(World world, int x, int y, int z) {
        return new AxisAlignedBB[]{AxisAlignedBB.func_72330_a((double)(this.orientation == ForgeDirection.WEST ? (double)0.005f : 0.0), (double)(this.orientation == ForgeDirection.DOWN ? (double)0.005f : 0.0), (double)(this.orientation == ForgeDirection.NORTH ? (double)0.005f : 0.0), (double)(this.orientation == ForgeDirection.EAST ? (double)0.995f : 1.0), (double)(this.orientation == ForgeDirection.UP ? (double)0.995f : 1.0), (double)(this.orientation == ForgeDirection.SOUTH ? (double)0.995f : 1.0))};
    }

    @Override
    public void cycleOrientation() {
        this.orientation = Platform.cycleOrientations(this.orientation, false);
        this.markForUpdate();
    }

    @Override
    public ForgeDirection getPrimaryOrientation() {
        return this.orientation;
    }

    @Override
    public int getSpin() {
        return 0;
    }

    @Override
    public void setPrimaryOrientation(ForgeDirection s) {
        this.orientation = s;
        MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(this, this.getWorld(), this.getLocation()));
    }

    @Override
    public void setSpin(int spin) {
    }
}

