/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile;

import appeng.api.IAEItemStack;
import appeng.api.IItemList;
import appeng.api.WorldCoord;
import appeng.api.config.IConfigEnum;
import appeng.api.config.RedstoneModeOutput;
import appeng.api.events.GridTileConnectivityEvent;
import appeng.api.me.tiles.IColoredMETile;
import appeng.api.me.tiles.IConfigureableTile;
import appeng.api.me.tiles.IDirectionalMETile;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.tiles.IOrientableTile;
import appeng.api.me.tiles.ITileIOCable;
import appeng.api.me.util.IConfigManager;
import appeng.api.networkevents.MENetworkEventSubscribe;
import appeng.api.networkevents.MENetworkStorageEvent;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngTile;
import appeng.common.network.IAppEngNetworkTile;
import appeng.interfaces.IConfigEnabledTile;
import appeng.me.basetiles.TileCableBase;
import appeng.me.tile.AEAppEngInternalInventory;
import appeng.render.AppEngBlockRenderer;
import appeng.util.ConfigManager;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import powercrystals.minefactoryreloaded.api.rednet.RedNetConnectionType;

public class TileLevelEmitter
extends TileCableBase
implements IOrientableTile,
IConfigEnabledTile,
ITileIOCable,
IConfigureableTile,
IDirectionalMETile,
IAppEngNetworkTile,
IGridMachine,
IColoredMETile {
    ConfigManager config = new ConfigManager(this);
    ForgeDirection orientation;
    int color = -1;
    int delay = 0;
    public int configuredLimit = 1;
    boolean currentState;
    public AEAppEngInternalInventory item;
    RedstoneModeOutput rsMode = RedstoneModeOutput.WhenOn;
    double cenx;
    double ceny;
    double cenz;

    @Override
    public ITileIOCable.Version getVersion() {
        return ITileIOCable.Version.Basic;
    }

    @Override
    public AxisAlignedBB extendBusCollision(AxisAlignedBB b) {
        return this.IOBusCollision(0.4f, this.orientation, b);
    }

    @Override
    public boolean isColored(ForgeDirection d) {
        return this.color >= 0;
    }

    public ForgeDirection getCurrentOrientation() {
        return this.orientation;
    }

    public TileLevelEmitter() {
        this.orientation = ForgeDirection.UP;
        this.rsMode = RedstoneModeOutput.WhenOn;
        this.config.RegisterSetting(this.rsMode);
        this.item = new AEAppEngInternalInventory(this, 1);
        this.orientation = ForgeDirection.NORTH;
    }

    @Override
    public void setOrientationBySide(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        super.setOrientationBySide(player, side, hitX, hitY, hitZ);
        this.orientation = ForgeDirection.getOrientation((int)side);
        if (player.func_70093_af()) {
            this.orientation = this.orientation.getOpposite();
        }
        WorldCoord pos = new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        pos.add(this.orientation, -1);
        TileEntity te = this.field_70331_k.func_72796_p(pos.x, pos.y, pos.z);
        if (te instanceof IColoredMETile && ((IColoredMETile)te).isColored(ForgeDirection.UNKNOWN)) {
            this.color = ((IColoredMETile)te).getColor();
        }
    }

    @Override
    public void setPowerStatus(boolean _hasPower) {
        super.setPowerStatus(_hasPower);
    }

    @Override
    public int getLightOpacity() {
        return 1;
    }

    public void addVertexWithUV(double x, double y, double z, double u, double v) {
        double m;
        Tessellator var12 = Tessellator.field_78398_a;
        x -= this.cenx;
        y -= this.ceny;
        z -= this.cenz;
        if (this.orientation == ForgeDirection.DOWN) {
            y = -y;
            z = -z;
        }
        if (this.orientation == ForgeDirection.EAST) {
            m = x;
            x = y;
            y = m;
            y = -y;
        }
        if (this.orientation == ForgeDirection.WEST) {
            m = x;
            x = -y;
            y = m;
        }
        if (this.orientation == ForgeDirection.SOUTH) {
            m = z;
            z = y;
            y = m;
            y = -y;
        }
        if (this.orientation == ForgeDirection.NORTH) {
            m = z;
            z = -y;
            y = m;
        }
        var12.func_78374_a(x += this.cenx, y += this.ceny, z += this.cenz, u, v);
    }

    public boolean isLevelEmitterOn() {
        return this.currentState ? this.rsMode == RedstoneModeOutput.WhenOn : this.rsMode == RedstoneModeOutput.WhenOff;
    }

    public void renderTorchAtAngle(double par2, double par4, double par6) {
        boolean isOn = this.isLevelEmitterOn();
        Icon icon = isOn ? AppEngTextureRegistry.Blocks.LevelEmitterTorchOn.get() : AppEngTextureRegistry.Blocks.LevelEmitterTorchOff.get();
        this.cenx = par2 + 0.5;
        this.ceny = par4 + 0.5;
        this.cenz = par6 + 0.5;
        par4 += 0.4;
        double par10 = 0.0;
        double par11 = 0.0;
        double par8 = 0.0;
        float var16 = icon.func_94209_e();
        float var17 = icon.func_94212_f();
        float var18 = icon.func_94206_g();
        float var19 = icon.func_94210_h();
        double var20 = icon.func_94214_a(7.0);
        double var22 = icon.func_94207_b(6.0 + (isOn ? 0.0 : 1.0));
        double var24 = icon.func_94214_a(9.0);
        double var26 = icon.func_94207_b(8.0 + (isOn ? 0.0 : 1.0));
        double var28 = icon.func_94214_a(7.0);
        double var30 = icon.func_94207_b(13.0);
        double var32 = icon.func_94214_a(9.0);
        double var34 = icon.func_94207_b(15.0);
        double var36 = (par2 += 0.5) - 0.5;
        double var38 = par2 + 0.5;
        double var40 = (par6 += 0.5) - 0.5;
        double var42 = par6 + 0.5;
        double var44 = 0.0625;
        double var46 = 0.625;
        double toff = 0.0;
        if (!isOn) {
            toff = 0.0625;
        }
        Tessellator var12 = Tessellator.field_78398_a;
        if (isOn) {
            var12.func_78386_a(1.0f, 1.0f, 1.0f);
            var12.func_78380_c(0xB000B0);
        }
        this.addVertexWithUV(par2 + par8 * (1.0 - var46) - var44, par4 + var46 - toff, par6 + par10 * (1.0 - var46) - var44, var20, var22);
        this.addVertexWithUV(par2 + par8 * (1.0 - var46) - var44, par4 + var46 - toff, par6 + par10 * (1.0 - var46) + var44, var20, var26);
        this.addVertexWithUV(par2 + par8 * (1.0 - var46) + var44, par4 + var46 - toff, par6 + par10 * (1.0 - var46) + var44, var24, var26);
        this.addVertexWithUV(par2 + par8 * (1.0 - var46) + var44, par4 + var46 - toff, par6 + par10 * (1.0 - var46) - var44, var24, var22);
        this.addVertexWithUV(par2 + var44 + par8, par4, par6 - var44 + par10, var32, var30);
        this.addVertexWithUV(par2 + var44 + par8, par4, par6 + var44 + par10, var32, var34);
        this.addVertexWithUV(par2 - var44 + par8, par4, par6 + var44 + par10, var28, var34);
        this.addVertexWithUV(par2 - var44 + par8, par4, par6 - var44 + par10, var28, var30);
        this.addVertexWithUV(par2 - var44, par4 + 1.0, var40, var16, var18);
        this.addVertexWithUV(par2 - var44 + par8, par4 + 0.0, var40 + par10, var16, var19);
        this.addVertexWithUV(par2 - var44 + par8, par4 + 0.0, var42 + par10, var17, var19);
        this.addVertexWithUV(par2 - var44, par4 + 1.0, var42, var17, var18);
        this.addVertexWithUV(par2 + var44, par4 + 1.0, var42, var16, var18);
        this.addVertexWithUV(par2 + par8 + var44, par4 + 0.0, var42 + par10, var16, var19);
        this.addVertexWithUV(par2 + par8 + var44, par4 + 0.0, var40 + par10, var17, var19);
        this.addVertexWithUV(par2 + var44, par4 + 1.0, var40, var17, var18);
        this.addVertexWithUV(var36, par4 + 1.0, par6 + var44, var16, var18);
        this.addVertexWithUV(var36 + par8, par4 + 0.0, par6 + var44 + par10, var16, var19);
        this.addVertexWithUV(var38 + par8, par4 + 0.0, par6 + var44 + par10, var17, var19);
        this.addVertexWithUV(var38, par4 + 1.0, par6 + var44, var17, var18);
        this.addVertexWithUV(var38, par4 + 1.0, par6 - var44, var16, var18);
        this.addVertexWithUV(var38 + par8, par4 + 0.0, par6 - var44 + par10, var16, var19);
        this.addVertexWithUV(var36 + par8, par4 + 0.0, par6 - var44 + par10, var17, var19);
        this.addVertexWithUV(var36, par4 + 1.0, par6 - var44, var17, var18);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        renderer.field_78661_f = true;
        Icon cableColor = this.color == -1 ? AppEngTextureRegistry.Blocks.MECableClear.get() : AppEngTextureRegistry.Blocks.MECableColors[this.color].get();
        this.renderCableAt(0.11, world, x, y, z, block, modelId, renderer, cableColor, true, 0.0);
        this.renderCableAt(0.18, world, x, y, z, block, modelId, renderer, AppEngTextureRegistry.Blocks.MECable.get(), false, 0.1875);
        AppEngBlockRenderer.instance.setOverrideBlockTexture(block, AppEngTextureRegistry.Blocks.MECable.get());
        renderer.func_83020_a(0.32, 0.32, 0.32, 0.6799999999999999, 0.6799999999999999, 0.6799999999999999);
        renderer.func_78570_q(block, x, y, z);
        AppEngBlockRenderer.instance.setOverrideBlockTexture(block, null);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78380_c(block.func_71874_e(world, x, y, z));
        tess.func_78386_a(1.0f, 1.0f, 1.0f);
        this.renderTorchAtAngle(x, y, z);
        renderer.field_78661_f = false;
        super.renderWorldBlock(world, x, y, z, block, modelId, renderer);
        return true;
    }

    @Override
    public void func_70307_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70307_a(par1nbtTagCompound);
        this.color = par1nbtTagCompound.func_74771_c("co");
        this.orientation = ForgeDirection.getOrientation((int)par1nbtTagCompound.func_74771_c("ori"));
        this.item.readFromNBT(par1nbtTagCompound.func_74775_l("it"));
        this.configuredLimit = par1nbtTagCompound.func_74762_e("configuredLimit");
        this.currentState = par1nbtTagCompound.func_74767_n("currentState");
        this.rsMode = (RedstoneModeOutput)this.config.loadSetting(this.rsMode, par1nbtTagCompound, "rsMode");
        if (this.configuredLimit < 1) {
            this.configuredLimit = 1;
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70310_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74774_a("co", (byte)this.color);
        par1nbtTagCompound.func_74774_a("ori", (byte)this.orientation.ordinal());
        par1nbtTagCompound.func_74778_a("rsMode", this.rsMode.toString());
        par1nbtTagCompound.func_74768_a("configuredLimit", this.configuredLimit);
        par1nbtTagCompound.func_74757_a("currentState", this.currentState);
        NBTTagCompound it = new NBTTagCompound();
        if (this.item != null) {
            this.item.writeToNBT(it);
        }
        par1nbtTagCompound.func_74766_a("it", it);
    }

    @Override
    public boolean isBlockNormalCube() {
        return false;
    }

    @Override
    public void setColor(int offset) {
        this.color = offset;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public boolean handleTilePacket(DataInputStream stream) throws IOException {
        ForgeDirection oldOrientation = this.orientation;
        int oldColor = this.color;
        boolean oldcurrentState = this.currentState;
        super.handleTilePacket(stream);
        this.orientation = ForgeDirection.getOrientation((int)stream.readByte());
        this.color = stream.readByte();
        this.configuredLimit = stream.readInt();
        this.currentState = stream.readBoolean();
        this.rsMode = RedstoneModeOutput.values()[stream.readInt()];
        return oldcurrentState != this.currentState || oldColor != this.color || oldOrientation != this.orientation;
    }

    @Override
    public void configureTilePacket(DataOutputStream data) throws IOException {
        super.configureTilePacket(data);
        data.writeByte((byte)this.orientation.ordinal());
        data.writeByte((byte)this.color);
        data.writeInt(this.configuredLimit);
        data.writeBoolean(this.currentState);
        data.writeInt(this.rsMode.ordinal());
    }

    @Override
    public NBTTagCompound getSettings(AppEngTile.ConfigMode mode) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("rsMode", this.rsMode.toString());
        tag.func_74768_a("configuredLimit", this.configuredLimit);
        NBTTagCompound it = new NBTTagCompound();
        if (this.item != null) {
            this.item.writeToNBT(it);
        }
        tag.func_74766_a("it", it);
        return tag;
    }

    @Override
    public void restoreSettings(NBTTagCompound tag, AppEngTile.ConfigMode mode) {
        try {
            this.item.readFromNBT(tag.func_74775_l("it"));
            this.configuredLimit = tag.func_74762_e("configuredLimit");
            this.rsMode = (RedstoneModeOutput)this.config.loadSetting(this.rsMode, tag, "rsMode");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @MENetworkEventSubscribe
    public void NetworkStorageUpdate(MENetworkStorageEvent e) {
        this.onNetworkInventoryChange(e.currentItems);
    }

    private void onNetworkInventoryChange(IItemList isList) {
        if (this.isMachineActive()) {
            boolean oldState = this.currentState;
            IAEItemStack Target = this.item.getAEStackInSlot(0);
            this.currentState = false;
            long total = 0L;
            if (Target != null) {
                IAEItemStack out = isList.findItem(Target);
                if (out != null) {
                    total = out.getStackSize();
                }
            } else {
                for (IAEItemStack is : isList) {
                    total += is.getStackSize();
                }
            }
            boolean bl = this.currentState = total >= (long)this.configuredLimit;
            if (this.currentState != oldState) {
                this.markForUpdate();
                this.notifyNeightbors();
            }
        }
    }

    @Override
    public boolean canConnectRedstone(int side) {
        if (side == ForgeDirection.UNKNOWN.ordinal()) {
            return false;
        }
        return side == this.orientation.getOpposite().ordinal();
    }

    @Override
    public int isProvidingStrongPower(int s) {
        WorldCoord wc = this.getLocation();
        wc = wc.add(this.orientation, 1);
        ForgeDirection opposite = this.orientation.getOpposite();
        if (this.field_70331_k.func_72804_r(wc.x, wc.y, wc.z) || this.field_70331_k.isBlockSolidOnSide(wc.x, wc.y, wc.z, opposite)) {
            int off;
            int on = this.rsMode == RedstoneModeOutput.WhenOn ? 15 : 0;
            int n = off = this.rsMode == RedstoneModeOutput.WhenOff ? 15 : 0;
            if (opposite.ordinal() == s) {
                return this.currentState ? on : off;
            }
            if (s == -1) {
                return this.currentState ? on : off;
            }
        }
        return 0;
    }

    @Override
    public int isProvidingWeakPower(int s) {
        int off;
        int on = this.rsMode == RedstoneModeOutput.WhenOn ? 15 : 0;
        int n = off = this.rsMode == RedstoneModeOutput.WhenOff ? 15 : 0;
        if (this.orientation.getOpposite().ordinal() == s) {
            return this.currentState ? on : off;
        }
        if (s == -1) {
            return this.currentState ? on : off;
        }
        return 0;
    }

    @Override
    public float getHoleThickness(ForgeDirection direction) {
        if (this.orientation == direction) {
            return 0.4375f;
        }
        return super.getHoleThickness(direction);
    }

    @Override
    public void notifyNeightbors() {
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
        this.field_70331_k.func_72898_h(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
        this.field_70331_k.func_72898_h(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    @Override
    public void cycleOrientation() {
        this.orientation = Platform.cycleOrientations(this.orientation, false);
        MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(this, this.getWorld(), this.getLocation()));
    }

    @Override
    public float getPowerDrainPerTick() {
        return 1.0f;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir.ordinal() != this.orientation.ordinal();
    }

    @Override
    public List<String> getConfigurations() {
        return this.config.getConfigurations();
    }

    @Override
    public String nextConfiguration(String name) {
        return this.config.nextConfiguration(name);
    }

    @Override
    public String prevConfiguration(String name) {
        return this.config.prevConfiguration(name);
    }

    @Override
    public String setConfiguration(String name, String value) {
        return this.config.setConfiguration(name, value);
    }

    @Override
    public String getConfiguration(String name) {
        return this.config.getConfiguration(name);
    }

    @Override
    public List<String> getConfiguationOptions(String name) {
        return this.config.getConfiguationOptions(name);
    }

    @Override
    public IInventory getConfiguration() {
        return this.item;
    }

    @Override
    public void actionHandler(EntityPlayerMP pmp, int action, DataInputStream stream) {
        try {
            if (action == 2) {
                this.configuredLimit = stream.readInt();
                if (this.getGrid() != null) {
                    this.onNetworkInventoryChange(this.getGrid().getCellArray().getAvailableItems());
                }
                this.markForUpdate();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Override
    public String getName() {
        return "ME Level Emitter";
    }

    @Override
    public RedNetConnectionType getConnectionType(World world, int x, int y, int z, ForgeDirection side) {
        if (side == this.orientation) {
            return RedNetConnectionType.CableSingle;
        }
        return RedNetConnectionType.None;
    }

    @Override
    public void updateSetting(IConfigEnum newValue) {
        if (newValue instanceof RedstoneModeOutput) {
            this.rsMode = (RedstoneModeOutput)newValue;
            if (this.field_70331_k != null) {
                this.notifyNeightbors();
                if (Platform.isClient()) {
                    this.markForUpdate();
                }
            }
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.config;
    }

    @Override
    public ForgeDirection getPrimaryOrientation() {
        return this.orientation;
    }

    @Override
    public int getSpin() {
        return 0;
    }

    @Override
    public void setPrimaryOrientation(ForgeDirection s) {
        this.orientation = s;
        MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(this, this.getWorld(), this.getLocation()));
    }

    @Override
    public void setSpin(int spin) {
    }
}

