/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile;

import appeng.api.Util;
import appeng.api.config.FullnessMode;
import appeng.api.config.IConfigEnum;
import appeng.api.config.ListMode;
import appeng.api.config.OperationMode;
import appeng.api.config.RedstoneModeInputOnOff;
import appeng.api.me.tiles.IConfigureableTile;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.util.IConfigManager;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventoryHandler;
import appeng.common.AppEngConfiguration;
import appeng.common.AppEngTextureRegistry;
import appeng.common.registries.AppEngCellRegistry;
import appeng.interfaces.IConfigEnabledTile;
import appeng.me.METhrottle;
import appeng.me.basetiles.TileMEWInventory;
import appeng.util.AEItemStack;
import appeng.util.ConfigManager;
import appeng.util.ItemList;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class TileIOPort
extends TileMEWInventory
implements IConfigEnabledTile,
IConfigureableTile,
IGridMachine,
IInventory,
ISidedInventory {
    METhrottle throttle;
    ConfigManager config = new ConfigManager(this);
    FullnessMode fullMode = FullnessMode.Empty;
    OperationMode opMode = OperationMode.Empty;
    RedstoneModeInputOnOff rsMode = RedstoneModeInputOnOff.Ignore;
    int[] inputs = new int[]{0, 1, 2, 3, 4, 5};
    int[] outputs = new int[]{6, 7, 8, 9, 10, 11};

    @Override
    public boolean requiresRedstoneUpdates() {
        return true;
    }

    public TileIOPort() {
        super(12);
        this.config.RegisterSetting(this.fullMode);
        this.config.RegisterSetting(this.opMode);
        this.config.RegisterSetting(this.rsMode);
        this.updatesOnPower = false;
        this.throttle = new METhrottle(5, AppEngConfiguration.automationMinTickRate, AppEngConfiguration.automationMinTickRate + 320);
    }

    public int getNextCell() {
        for (int x = 0; x < 6; ++x) {
            if (!AppEngCellRegistry.isCell(this.func_70301_a(x))) continue;
            return x;
        }
        return -1;
    }

    public void moveToOutput(int slot) {
        for (int x = 0; x < 6; ++x) {
            if (this.func_70301_a(x + 6) != null) continue;
            this.func_70299_a(x + 6, this.func_70301_a(slot));
            this.func_70299_a(slot, null);
            return;
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70310_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74778_a("op", this.opMode.toString());
        par1nbtTagCompound.func_74778_a("full", this.fullMode.toString());
        par1nbtTagCompound.func_74778_a("rs", this.rsMode.toString());
    }

    @Override
    public void func_70307_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70307_a(par1nbtTagCompound);
        this.opMode = (OperationMode)this.config.loadSetting(this.opMode, par1nbtTagCompound, "op");
        this.fullMode = (FullnessMode)this.config.loadSetting(this.fullMode, par1nbtTagCompound, "full");
        this.rsMode = (RedstoneModeInputOnOff)this.config.loadSetting(this.rsMode, par1nbtTagCompound, "rs");
    }

    @Override
    public void onUpdateRedstone() {
        super.onUpdateRedstone();
        this.throttle.hasAccomplishedWork();
    }

    @Override
    public void updateTileEntity() {
        if (this.throttle.process()) {
            int slot;
            if (this.rsMode == RedstoneModeInputOnOff.WhenOff && this.getRedstoneState()) {
                return;
            }
            if (this.rsMode == RedstoneModeInputOnOff.WhenOn && !this.getRedstoneState()) {
                return;
            }
            IGridInterface gi = this.getGrid();
            if (gi != null && (slot = this.getNextCell()) >= 0) {
                boolean validToContinue;
                IMEInventoryHandler network;
                ItemStack target = this.func_70301_a(slot);
                IMEInventoryHandler cell = AppEngCellRegistry.getCellHandler(target);
                FullnessMode presentState = null;
                presentState = cell.freeBytes() == 0L ? FullnessMode.Full : (cell.usedBytes() == 0L ? FullnessMode.Empty : FullnessMode.Half);
                boolean didSomething = false;
                int remainingPerRound = 768;
                if (this.opMode == OperationMode.Fill && presentState != FullnessMode.Full) {
                    network = this.getGrid().getCellArray();
                    List<ItemStack> whatToTry = cell.isPreformatted() && cell.getListMode() == ListMode.WHITELIST ? (cell.isFuzzyPreformatted() ? ((ItemList)network.getAvailableItems(new ItemList())).getSharedItems() : cell.getPreformattedItems()) : ((ItemList)network.getAvailableItems(new ItemList())).getSharedItems();
                    boolean again = false;
                    do {
                        again = false;
                        for (ItemStack is : whatToTry) {
                            AEItemStack it;
                            if (is == null || cell.getAvailableSpaceByItem(it = AEItemStack.create(is), 1L) <= 0L || !gi.useMEEnergy(5.0f, "io port")) continue;
                            is.field_77994_a = remainingPerRound;
                            is = Platform.extractItems(network, is);
                            if (this.func_70301_a(slot) != target) {
                                Platform.addItems(network, is);
                                continue;
                            }
                            if (is != null) {
                                int r = is.field_77994_a;
                                remainingPerRound -= is.field_77994_a;
                                if ((is = Platform.addItems(cell, is)) != null) {
                                    remainingPerRound += is.field_77994_a;
                                    Platform.addItems(network, is);
                                    if (is.field_77994_a == r) {
                                        gi.refundMEEnergy(5.0f, "io port");
                                    }
                                }
                                again = true;
                                didSomething = true;
                                continue;
                            }
                            gi.refundMEEnergy(5.0f, "io port");
                        }
                    } while (again && remainingPerRound > 0);
                } else if (this.opMode == OperationMode.Empty && presentState != FullnessMode.Empty) {
                    network = this.getGrid().getCellArray();
                    List<ItemStack> whatToTry = ((ItemList)cell.getAvailableItems(new ItemList())).getSharedItems();
                    boolean again = false;
                    do {
                        again = false;
                        for (ItemStack is : whatToTry) {
                            if (is == null || network.getAvailableSpaceByItem(AEItemStack.create(is), 1L) <= 0L) continue;
                            if (gi.useMEEnergy(5.0f, "io port")) {
                                is.field_77994_a = remainingPerRound;
                                if ((is = Platform.extractItems(cell, is)) != null) {
                                    int r = is.field_77994_a;
                                    remainingPerRound -= is.field_77994_a;
                                    if ((is = Platform.addItems(network, is)) != null) {
                                        remainingPerRound += is.field_77994_a;
                                        Platform.addItems(cell, is);
                                        if (is.field_77994_a == r) {
                                            gi.refundMEEnergy(5.0f, "io port");
                                            continue;
                                        }
                                    }
                                    again = true;
                                    didSomething = true;
                                    continue;
                                }
                                gi.refundMEEnergy(5.0f, "io port");
                                continue;
                            }
                            didSomething = true;
                        }
                    } while (again && remainingPerRound > 0);
                }
                boolean bl = validToContinue = this.fullMode == presentState;
                if (this.opMode == OperationMode.Fill && this.fullMode == FullnessMode.Half) {
                    validToContinue = true;
                }
                if (this.opMode == OperationMode.Empty && this.fullMode == FullnessMode.Half) {
                    validToContinue = true;
                }
                if (didSomething) {
                    this.throttle.hasAccomplishedWork();
                }
                if (!didSomething && validToContinue && gi.useMEEnergy(1.0f, "io port")) {
                    this.moveToOutput(slot);
                }
            }
        }
    }

    @Override
    public Icon getBlockTextureFromSide(ForgeDirection side) {
        if (side == ForgeDirection.DOWN) {
            return AppEngTextureRegistry.Blocks.GenericBottom.get();
        }
        if (side == ForgeDirection.UP) {
            return AppEngTextureRegistry.Blocks.BlockIOPortTop.get();
        }
        return AppEngTextureRegistry.Blocks.BlockIOPortSide.get();
    }

    @Override
    public float getPowerDrainPerTick() {
        return 1.0f;
    }

    public String func_70303_b() {
        return "IO Port";
    }

    @Override
    public List<String> getConfigurations() {
        return this.config.getConfigurations();
    }

    @Override
    public String nextConfiguration(String name) {
        return this.config.nextConfiguration(name);
    }

    @Override
    public String prevConfiguration(String name) {
        return this.config.prevConfiguration(name);
    }

    @Override
    public String setConfiguration(String name, String value) {
        return this.config.setConfiguration(name, value);
    }

    @Override
    public String getConfiguration(String name) {
        return this.config.getConfiguration(name);
    }

    @Override
    public List<String> getConfiguationOptions(String name) {
        return this.config.getConfiguationOptions(name);
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return Util.isCell(itemstack);
    }

    public int[] func_94128_d(int var1) {
        ForgeDirection side = ForgeDirection.getOrientation((int)var1);
        if (side == ForgeDirection.UP || side == ForgeDirection.DOWN) {
            return this.outputs;
        }
        return this.inputs;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.func_94041_b(i, itemstack);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    @Override
    public void updateSetting(IConfigEnum newValue) {
        if (newValue instanceof RedstoneModeInputOnOff) {
            this.rsMode = (RedstoneModeInputOnOff)newValue;
        }
        if (newValue instanceof OperationMode) {
            this.opMode = (OperationMode)newValue;
        }
        if (newValue instanceof FullnessMode) {
            this.fullMode = (FullnessMode)newValue;
        }
        if (this.field_70331_k != null) {
            this.notifyNeightbors();
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.config;
    }
}

