/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster.implementations;

import appeng.api.TileRef;
import appeng.api.WorldCoord;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.MBCalculator;
import appeng.me.cluster.implementations.SpatialPylonCluster;
import appeng.me.tile.TileSpatialPylon;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class SpatialPylonCalculator
extends MBCalculator {
    TileSpatialPylon tqb;

    public SpatialPylonCalculator(IAEMultiBlock t) {
        super(t);
        this.tqb = (TileSpatialPylon)t;
    }

    @Override
    public boolean isValidTile(TileEntity te) {
        return te instanceof TileSpatialPylon;
    }

    @Override
    public boolean checkMultiblockScale(WorldCoord min, WorldCoord max) {
        return min.x == max.x && min.y == max.y && min.z != max.z || min.x == max.x && min.y != max.y && min.z == max.z || min.x != max.x && min.y == max.y && min.z == max.z;
    }

    @Override
    public void updateTiles(IAECluster cl, IBlockAccess w, WorldCoord min, WorldCoord max) {
        SpatialPylonCluster c = (SpatialPylonCluster)cl;
        for (int x = min.x; x <= max.x; ++x) {
            for (int y = min.y; y <= max.y; ++y) {
                for (int z = min.z; z <= max.z; ++z) {
                    TileSpatialPylon te = (TileSpatialPylon)w.func_72796_p(x, y, z);
                    te.updateStatus(c);
                    c.line.add(new TileRef(te));
                }
            }
        }
    }

    @Override
    public IAECluster createCluster(IBlockAccess w, WorldCoord min, WorldCoord max) {
        return new SpatialPylonCluster(min, max);
    }

    @Override
    public void disconnect() {
        this.tqb.disconnect();
    }

    @Override
    public boolean verifyInternalStructure(IBlockAccess w, WorldCoord min, WorldCoord max) {
        for (int x = min.x; x <= max.x; ++x) {
            for (int y = min.y; y <= max.y; ++y) {
                for (int z = min.z; z <= max.z; ++z) {
                    IAEMultiBlock te = (IAEMultiBlock)w.func_72796_p(x, y, z);
                    if (te.isValid()) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

