/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.block;

import appeng.api.WorldCoord;
import appeng.api.events.GridTileConnectivityEvent;
import appeng.api.me.tiles.ITileIOCable;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngMultiBlock;
import appeng.gui.AppEngGuiHandler;
import appeng.me.block.BlockCableBase;
import appeng.me.tile.TileInputCable;
import appeng.util.Platform;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class BlockInputCableBasic
extends BlockCableBase {
    public BlockInputCableBasic(AppEngMultiBlock mb, boolean en) {
        super(mb, en);
        this.unlocalizedName = "ImportBus";
    }

    @Override
    public Icon getBlockTextureFromSide(int side) {
        return AppEngTextureRegistry.Blocks.MECableClear.get();
    }

    @Override
    public TileEntity createNewTileEntity(World w) {
        TileInputCable toc = new TileInputCable();
        toc.ver = ITileIOCable.Version.Basic;
        return toc;
    }

    @Override
    public boolean hasTileEntity() {
        return true;
    }

    @Override
    public boolean onBlockActivated(World w, int x, int y, int z, EntityPlayer p, int side) {
        if (super.onBlockActivated(w, x, y, z, p, side)) {
            return true;
        }
        TileEntity tileEntity = w.func_72796_p(x, y, z);
        ItemStack eq = p.func_71045_bC();
        if (Platform.isWrench(p, eq, x, y, z) && tileEntity instanceof TileInputCable) {
            TileInputCable ate = (TileInputCable)tileEntity;
            ate.cycleOrientation();
            ate.markForUpdate();
            ate.notifyNeightbors();
            MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(ate, w, new WorldCoord(x, y, z)));
            return true;
        }
        if (tileEntity == null || p.func_70093_af()) {
            return false;
        }
        if (tileEntity instanceof TileInputCable) {
            TileInputCable tic = (TileInputCable)tileEntity;
            if (tic.ver == ITileIOCable.Version.Basic) {
                return false;
            }
            Platform.openGui(p, AppEngGuiHandler.GUI_IO_CABLE, w, x, y, z);
        }
        return true;
    }
}

