/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.block;

import binnie.core.Binnie;
import binnie.core.block.TileEntityMetadata;
import binnie.core.language.LocalisedString;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.api.CarpentryManager;
import binnie.extratrees.api.ICarpentryWood;
import binnie.extratrees.block.DoorType;
import binnie.extratrees.block.IPlankType;
import com.google.common.base.Optional;
import forestry.api.core.BlockInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public class PlankType {
    static Map<IPlankType, LocalisedString> names = new HashMap<IPlankType, LocalisedString>();
    static Map<IPlankType, LocalisedString> descriptions = new HashMap<IPlankType, LocalisedString>();

    public static void setup() {
        for (VanillaPlanks vanillaPlanks : VanillaPlanks.values()) {
            CarpentryManager.carpentryInterface.registerCarpentryWood(vanillaPlanks.ordinal(), vanillaPlanks);
            PlankType.registerStrings(vanillaPlanks, "vanilla.");
        }
        for (Enum enum_ : ExtraTreePlanks.values()) {
            CarpentryManager.carpentryInterface.registerCarpentryWood(enum_.ordinal() + 32, (ICarpentryWood)((Object)enum_));
            PlankType.registerStrings((IPlankType)((Object)enum_), "");
        }
        for (Enum enum_ : ForestryPlanks.values()) {
            CarpentryManager.carpentryInterface.registerCarpentryWood(enum_.ordinal() + 128, (ICarpentryWood)((Object)enum_));
            PlankType.registerStrings((IPlankType)((Object)enum_), "forestry.");
        }
        for (Enum enum_ : ExtraBiomesPlank.values()) {
            CarpentryManager.carpentryInterface.registerCarpentryWood(enum_.ordinal() + 192, (ICarpentryWood)((Object)enum_));
            PlankType.registerStrings((IPlankType)((Object)enum_), "ebxl.");
        }
    }

    private static void registerStrings(IPlankType plank, String pref) {
        names.put(plank, Binnie.Language.registerBlock(ExtraTrees.instance, "planks." + pref + plank.toString().toLowerCase()));
        descriptions.put(plank, Binnie.Language.registerBlock(ExtraTrees.instance, "planks." + pref + plank.toString().toLowerCase() + ".desc"));
    }

    public static IPlankType getPlank(int index) {
        ICarpentryWood wood = CarpentryManager.carpentryInterface.getCarpentryWood(index);
        if (wood instanceof IPlankType) {
            return (IPlankType)wood;
        }
        return ExtraTreePlanks.Fir;
    }

    public static int indexOf(IPlankType type) {
        int index = CarpentryManager.carpentryInterface.getCarpentryWoodIndex(type);
        return index < 0 ? 0 : index;
    }

    public static ItemStack getGate(IPlankType plank) {
        return TileEntityMetadata.getItemStack(ExtraTrees.blockGate.field_71990_ca, PlankType.indexOf(plank));
    }

    public static ItemStack getFence(IPlankType plank) {
        if (plank instanceof ForestryPlanks) {
            int ordinal;
            for (ordinal = ((ForestryPlanks)plank).ordinal(); ordinal >= 16; ordinal -= 16) {
            }
            ItemStack fence = BlockInterface.getBlock((String)("fences" + (((ForestryPlanks)plank).ordinal() / 16 + 1)));
            fence.func_77964_b(ordinal);
            return fence;
        }
        return TileEntityMetadata.getItemStack(ExtraTrees.blockFence.field_71990_ca, PlankType.indexOf(plank));
    }

    public static ItemStack getDoor(IPlankType plank, DoorType type) {
        return TileEntityMetadata.getItemStack(ExtraTrees.blockDoor.field_71990_ca, type.ordinal() * 256 + PlankType.indexOf(plank));
    }

    public static List<IPlankType> getAllPlankTypes() {
        ArrayList<IPlankType> list = new ArrayList<IPlankType>();
        for (ExtraTreePlanks extraTreePlanks : ExtraTreePlanks.values()) {
            list.add(extraTreePlanks);
        }
        for (Enum enum_ : ForestryPlanks.values()) {
            list.add((IPlankType)((Object)enum_));
        }
        for (Enum enum_ : ExtraBiomesPlank.values()) {
            list.add((IPlankType)((Object)enum_));
        }
        for (Enum enum_ : VanillaPlanks.values()) {
            list.add((IPlankType)((Object)enum_));
        }
        return list;
    }

    public static IPlankType get(ItemStack species) {
        for (IPlankType type : PlankType.getAllPlankTypes()) {
            if (type.getPlank() == null || !type.getPlank().func_77969_a(species)) continue;
            return type;
        }
        return null;
    }

    public static String getName(IPlankType type) {
        return names.get(type) == null ? "" : names.get(type).get();
    }

    public static String getDescription(IPlankType type) {
        return descriptions.get(type) == null ? "" : descriptions.get(type).getOrBlank();
    }

    public static enum ExtraBiomesPlank implements IPlankType
    {
        Redwood(10185538),
        Fir(8288074),
        Acacia(12561022);

        String name;
        int color;

        private ExtraBiomesPlank(int color) {
            this.name = this.name;
            this.color = color;
        }

        @Override
        public String getName() {
            return PlankType.getName(this);
        }

        @Override
        public String getDescription() {
            return PlankType.getDescription(this);
        }

        @Override
        public int getColour() {
            return this.color;
        }

        @Override
        public ItemStack getPlank() {
            try {
                Class<?> clss = Class.forName("extrabiomes.api.Stuff");
                Block block = (Block)((Optional)clss.getField("planks").get(null)).get();
                return new ItemStack(block, 1, this.ordinal());
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public Icon getIcon() {
            if (this.getPlank() != null) {
                int meta = this.getPlank().func_77960_j();
                Block block = Block.field_71973_m[((ItemBlock)this.getPlank().func_77973_b()).func_77883_f()];
                return block.func_71858_a(2, meta);
            }
            return null;
        }
    }

    public static enum ForestryPlanks implements IPlankType
    {
        LARCH(14131085),
        TEAK(8223075),
        ACACIA(9745287),
        LIME(13544048),
        CHESTNUT(12298845),
        WENGE(6182474),
        BAOBAB(9608290),
        SEQUOIA(10050135),
        KAPOK(8156212),
        EBONY(3946288),
        MAHOGANY(7749432),
        BALSA(0xA9A299),
        WILLOW(11710818),
        WALNUT(6836802),
        GREENHEART(5144156),
        CHERRY(11895348),
        MAHOE(8362154),
        POPLAR(13619074),
        PALM(13271115),
        PAPAYA(14470005),
        PINE(12885585),
        PLUM(11364479),
        MAPLE(11431211),
        CITRUS(10266653);

        String name;
        int color;

        private ForestryPlanks(int color) {
            this.name = this.name;
            this.color = color;
        }

        @Override
        public String getName() {
            return PlankType.getName(this);
        }

        @Override
        public String getDescription() {
            return PlankType.getDescription(this);
        }

        @Override
        public int getColour() {
            return this.color;
        }

        @Override
        public ItemStack getPlank() {
            ItemStack stack = BlockInterface.getBlock((String)("planks" + (this.ordinal() / 16 + 1)));
            return new ItemStack(stack.func_77973_b(), 1, this.ordinal() % 16);
        }

        @Override
        public Icon getIcon() {
            if (this.getPlank() != null) {
                int meta = this.getPlank().func_77960_j();
                Block block = Block.field_71973_m[((ItemBlock)this.getPlank().func_77973_b()).func_77883_f()];
                return block.func_71858_a(2, meta);
            }
            return null;
        }
    }

    public static enum VanillaPlanks implements IPlankType
    {
        OAK(11833434),
        SPRUCE(8412726),
        BIRCH(14139781),
        JUNGLE(11632732);

        int color;

        private VanillaPlanks(int color) {
            this.color = color;
        }

        @Override
        public String getName() {
            return PlankType.getName(this);
        }

        @Override
        public String getDescription() {
            return PlankType.getDescription(this);
        }

        @Override
        public int getColour() {
            return this.color;
        }

        @Override
        public ItemStack getPlank() {
            return new ItemStack(Block.field_71988_x.field_71990_ca, 1, this.ordinal());
        }

        @Override
        public Icon getIcon() {
            if (this.getPlank() != null) {
                int meta = this.getPlank().func_77960_j();
                Block block = Block.field_71988_x;
                return block.func_71858_a(2, meta);
            }
            return null;
        }
    }

    public static enum ExtraTreePlanks implements IPlankType
    {
        Fir(12815444),
        Cedar(14181940),
        Hemlock(13088108),
        Cypress(16169052),
        Fig(13142058),
        Beech(14784849),
        Alder(12092755),
        Hazel(13480341),
        Hornbeam(12818528),
        Box(16511430),
        Butternut(15510138),
        Hickory(14333070),
        Whitebeam(13222585),
        Elm(15772004),
        Apple(6305064),
        Yew(14722426),
        Pear(12093805),
        Hawthorn(13402978),
        Rowan(13610394),
        Elder(12489337),
        Maclura(15970862),
        Syzgium(15123393),
        Brazilwood(7487063),
        Logwood(10762028),
        Iroko(7681024),
        Locust(12816736),
        Eucalyptus(16165771),
        Purpleheart(5970991),
        Ash(16107368),
        Holly(16512743),
        Olive(11578760),
        Sweetgum(13997656),
        Rosewood(7738624),
        Gingko(16050106),
        PinkIvory(15502496);

        int color;
        Icon icon;

        private ExtraTreePlanks(int color) {
            this.color = color;
        }

        @Override
        public String getName() {
            return PlankType.getName(this);
        }

        @Override
        public String getDescription() {
            return PlankType.getDescription(this);
        }

        @Override
        public int getColour() {
            return this.color;
        }

        @Override
        public ItemStack getPlank() {
            return TileEntityMetadata.getItemStack(ExtraTrees.blockPlanks.field_71990_ca, this.ordinal());
        }

        public Icon loadIcon(IconRegister register) {
            this.icon = ExtraTrees.proxy.getIcon(register, "planks/" + this.toString());
            return this.icon;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }
    }
}

