/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.alcohol.drink;

import binnie.extratrees.alcohol.Cocktail;
import binnie.extratrees.alcohol.Glassware;
import binnie.extratrees.alcohol.ICocktailLiquid;
import binnie.extratrees.alcohol.drink.IDrinkType;
import binnie.extratrees.alcohol.drink.ItemDrink;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class DrinkType
extends IDrinkType {
    ICocktailLiquid ingredient = null;

    public DrinkType(Glassware glassware, String ingredients) {
        this.glassware = glassware;
        this.volume = glassware.getCapacity();
        this.ingredient = (ICocktailLiquid)Cocktail.getIngredient(ingredients);
        this.colour = this.ingredient.getColour();
        this.transparency = this.ingredient.getTransparency();
    }

    public DrinkType() {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.ingredient = (ICocktailLiquid)Cocktail.getIngredient(nbt.func_74779_i("ingr"));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74778_a("ingr", this.ingredient.getIdentifier());
    }

    @Override
    public void getInformation(List<String> par3List) {
        super.getInformation(par3List);
    }

    @Override
    public String getDisplayName() {
        return this.ingredient.getName();
    }

    public static ItemStack get(Glassware glassware, String name, int i) {
        return ItemDrink.getCocktailItem(new DrinkType(glassware, name), i);
    }
}

