/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.alcohol;

import binnie.core.liquid.IFluidType;
import binnie.core.liquid.LiquidContainer;
import binnie.core.liquid.LiquidManager;
import binnie.extratrees.alcohol.ICocktailLiquid;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.Icon;
import net.minecraftforge.fluids.FluidStack;

public enum Spirit implements IFluidType,
ICocktailLiquid
{
    Vodka("Vodka", "vodka", 16053751, 0.05),
    WhiteRum("White Rum", "rumWhite", 15132132, 0.05),
    DarkRum("Dark Rum", "rumDark", 11018752, 0.4),
    Whiskey("Whiskey", "whiskey", 13594368, 0.2),
    CornWhiskey("Bourbon", "whiskeyCorn", 9835009, 0.2),
    RyeWhiskey("Rye Whiskey", "whiskeyRye", 16085800, 0.2),
    WheatWhiskey("Wheat Whiskey", "whiskeyWheat", 14976530, 0.2),
    FortifiedWine("Fortified Wine", "wineFortified", 15569439, 0.2),
    Tequila("Tequila", "tequila", 16116160, 0.05),
    Brandy("Brandy", "brandyGrape", 16228128, 0.2),
    AppleBrandy("Apple Brandy", "brandyApple", 14985790, 0.2),
    PearBrandy("Pear Brandy", "brandyPear", 16696883, 0.2),
    ApricotBrandy("Apricot Brandy", "brandyApricot", 13336387, 0.2),
    PlumBrandy("Plum Brandy", "brandyPlum", 9511697, 0.2),
    CherryBrandy("Cherry Brandy", "brandyCherry", 8588062, 0.2),
    ElderberryBrandy("Elderberry Brandy", "brandyElderberry", 12462919, 0.2),
    CreamWhiskey("Cream Whiskey", "whiskeyCream", 12884837, 0.6),
    Cachaca("Cachaca", "spiritSugarcane", 15331535, 0.1),
    Gin("Gin", "spiritGin", 0xF6F6F6, 0.05),
    AppleLiquor("Apple Liquor", "liquorApple", 15064775, 0.05),
    PearLiquor("Pear Liquor", "liquorPear", 15064775, 0.05),
    CherryLiquor("Cherry Liquor", "liquorCherry", 15064775, 0.05),
    ElderberryLiquor("Elderberry Liquor", "liquorElderberry", 15064775, 0.05),
    ApricotLiquor("Apricot Liquor", "liquorApricot", 15064775, 0.05),
    NeutralSpirit("Neutral Spirit", "spiritNeutral", 0xFFFFFF, 0.05);

    String name;
    String ident;
    Icon icon;
    int colour;
    float transparency;

    private Spirit(String name, String ident, int colour, double transparency) {
        this.name = name;
        this.ident = ident;
        this.colour = colour;
        this.transparency = (float)transparency;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public boolean canBePlacedInContainer(LiquidContainer container) {
        return true;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void registerIcon(IconRegister register) {
        this.icon = LiquidManager.loadLiquidIcon(register, this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIdentifier() {
        return "binnie." + this.ident;
    }

    @Override
    public int getColour() {
        return this.colour;
    }

    @Override
    public FluidStack get(int amount) {
        return LiquidManager.getLiquidStack(this.getIdentifier(), amount);
    }

    @Override
    public int getTransparency() {
        return (int)(Math.min(1.0, (double)this.transparency + 0.3) * 255.0);
    }

    @Override
    public String getTooltip(int ratio) {
        return ratio + " Part" + (ratio > 1 ? "s " : " ") + this.getName();
    }
}

