/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.products;

import binnie.core.Binnie;
import binnie.core.item.IItemEnum;
import binnie.core.language.LocalisedString;
import binnie.core.liquid.LiquidManager;
import binnie.extrabees.ExtraBees;
import forestry.api.recipes.RecipeManagers;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public enum EnumPropolis implements IItemEnum
{
    WATER(2405321, 12762791, "Water"),
    OIL(1519411, 12762791, "Oil"),
    FUEL(10718482, 12762791, "Fuel"),
    MILK,
    FRUIT,
    SEED,
    ALCOHOL,
    CREOSOTE(8877313, 12428819, "creosote"),
    GLACIAL,
    PEAT(4203288, 9712140, "Peat");

    LocalisedString name;
    int[] colour = new int[0];
    String liquidName;
    boolean active = true;

    private EnumPropolis() {
        this(0xFFFFFF, 0xFFFFFF, "");
        this.active = false;
    }

    private EnumPropolis(int colour, int colour2, String liquid) {
        this.name = Binnie.Language.registerItem(ExtraBees.instance, "propolis." + this.name().toLowerCase());
        this.colour = new int[]{colour, colour2};
        this.liquidName = liquid;
    }

    public void addRecipe() {
        FluidStack liquid = LiquidManager.getLiquidStack(this.liquidName, 500);
        if (liquid != null) {
            RecipeManagers.squeezerManager.addRecipe(20, new ItemStack[]{this.get(1)}, liquid, null, 0);
        }
    }

    @Override
    public boolean isActive() {
        return this.active && LiquidManager.getLiquidStack(this.liquidName, 100) != null;
    }

    public static EnumPropolis get(ItemStack itemStack) {
        int i = itemStack.func_77960_j();
        if (i >= 0 && i < EnumPropolis.values().length) {
            return EnumPropolis.values()[i];
        }
        return EnumPropolis.values()[0];
    }

    @Override
    public ItemStack get(int size) {
        return new ItemStack(ExtraBees.propolis, size, this.ordinal());
    }

    @Override
    public String getName(ItemStack stack) {
        return this.name.toString();
    }
}

