/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.machines.tile;

import binnie.core.machines.inventory.TankValidator;
import binnie.core.machines.power.ErrorState;
import binnie.core.triggers.TriggerData;
import binnie.core.triggers.TriggerInventory;
import binnie.extrabees.core.ExtraBeeGUID;
import binnie.extrabees.engineering.ModuleEngineering;
import binnie.extrabees.machines.logic.SlotValidatorSerum;
import binnie.extrabees.machines.tile.TileEntityMachine;
import buildcraft.api.power.IPowerReceptor;
import java.util.List;
import net.minecraft.inventory.IInventory;

public class TileEntitySynthesizer
extends TileEntityMachine
implements IInventory,
IPowerReceptor {
    public static final int SlotSerum = 2;

    @Override
    public ExtraBeeGUID getGUI() {
        return ExtraBeeGUID.Synthesizer;
    }

    public TileEntitySynthesizer() {
        super("Synthesizer", 25000, 500, 40000);
        this.addSlot(2, "Serum Slot");
        this.getSlot(2).setValidator(new SlotValidatorSerum(SlotValidatorSerum.Mode.Serum));
        this.addTank(0, "DNA Tank", 8000);
        this.getTankSlot(0).setValidator(new TankValidator.Basic("liquiddna"));
    }

    @Override
    public void onFinishTask() {
        this.getSlot(2).getItemStack().func_77964_b(this.getSlot(2).getItemStack().func_77960_j() - 1);
        this.getTank(0).drain(100, true);
        ModuleEngineering.changeQuality(this.getSlot(2).getItemStack(), -this.field_70331_k.field_73012_v.nextInt(2));
    }

    @Override
    public ErrorState canWork() {
        if (this.getSlot(2).getItemStack() == null) {
            return new ErrorState.NoItem("No Serum", 2);
        }
        if (this.getSlot(2).getItemStack().func_77960_j() == 0) {
            return new ErrorState.InvalidItem("Serum already Full", 2);
        }
        return super.canWork();
    }

    @Override
    public ErrorState canProgress() {
        if (!this.canDrain(0, 100)) {
            return new ErrorState.InsufficientLiquid("Not enough Liquid DNA", 0);
        }
        return super.canProgress();
    }

    public boolean canDrain(int index, int amount) {
        return this.getTank(index).drain(amount, false) != null && this.getTank((int)index).drain((int)amount, (boolean)false).amount == amount;
    }

    @Override
    public void getTriggers(List<TriggerData> triggers) {
        super.getTriggers(triggers);
        triggers.add(TriggerInventory.serumFull(this, 2));
    }

    @Override
    public String getInformation() {
        return "The Synthesizer fills serum vials with Liquid DNA, at the expense of quality.";
    }
}

