/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.machines.tile;

import binnie.core.Binnie;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.MachineSide;
import binnie.core.machines.power.ErrorState;
import binnie.core.triggers.TriggerData;
import binnie.core.triggers.TriggerInventory;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.core.ExtraBeeGUID;
import binnie.extrabees.engineering.ItemSerum;
import binnie.extrabees.engineering.ModuleEngineering;
import binnie.extrabees.machines.logic.SlotValidatorBee;
import binnie.extrabees.machines.logic.SlotValidatorSerum;
import binnie.extrabees.machines.tile.TileEntityMachine;
import buildcraft.api.power.IPowerReceptor;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TileEntityInoculator
extends TileEntityMachine
implements IInventory,
IPowerReceptor {
    public static final int SlotBee = 2;
    public static final int[] SlotBeeReserve = new int[]{3, 4, 5, 6, 7, 8};
    public static final int[] SlotBeeDone = new int[]{9, 10, 11, 12, 13, 14};
    public static final int SlotSerum = 15;

    @Override
    public ExtraBeeGUID getGUI() {
        return ExtraBeeGUID.Inoculator;
    }

    public TileEntityInoculator() {
        super("Inoculator", 50000, 2000, 75000);
        this.addSlot(2, InventorySlot.NameProcess);
        this.getSlot(2).setValidator(new SlotValidatorBee(SlotValidatorBee.Mode.Bee));
        this.getSlot(2).setReadOnly();
        this.getSlot(2).forbidInteraction();
        this.addSlot(15, "Serum Slot");
        this.getSlot(15).setValidator(new SlotValidatorSerum(SlotValidatorSerum.Mode.Serum));
        this.getSlot(15).setOutputSides(MachineSide.TopAndBottom);
        this.addSlotArray(SlotBeeReserve, InventorySlot.NameInput);
        for (int slot : SlotBeeReserve) {
            this.getSlot(slot).setValidator(new SlotValidatorBee(SlotValidatorBee.Mode.Bee));
            this.getSlot(slot).forbidExtraction();
        }
        this.addSlotArray(SlotBeeDone, InventorySlot.NameOutput);
        for (int slot : SlotBeeDone) {
            this.getSlot(slot).setReadOnly();
            this.getSlot(slot).setValidator(new SlotValidatorBee(SlotValidatorBee.Mode.Bee));
            this.getSlot(slot).setOutputSides(MachineSide.Sides);
        }
        this.transfer.addRestock(SlotBeeReserve, 2, 1);
    }

    public Integer[] getFreeBeeDoneSlots() {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        int[] arr$ = SlotBeeDone;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer slot = arr$[i$];
            if (this.func_70301_a(slot) != null) continue;
            slots.add(slot);
        }
        return slots.toArray(new Integer[0]);
    }

    public Integer[] getBeeReserveSlots() {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        int[] arr$ = SlotBeeReserve;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer slot = arr$[i$];
            if (this.func_70301_a(slot) == null) continue;
            slots.add(slot);
        }
        return slots.toArray(new Integer[0]);
    }

    @Override
    public void onFinishTask() {
        String UID = ItemSerum.getUID(this.func_70301_a(15));
        IAllele allele = AlleleManager.alleleRegistry.getAllele(UID);
        IBee bee = Binnie.Genetics.getBeeRoot().getMember(this.func_70301_a(2));
        if (allele == null || bee == null) {
            return;
        }
        int chromosomeID = this.getSlot(15).getItemStack().func_77978_p().func_74762_e("chromosome");
        int id = this.field_70331_k.field_73012_v.nextBoolean() ? 1 : 0;
        ItemStack beeItem = this.getSlot(2).getItemStack().func_77946_l();
        NBTTagCompound beeNBT = beeItem.func_77978_p();
        if (beeNBT == null) {
            return;
        }
        NBTTagCompound genomeNBT = beeNBT.func_74775_l("Genome");
        NBTTagList chromosomes = genomeNBT.func_74761_m("Chromosomes");
        NBTTagCompound chromosome = (NBTTagCompound)chromosomes.func_74743_b(chromosomeID);
        if (chromosome.func_74779_i("UID" + id).equals(allele.getUID())) {
            id = 1 - id;
        }
        chromosome.func_74778_a("UID" + id, allele.getUID());
        beeItem.func_77982_d(beeNBT);
        ModuleEngineering.doBadStuff(beeItem, this.func_70301_a(15));
        ItemStack serum = this.func_70301_a(15);
        serum.func_77964_b(serum.func_77960_j() + 1);
        if (serum.func_77960_j() > serum.func_77958_k()) {
            serum = null;
        }
        this.func_70299_a(15, serum);
        this.func_70299_a(2, beeItem);
        if (this.getFreeBeeDoneSlots().length > 0 && !this.canInoculate()) {
            this.transfer.performTransfer(2, SlotBeeDone);
        }
        this.func_70296_d();
    }

    @Override
    public ErrorState canWork() {
        if (this.getSlot(15).getItemStack() == null) {
            return new ErrorState.NoItem("No Serum for inoculation", 15);
        }
        if (this.getSlot(2).getItemStack() == null) {
            return new ErrorState.NoItem("No Bee for inoculation", 2);
        }
        if (this.getSlot(15).getItemStack().func_77960_j() >= ExtraBees.serum.func_77612_l()) {
            return new ErrorState.InvalidItem("Empty Serum", "Serum has no charges left", 15);
        }
        if (!this.canInoculate()) {
            return new ErrorState.InvalidItem("Cannot Inoculate Bee", "Can't innoculate current bee with this serum", 2);
        }
        if (this.getFreeBeeDoneSlots().length == 0) {
            return new ErrorState.NoSpace("No Space for Inoculated Bees", SlotBeeDone);
        }
        return super.canWork();
    }

    public boolean canInoculate() {
        if (this.getSlot(15).isEmpty() || this.getSlot(2).isEmpty()) {
            return false;
        }
        ItemStack serum = this.getSlot(15).getItemStack();
        String uid = ItemSerum.getUID(serum);
        EnumBeeChromosome chromosome = ItemSerum.getChromosome(serum);
        IAllele allele = AlleleManager.alleleRegistry.getAllele(uid);
        if (allele == null || chromosome == null) {
            return false;
        }
        IBee bee = Binnie.Genetics.getBeeRoot().getMember(this.getSlot(2).getItemStack());
        if (bee == null) {
            return false;
        }
        IBeeGenome genome = bee.getGenome();
        return genome.getActiveAllele(chromosome.ordinal()) != allele || genome.getInactiveAllele(chromosome.ordinal()) != allele;
    }

    @Override
    protected void onUpdate() {
        if (!this.isServer()) {
            return;
        }
        if (!(this.canInoculate() || this.getSlot(15).isEmpty() || this.getSlot(2).isEmpty() || this.getFreeBeeDoneSlots().length <= 0)) {
            this.transfer.performTransfer(2, SlotBeeDone);
        }
    }

    @Override
    public String getInformation() {
        return "The Inoculator injects serums containing alleles into bees, altering their genes.";
    }

    @Override
    public String getProcessTooltip() {
        return "Injecting " + this.func_70301_a(15).func_82833_r();
    }

    @Override
    public void getTriggers(List<TriggerData> triggers) {
        super.getTriggers(triggers);
        triggers.add(TriggerInventory.serumEmpty(this, 15));
    }
}

