/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.machines.logic;

import binnie.core.Binnie;
import binnie.core.machines.inventory.SlotValidator;
import net.minecraft.item.ItemStack;

public class SlotValidatorBee
extends SlotValidator {
    public Mode mode;

    public SlotValidatorBee(Mode mode) {
        super(SlotValidator.IconBee);
        this.mode = mode;
    }

    @Override
    public boolean isValid(ItemStack itemStack) {
        if (!Binnie.Genetics.getBeeRoot().isMember(itemStack)) {
            return false;
        }
        switch (this.mode) {
            case Bee: {
                return true;
            }
            case Princess: {
                return !Binnie.Genetics.getBeeRoot().isDrone(itemStack) && !Binnie.Genetics.getBeeRoot().isMated(itemStack);
            }
            case Queen: {
                return !Binnie.Genetics.getBeeRoot().isDrone(itemStack) && Binnie.Genetics.getBeeRoot().isMated(itemStack);
            }
            case Drone: {
                return Binnie.Genetics.getBeeRoot().isDrone(itemStack);
            }
        }
        return false;
    }

    @Override
    public String getTooltip() {
        switch (this.mode) {
            case Bee: {
                return "Bees";
            }
            case Drone: {
                return "Bee Drones";
            }
            case Princess: {
                return "Bee Princesses";
            }
            case Queen: {
                return "Bee Queens";
            }
        }
        return "Bees";
    }

    public static enum Mode {
        Bee,
        Princess,
        Drone,
        Queen;

    }
}

