/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.genetics;

import binnie.core.Binnie;
import binnie.extrabees.genetics.EnumExtraBeeSpecies;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeMutation;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class ExtraBeeMutation
implements IBeeMutation {
    public static List<IBeeMutation> mutations = new ArrayList<IBeeMutation>();
    IAlleleBeeSpecies species0 = null;
    IAlleleBeeSpecies species1 = null;
    IAllele[] template = new IAllele[0];
    int chance = 80;

    public static void doInit() {
        IAlleleBeeSpecies[] vanilla = new IAlleleBeeSpecies[]{};
        new ExtraBeeMutation(EnumExtraBeeSpecies.getVanilla("Meadows"), EnumExtraBeeSpecies.getVanilla("Modest"), EnumExtraBeeSpecies.ARID, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.ARID, EnumExtraBeeSpecies.getVanilla("Common"), EnumExtraBeeSpecies.BARREN, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.ARID, (IAlleleBeeSpecies)EnumExtraBeeSpecies.BARREN, EnumExtraBeeSpecies.DESOLATE, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.BARREN, EnumExtraBeeSpecies.getVanilla("Forest"), EnumExtraBeeSpecies.GNAWING, 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.DESOLATE, EnumExtraBeeSpecies.getVanilla("Modest"), EnumExtraBeeSpecies.ROTTEN, 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.DESOLATE, EnumExtraBeeSpecies.getVanilla("Frugal"), EnumExtraBeeSpecies.BONE, 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.DESOLATE, EnumExtraBeeSpecies.getVanilla("Austere"), EnumExtraBeeSpecies.CREEPER, 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.GNAWING, EnumExtraBeeSpecies.getVanilla("Common"), EnumExtraBeeSpecies.DECOMPOSING, 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.ROCK, EnumExtraBeeSpecies.getVanilla("Diligent"), EnumExtraBeeSpecies.STONE, 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.ROCK, (IAlleleBeeSpecies)EnumExtraBeeSpecies.STONE, EnumExtraBeeSpecies.GRANITE, 15);
        new ExtraBeeMutation(EnumExtraBeeSpecies.getVanilla("Imperial"), (IAlleleBeeSpecies)EnumExtraBeeSpecies.GRANITE, EnumExtraBeeSpecies.MINERAL, 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.MINERAL, EnumExtraBeeSpecies.getVanilla("Meadows"), EnumExtraBeeSpecies.IRON, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.MINERAL, EnumExtraBeeSpecies.getVanilla("Forest"), EnumExtraBeeSpecies.COPPER, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.MINERAL, EnumExtraBeeSpecies.getVanilla("Marshy"), EnumExtraBeeSpecies.TIN, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.MINERAL, EnumExtraBeeSpecies.getVanilla("Unweary"), EnumExtraBeeSpecies.LEAD, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.TIN, EnumExtraBeeSpecies.getVanilla("Cultivated"), EnumExtraBeeSpecies.ZINC, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.MINERAL, EnumExtraBeeSpecies.getVanilla("Unweary"), EnumExtraBeeSpecies.NICKEL, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.MINERAL, EnumExtraBeeSpecies.getVanilla("Noble"), EnumExtraBeeSpecies.TITANIUM, 3);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.MINERAL, EnumExtraBeeSpecies.getVanilla("Ended"), EnumExtraBeeSpecies.TUNGSTATE, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.IRON, EnumExtraBeeSpecies.getVanilla("Imperial"), EnumExtraBeeSpecies.SILVER, 2);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.COPPER, EnumExtraBeeSpecies.getVanilla("Imperial"), EnumExtraBeeSpecies.GOLD, 2);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.GOLD, (IAlleleBeeSpecies)EnumExtraBeeSpecies.SILVER, EnumExtraBeeSpecies.PLATINUM, 2);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.MINERAL, (IAlleleBeeSpecies)EnumExtraBeeSpecies.WATER, EnumExtraBeeSpecies.LAPIS, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.LAPIS, EnumExtraBeeSpecies.getVanilla("Noble"), EnumExtraBeeSpecies.EMERALD, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.EMERALD, EnumExtraBeeSpecies.getVanilla("Austere"), EnumExtraBeeSpecies.RUBY, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.EMERALD, (IAlleleBeeSpecies)EnumExtraBeeSpecies.OCEAN, EnumExtraBeeSpecies.SAPPHIRE, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.LAPIS, EnumExtraBeeSpecies.getVanilla("Imperial"), EnumExtraBeeSpecies.DIAMOND, 5);
        new ExtraBeeMutation(EnumExtraBeeSpecies.getVanilla("Austere"), (IAlleleBeeSpecies)EnumExtraBeeSpecies.ROCK, EnumExtraBeeSpecies.UNSTABLE, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.UNSTABLE, (IAlleleBeeSpecies)EnumExtraBeeSpecies.IRON, EnumExtraBeeSpecies.NUCLEAR, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.NUCLEAR, (IAlleleBeeSpecies)EnumExtraBeeSpecies.GOLD, EnumExtraBeeSpecies.RADIOACTIVE, 5);
        new ExtraBeeMutation(EnumExtraBeeSpecies.getVanilla("Noble"), EnumExtraBeeSpecies.getVanilla("Diligent"), EnumExtraBeeSpecies.ANCIENT, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.ANCIENT, EnumExtraBeeSpecies.getVanilla("Noble"), EnumExtraBeeSpecies.PRIMEVAL, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.PRIMEVAL, EnumExtraBeeSpecies.getVanilla("Majestic"), EnumExtraBeeSpecies.PREHISTORIC, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.PREHISTORIC, EnumExtraBeeSpecies.getVanilla("Imperial"), EnumExtraBeeSpecies.RELIC, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.PRIMEVAL, (IAlleleBeeSpecies)EnumExtraBeeSpecies.GROWING, EnumExtraBeeSpecies.COAL, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.PRIMEVAL, (IAlleleBeeSpecies)EnumExtraBeeSpecies.FUNGAL, EnumExtraBeeSpecies.RESIN, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.PRIMEVAL, (IAlleleBeeSpecies)EnumExtraBeeSpecies.OCEAN, EnumExtraBeeSpecies.OIL, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.PRIMEVAL, (IAlleleBeeSpecies)EnumExtraBeeSpecies.BOGGY, EnumExtraBeeSpecies.PEAT, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.OIL, EnumExtraBeeSpecies.getVanilla("Industrious"), EnumExtraBeeSpecies.DISTILLED, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.OIL, (IAlleleBeeSpecies)EnumExtraBeeSpecies.DISTILLED, EnumExtraBeeSpecies.FUEL, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.FUEL, (IAlleleBeeSpecies)EnumExtraBeeSpecies.COAL, EnumExtraBeeSpecies.CREOSOTE, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.FUEL, (IAlleleBeeSpecies)EnumExtraBeeSpecies.RESIN, EnumExtraBeeSpecies.LATEX, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.WATER, EnumExtraBeeSpecies.getVanilla("Common"), EnumExtraBeeSpecies.RIVER, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.WATER, EnumExtraBeeSpecies.getVanilla("Diligent"), EnumExtraBeeSpecies.OCEAN, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.BLACK, (IAlleleBeeSpecies)EnumExtraBeeSpecies.OCEAN, EnumExtraBeeSpecies.INK, 8);
        new ExtraBeeMutation(EnumExtraBeeSpecies.getVanilla("Diligent"), EnumExtraBeeSpecies.getVanilla("Forest"), EnumExtraBeeSpecies.GROWING, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.GROWING, EnumExtraBeeSpecies.getVanilla("Rural"), EnumExtraBeeSpecies.THRIVING, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.THRIVING, (IAlleleBeeSpecies)EnumExtraBeeSpecies.GROWING, EnumExtraBeeSpecies.BLOOMING, 8);
        new ExtraBeeMutation(EnumExtraBeeSpecies.getVanilla("Valiant"), EnumExtraBeeSpecies.getVanilla("Diligent"), EnumExtraBeeSpecies.SWEET, 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.SWEET, EnumExtraBeeSpecies.getVanilla("Diligent"), EnumExtraBeeSpecies.SUGAR, 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.SUGAR, EnumExtraBeeSpecies.getVanilla("Forest"), EnumExtraBeeSpecies.RIPENING, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.RIPENING, EnumExtraBeeSpecies.getVanilla("Rural"), EnumExtraBeeSpecies.FRUIT, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.FRUIT, EnumExtraBeeSpecies.getVanilla("Rural"), EnumExtraBeeSpecies.ALCOHOL, 10);
        new ExtraBeeMutation(EnumExtraBeeSpecies.getVanilla("Cultivated"), EnumExtraBeeSpecies.getVanilla("Rural"), EnumExtraBeeSpecies.FARM, 10);
        new ExtraBeeMutation(EnumExtraBeeSpecies.getVanilla("Rural"), (IAlleleBeeSpecies)EnumExtraBeeSpecies.WATER, EnumExtraBeeSpecies.MILK, 10);
        new ExtraBeeMutation(EnumExtraBeeSpecies.getVanilla("Tropical"), EnumExtraBeeSpecies.getVanilla("Rural"), EnumExtraBeeSpecies.COFFEE, 10);
        new ExtraBeeMutation(EnumExtraBeeSpecies.getVanilla("Modest"), (IAlleleBeeSpecies)EnumExtraBeeSpecies.FARM, EnumExtraBeeSpecies.CITRUS, 10);
        new ExtraBeeMutation(EnumExtraBeeSpecies.getVanilla("Tropical"), (IAlleleBeeSpecies)EnumExtraBeeSpecies.FARM, EnumExtraBeeSpecies.MINT, 10);
        new ExtraBeeMutation(EnumExtraBeeSpecies.getVanilla("Common"), EnumExtraBeeSpecies.getVanilla("Marshy"), EnumExtraBeeSpecies.SWAMP, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.SWAMP, EnumExtraBeeSpecies.getVanilla("Marshy"), EnumExtraBeeSpecies.BOGGY, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.BOGGY, (IAlleleBeeSpecies)EnumExtraBeeSpecies.SWAMP, EnumExtraBeeSpecies.FUNGAL, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.WATER, EnumExtraBeeSpecies.getVanilla("Forest"), EnumExtraBeeSpecies.getVanillaTemplate("Common"), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.WATER, EnumExtraBeeSpecies.getVanilla("Meadows"), EnumExtraBeeSpecies.getVanillaTemplate("Common"), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.WATER, EnumExtraBeeSpecies.getVanilla("Modest"), EnumExtraBeeSpecies.getVanillaTemplate("Common"), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.WATER, EnumExtraBeeSpecies.getVanilla("Tropical"), EnumExtraBeeSpecies.getVanillaTemplate("Common"), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.WATER, EnumExtraBeeSpecies.getVanilla("Marshy"), EnumExtraBeeSpecies.getVanillaTemplate("Common"), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.WATER, EnumExtraBeeSpecies.getVanilla("Wintry"), EnumExtraBeeSpecies.getVanillaTemplate("Common"), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.WATER, (IAlleleBeeSpecies)EnumExtraBeeSpecies.ROCK, EnumExtraBeeSpecies.getVanillaTemplate("Common"), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.WATER, (IAlleleBeeSpecies)EnumExtraBeeSpecies.BASALT, EnumExtraBeeSpecies.getVanillaTemplate("Common"), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.ROCK, EnumExtraBeeSpecies.getVanilla("Forest"), EnumExtraBeeSpecies.getVanillaTemplate("Common"), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.ROCK, EnumExtraBeeSpecies.getVanilla("Meadows"), EnumExtraBeeSpecies.getVanillaTemplate("Common"), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.ROCK, EnumExtraBeeSpecies.getVanilla("Modest"), EnumExtraBeeSpecies.getVanillaTemplate("Common"), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.ROCK, EnumExtraBeeSpecies.getVanilla("Tropical"), EnumExtraBeeSpecies.getVanillaTemplate("Common"), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.ROCK, EnumExtraBeeSpecies.getVanilla("Marshy"), EnumExtraBeeSpecies.getVanillaTemplate("Common"), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.ROCK, EnumExtraBeeSpecies.getVanilla("Wintry"), EnumExtraBeeSpecies.getVanillaTemplate("Common"), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.ROCK, (IAlleleBeeSpecies)EnumExtraBeeSpecies.BASALT, EnumExtraBeeSpecies.getVanillaTemplate("Common"), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.WATER, EnumExtraBeeSpecies.getVanilla("Common"), EnumExtraBeeSpecies.getVanillaTemplate("Cultivated"), 12);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.ROCK, EnumExtraBeeSpecies.getVanilla("Common"), EnumExtraBeeSpecies.getVanillaTemplate("Cultivated"), 12);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.BASALT, EnumExtraBeeSpecies.getVanilla("Sinister"), EnumExtraBeeSpecies.TEMPERED, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.BASALT, (IAlleleBeeSpecies)EnumExtraBeeSpecies.TEMPERED, EnumExtraBeeSpecies.VOLCANIC, 6);
        new ExtraBeeMutation(EnumExtraBeeSpecies.getVanilla("Sinister"), EnumExtraBeeSpecies.getVanilla("Tropical"), EnumExtraBeeSpecies.MALICIOUS, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.MALICIOUS, EnumExtraBeeSpecies.getVanilla("Tropical"), EnumExtraBeeSpecies.INFECTIOUS, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.MALICIOUS, (IAlleleBeeSpecies)EnumExtraBeeSpecies.INFECTIOUS, EnumExtraBeeSpecies.VIRULENT, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.WATER, EnumExtraBeeSpecies.getVanilla("Exotic"), EnumExtraBeeSpecies.VISCOUS, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.VISCOUS, EnumExtraBeeSpecies.getVanilla("Exotic"), EnumExtraBeeSpecies.GLUTINOUS, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.VISCOUS, (IAlleleBeeSpecies)EnumExtraBeeSpecies.GLUTINOUS, EnumExtraBeeSpecies.STICKY, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.VIRULENT, (IAlleleBeeSpecies)EnumExtraBeeSpecies.STICKY, EnumExtraBeeSpecies.CORROSIVE, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.CORROSIVE, EnumExtraBeeSpecies.getVanilla("Fiendish"), EnumExtraBeeSpecies.CAUSTIC, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.CORROSIVE, (IAlleleBeeSpecies)EnumExtraBeeSpecies.CAUSTIC, EnumExtraBeeSpecies.ACIDIC, 4);
        new ExtraBeeMutation(EnumExtraBeeSpecies.getVanilla("Cultivated"), EnumExtraBeeSpecies.getVanilla("Valiant"), EnumExtraBeeSpecies.EXCITED, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.EXCITED, EnumExtraBeeSpecies.getVanilla("Valiant"), EnumExtraBeeSpecies.ENERGETIC, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.EXCITED, (IAlleleBeeSpecies)EnumExtraBeeSpecies.ENERGETIC, EnumExtraBeeSpecies.ECSTATIC, 8);
        new ExtraBeeMutation(EnumExtraBeeSpecies.getVanilla("Wintry"), EnumExtraBeeSpecies.getVanilla("Diligent"), EnumExtraBeeSpecies.ARTIC, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.OCEAN, (IAlleleBeeSpecies)EnumExtraBeeSpecies.ARTIC, EnumExtraBeeSpecies.FREEZING, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.STONE, EnumExtraBeeSpecies.getVanilla("Sinister"), EnumExtraBeeSpecies.SHADOW, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.SHADOW, (IAlleleBeeSpecies)EnumExtraBeeSpecies.BASALT, EnumExtraBeeSpecies.DARKENED, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.SHADOW, (IAlleleBeeSpecies)EnumExtraBeeSpecies.DARKENED, EnumExtraBeeSpecies.ABYSS, 8);
        new ExtraBeeMutation(EnumExtraBeeSpecies.getVanilla("Forest"), EnumExtraBeeSpecies.getVanilla("Valiant"), EnumExtraBeeSpecies.RED, 5);
        new ExtraBeeMutation(EnumExtraBeeSpecies.getVanilla("Meadows"), EnumExtraBeeSpecies.getVanilla("Valiant"), EnumExtraBeeSpecies.YELLOW, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.WATER, EnumExtraBeeSpecies.getVanilla("Valiant"), EnumExtraBeeSpecies.BLUE, 5);
        new ExtraBeeMutation(EnumExtraBeeSpecies.getVanilla("Tropical"), EnumExtraBeeSpecies.getVanilla("Valiant"), EnumExtraBeeSpecies.GREEN, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.ROCK, EnumExtraBeeSpecies.getVanilla("Valiant"), EnumExtraBeeSpecies.BLACK, 5);
        new ExtraBeeMutation(EnumExtraBeeSpecies.getVanilla("Wintry"), EnumExtraBeeSpecies.getVanilla("Valiant"), EnumExtraBeeSpecies.WHITE, 5);
        new ExtraBeeMutation(EnumExtraBeeSpecies.getVanilla("Marshy"), EnumExtraBeeSpecies.getVanilla("Valiant"), EnumExtraBeeSpecies.BROWN, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.RED, (IAlleleBeeSpecies)EnumExtraBeeSpecies.YELLOW, EnumExtraBeeSpecies.ORANGE, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.GREEN, (IAlleleBeeSpecies)EnumExtraBeeSpecies.BLUE, EnumExtraBeeSpecies.CYAN, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.RED, (IAlleleBeeSpecies)EnumExtraBeeSpecies.BLUE, EnumExtraBeeSpecies.PURPLE, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.BLACK, (IAlleleBeeSpecies)EnumExtraBeeSpecies.WHITE, EnumExtraBeeSpecies.GRAY, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.BLUE, (IAlleleBeeSpecies)EnumExtraBeeSpecies.WHITE, EnumExtraBeeSpecies.LIGHTBLUE, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.RED, (IAlleleBeeSpecies)EnumExtraBeeSpecies.WHITE, EnumExtraBeeSpecies.PINK, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.GREEN, (IAlleleBeeSpecies)EnumExtraBeeSpecies.WHITE, EnumExtraBeeSpecies.LIMEGREEN, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.PURPLE, (IAlleleBeeSpecies)EnumExtraBeeSpecies.PINK, EnumExtraBeeSpecies.MAGENTA, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.GRAY, (IAlleleBeeSpecies)EnumExtraBeeSpecies.WHITE, EnumExtraBeeSpecies.LIGHTGRAY, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.TEMPERED, (IAlleleBeeSpecies)EnumExtraBeeSpecies.EXCITED, EnumExtraBeeSpecies.GLOWSTONE, 5);
        new ExtraBeeMutation(EnumExtraBeeSpecies.getVanilla("Austere"), (IAlleleBeeSpecies)EnumExtraBeeSpecies.DESOLATE, EnumExtraBeeSpecies.HAZARDOUS, 5);
        new ExtraBeeMutation(EnumExtraBeeSpecies.getVanilla("Ended"), (IAlleleBeeSpecies)EnumExtraBeeSpecies.RELIC, EnumExtraBeeSpecies.JADED, 2);
        new ExtraBeeMutation(EnumExtraBeeSpecies.getVanilla("Austere"), (IAlleleBeeSpecies)EnumExtraBeeSpecies.EXCITED, EnumExtraBeeSpecies.CELEBRATORY, 5);
        new ExtraBeeMutation(EnumExtraBeeSpecies.getVanilla("Secluded"), EnumExtraBeeSpecies.getVanilla("Ended"), EnumExtraBeeSpecies.UNUSUAL, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.UNUSUAL, EnumExtraBeeSpecies.getVanilla("Hermitic"), EnumExtraBeeSpecies.SPATIAL, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)EnumExtraBeeSpecies.SPATIAL, EnumExtraBeeSpecies.getVanilla("Spectral"), EnumExtraBeeSpecies.QUANTUM, 5);
        for (IBeeMutation mutation : mutations) {
            Binnie.Genetics.getBeeRoot().registerMutation((IMutation)mutation);
        }
    }

    public ExtraBeeMutation(IAlleleBeeSpecies allele0, IAlleleBeeSpecies allele1, EnumExtraBeeSpecies mutation, int chance) {
        this(allele0, allele1, mutation.getTemplate(), chance);
    }

    public ExtraBeeMutation(IAlleleBeeSpecies allele0, IAlleleBeeSpecies allele1, IAllele[] mutation, int chance) {
        this.chance = chance;
        this.species0 = allele0;
        this.species1 = allele1;
        this.template = mutation;
        if (this.species0 != null && this.species1 != null && this.template != null) {
            mutations.add(this);
        }
    }

    public IAllele getAllele0() {
        return this.species0;
    }

    public IAllele getAllele1() {
        return this.species1;
    }

    public IAllele[] getTemplate() {
        return this.template;
    }

    public float getBaseChance() {
        return this.chance;
    }

    public boolean isPartner(IAllele allele) {
        return allele.getUID().equals(this.species0.getUID()) || allele.getUID().equals(this.species1.getUID());
    }

    public IAllele getPartner(IAllele allele) {
        return allele.getUID().equals(this.species0.getUID()) ? this.species1 : this.species0;
    }

    public boolean isSecret() {
        return false;
    }

    public float getChance(IBeeHousing housing, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        if (this.species0 == null || this.species1 == null || allele0 == null || allele1 == null) {
            return 0.0f;
        }
        World world = housing.getWorld();
        int x = housing.getXCoord();
        int y = housing.getYCoord();
        int z = housing.getZCoord();
        int biome = housing.getBiomeId();
        if (!(this.template[0] != EnumExtraBeeSpecies.JADED || housing.getOwnerName() != null && housing.getOwnerName().equals("jadedcat"))) {
            return 0.0f;
        }
        if (this.template[0] == EnumExtraBeeSpecies.OCEAN && BiomeGenBase.field_76773_a[biome] != BiomeGenBase.field_76771_b) {
            return 0.0f;
        }
        int processedChance = Math.round((float)this.chance * housing.getMutationModifier((IBeeGenome)genome0, (IBeeGenome)genome1, 1.0f) * Binnie.Genetics.getBeeRoot().getBeekeepingMode(world).getMutationModifier((IBeeGenome)genome0, (IBeeGenome)genome1, 1.0f));
        if (this.species0.getUID().equals(allele0.getUID()) && this.species1.getUID().equals(allele1.getUID())) {
            return processedChance;
        }
        if (this.species1.getUID().equals(allele0.getUID()) && this.species0.getUID().equals(allele1.getUID())) {
            return processedChance;
        }
        return 0.0f;
    }

    public Collection<String> getSpecialConditions() {
        ArrayList<String> conditions = new ArrayList<String>();
        if (this.getTemplate()[0] == EnumExtraBeeSpecies.OCEAN) {
            conditions.add("Hive needs to be in Ocean");
        }
        return conditions;
    }

    public IBeeRoot getRoot() {
        return Binnie.Genetics.getBeeRoot();
    }
}

