/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.genetics;

import binnie.core.Binnie;
import binnie.core.BinnieCore;
import binnie.core.item.IItemEnum;
import binnie.core.language.LocalisedString;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.engineering.ModuleEngineering;
import binnie.extrabees.genetics.EnumExtraBeeFlowers;
import binnie.extrabees.genetics.effect.EnumExtraBeeEffect;
import binnie.extrabees.products.EnumHoneyComb;
import binnie.extrabees.products.ItemHoneyComb;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IIconProvider;
import forestry.api.core.ItemInterface;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public enum EnumExtraBeeSpecies implements IAlleleBeeSpecies,
IIconProvider
{
    ARID("aridus", 12511316),
    BARREN("infelix", 14733923),
    DESOLATE("desolo", 13744272),
    GNAWING("apica", 15234224),
    ROTTEN("caries", 12574902),
    BONE("os", 15330792),
    CREEPER("erepo", 2942485),
    DECOMPOSING("aegrus", 5388049),
    ROCK("saxum", 0xA8A8A8),
    STONE("lapis", 0x757575),
    GRANITE("granum", 0x695555),
    MINERAL("minerale", 7239037),
    COPPER("cuprous", 13722376),
    TIN("stannus", 0xBDB1BD),
    IRON("ferrous", 11038808),
    LEAD("plumbous", 11373483),
    ZINC("spelta", 15592447),
    TITANIUM("titania", 11578083),
    BRONZE("pyropus", 13926677),
    BRASS("braza", 16768343),
    STEEL("stela", 0x333238),
    TUNGSTATE("wolfram", 1249812),
    GOLD("aureus", 15125515),
    SILVER("argentus", 0xDBDBDB),
    ELECTRUM("electra", 16247708),
    PLATINUM("platina", 0xDBDBDB),
    LAPIS("lazuli", 4009179),
    SODALITE("soda", 1396717),
    PYRITE("pyrus", 14919481),
    BAUXITE("bauxus", 10249472),
    CINNABAR("cinna", 4665867),
    SPHALERITE("spahleri", 14406941),
    EMERALD("emerala", 1900291),
    RUBY("ruba", 0xD60000),
    SAPPHIRE("saphhira", 673791),
    OLIVINE("olivia", 8060779),
    DIAMOND("diama", 8371706),
    UNSTABLE("levis", 4099124),
    NUCLEAR("nucleus", 4312111),
    RADIOACTIVE("fervens", 2031360),
    ANCIENT("antiquus", 15915919),
    PRIMEVAL("priscus", 11773563),
    PREHISTORIC("pristinus", 7232064),
    RELIC("sapiens", 5062166),
    COAL("carbo", 8025672),
    RESIN("lacrima", 10908443),
    OIL("lubricus", 5719920),
    PEAT("peatus", 9185802),
    DISTILLED("distilli", 0x356356),
    FUEL("refina", 16760835),
    CREOSOTE("creosota", 9936403),
    LATEX("latex", 4803134),
    WATER("aqua", 9741055),
    RIVER("flumen", 8631252),
    OCEAN("mare", 1912493),
    INK("atramentum", 922695),
    GROWING("tyrelli", 6024152),
    THRIVING("thriva", 3466109),
    BLOOMING("blooma", 704308),
    SWEET("mellitus", 16536049),
    SUGAR("dulcis", 15127520),
    RIPENING("ripa", 11716445),
    FRUIT("pomum", 14375030),
    ALCOHOL("vinum", 15239777),
    FARM("ager", 7723872),
    MILK("lacteus", 0xE3E8E8),
    COFFEE("arabica", 9199152),
    CITRUS("citrus", 16444501),
    MINT("minty", 7206760),
    SWAMP("paludis", 3500339),
    BOGGY("lama", 7887913),
    FUNGAL("boletus", 13722112),
    MARBLE("marbla", 14076367),
    ROMAN("roman", 11373488),
    GREEK("greco", 8735882),
    CLASSICAL("classica", 8592780),
    BASALT("aceri", 9202025),
    TEMPERED("iratus", 0x8A4848),
    ANGRY("iratus", 8396575),
    VOLCANIC("volcano", 5049356),
    MALICIOUS("acerbus", 7875191),
    INFECTIOUS("contagio", 12070581),
    VIRULENT("morbus", 15733740),
    VISCOUS("liquidus", 608014),
    GLUTINOUS("glutina", 1936423),
    STICKY("lentesco", 1565480),
    CORROSIVE("corrumpo", 4873227),
    CAUSTIC("torrens", 8691997),
    ACIDIC("acidus", 12644374),
    EXCITED("excita", 0xFF4545),
    ENERGETIC("energia", 15218119),
    ECSTATIC("ecstatica", 11482600),
    ARTIC("artica", 11395296),
    FREEZING("glacia", 8119267),
    SHADOW("shadowa", 0x595959),
    DARKENED("darka", 0x332E33),
    ABYSS("abyssba", 2164769),
    RED("rubra", 0xFF0000),
    YELLOW("fulvus", 0xFFDD00),
    BLUE("caeruleus", 8959),
    GREEN("prasinus", 39168),
    BLACK("niger", 0x575757),
    WHITE("albus", 0xFFFFFF),
    BROWN("fuscus", 6042895),
    ORANGE("flammeus", 16751872),
    CYAN("cyana", 65509),
    PURPLE("purpureus", 11403519),
    GRAY("ravus", 0xBABABA),
    LIGHTBLUE("aqua", 40447),
    PINK("rosaceus", 16744671),
    LIMEGREEN("lima", 65288),
    MAGENTA("fuchsia", 0xFF00CC),
    LIGHTGRAY("canus", 0xC9C9C9),
    CELEBRATORY("celeba", 16386666),
    JADED("jadeca", 16386666),
    GLOWSTONE("glowia", 14730779),
    HAZARDOUS("infensus", 11562024),
    NICKEL("claro", 16768764),
    INVAR("invara", 13625551),
    QUANTUM("quanta", 3655131),
    SPATIAL("spatia", 4987872),
    UNUSUAL("daniella", 5874874);

    private LocalisedString name = Binnie.Language.register(ExtraBees.instance, "species." + this.name().toLowerCase() + ".name");
    private LocalisedString description = Binnie.Language.register(ExtraBees.instance, "species." + this.name().toLowerCase() + ".desc");
    private int primaryColor = 0xFFFFFF;
    private int secondaryColor = 16768022;
    private EnumTemperature temperature = EnumTemperature.NORMAL;
    private EnumHumidity humidity = EnumHumidity.NORMAL;
    private boolean hasEffect = false;
    private boolean isSecret = true;
    private boolean isCounted = true;
    private String binomial = "";
    private IClassification branch = null;
    private String uid = "";
    private Achievement achievement = null;
    private boolean dominant = true;
    private HashMap<ItemStack, Integer> products = new LinkedHashMap<ItemStack, Integer>();
    private HashMap<ItemStack, Integer> specialties = new LinkedHashMap<ItemStack, Integer>();
    private IAllele[] template;
    boolean active = true;
    @SideOnly(value=Side.CLIENT)
    private Icon[][] icons;
    boolean nocturnal = false;

    public String getName() {
        return this.name.get();
    }

    public String getDescription() {
        return this.description.getOrBlank();
    }

    public EnumTemperature getTemperature() {
        return this.temperature;
    }

    public EnumHumidity getHumidity() {
        return this.humidity;
    }

    public boolean hasEffect() {
        return this.hasEffect;
    }

    public boolean isSecret() {
        return this.isSecret;
    }

    public boolean isCounted() {
        return this.isCounted;
    }

    public String getBinomial() {
        return this.binomial;
    }

    public String getAuthority() {
        return "Binnie";
    }

    public IClassification getBranch() {
        return this.branch;
    }

    public String getUID() {
        return "extrabees.species." + this.uid;
    }

    public boolean isDominant() {
        return this.dominant;
    }

    public HashMap<ItemStack, Integer> getProducts() {
        return this.products;
    }

    public HashMap<ItemStack, Integer> getSpecialty() {
        return this.specialties;
    }

    private EnumExtraBeeSpecies(String binomial, int colour) {
        this.uid = this.toString().toLowerCase();
        this.binomial = binomial;
        this.primaryColor = colour;
    }

    public void init() {
        this.template = EnumExtraBeeSpecies.getDefaultTemplate();
    }

    public void register() {
        Binnie.Genetics.getBeeRoot().registerTemplate(this.getTemplate());
        AlleleManager.alleleRegistry.registerAllele((IAllele)this);
        if (!this.active) {
            AlleleManager.alleleRegistry.blacklistAllele(this.getUID());
        }
    }

    public void addProduct(ItemStack product, int chance) {
        if (product == null) {
            this.active = false;
        } else {
            this.products.put(product, chance);
        }
    }

    public void addProduct(IItemEnum product, int chance) {
        if (product.isActive()) {
            this.addProduct(product.get(1), chance);
        } else {
            this.active = false;
        }
    }

    public void addSpecialty(ItemStack product, int chance) {
        if (product == null) {
            this.active = false;
        } else {
            this.specialties.put(product, chance);
        }
    }

    public void addSpecialty(IItemEnum product, int chance) {
        if (product.isActive()) {
            this.addSpecialty(product.get(1), chance);
        } else {
            this.active = false;
        }
    }

    public void setHumidity(EnumHumidity humidity) {
        this.humidity = humidity;
    }

    public void setTemperature(EnumTemperature temperature) {
        this.temperature = temperature;
    }

    public static IAllele[] getDefaultTemplate() {
        return Binnie.Genetics.getBeeRoot().getDefaultTemplate();
    }

    public IAllele[] getTemplate() {
        this.template[EnumBeeChromosome.SPECIES.ordinal()] = this;
        return this.template;
    }

    public void importVanillaTemplate(String uid) {
        String text = uid.substring(0, 1).toUpperCase() + uid.substring(1).toLowerCase();
        IAllele[] vanilla = Binnie.Genetics.getBeeRoot().getTemplate("forestry.species" + text);
        if (vanilla != null) {
            this.importTemplate(vanilla);
        } else {
            FMLLog.getLogger().warning("Couldn't find vanilla template - forestry.species" + text);
        }
    }

    public void importTemplate(EnumExtraBeeSpecies species) {
        this.importTemplate(species.getTemplate());
    }

    public void importTemplate(IAllele[] template) {
        this.template = (IAllele[])template.clone();
        this.setHumidity(((IAlleleSpecies)template[0]).getHumidity());
        this.setTemperature(((IAlleleSpecies)template[0]).getTemperature());
        this.setSecondaryColor(((IAlleleSpecies)template[0]).getIconColour(1));
        this.template[EnumBeeChromosome.SPECIES.ordinal()] = this;
    }

    public void recessive() {
        this.dominant = false;
    }

    public void setIsSecret(boolean secret) {
        this.isSecret = secret;
    }

    public void setHasEffect(boolean effect) {
        this.hasEffect = effect;
    }

    public void setSecondaryColor(int colour) {
        this.secondaryColor = colour;
    }

    public static void doInit() {
        for (EnumExtraBeeSpecies species : EnumExtraBeeSpecies.values()) {
            species.init();
        }
        AlleleManager.alleleRegistry.blacklistAllele(BRONZE.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(BRASS.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(STEEL.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(ELECTRUM.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(SODALITE.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(PYRITE.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(BAUXITE.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(CINNABAR.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(SPHALERITE.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(OLIVINE.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(MARBLE.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(ROMAN.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(GREEK.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(CLASSICAL.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(INVAR.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(ANGRY.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(CITRUS.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(MINT.getUID());
        int aridBody = 13362036;
        int rockBody = 0x999999;
        int endBody = 0xD9DE9E;
        ARID.importVanillaTemplate("modest");
        ARID.addProduct(EnumHoneyComb.BARREN, 30);
        ARID.setHumidity(EnumHumidity.ARID);
        ARID.setFlowerProvider(EnumExtraBeeFlowers.DEAD.getUID());
        ARID.setTemperatureTolerance(ModuleEngineering.Tolerance.Up1);
        ARID.setSecondaryColor(aridBody);
        BARREN.importTemplate(ARID);
        BARREN.setFertility(ModuleEngineering.Fertility.Low);
        BARREN.addProduct(EnumHoneyComb.BARREN, 30);
        DESOLATE.addProduct(EnumHoneyComb.BARREN, 30);
        DESOLATE.importTemplate(BARREN);
        DESOLATE.setEffect(EnumExtraBeeEffect.HUNGER.getUID());
        DESOLATE.recessive();
        GNAWING.importTemplate(BARREN);
        GNAWING.setFlowerProvider(EnumExtraBeeFlowers.WOOD.getUID());
        GNAWING.addProduct(EnumHoneyComb.BARREN, 25);
        GNAWING.addSpecialty(EnumHoneyComb.SAWDUST, 25);
        ROTTEN.importTemplate(DESOLATE);
        ROTTEN.setNocturnal();
        ROTTEN.setCaveDwelling();
        ROTTEN.setTolerantFlyer();
        ROTTEN.setEffect(EnumExtraBeeEffect.SPAWN_ZOMBIE.getUID());
        ROTTEN.addProduct(EnumHoneyComb.BARREN, 30);
        ROTTEN.addSpecialty(EnumHoneyComb.ROTTEN, 10);
        BONE.importTemplate(ROTTEN);
        BONE.addProduct(EnumHoneyComb.BARREN, 30);
        BONE.addSpecialty(EnumHoneyComb.BONE, 10);
        BONE.setEffect(EnumExtraBeeEffect.SPAWN_SKELETON.getUID());
        CREEPER.importTemplate(ROTTEN);
        CREEPER.setAllDay();
        CREEPER.addProduct(EnumHoneyComb.BARREN, 30);
        CREEPER.addSpecialty(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.POWDERY), 8);
        CREEPER.setEffect(EnumExtraBeeEffect.SPAWN_CREEPER.getUID());
        DECOMPOSING.importTemplate(BARREN);
        DECOMPOSING.addProduct(EnumHoneyComb.BARREN, 30);
        DECOMPOSING.addSpecialty(EnumHoneyComb.COMPOST, 8);
        ROCK.addProduct(EnumHoneyComb.STONE, 30);
        ROCK.setIsSecret(false);
        ROCK.setAllDay();
        ROCK.setCaveDwelling();
        ROCK.setTolerantFlyer();
        ROCK.setTemperatureTolerance(ModuleEngineering.Tolerance.Both1);
        ROCK.setHumidityTolerance(ModuleEngineering.Tolerance.Both1);
        ROCK.setFlowerProvider(EnumExtraBeeFlowers.ROCK.getUID());
        ROCK.setFertility(ModuleEngineering.Fertility.Low);
        ROCK.setLifespan(ModuleEngineering.Lifespan.Short);
        ROCK.setSecondaryColor(rockBody);
        STONE.addProduct(EnumHoneyComb.STONE, 30);
        STONE.importTemplate(ROCK);
        STONE.recessive();
        STONE.setSecondaryColor(rockBody);
        GRANITE.addProduct(EnumHoneyComb.STONE, 30);
        GRANITE.importTemplate(STONE);
        GRANITE.setTemperatureTolerance(ModuleEngineering.Tolerance.Both2);
        GRANITE.setHumidityTolerance(ModuleEngineering.Tolerance.Both2);
        GRANITE.setSecondaryColor(rockBody);
        MINERAL.addProduct(EnumHoneyComb.STONE, 30);
        MINERAL.importTemplate(GRANITE);
        MINERAL.setSecondaryColor(rockBody);
        COPPER.addProduct(EnumHoneyComb.STONE, 20);
        COPPER.addSpecialty(EnumHoneyComb.COPPER, 6);
        COPPER.importTemplate(MINERAL);
        COPPER.setSecondaryColor(rockBody);
        TIN.addProduct(EnumHoneyComb.STONE, 20);
        TIN.addSpecialty(EnumHoneyComb.TIN, 6);
        TIN.importTemplate(MINERAL);
        TIN.setSecondaryColor(rockBody);
        IRON.addProduct(EnumHoneyComb.STONE, 20);
        IRON.addSpecialty(EnumHoneyComb.IRON, 5);
        IRON.importTemplate(MINERAL);
        IRON.recessive();
        IRON.setSecondaryColor(rockBody);
        LEAD.addProduct(EnumHoneyComb.STONE, 20);
        LEAD.addSpecialty(EnumHoneyComb.LEAD, 5);
        LEAD.importTemplate(MINERAL);
        LEAD.setSecondaryColor(rockBody);
        NICKEL.addProduct(EnumHoneyComb.STONE, 20);
        NICKEL.addSpecialty(EnumHoneyComb.NICKEL, 5);
        NICKEL.importTemplate(MINERAL);
        NICKEL.setSecondaryColor(rockBody);
        ZINC.addProduct(EnumHoneyComb.STONE, 20);
        ZINC.addSpecialty(EnumHoneyComb.ZINC, 5);
        ZINC.importTemplate(MINERAL);
        ZINC.setSecondaryColor(rockBody);
        TITANIUM.addProduct(EnumHoneyComb.STONE, 20);
        TITANIUM.addSpecialty(EnumHoneyComb.TITANIUM, 2);
        TITANIUM.importTemplate(MINERAL);
        TITANIUM.setSecondaryColor(rockBody);
        TUNGSTATE.addProduct(EnumHoneyComb.STONE, 20);
        TUNGSTATE.addSpecialty(EnumHoneyComb.TUNGSTEN, 1);
        TUNGSTATE.importTemplate(MINERAL);
        TUNGSTATE.setSecondaryColor(rockBody);
        GOLD.addProduct(EnumHoneyComb.STONE, 20);
        GOLD.addSpecialty(EnumHoneyComb.GOLD, 2);
        GOLD.importTemplate(MINERAL);
        GOLD.setSecondaryColor(rockBody);
        SILVER.addProduct(EnumHoneyComb.STONE, 20);
        SILVER.addSpecialty(EnumHoneyComb.SILVER, 2);
        SILVER.importTemplate(MINERAL);
        SILVER.recessive();
        SILVER.recessive();
        SILVER.setSecondaryColor(rockBody);
        PLATINUM.addProduct(EnumHoneyComb.STONE, 20);
        PLATINUM.addSpecialty(EnumHoneyComb.PLATINUM, 1);
        PLATINUM.importTemplate(MINERAL);
        PLATINUM.recessive();
        PLATINUM.setSecondaryColor(rockBody);
        LAPIS.addProduct(EnumHoneyComb.STONE, 20);
        LAPIS.addSpecialty(EnumHoneyComb.LAPIS, 5);
        LAPIS.importTemplate(MINERAL);
        LAPIS.setSecondaryColor(rockBody);
        EMERALD.addProduct(EnumHoneyComb.STONE, 20);
        EMERALD.addSpecialty(EnumHoneyComb.EMERALD, 4);
        EMERALD.importTemplate(MINERAL);
        EMERALD.setSecondaryColor(rockBody);
        RUBY.addProduct(EnumHoneyComb.STONE, 20);
        RUBY.addSpecialty(EnumHoneyComb.RUBY, 3);
        RUBY.importTemplate(MINERAL);
        RUBY.setSecondaryColor(rockBody);
        SAPPHIRE.addProduct(EnumHoneyComb.STONE, 20);
        SAPPHIRE.addSpecialty(EnumHoneyComb.SAPPHIRE, 3);
        SAPPHIRE.importTemplate(MINERAL);
        SAPPHIRE.setSecondaryColor(rockBody);
        DIAMOND.addProduct(EnumHoneyComb.STONE, 20);
        DIAMOND.addSpecialty(EnumHoneyComb.DIAMOND, 1);
        DIAMOND.importTemplate(MINERAL);
        DIAMOND.setSecondaryColor(rockBody);
        UNSTABLE.importTemplate(MINERAL);
        UNSTABLE.addProduct(EnumHoneyComb.BARREN, 20);
        UNSTABLE.setEffect(EnumExtraBeeEffect.RADIOACTIVE.getUID());
        UNSTABLE.setFertility(ModuleEngineering.Fertility.Low);
        UNSTABLE.setLifespan(ModuleEngineering.Lifespan.Shortest);
        UNSTABLE.recessive();
        NUCLEAR.importTemplate(UNSTABLE);
        NUCLEAR.addProduct(EnumHoneyComb.BARREN, 20);
        NUCLEAR.recessive();
        RADIOACTIVE.importTemplate(NUCLEAR);
        RADIOACTIVE.addProduct(EnumHoneyComb.BARREN, 20);
        RADIOACTIVE.addSpecialty(EnumHoneyComb.URANIUM, 2);
        RADIOACTIVE.setHasEffect(true);
        RADIOACTIVE.recessive();
        ANCIENT.importVanillaTemplate("Noble");
        ANCIENT.addProduct(EnumHoneyComb.OLD, 30);
        ANCIENT.setLifespan(ModuleEngineering.Lifespan.Elongated);
        PRIMEVAL.importTemplate(ANCIENT);
        PRIMEVAL.addProduct(EnumHoneyComb.OLD, 30);
        PRIMEVAL.setLifespan(ModuleEngineering.Lifespan.Long);
        PREHISTORIC.importTemplate(ANCIENT);
        PREHISTORIC.addProduct(EnumHoneyComb.OLD, 30);
        PREHISTORIC.setLifespan(ModuleEngineering.Lifespan.Longer);
        PREHISTORIC.setFertility(ModuleEngineering.Fertility.Low);
        PREHISTORIC.recessive();
        RELIC.importTemplate(ANCIENT);
        RELIC.addProduct(EnumHoneyComb.OLD, 30);
        RELIC.setHasEffect(true);
        RELIC.setLifespan(ModuleEngineering.Lifespan.Longest);
        COAL.importTemplate(ANCIENT);
        COAL.setLifespan(ModuleEngineering.Lifespan.Normal);
        COAL.addProduct(EnumHoneyComb.OLD, 20);
        COAL.addSpecialty(EnumHoneyComb.COAL, 8);
        RESIN.importTemplate(COAL);
        RESIN.addProduct(EnumHoneyComb.OLD, 20);
        RESIN.addSpecialty(EnumHoneyComb.RESIN, 5);
        RESIN.recessive();
        OIL.importTemplate(COAL);
        OIL.addProduct(EnumHoneyComb.OLD, 20);
        OIL.addSpecialty(EnumHoneyComb.OIL, 5);
        PEAT.importTemplate(COAL);
        PEAT.addProduct(EnumHoneyComb.OLD, 20);
        PEAT.addSpecialty(EnumHoneyComb.PEAT, 8);
        DISTILLED.importTemplate(OIL);
        DISTILLED.addProduct(EnumHoneyComb.OIL, 10);
        DISTILLED.recessive();
        FUEL.importTemplate(OIL);
        FUEL.addProduct(EnumHoneyComb.OIL, 10);
        FUEL.addSpecialty(EnumHoneyComb.FUEL, 4);
        FUEL.setHasEffect(true);
        CREOSOTE.importTemplate(COAL);
        CREOSOTE.addProduct(EnumHoneyComb.COAL, 10);
        CREOSOTE.addSpecialty(EnumHoneyComb.CREOSOTE, 7);
        CREOSOTE.setHasEffect(true);
        LATEX.importTemplate(RESIN);
        LATEX.addProduct(EnumHoneyComb.RESIN, 10);
        LATEX.addSpecialty(EnumHoneyComb.LATEX, 5);
        LATEX.setHasEffect(true);
        WATER.addProduct(EnumHoneyComb.WATER, 30);
        WATER.setIsSecret(false);
        WATER.setTolerantFlyer();
        WATER.setHumidityTolerance(ModuleEngineering.Tolerance.Both1);
        WATER.setFlowerProvider(EnumExtraBeeFlowers.WATER.getUID());
        WATER.setFlowering(ModuleEngineering.Flowering.Slow);
        WATER.setEffect(EnumExtraBeeEffect.WATER.getUID());
        WATER.setHumidity(EnumHumidity.DAMP);
        RIVER.importTemplate(WATER);
        RIVER.addProduct(EnumHoneyComb.WATER, 30);
        RIVER.addSpecialty(EnumHoneyComb.CLAY, 20);
        RIVER.importTemplate(WATER);
        OCEAN.importTemplate(WATER);
        OCEAN.addProduct(EnumHoneyComb.WATER, 30);
        OCEAN.importTemplate(WATER);
        OCEAN.recessive();
        INK.importTemplate(OCEAN);
        INK.addProduct(EnumHoneyComb.WATER, 30);
        INK.addSpecialty(new ItemStack(Item.field_77756_aW, 1, 0), 10);
        GROWING.importVanillaTemplate("Forest");
        GROWING.addProduct(ItemHoneyComb.EnumVanillaType.HONEY.get(), 35);
        GROWING.setFlowering(ModuleEngineering.Flowering.Average);
        GROWING.setFlowerProvider(EnumExtraBeeFlowers.LEAVES.getUID());
        THRIVING.importTemplate(GROWING);
        THRIVING.addProduct(ItemHoneyComb.EnumVanillaType.HONEY.get(), 35);
        THRIVING.setFlowering(ModuleEngineering.Flowering.Fast);
        BLOOMING.importTemplate(THRIVING);
        BLOOMING.setFlowering(ModuleEngineering.Flowering.Fastest);
        BLOOMING.addProduct(ItemHoneyComb.EnumVanillaType.HONEY.get(), 35);
        BLOOMING.setFlowerProvider(EnumExtraBeeFlowers.Sapling.getUID());
        BLOOMING.setEffect(EnumExtraBeeEffect.BonemalSapling.getUID());
        SWEET.importVanillaTemplate("Rural");
        SWEET.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.HONEY), 40);
        SWEET.addProduct(new ItemStack(Item.field_77747_aY, 1, 0), 10);
        SWEET.setFlowerProvider(EnumExtraBeeFlowers.SUGAR.getUID());
        SUGAR.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.HONEY), 40);
        SUGAR.addProduct(new ItemStack(Item.field_77747_aY, 1, 0), 20);
        SUGAR.importTemplate(SWEET);
        RIPENING.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.HONEY), 30);
        RIPENING.addProduct(new ItemStack(Item.field_77747_aY, 1, 0), 10);
        RIPENING.addSpecialty(EnumHoneyComb.FRUIT, 10);
        RIPENING.setFlowerProvider(EnumExtraBeeFlowers.Fruit.getUID());
        RIPENING.importTemplate(SUGAR);
        FRUIT.importTemplate(RIPENING);
        FRUIT.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.HONEY), 30);
        FRUIT.addProduct(new ItemStack(Item.field_77747_aY, 1, 0), 15);
        FRUIT.addSpecialty(EnumHoneyComb.FRUIT, 20);
        FRUIT.setEffect(EnumExtraBeeEffect.BonemealFruit.getUID());
        FRUIT.setHasEffect(true);
        ALCOHOL.importTemplate(SWEET);
        ALCOHOL.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.WHEATEN), 30);
        ALCOHOL.addSpecialty(EnumHoneyComb.ALCOHOL, 10);
        ALCOHOL.setEffect("forestry.effectDrunkard");
        ALCOHOL.recessive();
        FARM.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.WHEATEN), 30);
        FARM.addSpecialty(EnumHoneyComb.SEED, 10);
        FARM.importVanillaTemplate("rural");
        MILK.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.WHEATEN), 30);
        MILK.addSpecialty(EnumHoneyComb.MILK, 10);
        MILK.importVanillaTemplate("rural");
        COFFEE.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.WHEATEN), 30);
        COFFEE.addSpecialty(EnumHoneyComb.COFFEE, 8);
        COFFEE.importVanillaTemplate("rural");
        SWAMP.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.MOSSY), 30);
        SWAMP.importVanillaTemplate("marshy");
        SWAMP.setHumidity(EnumHumidity.DAMP);
        SWAMP.setEffect(EnumExtraBeeEffect.SLOW.getUID());
        BOGGY.importTemplate(SWAMP);
        BOGGY.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.MOSSY), 30);
        BOGGY.importTemplate(SWAMP);
        BOGGY.recessive();
        FUNGAL.importTemplate(BOGGY);
        FUNGAL.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.MOSSY), 30);
        FUNGAL.addSpecialty(EnumHoneyComb.FUNGAL, 15);
        FUNGAL.importTemplate(BOGGY);
        FUNGAL.setEffect(EnumExtraBeeEffect.BonemealMushroom.getUID());
        FUNGAL.setHasEffect(true);
        MARBLE.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.HONEY), 30);
        MARBLE.importVanillaTemplate("noble");
        ROMAN.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.HONEY), 30);
        ROMAN.importTemplate(MARBLE);
        GREEK.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.HONEY), 30);
        GREEK.recessive();
        GREEK.importTemplate(ROMAN);
        CLASSICAL.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.HONEY), 30);
        CLASSICAL.addSpecialty(ItemInterface.getItem((String)"royalJelly"), 25);
        CLASSICAL.setHasEffect(true);
        CLASSICAL.importTemplate(GREEK);
        BASALT.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.SIMMERING), 25);
        BASALT.importVanillaTemplate("sinister");
        BASALT.setEffect("forestry.effectAggressive");
        BASALT.setSecondaryColor(10101539);
        BASALT.setHumidity(EnumHumidity.ARID);
        BASALT.setTemperature(EnumTemperature.HELLISH);
        TEMPERED.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.SIMMERING), 25);
        TEMPERED.importTemplate(BASALT);
        TEMPERED.setEffect(EnumExtraBeeEffect.METEOR.getUID());
        TEMPERED.recessive();
        TEMPERED.setSecondaryColor(10101539);
        ANGRY.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.SIMMERING), 25);
        ANGRY.importTemplate(TEMPERED);
        ANGRY.setSecondaryColor(10101539);
        VOLCANIC.importTemplate(TEMPERED);
        VOLCANIC.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.SIMMERING), 25);
        VOLCANIC.addSpecialty(EnumHoneyComb.BLAZE, 10);
        VOLCANIC.setHasEffect(true);
        VOLCANIC.setSecondaryColor(10101539);
        MALICIOUS.importVanillaTemplate("tropical");
        MALICIOUS.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.SILKY), 25);
        MALICIOUS.setSecondaryColor(431972);
        MALICIOUS.setHumidity(EnumHumidity.DAMP);
        MALICIOUS.setTemperature(EnumTemperature.WARM);
        INFECTIOUS.importTemplate(MALICIOUS);
        INFECTIOUS.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.SILKY), 25);
        INFECTIOUS.setFlowering(ModuleEngineering.Flowering.Slow);
        INFECTIOUS.setSecondaryColor(431972);
        VIRULENT.importTemplate(INFECTIOUS);
        VIRULENT.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.SILKY), 25);
        VIRULENT.addSpecialty(EnumHoneyComb.VENOMOUS, 12);
        VIRULENT.setFlowering(ModuleEngineering.Flowering.Average);
        VIRULENT.recessive();
        VIRULENT.setHasEffect(true);
        VIRULENT.setSecondaryColor(431972);
        VISCOUS.importVanillaTemplate("tropical");
        VISCOUS.setEffect(EnumExtraBeeEffect.ECTOPLASM.getUID());
        VISCOUS.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.SILKY), 25);
        VISCOUS.setSecondaryColor(431972);
        VISCOUS.setHumidity(EnumHumidity.DAMP);
        VISCOUS.setSpeed(ModuleEngineering.Speed.Slow);
        VISCOUS.setTemperature(EnumTemperature.WARM);
        GLUTINOUS.importTemplate(VISCOUS);
        GLUTINOUS.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.SILKY), 25);
        GLUTINOUS.setSpeed(ModuleEngineering.Speed.Norm);
        GLUTINOUS.setSecondaryColor(431972);
        STICKY.importTemplate(GLUTINOUS);
        STICKY.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.SILKY), 25);
        STICKY.addSpecialty(EnumHoneyComb.SLIME, 12);
        STICKY.setSpeed(ModuleEngineering.Speed.Fast);
        STICKY.setHasEffect(true);
        STICKY.setSecondaryColor(431972);
        CORROSIVE.importTemplate(STICKY);
        CORROSIVE.setHumidity(EnumHumidity.DAMP);
        CORROSIVE.setTemperature(EnumTemperature.WARM);
        CORROSIVE.setEffect(EnumExtraBeeEffect.ACID.getUID());
        CORROSIVE.setFlowering(ModuleEngineering.Flowering.Average);
        CORROSIVE.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.SILKY), 20);
        CORROSIVE.recessive();
        CORROSIVE.setSecondaryColor(431972);
        CAUSTIC.importTemplate(CORROSIVE);
        CAUSTIC.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.SILKY), 25);
        CAUSTIC.addSpecialty(EnumHoneyComb.ACIDIC, 3);
        CAUSTIC.setSecondaryColor(431972);
        ACIDIC.importTemplate(CAUSTIC);
        ACIDIC.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.SILKY), 20);
        ACIDIC.addSpecialty(EnumHoneyComb.ACIDIC, 16);
        ACIDIC.setHasEffect(true);
        ACIDIC.setSecondaryColor(431972);
        EXCITED.setEffect(EnumExtraBeeEffect.LIGHTNING.getUID());
        EXCITED.addProduct(EnumHoneyComb.REDSTONE, 10);
        EXCITED.setCaveDwelling();
        EXCITED.setFlowerProvider(EnumExtraBeeFlowers.REDSTONE.getUID());
        ENERGETIC.importTemplate(EXCITED);
        ENERGETIC.setEffect(EnumExtraBeeEffect.LIGHTNING.getUID());
        ENERGETIC.addProduct(EnumHoneyComb.REDSTONE, 12);
        ENERGETIC.recessive();
        ECSTATIC.importTemplate(ENERGETIC);
        ECSTATIC.setEffect(EnumExtraBeeEffect.Power.getUID());
        ECSTATIC.addProduct(EnumHoneyComb.REDSTONE, 20);
        ECSTATIC.addSpecialty(EnumHoneyComb.IC2ENERGY, 8);
        ECSTATIC.setHasEffect(true);
        ARTIC.importVanillaTemplate("wintry");
        ARTIC.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.FROZEN), 25);
        ARTIC.setTemperature(EnumTemperature.ICY);
        ARTIC.setSecondaryColor(14349811);
        FREEZING.importTemplate(ARTIC);
        FREEZING.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.FROZEN), 20);
        FREEZING.addSpecialty(EnumHoneyComb.GLACIAL, 10);
        FREEZING.setSecondaryColor(14349811);
        SHADOW.importTemplate(BASALT);
        SHADOW.setNocturnal();
        SHADOW.addProduct(EnumHoneyComb.SHADOW, 5);
        SHADOW.setEffect(EnumExtraBeeEffect.BLINDNESS.getUID());
        SHADOW.setAllDay(false);
        SHADOW.recessive();
        SHADOW.setSecondaryColor(0x333333);
        DARKENED.addProduct(EnumHoneyComb.SHADOW, 10);
        DARKENED.setNocturnal();
        DARKENED.importTemplate(SHADOW);
        DARKENED.setSecondaryColor(0x333333);
        ABYSS.importTemplate(DARKENED);
        ABYSS.setNocturnal();
        ABYSS.addProduct(EnumHoneyComb.SHADOW, 25);
        ABYSS.setEffect(EnumExtraBeeEffect.WITHER.getUID());
        ABYSS.setHasEffect(true);
        ABYSS.setSecondaryColor(0x333333);
        CELEBRATORY.importVanillaTemplate("festive");
        CELEBRATORY.setEffect(EnumExtraBeeEffect.FIREWORKS.getUID());
        GLOWSTONE.importTemplate(BASALT);
        GLOWSTONE.addProduct(EnumHoneyComb.GLOWSTONE, 15);
        GLOWSTONE.setSecondaryColor(10101539);
        HAZARDOUS.importVanillaTemplate("Austere");
        HAZARDOUS.addProduct(EnumHoneyComb.SALTPETER, 12);
        JADED.importVanillaTemplate("imperial");
        JADED.setFertility(ModuleEngineering.Fertility.Maximum);
        JADED.setFlowering(ModuleEngineering.Flowering.Maximum);
        JADED.setTerritory(ModuleEngineering.Territory.Largest);
        JADED.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.HONEY), 30);
        JADED.addSpecialty(ItemInterface.getItem((String)"pollen"), 20);
        JADED.setHasEffect(true);
        JADED.setSecondaryColor(14453483);
        UNUSUAL.importVanillaTemplate("ended");
        UNUSUAL.setEffect(EnumExtraBeeEffect.GRAVITY.getUID());
        UNUSUAL.setSecondaryColor(12231403);
        UNUSUAL.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.QUARTZ), 25);
        SPATIAL.importTemplate(UNUSUAL);
        SPATIAL.setEffect(EnumExtraBeeEffect.GRAVITY.getUID());
        SPATIAL.setSecondaryColor(10768076);
        SPATIAL.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.QUARTZ), 25);
        SPATIAL.addSpecialty(EnumHoneyComb.CERTUS, 5);
        QUANTUM.importTemplate(QUANTUM);
        QUANTUM.setEffect(EnumExtraBeeEffect.TELEPORT.getUID());
        QUANTUM.setSecondaryColor(13963227);
        QUANTUM.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.QUARTZ), 25);
        QUANTUM.addSpecialty(EnumHoneyComb.CERTUS, 15);
        QUANTUM.addSpecialty(EnumHoneyComb.ENDERPEARL, 15);
        JADED.addSpecialty(EnumHoneyComb.PURPLE, 15);
        EnumExtraBeeSpecies.JADED.isCounted = false;
        for (EnumExtraBeeSpecies species : EnumExtraBeeSpecies.values()) {
            if (!species.isActive()) {
                AlleleManager.alleleRegistry.blacklistAllele(species.getUID());
            }
            for (EnumBeeChromosome chromo : EnumBeeChromosome.values()) {
                IAllele allele;
                if (chromo == EnumBeeChromosome.HUMIDITY || (allele = species.template[chromo.ordinal()]) != null && chromo.getAlleleClass().isInstance(allele)) continue;
                throw new RuntimeException(species.getName() + " has an invalid " + chromo.toString() + " chromosome!");
            }
        }
        for (int i = 0; i < 16; ++i) {
            EnumExtraBeeSpecies species = EnumExtraBeeSpecies.values()[RED.ordinal() + i];
            EnumHoneyComb comb = EnumHoneyComb.values()[EnumHoneyComb.RED.ordinal() + i];
            species.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.HONEY), 75);
            species.addSpecialty(comb, 25);
            species.setSecondaryColor(9240320);
        }
        for (EnumExtraBeeSpecies species : EnumExtraBeeSpecies.values()) {
            species.register();
        }
    }

    public static IAlleleBeeSpecies getVanilla(String name) {
        return (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.species" + name);
    }

    public static IAllele[] getVanillaTemplate(String uid) {
        String text = uid.substring(0, 1).toUpperCase() + uid.substring(1).toLowerCase();
        return Binnie.Genetics.getBeeRoot().getTemplate("forestry.species" + text);
    }

    void setBranch(IClassification branch) {
        this.branch = branch;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isJubilant(World world, int biomeid, int x, int y, int z) {
        return true;
    }

    public boolean isJubilant(IBeeGenome genome, IBeeHousing housing) {
        return true;
    }

    public int getIconColour(int renderPass) {
        return renderPass == 0 ? this.primaryColor : (renderPass == 1 ? this.secondaryColor : 0xFFFFFF);
    }

    public IIconProvider getIconProvider() {
        return this;
    }

    public Icon getIcon(short texUID) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister register) {
        String iconType = "default";
        String mod = "forestry";
        if (this == JADED) {
            iconType = "jaded";
            mod = "extrabees";
        }
        this.icons = new Icon[EnumBeeType.values().length][3];
        Icon body1 = BinnieCore.proxy.getIcon(register, mod, "bees/" + iconType + "/body1");
        for (int i = 0; i < EnumBeeType.values().length; ++i) {
            if (EnumBeeType.values()[i] == EnumBeeType.NONE) continue;
            this.icons[i][0] = BinnieCore.proxy.getIcon(register, mod, "bees/" + iconType + "/" + EnumBeeType.values()[i].toString().toLowerCase(Locale.ENGLISH) + ".outline");
            this.icons[i][1] = EnumBeeType.values()[i] != EnumBeeType.LARVAE ? body1 : BinnieCore.proxy.getIcon(register, mod, "bees/" + iconType + "/" + EnumBeeType.values()[i].toString().toLowerCase(Locale.ENGLISH) + ".body");
            this.icons[i][2] = BinnieCore.proxy.getIcon(register, mod, "bees/" + iconType + "/" + EnumBeeType.values()[i].toString().toLowerCase(Locale.ENGLISH) + ".body2");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(EnumBeeType type, int renderPass) {
        return this.icons[type.ordinal()][renderPass];
    }

    public IBeeRoot getRoot() {
        return Binnie.Genetics.getBeeRoot();
    }

    public boolean isNocturnal() {
        return this.nocturnal;
    }

    public void setNocturnal() {
        this.nocturnal = true;
    }

    public void setAllDay() {
        this.setAllDay(true);
    }

    public void setAllDay(boolean allDay) {
        this.template[EnumBeeChromosome.NOCTURNAL.ordinal()] = allDay ? AlleleManager.alleleRegistry.getAllele("forestry.boolTrue") : AlleleManager.alleleRegistry.getAllele("forestry.boolFalse");
    }

    public void setCaveDwelling() {
        this.template[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.boolTrue");
    }

    public void setTolerantFlyer() {
        this.template[EnumBeeChromosome.TOLERANT_FLYER.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.boolTrue");
    }

    public void setFlowerProvider(String uid) {
        IAllele allele = AlleleManager.alleleRegistry.getAllele(uid);
        if (allele instanceof IAlleleFlowers) {
            this.template[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = allele;
        }
    }

    public void setEffect(String uid) {
        IAllele allele = AlleleManager.alleleRegistry.getAllele(uid);
        if (allele instanceof IAlleleBeeEffect) {
            this.template[EnumBeeChromosome.EFFECT.ordinal()] = AlleleManager.alleleRegistry.getAllele(uid);
        }
    }

    private void setFertility(ModuleEngineering.Fertility fert) {
        this.template[EnumBeeChromosome.FERTILITY.ordinal()] = AlleleManager.alleleRegistry.getAllele(fert.getUID());
    }

    private void setLifespan(ModuleEngineering.Lifespan fert) {
        this.template[EnumBeeChromosome.LIFESPAN.ordinal()] = AlleleManager.alleleRegistry.getAllele(fert.getUID());
    }

    private void setSpeed(ModuleEngineering.Speed fert) {
        this.template[EnumBeeChromosome.SPEED.ordinal()] = AlleleManager.alleleRegistry.getAllele(fert.getUID());
    }

    private void setTerritory(ModuleEngineering.Territory fert) {
        this.template[EnumBeeChromosome.TERRITORY.ordinal()] = AlleleManager.alleleRegistry.getAllele(fert.getUID());
    }

    private void setFlowering(ModuleEngineering.Flowering fert) {
        this.template[EnumBeeChromosome.FLOWERING.ordinal()] = AlleleManager.alleleRegistry.getAllele(fert.getUID());
    }

    private void setHumidityTolerance(ModuleEngineering.Tolerance fert) {
        this.template[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = AlleleManager.alleleRegistry.getAllele(fert.getUID());
    }

    private void setTemperatureTolerance(ModuleEngineering.Tolerance both1) {
        this.template[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = AlleleManager.alleleRegistry.getAllele(both1.getUID());
    }

    public float getResearchSuitability(ItemStack itemstack) {
        if (itemstack == null) {
            return 0.0f;
        }
        for (ItemStack itemStack : this.products.keySet()) {
            if (!itemStack.func_77969_a(itemstack)) continue;
            return 1.0f;
        }
        for (ItemStack itemStack : this.specialties.keySet()) {
            if (!itemStack.func_77969_a(itemstack)) continue;
            return 1.0f;
        }
        if (itemstack.field_77993_c == Item.field_77729_bt.field_77779_bT) {
            return 0.9f;
        }
        if (itemstack.field_77993_c == ItemInterface.getItem((String)"honeyDrop").field_77993_c) {
            return 0.5f;
        }
        if (itemstack.field_77993_c == ItemInterface.getItem((String)"honeydew").field_77993_c) {
            return 0.7f;
        }
        if (itemstack.field_77993_c == ItemInterface.getItem((String)"beeComb").field_77993_c) {
            return 0.4f;
        }
        if (AlleleManager.alleleRegistry.isIndividual(itemstack)) {
            return 1.0f;
        }
        for (Map.Entry entry : this.getRoot().getResearchCatalysts().entrySet()) {
            if (!((ItemStack)entry.getKey()).func_77969_a(itemstack)) continue;
            return ((Float)entry.getValue()).floatValue();
        }
        return 0.0f;
    }

    public ItemStack[] getResearchBounty(World world, String researcher, IIndividual individual, int bountyLevel) {
        ItemStack stack2;
        Collection combinations;
        ArrayList<ItemStack> bounty = new ArrayList<ItemStack>();
        ItemStack research = null;
        if (world.field_73012_v.nextFloat() < 10.0f / (float)bountyLevel && (combinations = this.getRoot().getCombinations((IAllele)this)).size() > 0) {
            IMutation[] candidates = combinations.toArray(new IMutation[0]);
            research = AlleleManager.alleleRegistry.getMutationNoteStack(researcher, candidates[world.field_73012_v.nextInt(candidates.length)]);
        }
        if (research != null) {
            bounty.add(research);
        }
        if (bountyLevel > 10) {
            for (ItemStack stack : this.specialties.keySet()) {
                stack2 = stack.func_77946_l();
                stack2.field_77994_a = world.field_73012_v.nextInt((int)((float)bountyLevel / 2.0f)) + 1;
                bounty.add(stack2);
            }
        }
        for (ItemStack stack : this.products.keySet()) {
            stack2 = stack.func_77946_l();
            stack2.field_77994_a = world.field_73012_v.nextInt((int)((float)bountyLevel / 2.0f)) + 1;
            bounty.add(stack2);
        }
        return bounty.toArray(new ItemStack[0]);
    }

    public String getEntityTexture() {
        return "/gfx/forestry/entities/bees/honeyBee.png";
    }

    public int getComplexity() {
        return 1 + this.getGeneticAdvancement((IAllele)this, new ArrayList<IAllele>());
    }

    private int getGeneticAdvancement(IAllele species, ArrayList<IAllele> exclude) {
        int own = 1;
        int highest = 0;
        exclude.add(species);
        for (IMutation mutation : this.getRoot().getPaths(species, EnumBeeChromosome.SPECIES.ordinal())) {
            int otherAdvance;
            if (!exclude.contains(mutation.getAllele0()) && (otherAdvance = this.getGeneticAdvancement(mutation.getAllele0(), exclude)) > highest) {
                highest = otherAdvance;
            }
            if (exclude.contains(mutation.getAllele1()) || (otherAdvance = this.getGeneticAdvancement(mutation.getAllele1(), exclude)) <= highest) continue;
            highest = otherAdvance;
        }
        return own + (highest < 0 ? 0 : highest);
    }
}

