/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.engineering;

import binnie.core.Binnie;
import binnie.core.language.LocalisedString;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.engineering.CreativeTabGenetics;
import binnie.extrabees.engineering.ItemSerumEmpty;
import binnie.extrabees.engineering.ModuleEngineering;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;

public class ItemSerum
extends ItemSerumEmpty {
    LocalisedString chargeEmpty = Binnie.Language.registerItem(ExtraBees.instance, "serum.tooltip.nocharge");
    LocalisedString charge1 = Binnie.Language.registerItem(ExtraBees.instance, "serum.tooltip.1charge");
    LocalisedString chargeMany = Binnie.Language.registerItem(ExtraBees.instance, "serum.tooltip.manycharge");
    LocalisedString corruptedSerum = Binnie.Language.registerItem(ExtraBees.instance, "serum.corrupted");
    LocalisedString serumName = Binnie.Language.registerItem(ExtraBees.instance, "serum.name");
    Icon[] icons = new Icon[4];

    @SideOnly(value=Side.CLIENT)
    public Icon func_77618_c(int damage, int pass) {
        return this.icons[pass];
    }

    public boolean isRepairable() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister register) {
        this.icons[0] = ExtraBees.proxy.getIcon(register, "machines/serumOutline");
        this.icons[1] = ExtraBees.proxy.getIcon(register, "machines/serumCaps");
        this.icons[2] = ExtraBees.proxy.getIcon(register, "machines/serumFilling");
        this.icons[3] = ExtraBees.proxy.getIcon(register, "machines/serumEdges");
    }

    public int getRenderPasses(int metadata) {
        return 4;
    }

    public ItemSerum(int id) {
        super(id);
        this.func_77625_d(1);
        this.func_77656_e(16);
        this.func_77655_b("serum");
        this.func_77637_a(CreativeTabGenetics.instance);
    }

    public int func_82790_a(ItemStack itemstack, int j) {
        int i = itemstack.func_77960_j();
        IAllele allele = AlleleManager.alleleRegistry.getAllele(ItemSerum.getUID(itemstack));
        EnumBeeChromosome chromosome = ItemSerum.getChromosome(itemstack);
        if (allele == null || chromosome == null) {
            return 0x444444;
        }
        int colour = ModuleEngineering.getColour(allele, chromosome, j);
        if (colour >= 0) {
            return colour;
        }
        if (j == 3) {
            return 14068137;
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        int damage = this.func_77612_l() - itemStack.func_77960_j();
        if (damage == 0) {
            list.add(this.chargeEmpty.get());
        } else if (damage == 1) {
            list.add(this.charge1.get());
        } else {
            list.add(this.chargeMany.get(damage));
        }
        ModuleEngineering.getQualityInfo(itemStack, list);
    }

    @Override
    public String func_77628_j(ItemStack itemstack) {
        String UID = ItemSerum.getUID(itemstack);
        if (UID == null) {
            return this.corruptedSerum.get();
        }
        IAllele allele = AlleleManager.alleleRegistry.getAllele(UID);
        EnumBeeChromosome chromo = ItemSerum.getChromosome(itemstack);
        if (allele == null || chromo == null) {
            return this.corruptedSerum.get();
        }
        return this.serumName.get(ModuleEngineering.getName(allele, chromo));
    }

    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List itemList) {
        ModuleEngineering.getCreativeTabSerums(itemList);
    }

    public boolean func_77623_v() {
        return true;
    }

    public static String getUID(ItemStack item) {
        if (!item.func_77942_o()) {
            return null;
        }
        NBTTagCompound nbt = item.func_77978_p();
        if (nbt.func_74764_b("uid")) {
            return nbt.func_74779_i("uid");
        }
        return null;
    }

    public static EnumBeeChromosome getChromosome(ItemStack item) {
        if (!item.func_77942_o()) {
            return null;
        }
        NBTTagCompound nbt = item.func_77978_p();
        if (nbt.func_74764_b("chromosome")) {
            int i = nbt.func_74762_e("chromosome");
            if (i >= EnumBeeChromosome.HUMIDITY.ordinal()) {
                ++i;
            }
            return EnumBeeChromosome.values()[i];
        }
        return null;
    }
}

