/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.apiary.machine;

import binnie.core.Binnie;
import binnie.core.machines.Machine;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.SlotValidator;
import binnie.craftgui.minecraft.IMachineInformation;
import binnie.extrabees.apiary.ComponentBeeModifier;
import binnie.extrabees.apiary.ComponentExtraBeeGUI;
import binnie.extrabees.apiary.TileExtraBeeAlveary;
import binnie.extrabees.apiary.machine.AlvearyMachine;
import binnie.extrabees.core.ExtraBeeGUID;
import binnie.extrabees.core.ExtraBeeTexture;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IHiveFrame;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class AlvearyFrame {
    public static int slotFrame = 0;

    public static class ComponentFrameModifier
    extends ComponentBeeModifier
    implements IBeeModifier,
    IBeeListener {
        public ComponentFrameModifier(Machine machine) {
            super(machine);
        }

        @Override
        public void wearOutEquipment(int amount) {
            if (this.getHiveFrame() == null) {
                return;
            }
            World world = this.getMachine().getTileEntity().field_70331_k;
            int wear = Math.round((float)(amount * 5) * Binnie.Genetics.getBeeRoot().getBeekeepingMode(world).getWearModifier());
            this.getInventory().func_70299_a(slotFrame, this.getHiveFrame().frameUsed((IBeeHousing)((TileExtraBeeAlveary)this.getMachine().getTileEntity()).getCentralTE(), this.getInventory().func_70301_a(slotFrame), null, wear));
        }

        public IHiveFrame getHiveFrame() {
            if (this.getInventory().func_70301_a(slotFrame) != null) {
                return (IHiveFrame)this.getInventory().func_70301_a(slotFrame).func_77973_b();
            }
            return null;
        }

        @Override
        public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
            return this.getHiveFrame() == null ? 1.0f : this.getHiveFrame().getTerritoryModifier(genome, currentModifier);
        }

        @Override
        public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            return this.getHiveFrame() == null ? 1.0f : this.getHiveFrame().getMutationModifier(genome, mate, currentModifier);
        }

        @Override
        public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            return this.getHiveFrame() == null ? 1.0f : this.getHiveFrame().getLifespanModifier(genome, mate, currentModifier);
        }

        @Override
        public float getProductionModifier(IBeeGenome genome, float currentModifier) {
            return this.getHiveFrame() == null ? 1.0f : this.getHiveFrame().getProductionModifier(genome, currentModifier);
        }

        @Override
        public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
            return this.getHiveFrame() == null ? 1.0f : this.getHiveFrame().getFloweringModifier(genome, currentModifier);
        }
    }

    public static class SlotValidatorFrame
    extends SlotValidator {
        public SlotValidatorFrame() {
            super(SlotValidator.IconFrame);
        }

        @Override
        public boolean isValid(ItemStack itemStack) {
            return itemStack != null && itemStack.func_77973_b() instanceof IHiveFrame;
        }

        @Override
        public String getTooltip() {
            return "Hive Frames";
        }
    }

    public static class PackageAlvearyFrame
    extends AlvearyMachine.AlvearyPackage
    implements IMachineInformation {
        public PackageAlvearyFrame() {
            super("frame", ExtraBeeTexture.AlvearyFrame.getTexture());
        }

        @Override
        public void createMachine(Machine machine) {
            new ComponentExtraBeeGUI(machine, ExtraBeeGUID.AlvearyFrame);
            ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
            inventory.addSlot(slotFrame, "Frame Slot");
            inventory.getSlot(slotFrame).setValidator(new SlotValidatorFrame());
            new ComponentFrameModifier(machine);
        }
    }
}

