/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.apiary;

import binnie.core.Binnie;
import binnie.core.BinnieCore;
import binnie.core.machines.TileEntityMachine;
import binnie.extrabees.apiary.machine.AlvearyMachine;
import forestry.api.apiculture.IAlvearyComponent;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.core.IStructureLogic;
import forestry.api.core.ITileStructure;
import forestry.api.genetics.IIndividual;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileExtraBeeAlveary
extends TileEntityMachine
implements IAlvearyComponent,
IBeeModifier,
IBeeListener {
    IStructureLogic structureLogic = Binnie.Genetics.getBeeRoot().createAlvearyStructureLogic((IAlvearyComponent)this);
    private boolean isMaster;
    protected int masterX;
    protected int masterZ;
    protected int masterY = -99;

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!BinnieCore.proxy.isSimulating(this.field_70331_k)) {
            return;
        }
        if (this.field_70331_k.func_72820_D() % 200L == 0L) {
            ITileStructure master = this.getCentralTE();
            if (master == null) {
                return;
            }
            if (this.getBeeListener() != null) {
                ((IAlvearyComponent)master).registerBeeListener(this.getBeeListener());
            }
            if (this.getBeeModifier() != null) {
                ((IAlvearyComponent)master).registerBeeModifier(this.getBeeModifier());
            }
            if (!this.isIntegratedIntoStructure() || this.isMaster()) {
                this.validateStructure();
            }
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.isMaster = nbttagcompound.func_74767_n("IsMaster");
        this.masterX = nbttagcompound.func_74762_e("MasterX");
        this.masterY = nbttagcompound.func_74762_e("MasterY");
        this.masterZ = nbttagcompound.func_74762_e("MasterZ");
        if (this.isMaster) {
            this.makeMaster();
        }
        this.structureLogic.readFromNBT(nbttagcompound);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74757_a("IsMaster", this.isMaster);
        nbttagcompound.func_74768_a("MasterX", this.masterX);
        nbttagcompound.func_74768_a("MasterY", this.masterY);
        nbttagcompound.func_74768_a("MasterZ", this.masterZ);
        this.structureLogic.writeToNBT(nbttagcompound);
    }

    AlvearyMachine.AlvearyPackage getAlvearyPackage() {
        return (AlvearyMachine.AlvearyPackage)this.getMachine().getPackage();
    }

    public TileExtraBeeAlveary() {
    }

    public TileExtraBeeAlveary(AlvearyMachine.AlvearyPackage alvearyPackage) {
        super(alvearyPackage);
    }

    public String getTypeUID() {
        return this.structureLogic.getTypeUID();
    }

    public void makeMaster() {
    }

    public void onStructureReset() {
        this.setCentralTE(null);
        this.isMaster = false;
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public ITileStructure getCentralTE() {
        if (!this.isIntegratedIntoStructure()) {
            return null;
        }
        if (!this.isMaster()) {
            TileEntity tile = this.field_70331_k.func_72796_p(this.masterX, this.masterY, this.masterZ);
            if (tile instanceof ITileStructure) {
                ITileStructure master = (ITileStructure)this.field_70331_k.func_72796_p(this.masterX, this.masterY, this.masterZ);
                if (master.isMaster()) {
                    return master;
                }
                return null;
            }
            return null;
        }
        return this;
    }

    public void validateStructure() {
        this.structureLogic.validateStructure();
    }

    private boolean isSameTile(TileEntity tile) {
        return tile.field_70329_l == this.field_70329_l && tile.field_70330_m == this.field_70330_m && tile.field_70327_n == this.field_70327_n;
    }

    public void setCentralTE(TileEntity tile) {
        if (tile == null || tile == this || this.isSameTile(tile)) {
            this.masterZ = 0;
            this.masterX = 0;
            this.masterY = -99;
            return;
        }
        this.isMaster = false;
        this.masterX = tile.field_70329_l;
        this.masterY = tile.field_70330_m;
        this.masterZ = tile.field_70327_n;
        if (this.getBeeListener() != null) {
            ((IAlvearyComponent)tile).registerBeeListener(this.getBeeListener());
        }
        if (this.getBeeModifier() != null) {
            ((IAlvearyComponent)tile).registerBeeModifier(this.getBeeModifier());
        }
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    protected boolean hasMaster() {
        return this.masterY >= 0;
    }

    public boolean isIntegratedIntoStructure() {
        return this.isMaster || this.masterY >= 0;
    }

    public void registerBeeModifier(IBeeModifier modifier) {
    }

    public void removeBeeModifier(IBeeModifier modifier) {
    }

    public void addTemperatureChange(float change, float boundaryDown, float boundaryUp) {
    }

    public void addHumidityChange(float change, float boundaryDown, float boundaryUp) {
    }

    public boolean hasFunction() {
        return true;
    }

    public IBeeModifier getBeeModifier() {
        return this.getMachine().getInterface(IBeeModifier.class);
    }

    public IBeeListener getBeeListener() {
        return this.getMachine().getInterface(IBeeListener.class);
    }

    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        return this.getBeeModifier() == null ? 1.0f : this.getBeeModifier().getTerritoryModifier(genome, currentModifier);
    }

    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return this.getBeeModifier() == null ? 1.0f : this.getBeeModifier().getMutationModifier(genome, mate, currentModifier);
    }

    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return this.getBeeModifier() == null ? 1.0f : this.getBeeModifier().getLifespanModifier(genome, mate, currentModifier);
    }

    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        return this.getBeeModifier() == null ? 1.0f : this.getBeeModifier().getProductionModifier(genome, currentModifier);
    }

    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        return this.getBeeModifier() == null ? 1.0f : this.getBeeModifier().getFloweringModifier(genome, currentModifier);
    }

    public boolean isSealed() {
        return this.getBeeModifier() == null ? false : this.getBeeModifier().isSealed();
    }

    public boolean isSelfLighted() {
        return this.getBeeModifier() == null ? false : this.getBeeModifier().isSelfLighted();
    }

    public boolean isSunlightSimulated() {
        return this.getBeeModifier() == null ? false : this.getBeeModifier().isSunlightSimulated();
    }

    public boolean isHellish() {
        return this.getBeeModifier() == null ? false : this.getBeeModifier().isHellish();
    }

    public void registerBeeListener(IBeeListener event) {
    }

    public void removeBeeListener(IBeeListener event) {
    }

    public void onQueenChange(ItemStack queen) {
        if (this.getBeeListener() != null) {
            this.getBeeListener().onQueenChange(queen);
        }
    }

    public void wearOutEquipment(int amount) {
        if (this.getBeeListener() != null) {
            this.getBeeListener().wearOutEquipment(amount);
        }
    }

    public void onQueenDeath(IBee queen) {
        if (this.getBeeListener() != null) {
            this.getBeeListener().onQueenDeath(queen);
        }
    }

    public void onPostQueenDeath(IBee queen) {
        if (this.getBeeListener() != null) {
            this.getBeeListener().onPostQueenDeath(queen);
        }
    }

    public boolean onPollenRetrieved(IBee queen, IIndividual pollen, boolean isHandled) {
        return false;
    }

    public boolean onEggLaid(IBee queen) {
        return false;
    }

    public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
        return 1.0f;
    }
}

