/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.apiary;

import binnie.core.Binnie;
import binnie.core.genetics.BeeModifierLogic;
import binnie.core.genetics.EnumBeeBooleanModifier;
import binnie.core.genetics.EnumBeeModifier;
import binnie.core.language.LocalisedString;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.apiary.ItemHiveFrame;
import binnie.extrabees.config.ConfigurationMain;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IHiveFrame;
import forestry.api.core.ItemInterface;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum EnumHiveFrame implements IHiveFrame
{
    Cocoa,
    Cage,
    Soul,
    Clay,
    Debug;

    Item item;
    int maxDamage = 240;
    LocalisedString name;
    BeeModifierLogic logic = new BeeModifierLogic();

    public static void init() {
        EnumHiveFrame.Cocoa.logic.setModifier(EnumBeeModifier.Lifespan, 0.75f, 0.5f);
        EnumHiveFrame.Cocoa.logic.setModifier(EnumBeeModifier.Production, 1.5f, 10.0f);
        EnumHiveFrame.Cage.logic.setModifier(EnumBeeModifier.Territory, 0.5f, 0.1f);
        EnumHiveFrame.Cage.logic.setModifier(EnumBeeModifier.Lifespan, 0.75f, 0.5f);
        EnumHiveFrame.Cage.logic.setModifier(EnumBeeModifier.Production, 0.75f, 0.5f);
        EnumHiveFrame.Soul.logic.setModifier(EnumBeeModifier.Mutation, 1.5f, 5.0f);
        EnumHiveFrame.Soul.logic.setModifier(EnumBeeModifier.Lifespan, 0.75f, 0.5f);
        EnumHiveFrame.Soul.logic.setModifier(EnumBeeModifier.Production, 0.25f, 0.1f);
        Soul.setMaxDamage(80);
        EnumHiveFrame.Clay.logic.setModifier(EnumBeeModifier.Lifespan, 1.5f, 5.0f);
        EnumHiveFrame.Clay.logic.setModifier(EnumBeeModifier.Mutation, 0.5f, 0.2f);
        EnumHiveFrame.Clay.logic.setModifier(EnumBeeModifier.Production, 0.75f, 0.2f);
        EnumHiveFrame.Debug.logic.setModifier(EnumBeeModifier.Lifespan, 1.0E-4f, 1.0E-4f);
        for (EnumHiveFrame frame : EnumHiveFrame.values()) {
            frame.item = new ItemHiveFrame(frame);
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack(EnumHiveFrame.Cocoa.item), (Object[])new Object[]{" c ", "cFc", " c ", Character.valueOf('F'), ItemInterface.getItem((String)"frameImpregnated"), Character.valueOf('c'), new ItemStack(Item.field_77756_aW, 1, 3)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(EnumHiveFrame.Cage.item), (Object[])new Object[]{ItemInterface.getItem((String)"frameImpregnated"), Block.field_72002_bp});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(EnumHiveFrame.Soul.item), (Object[])new Object[]{ItemInterface.getItem((String)"frameImpregnated"), Block.field_72013_bc});
        GameRegistry.addRecipe((ItemStack)new ItemStack(EnumHiveFrame.Clay.item), (Object[])new Object[]{" c ", "cFc", " c ", Character.valueOf('F'), ItemInterface.getItem((String)"frameImpregnated"), Character.valueOf('c'), Item.field_77757_aI});
    }

    public int getIconIndex() {
        return 55 + this.ordinal();
    }

    public int getItemID() {
        switch (this) {
            case Cocoa: {
                return ConfigurationMain.hiveFrameID;
            }
            case Cage: {
                return ConfigurationMain.hiveFrame2ID;
            }
            case Soul: {
                return ConfigurationMain.hiveFrame3ID;
            }
            case Clay: {
                return ConfigurationMain.hiveFrame4ID;
            }
            case Debug: {
                return ConfigurationMain.hiveFrame5ID;
            }
        }
        return ConfigurationMain.hiveFrameID;
    }

    public void setMaxDamage(int damage) {
        this.maxDamage = damage;
    }

    private EnumHiveFrame() {
        this.name = Binnie.Language.registerItem(ExtraBees.instance, "frame." + this.toString().toLowerCase());
    }

    public ItemStack frameUsed(IBeeHousing house, ItemStack frame, IBee queen, int wear) {
        frame.func_77964_b(frame.func_77960_j() + wear);
        if (frame.func_77960_j() >= frame.func_77958_k()) {
            return null;
        }
        return frame;
    }

    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.Territory, currentModifier);
    }

    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.Mutation, currentModifier);
    }

    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.Lifespan, currentModifier);
    }

    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.Production, currentModifier);
    }

    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.Flowering, currentModifier);
    }

    public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.GeneticDecay, currentModifier);
    }

    public boolean isSealed() {
        return this.logic.getModifier(EnumBeeBooleanModifier.Sealed);
    }

    public boolean isSelfLighted() {
        return this.logic.getModifier(EnumBeeBooleanModifier.SelfLighted);
    }

    public boolean isSunlightSimulated() {
        return this.logic.getModifier(EnumBeeBooleanModifier.SunlightStimulated);
    }

    public boolean isHellish() {
        return this.logic.getModifier(EnumBeeBooleanModifier.Hellish);
    }
}

