/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.minecraft;

import binnie.core.machines.power.ErrorState;
import binnie.craftgui.controls.core.Control;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.ITooltip;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.minecraft.ControlEnergyBar;
import binnie.craftgui.minecraft.ControlLiquidTank;
import binnie.craftgui.minecraft.ControlSlot;
import binnie.craftgui.minecraft.CustomSlot;
import binnie.craftgui.minecraft.EnumHighlighting;
import binnie.craftgui.minecraft.MinecraftTooltip;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.resource.minecraft.CraftGUITexture;
import net.minecraft.entity.player.InventoryPlayer;

public class ControlErrorState
extends Control
implements ITooltip {
    protected ErrorState errorState;
    protected int type = 0;

    @Override
    public void onRenderBackground() {
        CraftGUITexture texture = CraftGUITexture.StateWarning;
        if (this.errorState == null) {
            texture = CraftGUITexture.StateNone;
        } else if (this.type == 0) {
            texture = CraftGUITexture.StateError;
        }
        this.getRenderer().renderTexture((Object)texture, Vector2f.ZERO);
        super.onRenderBackground();
    }

    public ErrorState getError() {
        return ((Window)Window.get(this)).getContainer().getErrorState();
    }

    @Override
    public final void onUpdate() {
        this.errorState = this.getError();
        this.type = ((Window)Window.get(this)).getContainer().getErrorType();
        ControlSlot.highlighting.get((Object)EnumHighlighting.Error).clear();
        ControlSlot.highlighting.get((Object)EnumHighlighting.Warning).clear();
        ControlLiquidTank.tankError.clear();
        ControlEnergyBar.isError = false;
        if (!this.isMouseOver() || this.errorState == null) {
            return;
        }
        ControlEnergyBar.isError = this.errorState.isPowerError();
        if (this.errorState.isItemError()) {
            for (int slot : this.errorState.getData()) {
                int id = -1;
                for (CustomSlot cslot : ((Window)Window.get(this)).getContainer().getCustomSlots()) {
                    if (cslot.field_75224_c instanceof InventoryPlayer || cslot.slotID != slot) continue;
                    id = cslot.field_75222_d;
                }
                if (id < 0) continue;
                if (this.type == 0) {
                    ControlSlot.highlighting.get((Object)EnumHighlighting.Error).add(id);
                    continue;
                }
                ControlSlot.highlighting.get((Object)EnumHighlighting.Warning).add(id);
            }
        }
        if (this.errorState.isTankError()) {
            for (int slot : this.errorState.getData()) {
                ControlLiquidTank.tankError.add(slot);
            }
        }
    }

    public ControlErrorState(IWidget parent, float x, float y) {
        super(parent, x, y, 16.0f, 16.0f);
        this.addAttribute(Attribute.MouseOver);
    }

    @Override
    public void getTooltip(Tooltip tooltipOrig) {
        MinecraftTooltip tooltip = (MinecraftTooltip)tooltipOrig;
        if (this.errorState != null) {
            if (this.type == 0) {
                tooltip.setType(MinecraftTooltip.Type.Error);
            } else {
                tooltip.setType(MinecraftTooltip.Type.Warning);
            }
            tooltip.add(this.errorState.toString());
            if (this.errorState.getTooltip().length() > 0) {
                tooltip.add(this.errorState.getTooltip());
            }
        }
    }

    public ErrorState getErrorState() {
        return this.errorState;
    }
}

