/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.extratrees.kitchen;

import binnie.craftgui.controls.core.Control;
import binnie.craftgui.controls.scroll.IControlScrollable;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.Area;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.events.core.EventHandler;
import binnie.craftgui.minecraft.MinecraftGUI;
import binnie.craftgui.window.Panel;

public class ControlLineBrowser
extends Control
implements IControlScrollable {
    protected IWidget controlChild;
    float percentageIndex = 0.0f;
    int percentageIndexOffset = 0;

    @EventHandler(origin=EventHandler.Origin.Any)
    public void onMouseWheel(EventMouse.Wheel event) {
        if (this.getRelativeMousePosition().x() > 0.0f && this.getRelativeMousePosition().y() > 0.0f && this.getRelativeMousePosition().x() < this.getSize().x() && this.getRelativeMousePosition().y() < this.getSize().y()) {
            float percentageMove = 2.0f / this.getSize().x();
            this.movePercentage(percentageMove * (float)(-event.getDWheel()));
        }
    }

    public ControlLineBrowser(IWidget parent, float x, float y, float w, float h) {
        super(parent, x, y, w, h);
        new Panel(this, x, y, w, h, MinecraftGUI.PanelType.Gray);
    }

    public void setScrollableContent(IWidget child) {
        this.controlChild = child;
        child.setCroppedZone(this, new Area(1.0f, 1.0f, this.getSize().x() - 2.0f, this.getSize().y() - 2.0f));
    }

    public IWidget getContent() {
        return this.controlChild;
    }

    @Override
    public float getPercentageShown() {
        float shown = this.getSize().x() / this.controlChild.getSize().x();
        return Math.min(shown, 1.0f);
    }

    @Override
    public float getPercentageIndex() {
        return this.percentageIndex;
    }

    @Override
    public void movePercentage(float percentage) {
        this.percentageIndex += percentage;
        this.percentageIndexOffset = 0;
        if (this.percentageIndex + this.getPercentageShown() > 1.0f) {
            this.percentageIndex = 1.0f - this.getPercentageShown();
            this.percentageIndexOffset = 1;
        }
        if (this.percentageIndex < 0.0f) {
            this.percentageIndex = 0.0f;
        }
        this.controlChild.setOffset(new Vector2f(-this.percentageIndex * this.controlChild.getSize().x() - (float)this.percentageIndexOffset, 0.0f));
    }

    @Override
    public void setPercentageIndex(float index) {
        this.movePercentage(index - this.percentageIndex);
    }

    @Override
    public void onUpdate() {
        this.setPercentageIndex(this.getPercentageIndex());
    }
}

