/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.power;

import binnie.core.machines.power.IPoweredMachine;
import forestry.api.core.INBTTagable;
import net.minecraft.nbt.NBTTagCompound;

public class PowerInfo
implements INBTTagable {
    float currentEnergy = 0.0f;
    float maxEnergy = 0.0f;
    float currentInput = 0.0f;
    float maxInput = 0.0f;

    public PowerInfo(IPoweredMachine machine, float currentInput) {
        this.currentEnergy = machine.getPowerHandler().getEnergyStored();
        this.maxEnergy = machine.getPowerHandler().getMaxEnergyStored();
        this.currentInput = currentInput;
        this.maxInput = machine.getPowerHandler().getMaxEnergyReceived();
    }

    public PowerInfo() {
    }

    public float getStoredEnergy() {
        return this.currentEnergy;
    }

    public float getMaxEnergy() {
        return this.maxEnergy;
    }

    public float getMaxInput() {
        return this.maxInput;
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.currentEnergy = nbttagcompound.func_74762_e("current");
        this.maxEnergy = nbttagcompound.func_74762_e("max");
        this.maxInput = (float)nbttagcompound.func_74762_e("maxinput") / 10.0f;
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("current", (int)this.getStoredEnergy());
        nbttagcompound.func_74768_a("max", (int)this.getMaxEnergy());
        nbttagcompound.func_74768_a("maxinput", (int)this.getMaxInput() * 10);
    }
}

