/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.liquid;

import binnie.core.Binnie;
import binnie.core.BinnieCore;
import binnie.core.liquid.BinnieFluid;
import binnie.core.liquid.IFluidType;
import binnie.core.liquid.ILiquidType;
import binnie.core.liquid.ItemFluidContainer;
import binnie.core.liquid.ItemOldLiquidContainer;
import binnie.core.liquid.LiquidContainer;
import binnie.core.liquid.TextureBlankLiquid;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.Icon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class LiquidManager {
    static Map<String, IFluidType> fluids = new LinkedHashMap<String, IFluidType>();

    public static void createLiquids(ILiquidType[] liquids, int liquidID, int oldliquidContainerID, int containerID) {
        ItemOldLiquidContainer containerItem = new ItemOldLiquidContainer(oldliquidContainerID, liquids);
        for (ILiquidType liquid : liquids) {
            BinnieFluid fluid;
            if ((fluid = LiquidManager.createLiquid(liquid, containerID++)) == null) {
                throw new RuntimeException("Liquid registered incorrectly - " + liquid.getIdentifier());
            }
            for (LiquidContainer container : LiquidContainer.values()) {
                container.register(containerItem, liquid);
            }
        }
    }

    public static FluidStack getLiquidStack(String name, int amount) {
        return FluidRegistry.getFluidStack((String)name.toLowerCase(), (int)amount);
    }

    public static void updateTextures(IconRegister register) {
        for (IFluidType type : fluids.values()) {
            Fluid fluid = LiquidManager.getLiquidStack(type.getIdentifier(), 1).getFluid();
            type.registerIcon(register);
            if (fluid == null) {
                throw new RuntimeException("[Binnie] Liquid not registered properly - " + type.getIdentifier());
            }
            fluid.setIcons(type.getIcon());
        }
    }

    public static BinnieFluid createLiquid(IFluidType fluid, int containerID) {
        fluids.put(fluid.getIdentifier().toLowerCase(), fluid);
        BinnieFluid bFluid = new BinnieFluid(fluid);
        if (!FluidRegistry.registerFluid((Fluid)bFluid)) {
            throw new RuntimeException("[Binnie] Liquid not created correctly - " + fluid.getIdentifier());
        }
        ItemFluidContainer.registerFluidContainer(bFluid, containerID);
        return bFluid;
    }

    public static void createLiquids(IFluidType[] fluids, int containerStart) {
        for (IFluidType fluid : fluids) {
            LiquidManager.createLiquid(fluid, containerStart++);
        }
    }

    public static void init() {
        for (LiquidContainer container : LiquidContainer.values()) {
            container.name = Binnie.Language.registerItem(BinnieCore.instance, "container." + container.name().toLowerCase());
        }
        for (IFluidType fluid : fluids.values()) {
            for (LiquidContainer container : LiquidContainer.values()) {
                container.registerContainerData(container, fluid);
            }
        }
    }

    public static IFluidType getFluidType(String liquid) {
        return fluids.get(liquid.toLowerCase());
    }

    @SideOnly(value=Side.CLIENT)
    public static Icon loadLiquidIcon(IconRegister register, IFluidType fluid) {
        if (register instanceof TextureMap) {
            TextureBlankLiquid texture = new TextureBlankLiquid(fluid);
            ((TextureMap)register).setTextureEntry("binniecore:" + texture.getID(), (TextureAtlasSprite)texture);
            return texture;
        }
        return null;
    }
}

