/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.genetics;

import binnie.core.BinnieCore;
import binnie.core.genetics.BreedingSystem;
import binnie.core.genetics.IBreedingMessage;
import binnie.core.resource.BinnieResource;
import binnie.core.resource.ResourceManager;
import binnie.core.resource.ResourceType;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.ISpeciesRoot;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.ForgeSubscribe;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class BreedingMessageHandler
implements ITickHandler {
    public static BreedingMessageHandler instance;
    private Minecraft theGame;
    private int achievementWindowWidth;
    private int achievementWindowHeight;
    private IBreedingMessage currentMessage;
    private long messageTime;
    BinnieResource resource = ResourceManager.getPNG(BinnieCore.instance, ResourceType.GUI, "message");
    private RenderItem itemRender;
    Queue<IBreedingMessage> messages = new LinkedList<IBreedingMessage>();

    public BreedingMessageHandler(Minecraft par1Minecraft) {
        this.theGame = par1Minecraft;
        this.itemRender = new RenderItem();
        instance = this;
    }

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.RENDER);
    }

    public String getLabel() {
        return "Binnie";
    }

    @ForgeSubscribe
    public void onRender(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        BreedingMessageHandler breedingMessageHandler = this;
        float percentageTime = (float)(breedingMessageHandler.theGame.func_71386_F() - this.messageTime) / 3000.0f;
        if (percentageTime < 0.0f || percentageTime >= 1.0f) {
            this.currentMessage = null;
        }
        if (this.currentMessage == null) {
            this.currentMessage = this.messages.poll();
            BreedingMessageHandler breedingMessageHandler2 = this;
            this.messageTime = breedingMessageHandler2.theGame.func_71386_F();
            if (this.currentMessage == null) {
                return;
            }
        }
        String messageTitle = this.currentMessage.getTitle();
        String messageBody = this.currentMessage.getBody();
        ItemStack icon = this.currentMessage.getIcon();
        GuiIngame gui = this.theGame.field_71456_v;
        int width = 160;
        int i = event.resolution.func_78326_a() - width;
        int j = 0;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        BinnieCore.proxy.bindTexture(this.resource);
        GL11.glDisable((int)2896);
        gui.func_73729_b(i, j, 96, 202, width, 32);
        this.theGame.field_71466_p.func_78276_b(messageTitle, i + 30, j + 7, 0xFFFFFF);
        this.theGame.field_71466_p.func_78276_b(messageBody, i + 30, j + 18, 0xFFFFFF);
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        this.itemRender.func_82406_b(this.theGame.field_71466_p, this.theGame.field_71446_o, icon, i + 8, j + 8);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
    }

    public void recieve(NBTTagCompound nbt, EntityPlayer player) {
        if (nbt.func_74764_b("species")) {
            IAllele allele = AlleleManager.alleleRegistry.getAllele(nbt.func_74779_i("species"));
            if (!(allele instanceof IAlleleSpecies)) {
                return;
            }
            IAlleleSpecies species = (IAlleleSpecies)allele;
            this.messages.add(new IBreedingMessage.MessageSpeciesDiscovered(species));
            ISpeciesRoot root = null;
            for (ISpeciesRoot root2 : AlleleManager.alleleRegistry.getSpeciesRoot().values()) {
                if (!root2.getKaryotype()[0].getAlleleClass().isInstance(allele)) continue;
                root = root2;
            }
            if (root == null) {
                return;
            }
            IBreedingTracker tracker = root.getBreedingTracker(player.field_70170_p, player.field_71092_bJ);
            BreedingSystem system = BreedingSystem.BREEDING_SYSTEMS.get(root);
            IClassification branch = species.getBranch();
            if (branch == null) {
                return;
            }
            int discovedBranchSpecies = system.getDiscoveredBranchMembers(branch, tracker);
            if (discovedBranchSpecies == 1) {
                this.messages.add(new IBreedingMessage.BranchDiscovered(species, branch));
            }
        }
    }
}

