/*
 * Decompiled with CFR 0.152.
 */
package denoflionsx.denLib.Mod.Handlers.NewFluidHandler;

import denoflionsx.denLib.Mod.Handlers.NewFluidHandler.DenFluidHandlerEvents;
import denoflionsx.denLib.Mod.Handlers.NewFluidHandler.IDenLibFluidHandler;
import denoflionsx.denLib.Mod.denLibMod;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class DenLibFluidHandler {
    private HashMap<String, ArrayList<IDenLibFluidHandler>> handlerList = new HashMap();
    private HashMap<String, FluidStack> cache = new HashMap();

    public DenLibFluidHandler() {
        this.register();
    }

    private void register() {
        denLibMod.Proxy.registerForgeSubscribe(this);
        this.cache.put("water", FluidRegistry.getFluidStack((String)"water", (int)1000));
        this.cache.put("lava", FluidRegistry.getFluidStack((String)"lava", (int)1000));
        MinecraftForge.EVENT_BUS.post((Event)new DenFluidHandlerEvents.Ready());
    }

    public void register(IDenLibFluidHandler handler) {
        if (handler.lookingForFluid() == null) {
            this.addToList("null", handler);
            for (FluidStack f : this.cache.values()) {
                handler.onEvent(f);
            }
        } else {
            this.addToList(handler.lookingForFluid(), handler);
            if (this.cache.containsKey(handler.lookingForFluid())) {
                handler.onEvent(this.cache.get(handler.lookingForFluid()));
            }
        }
    }

    private void addToList(String s, IDenLibFluidHandler handler) {
        if (!this.handlerList.containsKey(s)) {
            this.handlerList.put(s, new ArrayList());
        }
        this.handlerList.get(s).add(handler);
    }

    @ForgeSubscribe
    public void onEvent(FluidRegistry.FluidRegisterEvent e) {
        denLibMod.log("Fluid: " + e.fluidName);
        FluidStack f = new FluidStack(e.fluidID, 1000);
        this.cache.put(f.getFluid().getName(), f);
        if (this.handlerList.containsKey(e.fluidName)) {
            for (IDenLibFluidHandler h : this.handlerList.get(e.fluidName)) {
                h.onEvent(f);
            }
        }
        if (this.handlerList.containsKey("null")) {
            for (IDenLibFluidHandler h : this.handlerList.get("null")) {
                h.onEvent(f);
            }
        }
    }
}

