/*
 * Decompiled with CFR 0.152.
 */
package denoflionsx.denLib.Mod.Handlers.NewDictHandler;

import denoflionsx.denLib.Mod.Handlers.NewDictHandler.IDenLibDictionaryHandler;
import denoflionsx.denLib.Mod.denLibMod;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.oredict.OreDictionary;

public class DenLibDictionaryHandler {
    private HashMap<String, ArrayList<ItemStack>> cache = new HashMap();
    private HashMap<String, ArrayList<IDenLibDictionaryHandler>> lists = new HashMap();

    public DenLibDictionaryHandler() {
        this.register();
        this.setup();
    }

    private void register() {
        denLibMod.Proxy.registerForgeSubscribe(this);
    }

    private void setup() {
        this.addToCache("logWood", new ItemStack(Block.field_71951_J, 1, Short.MAX_VALUE));
        this.addToCache("plankWood", new ItemStack(Block.field_71988_x, 1, Short.MAX_VALUE));
        this.addToCache("slabWood", new ItemStack((Block)Block.field_72092_bO, 1, Short.MAX_VALUE));
        this.addToCache("stairWood", Block.field_72063_at);
        this.addToCache("stairWood", Block.field_72072_bX);
        this.addToCache("stairWood", Block.field_72070_bY);
        this.addToCache("stairWood", Block.field_72074_bW);
        this.addToCache("stickWood", Item.field_77669_D);
        this.addToCache("treeSapling", new ItemStack(Block.field_71987_y, 1, Short.MAX_VALUE));
        this.addToCache("treeLeaves", new ItemStack((Block)Block.field_71952_K, 1, Short.MAX_VALUE));
        this.addToCache("oreGold", Block.field_71941_G);
        this.addToCache("oreIron", Block.field_71949_H);
        this.addToCache("oreLapis", Block.field_71947_N);
        this.addToCache("oreDiamond", Block.field_72073_aw);
        this.addToCache("oreRedstone", Block.field_72047_aN);
        this.addToCache("oreEmerald", Block.field_72068_bR);
        this.addToCache("oreQuartz", Block.field_94342_cr);
        this.addToCache("stone", Block.field_71981_t);
        this.addToCache("cobblestone", Block.field_71978_w);
        this.addToCache("record", Item.field_77819_bI);
        this.addToCache("record", Item.field_77797_bJ);
        this.addToCache("record", Item.field_77799_bK);
        this.addToCache("record", Item.field_77793_bL);
        this.addToCache("record", Item.field_77795_bM);
        this.addToCache("record", Item.field_77805_bN);
        this.addToCache("record", Item.field_77807_bO);
        this.addToCache("record", Item.field_77801_bP);
        this.addToCache("record", Item.field_77803_bQ);
        this.addToCache("record", Item.field_77783_bR);
        this.addToCache("record", Item.field_77781_bS);
        this.addToCache("record", Item.field_85180_cf);
        String[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
        for (int i = 0; i < 16; ++i) {
            ItemStack dye = new ItemStack(Item.field_77756_aW, 1, i);
            this.addToCache(dyes[i], dye);
        }
    }

    public void register(IDenLibDictionaryHandler handler) {
        if (handler.lookingFor() == null) {
            this.addToList("null", handler);
        } else {
            this.addToList(handler.lookingFor(), handler);
        }
        for (String key : this.cache.keySet()) {
            for (ItemStack value : this.cache.get(key)) {
                this.doEvent(key, value);
            }
        }
    }

    private void addToList(String s, IDenLibDictionaryHandler handler) {
        if (!this.lists.containsKey(s)) {
            this.lists.put(s, new ArrayList());
        }
        this.lists.get(s).add(handler);
    }

    private boolean doesMatchWildcard(String handler, String ore) {
        String[] search;
        for (String s : search = handler.split("\\*")) {
            if (!ore.contains(s)) continue;
            return true;
        }
        return false;
    }

    private boolean hasWildcard(String s) {
        return s.contains("*");
    }

    @ForgeSubscribe
    public void onEvent(OreDictionary.OreRegisterEvent evt) {
        this.addToCache(evt.Name, evt.Ore);
        this.doEvent(evt.Name, evt.Ore);
    }

    private void addToCache(String Name2, ItemStack Ore) {
        if (!this.cache.containsKey(Name2)) {
            this.cache.put(Name2, new ArrayList());
        }
        this.cache.get(Name2).add(Ore);
    }

    private void addToCache(String Name2, Block block) {
        this.addToCache(Name2, new ItemStack(block));
    }

    private void addToCache(String name, Item item) {
        this.addToCache(name, new ItemStack(item));
    }

    private void doEvent(String Name2, ItemStack Ore) {
        denLibMod.log("Ore: " + Name2);
        for (String s : this.lists.keySet()) {
            if (this.hasWildcard(s)) {
                denLibMod.log(s + " has wildcard.");
                if (!this.doesMatchWildcard(s, Name2)) continue;
                for (IDenLibDictionaryHandler h : this.lists.get(s)) {
                    h.onEvent(Ore);
                }
                continue;
            }
            if (!s.equals(Name2)) continue;
            for (IDenLibDictionaryHandler h : this.lists.get(s)) {
                h.onEvent(Ore);
            }
        }
    }
}

