/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.core.multiblock;

import erogenousbeef.core.common.BeefCoreLog;
import erogenousbeef.core.common.CoordTriplet;
import erogenousbeef.core.multiblock.IMultiblockPart;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import erogenousbeef.core.multiblock.MultiblockRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.chunk.IChunkProvider;

public abstract class MultiblockTileEntityBase
extends IMultiblockPart {
    private MultiblockControllerBase controller = null;
    private boolean visited = false;
    private boolean saveMultiblockData = false;
    private NBTTagCompound cachedMultiblockData = null;
    private boolean paused = false;

    @Override
    public Set<MultiblockControllerBase> attachToNeighbors() {
        IMultiblockPart[] partsToCheck;
        HashSet<MultiblockControllerBase> controllers = null;
        MultiblockControllerBase bestController = null;
        for (IMultiblockPart neighborPart : partsToCheck = this.getNeighboringParts()) {
            MultiblockControllerBase candidate;
            if (!neighborPart.isConnected() || !(candidate = neighborPart.getMultiblockController()).getClass().equals(this.getMultiblockControllerType())) continue;
            if (controllers == null) {
                controllers = new HashSet<MultiblockControllerBase>();
                bestController = candidate;
            } else if (!controllers.contains(candidate) && candidate.shouldConsume(bestController)) {
                bestController = candidate;
            }
            controllers.add(candidate);
        }
        if (bestController != null) {
            this.controller = bestController;
            bestController.attachBlock(this);
        }
        return controllers;
    }

    @Override
    public void assertDetached() {
        if (this.controller != null) {
            BeefCoreLog.info("[assert] Part @ (%d, %d, %d) should be detached already, but detected that it was not. This is not a fatal error, and will be repaired, but is unusual.", this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.controller = null;
        }
    }

    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        if (data.func_74764_b("multiblockData")) {
            this.cachedMultiblockData = data.func_74775_l("multiblockData");
        }
    }

    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        if (this.isMultiblockSaveDelegate() && this.isConnected()) {
            NBTTagCompound multiblockData = new NBTTagCompound();
            this.controller.writeToNBT(multiblockData);
            data.func_74766_a("multiblockData", multiblockData);
        }
    }

    public boolean canUpdate() {
        return false;
    }

    public void func_70313_j() {
        super.func_70313_j();
        this.detachSelf(false);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.detachSelf(true);
    }

    public void func_70312_q() {
        super.func_70312_q();
        MultiblockRegistry.onPartAdded(this.field_70331_k, this);
    }

    public Packet func_70319_e() {
        NBTTagCompound packetData = new NBTTagCompound();
        this.encodeDescriptionPacket(packetData);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, packetData);
    }

    public void onDataPacket(INetworkManager network, Packet132TileEntityData packet) {
        this.decodeDescriptionPacket(packet.field_73331_e);
    }

    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
        if (this.isMultiblockSaveDelegate() && this.isConnected()) {
            NBTTagCompound tag = new NBTTagCompound();
            this.getMultiblockController().formatDescriptionPacket(tag);
            packetData.func_74766_a("multiblockData", tag);
        }
    }

    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        if (packetData.func_74764_b("multiblockData")) {
            NBTTagCompound tag = packetData.func_74775_l("multiblockData");
            if (this.isConnected()) {
                this.getMultiblockController().decodeDescriptionPacket(tag);
            } else {
                this.cachedMultiblockData = tag;
            }
        }
    }

    @Override
    public boolean hasMultiblockSaveData() {
        return this.cachedMultiblockData != null;
    }

    @Override
    public NBTTagCompound getMultiblockSaveData() {
        return this.cachedMultiblockData;
    }

    @Override
    public void onMultiblockDataAssimilated() {
        this.cachedMultiblockData = null;
    }

    @Override
    public abstract void onMachineAssembled(MultiblockControllerBase var1);

    @Override
    public abstract void onMachineBroken();

    @Override
    public abstract void onMachineActivated();

    @Override
    public abstract void onMachineDeactivated();

    @Override
    public boolean isConnected() {
        return this.controller != null;
    }

    @Override
    public MultiblockControllerBase getMultiblockController() {
        return this.controller;
    }

    @Override
    public CoordTriplet getWorldLocation() {
        return new CoordTriplet(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void becomeMultiblockSaveDelegate() {
        this.saveMultiblockData = true;
    }

    @Override
    public void forfeitMultiblockSaveDelegate() {
        this.saveMultiblockData = false;
    }

    @Override
    public boolean isMultiblockSaveDelegate() {
        return this.saveMultiblockData;
    }

    @Override
    public void setUnvisited() {
        this.visited = false;
    }

    @Override
    public void setVisited() {
        this.visited = true;
    }

    @Override
    public boolean isVisited() {
        return this.visited;
    }

    @Override
    public void onAssimilated(MultiblockControllerBase newController) {
        assert (this.controller != newController);
        this.controller = newController;
    }

    @Override
    public void onAttached(MultiblockControllerBase newController) {
        this.controller = newController;
    }

    @Override
    public void onDetached(MultiblockControllerBase oldController) {
        this.controller = null;
    }

    @Override
    public abstract MultiblockControllerBase createNewMultiblock();

    @Override
    public IMultiblockPart[] getNeighboringParts() {
        CoordTriplet[] neighbors = new CoordTriplet[]{new CoordTriplet(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n), new CoordTriplet(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n), new CoordTriplet(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1), new CoordTriplet(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1), new CoordTriplet(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n), new CoordTriplet(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n)};
        ArrayList<IMultiblockPart> neighborParts = new ArrayList<IMultiblockPart>();
        IChunkProvider chunkProvider = this.field_70331_k.func_72863_F();
        for (CoordTriplet neighbor : neighbors) {
            TileEntity te;
            if (!chunkProvider.func_73149_a(neighbor.getChunkX(), neighbor.getChunkZ()) || !((te = this.field_70331_k.func_72796_p(neighbor.x, neighbor.y, neighbor.z)) instanceof IMultiblockPart)) continue;
            neighborParts.add((IMultiblockPart)te);
        }
        IMultiblockPart[] tmp = new IMultiblockPart[neighborParts.size()];
        return neighborParts.toArray(tmp);
    }

    @Override
    public void onOrphaned(MultiblockControllerBase controller, int oldSize, int newSize) {
        this.field_70331_k.func_72944_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, (TileEntity)this);
    }

    protected void detachSelf(boolean chunkUnloading) {
        if (this.controller != null) {
            this.controller.detachBlock(this, chunkUnloading);
            this.controller = null;
        }
        MultiblockRegistry.onPartRemovedFromWorld(this.field_70331_k, this);
    }
}

