/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.gui.controls;

import erogenousbeef.bigreactors.client.gui.BeefGuiBase;
import erogenousbeef.bigreactors.common.multiblock.MultiblockTurbine;
import erogenousbeef.bigreactors.gui.IBeefTooltipControl;
import erogenousbeef.bigreactors.gui.controls.BeefGuiTextureProgressBar;

public class BeefGuiRpmBar
extends BeefGuiTextureProgressBar
implements IBeefTooltipControl {
    MultiblockTurbine turbine;
    String[] tooltip = null;

    public BeefGuiRpmBar(BeefGuiBase container, int x, int y, MultiblockTurbine turbine, String tooltipTitle, String[] extraTooltip) {
        super(container, x, y);
        this.turbine = turbine;
        if (extraTooltip == null || extraTooltip.length <= 0) {
            this.tooltip = new String[2];
        } else {
            this.tooltip = new String[3 + extraTooltip.length];
            this.tooltip[2] = "";
            for (int i = 0; i < extraTooltip.length; ++i) {
                this.tooltip[i + 3] = extraTooltip[i];
            }
        }
        this.tooltip[0] = "\u00a7b" + tooltipTitle;
        this.tooltip[1] = "";
    }

    @Override
    protected String getBackgroundTexture() {
        return "controls/RpmBar.png";
    }

    @Override
    public String[] getTooltip() {
        this.tooltip[1] = this.turbine != null ? String.format("  %.0f RPM", Float.valueOf(this.turbine.getRotorSpeed())) : "  0 RPM";
        return this.tooltip;
    }

    @Override
    protected float getProgress() {
        if (this.turbine == null) {
            return 0.0f;
        }
        return Math.min(1.0f, this.turbine.getRotorSpeed() / (this.turbine.getMaxRotorSpeed() * 1.1f));
    }
}

