/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.gui.controls;

import erogenousbeef.bigreactors.client.gui.BeefGuiBase;
import erogenousbeef.bigreactors.common.interfaces.IReactorFuelInfo;
import erogenousbeef.bigreactors.gui.IBeefTooltipControl;
import erogenousbeef.bigreactors.gui.controls.BeefGuiVerticalProgressBar;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;

public class BeefGuiFuelMixBar
extends BeefGuiVerticalProgressBar
implements IBeefTooltipControl {
    IReactorFuelInfo entity;
    protected double fuelLeftU = 0.25;
    protected double fuelRightU = 0.4999;
    protected double wasteLeftU = 0.5;
    protected double wasteRightU = 0.7499;
    private static final double maxV = 0.984375;
    private static final double minV = 0.015625;

    public BeefGuiFuelMixBar(BeefGuiBase container, int x, int y, IReactorFuelInfo entity) {
        super(container, x, y);
        this.entity = entity;
    }

    @Override
    protected double getBackgroundLeftU() {
        return 0.0;
    }

    @Override
    protected double getBackgroundRightU() {
        return 0.2499;
    }

    @Override
    protected String getBackgroundTexture() {
        return "controls/FuelMixBar.png";
    }

    @Override
    protected void drawProgressBar(Tessellator tessellator, TextureManager renderEngine, int barMinX, int barMaxX, int barMinY, int barMaxY, int zLevel) {
        int barMaxHeight = this.height - 1;
        int barHeight = Math.max(1, Math.round(this.getProgress() * (float)barMaxHeight));
        double fullness = (double)(this.entity.getFuelAmount() + this.entity.getWasteAmount()) / (double)this.entity.getCapacity();
        double fuelProportion = (double)this.entity.getFuelAmount() / (double)(this.entity.getFuelAmount() + this.entity.getWasteAmount());
        double wasteProportion = (double)this.entity.getWasteAmount() / (double)(this.entity.getFuelAmount() + this.entity.getWasteAmount());
        renderEngine.func_110577_a(this.controlResource);
        if (fuelProportion > 0.0) {
            double fuelMinV = 1.0 - fullness * 0.984375;
            double fuelMaxV = 0.984375;
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)this.absoluteX, (double)(this.absoluteY + this.height - 1), (double)zLevel, this.fuelLeftU, fuelMaxV);
            tessellator.func_78374_a((double)(this.absoluteX + this.width), (double)(this.absoluteY + this.height - 1), (double)zLevel, this.fuelRightU, fuelMaxV);
            tessellator.func_78374_a((double)(this.absoluteX + this.width), (double)(this.absoluteY + this.height - barHeight), (double)zLevel, this.fuelRightU, fuelMinV);
            tessellator.func_78374_a((double)this.absoluteX, (double)(this.absoluteY + this.height - barHeight), (double)zLevel, this.fuelLeftU, fuelMinV);
            tessellator.func_78381_a();
        }
        if (wasteProportion > 0.0) {
            double wasteMinV = 1.0 - fullness * wasteProportion * 0.984375;
            double wasteMaxV = 0.984375;
            double wasteHeight = Math.round((double)barHeight * wasteProportion);
            if (wasteHeight > 0.0) {
                double wasteTop = (double)(this.absoluteY + this.height - 1) - wasteHeight;
                tessellator.func_78382_b();
                tessellator.func_78374_a((double)this.absoluteX, (double)(this.absoluteY + this.height - 1), (double)(zLevel + 1), this.wasteLeftU, wasteMaxV);
                tessellator.func_78374_a((double)(this.absoluteX + this.width), (double)(this.absoluteY + this.height - 1), (double)(zLevel + 1), this.wasteRightU, wasteMaxV);
                tessellator.func_78374_a((double)(this.absoluteX + this.width), wasteTop, (double)(zLevel + 1), this.wasteRightU, wasteMinV);
                tessellator.func_78374_a((double)this.absoluteX, wasteTop, (double)(zLevel + 1), this.wasteLeftU, wasteMinV);
                tessellator.func_78381_a();
            }
        }
    }

    @Override
    public String[] getTooltip() {
        float depletion;
        float fullness = this.getProgress() * 100.0f;
        String wasteString = "Empty";
        String fuelString = "Empty";
        if (this.entity.getFuelAmount() + this.entity.getWasteAmount() == 0) {
            depletion = 0.0f;
        } else {
            depletion = (float)this.entity.getWasteAmount() / (float)(this.entity.getFuelAmount() + this.entity.getWasteAmount()) * 100.0f;
            if (this.entity.getFuelAmount() > 0) {
                fuelString = Integer.toString(this.entity.getFuelAmount()) + " mB";
            }
            if (this.entity.getWasteAmount() > 0) {
                wasteString = Integer.toString(this.entity.getWasteAmount()) + " mB";
            }
        }
        return new String[]{"\u00a7bCore Fuel Status", String.format(" %2.1f%% full", Float.valueOf(fullness)), String.format(" %2.1f%% depleted", Float.valueOf(depletion)), "", String.format("Fuel Rods: %d", this.entity.getFuelRodCount()), String.format("Max Capacity: %d mB", this.entity.getCapacity()), String.format("Fuel: %s", fuelString), String.format("Waste: %s", wasteString), String.format("Total: %d mB", this.entity.getFuelAmount() + this.entity.getWasteAmount())};
    }

    @Override
    protected float getProgress() {
        return (float)(this.entity.getFuelAmount() + this.entity.getWasteAmount()) / (float)this.entity.getCapacity();
    }
}

