/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.gui;

import erogenousbeef.bigreactors.client.gui.BeefGuiBase;
import erogenousbeef.bigreactors.gui.IBeefGuiControl;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Icon;
import org.lwjgl.opengl.GL11;

public abstract class BeefGuiControlBase
implements IBeefGuiControl {
    protected BeefGuiBase guiContainer;
    protected int absoluteX;
    protected int absoluteY;
    protected int relativeX;
    protected int relativeY;
    protected int width;
    protected int height;
    public boolean visible;

    protected BeefGuiControlBase(BeefGuiBase container, int absoluteX, int absoluteY, int width, int height) {
        this.guiContainer = container;
        this.absoluteX = absoluteX;
        this.absoluteY = absoluteY;
        this.relativeX = absoluteX - container.getGuiLeft();
        this.relativeY = absoluteY - container.getGuiTop();
        this.height = height;
        this.width = width;
        this.visible = true;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.absoluteX && mouseX <= this.absoluteX + this.width && mouseY >= this.absoluteY && mouseY <= this.absoluteY + this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public void onMouseClicked(int mouseX, int mouseY, int mouseButton) {
    }

    protected static void drawRect(int xMin, int yMin, int xMax, int yMax, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        BeefGuiControlBase.drawRect(xMin, yMin, xMax, yMax, r, g, b, a);
    }

    protected static void drawRect(int xMin, int yMin, int xMax, int yMax, float r, float g, float b, float a) {
        int temp;
        if (xMax < xMin) {
            temp = xMin;
            xMin = xMax;
            xMax = temp;
        }
        if (yMax < yMin) {
            temp = yMin;
            yMin = yMax;
            yMax = temp;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)xMin, (double)yMax, 0.0);
        tessellator.func_78377_a((double)xMax, (double)yMax, 0.0);
        tessellator.func_78377_a((double)xMax, (double)yMin, 0.0);
        tessellator.func_78377_a((double)xMin, (double)yMin, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    protected static void drawTexturedModelRectFromIcon(int x, int y, Icon icon, int width, int height) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), 0.0, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        tessellator.func_78374_a((double)(x + width), (double)(y + height), 0.0, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), 0.0, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), 0.0, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        tessellator.func_78381_a();
    }

    public boolean isVisible() {
        return this.visible;
    }
}

