/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erogenousbeef.bigreactors.client.gui.GuiReactorRedstonePort;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.interfaces.ITickableMultiblockPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPartBase;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorRedNetPort;
import erogenousbeef.bigreactors.gui.container.ContainerBasic;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import erogenousbeef.core.multiblock.MultiblockValidationException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityReactorRedstonePort
extends TileEntityReactorPartBase
implements ITickableMultiblockPart {
    protected TileEntityReactorRedNetPort.CircuitType circuitType = TileEntityReactorRedNetPort.CircuitType.DISABLED;
    protected int outputLevel;
    protected boolean activeOnPulse;
    protected boolean greaterThan;
    protected int ticksSinceLastUpdate = 0;
    protected boolean isExternallyPowered = false;

    public boolean isRedstoneActive() {
        if (!this.isConnected()) {
            return false;
        }
        MultiblockReactor reactor = (MultiblockReactor)this.getMultiblockController();
        switch (this.circuitType) {
            case outputFuelTemperature: {
                return this.checkVariable((int)reactor.getFuelHeat());
            }
            case outputCasingTemperature: {
                return this.checkVariable((int)reactor.getReactorHeat());
            }
            case outputFuelMix: {
                return this.checkVariable((int)(reactor.getFuelRichness() * 100.0f));
            }
            case outputFuelAmount: {
                return this.checkVariable(reactor.getFuelAmount());
            }
            case outputWasteAmount: {
                return this.checkVariable(reactor.getWasteAmount());
            }
            case outputEnergyAmount: {
                return this.checkVariable(reactor.getEnergyStoredPercentage());
            }
            case DISABLED: {
                return false;
            }
        }
        return this.isExternallyPowered;
    }

    public boolean isInput() {
        return TileEntityReactorRedNetPort.isInput(this.circuitType);
    }

    public boolean isOutput() {
        return TileEntityReactorRedNetPort.isOutput(this.circuitType);
    }

    protected boolean checkVariable(int value) {
        if (this.greaterThan) {
            return value > this.getOutputLevel();
        }
        return value < this.getOutputLevel();
    }

    public void sendRedstoneUpdate() {
        if (this.field_70331_k != null && !this.field_70331_k.field_72995_K) {
            int md;
            if (this.isOutput()) {
                md = this.isRedstoneActive() ? 1 : 0;
            } else {
                int n = md = this.isExternallyPowered ? 1 : 0;
            }
            if (md != this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n)) {
                this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, md, 3);
            }
        }
    }

    public void onNeighborBlockChange(int x, int y, int z, int neighborBlockID) {
        if (!this.isConnected()) {
            return;
        }
        if (this.isInput()) {
            ForgeDirection out = this.getOutwardsDir();
            boolean nowPowered = this.isReceivingRedstonePowerFrom(this.field_70331_k, this.field_70329_l + out.offsetX, this.field_70330_m + out.offsetY, this.field_70327_n + out.offsetZ, out, neighborBlockID);
            if (this.isExternallyPowered != nowPowered) {
                this.isExternallyPowered = nowPowered;
                this.onRedstoneInputUpdated();
                this.sendRedstoneUpdate();
            }
        } else {
            this.isExternallyPowered = false;
        }
    }

    protected void onRedstoneInputUpdated() {
        if (!this.isConnected()) {
            return;
        }
        MultiblockReactor reactor = (MultiblockReactor)this.getMultiblockController();
        switch (this.circuitType) {
            case inputActive: {
                if (this.isInputActiveOnPulse()) {
                    if (!this.isExternallyPowered) break;
                    reactor.setActive(!reactor.isActive());
                    break;
                }
                reactor.setActive(this.isExternallyPowered);
                break;
            }
            case inputSetControlRod: {
                if (this.isInputActiveOnPulse()) {
                    if (!this.isExternallyPowered) break;
                    if (this.shouldSetControlRodsInsteadOfChange()) {
                        reactor.setAllControlRodInsertionValues(this.outputLevel);
                        break;
                    }
                    reactor.changeAllControlRodInsertionValues((short)this.outputLevel);
                    break;
                }
                if (this.isExternallyPowered) {
                    reactor.setAllControlRodInsertionValues(this.getControlRodLevelWhileOn());
                    break;
                }
                reactor.setAllControlRodInsertionValues(this.getControlRodLevelWhileOff());
                break;
            }
            case inputEjectWaste: {
                if (!this.isExternallyPowered) break;
                reactor.ejectWaste(false, null);
                break;
            }
        }
    }

    public int getOutputLevel() {
        return this.outputLevel;
    }

    public int getControlRodLevelWhileOff() {
        return (this.outputLevel & 0xFF00) >> 8 & 0xFF;
    }

    public int getControlRodLevelWhileOn() {
        return this.outputLevel & 0xFF;
    }

    public static int packControlRodLevels(byte off, byte on) {
        return off << 8 & 0xFF00 | on & 0xFF;
    }

    public static int unpackControlRodLevelOn(int level) {
        return level & 0xFF;
    }

    public static int unpackControlRodLevelOff(int level) {
        return level % 65280 >> 8 & 0xFF;
    }

    public boolean isInputActiveOnPulse() {
        return this.activeOnPulse;
    }

    public void onReceiveUpdatePacket(int newType, int outputLevel, boolean greaterThan, boolean activeOnPulse) {
        boolean oldTypeWasInput = this.isInput();
        this.circuitType = TileEntityReactorRedNetPort.CircuitType.values()[newType];
        this.outputLevel = outputLevel;
        this.greaterThan = greaterThan;
        this.activeOnPulse = activeOnPulse;
        if (TileEntityReactorRedstonePort.isAlwaysActiveOnPulse(this.circuitType)) {
            this.activeOnPulse = true;
        } else if (TileEntityReactorRedNetPort.isOutput(this.circuitType)) {
            this.activeOnPulse = false;
        }
        if (this.isInput()) {
            ForgeDirection out = this.getOutwardsDir();
            this.isExternallyPowered = this.isReceivingRedstonePowerFrom(this.field_70331_k, this.field_70329_l + out.offsetX, this.field_70330_m + out.offsetY, this.field_70327_n + out.offsetZ, out);
            if (!this.isInputActiveOnPulse()) {
                this.onRedstoneInputUpdated();
            }
        } else {
            this.isExternallyPowered = false;
        }
        this.sendRedstoneUpdate();
        if (!this.field_70331_k.field_72995_K) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getGreaterThan() {
        return this.greaterThan;
    }

    public TileEntityReactorRedNetPort.CircuitType getCircuitType() {
        return this.circuitType;
    }

    private boolean shouldSetControlRodsInsteadOfChange() {
        return !this.greaterThan;
    }

    public void onRedNetUpdate(int powerLevel) {
        if (this.isInput()) {
            boolean wasPowered = this.isExternallyPowered;
            boolean bl = this.isExternallyPowered = powerLevel > 0;
            if (wasPowered != this.isExternallyPowered) {
                this.onRedstoneInputUpdated();
                this.sendRedstoneUpdate();
            }
        }
    }

    private boolean isReceivingRedstonePowerFrom(World world, int x, int y, int z, ForgeDirection dir) {
        int blockId = world.func_72798_a(x, y, z);
        return this.isReceivingRedstonePowerFrom(world, x, y, z, dir, blockId);
    }

    private boolean isReceivingRedstonePowerFrom(World world, int x, int y, int z, ForgeDirection dir, int neighborBlockId) {
        if (neighborBlockId == Block.field_72075_av.field_71990_ca) {
            return world.func_72805_g(x, y, z) > 0;
        }
        return world.func_94574_k(x, y, z, dir.ordinal()) || world.func_72879_k(x, y, z, dir.ordinal()) > 0;
    }

    public boolean shouldRefresh(int oldID, int newID, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldID != newID;
    }

    @Override
    public void onMultiblockServerTick() {
        if (!this.isConnected()) {
            return;
        }
        ++this.ticksSinceLastUpdate;
        if (this.ticksSinceLastUpdate < BigReactors.ticksPerRedstoneUpdate) {
            return;
        }
        if (this.isOutput()) {
            this.sendRedstoneUpdate();
        }
        this.ticksSinceLastUpdate = 0;
    }

    private void readData(NBTTagCompound data) {
        if (data.func_74764_b("circuitType")) {
            TileEntityReactorRedstonePort tileEntityReactorRedstonePort = this;
            this.circuitType = tileEntityReactorRedstonePort.circuitType.values()[data.func_74762_e("circuitType")];
        }
        if (data.func_74764_b("outputLevel")) {
            this.outputLevel = data.func_74762_e("outputLevel");
        }
        if (data.func_74764_b("greaterThan")) {
            this.greaterThan = data.func_74767_n("greaterThan");
        }
        if (data.func_74764_b("activeOnPulse")) {
            this.activeOnPulse = data.func_74767_n("activeOnPulse");
        }
    }

    private void writeData(NBTTagCompound data) {
        data.func_74768_a("circuitType", this.circuitType.ordinal());
        data.func_74768_a("outputLevel", this.outputLevel);
        data.func_74757_a("greaterThan", this.greaterThan);
        data.func_74757_a("activeOnPulse", this.activeOnPulse);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.readData(data);
        this.sendRedstoneUpdate();
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        this.writeData(data);
    }

    @Override
    public void decodeDescriptionPacket(NBTTagCompound data) {
        super.decodeDescriptionPacket(data);
        this.readData(data);
    }

    @Override
    public void encodeDescriptionPacket(NBTTagCompound data) {
        super.encodeDescriptionPacket(data);
        data.func_74768_a("circuitType", this.circuitType.ordinal());
        data.func_74768_a("outputLevel", this.outputLevel);
        data.func_74757_a("greaterThan", this.greaterThan);
        data.func_74757_a("activeOnPulse", this.activeOnPulse);
    }

    @Override
    public void isGoodForFrame() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Redstone ports may only be placed on a reactor's external side faces, not as part of the frame", this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    @Override
    public void isGoodForSides() throws MultiblockValidationException {
    }

    @Override
    public void isGoodForTop() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Redstone ports may only be placed on a reactor's external side faces, not the top", this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    @Override
    public void isGoodForBottom() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Redstone ports may only be placed on a reactor's external side faces, not the bottom", this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    @Override
    public void isGoodForInterior() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Redstone ports may not be placed in a reactor's interior", this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase controller) {
        super.onMachineAssembled(controller);
        this.sendRedstoneUpdate();
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
        this.sendRedstoneUpdate();
    }

    @Override
    public void onMachineActivated() {
        this.sendRedstoneUpdate();
    }

    @Override
    public void onMachineDeactivated() {
        this.sendRedstoneUpdate();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getGuiElement(InventoryPlayer inventoryPlayer) {
        return new GuiReactorRedstonePort(new ContainerBasic(), this);
    }

    @Override
    public Object getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerBasic();
    }

    public static boolean isAlwaysActiveOnPulse(TileEntityReactorRedNetPort.CircuitType circuitType) {
        return circuitType == TileEntityReactorRedNetPort.CircuitType.inputEjectWaste;
    }
}

