/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erogenousbeef.bigreactors.client.gui.GuiReactorStatus;
import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.multiblock.block.BlockReactorPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPartBase;
import erogenousbeef.bigreactors.gui.container.ContainerReactorController;
import erogenousbeef.core.common.CoordTriplet;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import erogenousbeef.core.multiblock.MultiblockValidationException;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.world.World;

public class TileEntityReactorPart
extends TileEntityReactorPartBase {
    @Override
    public void isGoodForFrame() throws MultiblockValidationException {
        int metadata = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (BlockReactorPart.isCasing(metadata)) {
            return;
        }
        throw new MultiblockValidationException(String.format("%d, %d, %d - Only casing may be used as part of a reactor's frame", this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    @Override
    public void isGoodForSides() throws MultiblockValidationException {
    }

    @Override
    public void isGoodForTop() throws MultiblockValidationException {
        int metadata = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (BlockReactorPart.isCasing(metadata)) {
            return;
        }
        throw new MultiblockValidationException(String.format("%d, %d, %d - This part may not be placed on a reactor's top face", this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    @Override
    public void isGoodForBottom() throws MultiblockValidationException {
        int metadata = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (BlockReactorPart.isCasing(metadata)) {
            return;
        }
        throw new MultiblockValidationException(String.format("%d, %d, %d - This part may not be placed on a reactor's bottom face", this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    @Override
    public void isGoodForInterior() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - This reactor part may not be placed in the reactor's interior", this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase multiblockController) {
        super.onMachineAssembled(multiblockController);
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (multiblockController == null) {
            throw new IllegalArgumentException("Being assembled into a null controller. This should never happen. Please report this stacktrace to http://github.com/ErogenousBeef/BigReactors/");
        }
        if (this.getMultiblockController() == null) {
            BRLog.warning("Reactor part at (%d, %d, %d) is being assembled without being attached to a reactor. Attempting to auto-heal. Fully destroying and re-building this reactor is recommended if errors persist.", this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.onAttached(multiblockController);
        }
        if (this.func_70311_o().field_71990_ca == BigReactors.blockReactorPart.field_71990_ca) {
            int metadata = this.func_70322_n();
            if (BlockReactorPart.isCasing(metadata)) {
                this.setCasingMetadataBasedOnWorldPosition();
            } else if (BlockReactorPart.isController(metadata)) {
                if (!this.getReactorController().isActive()) {
                    this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 7, 2);
                } else {
                    this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 8, 2);
                }
            }
        }
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (this.func_70311_o().field_71990_ca == BigReactors.blockReactorPart.field_71990_ca) {
            int metadata = this.func_70322_n();
            if (BlockReactorPart.isCasing(metadata)) {
                this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, 2);
            } else if (BlockReactorPart.isController(metadata)) {
                this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 6, 2);
            }
        }
    }

    @Override
    public void onMachineActivated() {
        int metadata;
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (this.func_70311_o().field_71990_ca == BigReactors.blockReactorPart.field_71990_ca && BlockReactorPart.isController(metadata = this.func_70322_n())) {
            this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 8, 2);
        }
    }

    @Override
    public void onMachineDeactivated() {
        int metadata;
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (this.func_70311_o().field_71990_ca == BigReactors.blockReactorPart.field_71990_ca && BlockReactorPart.isController(metadata = this.func_70322_n())) {
            this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 7, 2);
        }
    }

    private void setCasingMetadataBasedOnWorldPosition() {
        MultiblockControllerBase controller = this.getMultiblockController();
        assert (controller != null);
        CoordTriplet minCoord = controller.getMinimumCoord();
        CoordTriplet maxCoord = controller.getMaximumCoord();
        int extremes = 0;
        boolean zExtreme = false;
        boolean yExtreme = false;
        boolean xExtreme = false;
        if (this.field_70329_l == minCoord.x) {
            ++extremes;
            xExtreme = true;
        }
        if (this.field_70330_m == minCoord.y) {
            ++extremes;
            yExtreme = true;
        }
        if (this.field_70327_n == minCoord.z) {
            ++extremes;
            zExtreme = true;
        }
        if (this.field_70329_l == maxCoord.x) {
            ++extremes;
            xExtreme = true;
        }
        if (this.field_70330_m == maxCoord.y) {
            ++extremes;
            yExtreme = true;
        }
        if (this.field_70327_n == maxCoord.z) {
            ++extremes;
            zExtreme = true;
        }
        if (extremes == 3) {
            this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, 2);
        } else if (extremes == 2) {
            if (!xExtreme) {
                this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 4, 2);
            } else if (!zExtreme) {
                this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 5, 2);
            } else {
                this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 3, 2);
            }
        } else if (extremes == 1) {
            this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 2, 2);
        } else {
            this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, 2);
        }
    }

    @Override
    public Object getContainer(InventoryPlayer inventoryPlayer) {
        if (!this.isConnected()) {
            return null;
        }
        int metadata = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (BlockReactorPart.isController(metadata)) {
            return new ContainerReactorController(this, inventoryPlayer.field_70458_d);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getGuiElement(InventoryPlayer inventoryPlayer) {
        if (!this.isConnected()) {
            return null;
        }
        int metadata = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (BlockReactorPart.isController(metadata)) {
            return new GuiReactorStatus(new ContainerReactorController(this, inventoryPlayer.field_70458_d), this);
        }
        return null;
    }

    public boolean shouldRefresh(int oldID, int newID, int oldMeta, int newMeta, World world, int x, int y, int z) {
        if (oldID != newID) {
            return true;
        }
        if (BlockReactorPart.isCasing(oldMeta) && BlockReactorPart.isCasing(newMeta)) {
            return false;
        }
        if (BlockReactorPart.isAccessPort(oldMeta) && BlockReactorPart.isAccessPort(newMeta)) {
            return false;
        }
        if (BlockReactorPart.isController(oldMeta) && BlockReactorPart.isController(newMeta)) {
            return false;
        }
        if (BlockReactorPart.isPowerTap(oldMeta) && BlockReactorPart.isPowerTap(newMeta)) {
            return false;
        }
        return !BlockReactorPart.isRedNetPort(oldMeta) || !BlockReactorPart.isPowerTap(newMeta);
    }
}

