/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erogenousbeef.bigreactors.client.gui.GuiReactorControlRod;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorFuelRod;
import erogenousbeef.bigreactors.gui.IBeefGuiEntity;
import erogenousbeef.bigreactors.gui.container.ContainerReactorControlRod;
import erogenousbeef.bigreactors.net.PacketWrapper;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import erogenousbeef.core.multiblock.MultiblockValidationException;
import erogenousbeef.core.multiblock.rectangular.RectangularMultiblockTileEntityBase;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityReactorControlRod
extends RectangularMultiblockTileEntityBase
implements IBeefGuiEntity {
    public static final short maxInsertion = 100;
    public static final short minInsertion = 0;
    protected short controlRodInsertion = 0;
    protected String name = "";
    private FluidStack cachedFuel = null;

    public short getControlRodInsertion() {
        return this.controlRodInsertion;
    }

    public FluidStack getCachedFuel() {
        return this.cachedFuel;
    }

    public void setControlRodInsertion(short newInsertion) {
        if (newInsertion > 100 || newInsertion < 0 || newInsertion == this.controlRodInsertion) {
            return;
        }
        if (!this.isConnected()) {
            return;
        }
        this.controlRodInsertion = (short)Math.max(Math.min(newInsertion, 100), 0);
        this.sendControlRodUpdate();
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.readLocalDataFromNBT(data);
        if (data.func_74764_b("fuelFluidStack")) {
            this.cachedFuel = FluidStack.loadFluidStackFromNBT((NBTTagCompound)data.func_74775_l("fuelFluidStack"));
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        this.writeLocalDataToNBT(data);
    }

    @Override
    public void beginUpdatingPlayer(EntityPlayer player) {
    }

    @Override
    public void stopUpdatingPlayer(EntityPlayer player) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGUI(EntityPlayer player) {
        return new GuiReactorControlRod(this.getContainer(player), this);
    }

    @Override
    public Container getContainer(EntityPlayer player) {
        return new ContainerReactorControlRod(this, player);
    }

    @Override
    public void onReceiveGuiButtonPress(String buttonName, DataInputStream dataStream) throws IOException {
        if (buttonName.equals("rodInsert")) {
            this.setControlRodInsertion((short)(this.controlRodInsertion + 10));
        } else if (buttonName.equals("rodRetract")) {
            this.setControlRodInsertion((short)(this.controlRodInsertion - 10));
        }
    }

    protected void sendControlRodUpdate() {
        if (this.field_70331_k == null || this.field_70331_k.field_72995_K) {
            return;
        }
        Packet250CustomPayload p = PacketWrapper.createPacket("BigReactors", 8, new Object[]{this.field_70329_l, this.field_70330_m, this.field_70327_n, this.controlRodInsertion});
        PacketDispatcher.sendPacketToAllAround((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)50.0, (int)this.field_70331_k.field_73011_w.field_76574_g, (Packet)p);
    }

    @SideOnly(value=Side.CLIENT)
    public void onControlRodUpdate(short controlRodInsertion) {
        this.controlRodInsertion = controlRodInsertion;
    }

    private void readLocalDataFromNBT(NBTTagCompound data) {
        if (data.func_74764_b("controlRodInsertion")) {
            this.controlRodInsertion = data.func_74765_d("controlRodInsertion");
        }
        this.name = data.func_74764_b("name") ? data.func_74779_i("name") : "";
    }

    private void writeLocalDataToNBT(NBTTagCompound data) {
        data.func_74777_a("controlRodInsertion", this.controlRodInsertion);
        if (!this.name.isEmpty()) {
            data.func_74778_a("name", this.name);
        }
    }

    @Override
    public MultiblockControllerBase createNewMultiblock() {
        return new MultiblockReactor(this.field_70331_k);
    }

    @Override
    public Class<? extends MultiblockControllerBase> getMultiblockControllerType() {
        return MultiblockReactor.class;
    }

    @Override
    public void isGoodForFrame() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Control rods may only be placed on the top face", this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    @Override
    public void isGoodForSides() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Control rods may only be placed on the top face", this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    @Override
    public void isGoodForTop() throws MultiblockValidationException {
        TileEntity teBelow = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
        if (!(teBelow instanceof TileEntityReactorFuelRod)) {
            throw new MultiblockValidationException(String.format("%d, %d, %d - Control rods may only be placed on the top face, atop a column of fuel rods", this.field_70329_l, this.field_70330_m, this.field_70327_n));
        }
    }

    @Override
    public void isGoodForBottom() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Control rods may only be placed on the top face", this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    @Override
    public void isGoodForInterior() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Control rods may only be placed on the top face", this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    @Override
    public void onMachineActivated() {
    }

    @Override
    public void onMachineDeactivated() {
    }

    @Override
    protected void encodeDescriptionPacket(NBTTagCompound packet) {
        super.encodeDescriptionPacket(packet);
        NBTTagCompound localData = new NBTTagCompound();
        this.writeLocalDataToNBT(localData);
        packet.func_74766_a("reactorControlRod", localData);
    }

    @Override
    protected void decodeDescriptionPacket(NBTTagCompound packet) {
        super.decodeDescriptionPacket(packet);
        if (packet.func_74764_b("reactorControlRod")) {
            NBTTagCompound localData = packet.func_74775_l("reactorControlRod");
            this.readLocalDataFromNBT(localData);
            if (this.field_70331_k != null && this.field_70331_k.field_72995_K) {
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        }
    }

    public void setName(String newName) {
        if (this.name.equals(newName)) {
            return;
        }
        this.name = newName;
        if (!this.field_70331_k.field_72995_K) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public String getName() {
        return this.name;
    }
}

