/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import buildcraft.api.transport.IPipeTile;
import cofh.api.transport.IItemConduit;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erogenousbeef.bigreactors.client.gui.GuiReactorAccessPort;
import erogenousbeef.bigreactors.common.BRRegistry;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPart;
import erogenousbeef.bigreactors.gui.container.ContainerReactorAccessPort;
import erogenousbeef.bigreactors.utils.InventoryHelper;
import erogenousbeef.bigreactors.utils.SidedInventoryHelper;
import erogenousbeef.bigreactors.utils.StaticUtils;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityReactorAccessPort
extends TileEntityReactorPart
implements IInventory,
ISidedInventory {
    protected ItemStack[] _inventories = new ItemStack[this.func_70302_i_()];
    public static final int SLOT_INLET = 0;
    public static final int SLOT_OUTLET = 1;
    public static final int NUM_SLOTS = 2;

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this._inventories = new ItemStack[this.func_70302_i_()];
        if (tag.func_74764_b("Items")) {
            NBTTagList tagList = tag.func_74761_m("Items");
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound itemTag = (NBTTagCompound)tagList.func_74743_b(i);
                int slot = itemTag.func_74771_c("Slot") & 0xFF;
                if (slot < 0 || slot > this._inventories.length) continue;
                ItemStack itemStack = new ItemStack(0, 0, 0);
                itemStack.func_77963_c(itemTag);
                this._inventories[slot] = itemStack;
            }
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this._inventories.length; ++i) {
            if (this._inventories[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            this._inventories[i].func_77955_b(itemTag);
            tagList.func_74742_a((NBTBase)itemTag);
        }
        if (tagList.func_74745_c() > 0) {
            tag.func_74782_a("Items", (NBTBase)tagList);
        }
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int slot) {
        return this._inventories[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this._inventories[slot] != null) {
            if (this._inventories[slot].field_77994_a <= amount) {
                ItemStack itemstack = this._inventories[slot];
                this._inventories[slot] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack newStack = this._inventories[slot].func_77979_a(amount);
            if (this._inventories[slot].field_77994_a == 0) {
                this._inventories[slot] = null;
            }
            this.func_70296_d();
            return newStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this._inventories[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_70303_b() {
        return "Access Port";
    }

    public boolean func_94042_c() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        if (itemstack == null) {
            return true;
        }
        FluidStack data = null;
        if (slot == 0) {
            data = BRRegistry.getReactorMappingForFuel(itemstack);
        } else if (slot == 1) {
            data = BRRegistry.getReactorMappingForWaste(itemstack);
        }
        return data != null;
    }

    public int[] func_94128_d(int side) {
        if (side == 0 || side == 1) {
            return null;
        }
        int metadata = this.func_70322_n();
        if (metadata == 11) {
            return new int[]{0};
        }
        if (metadata == 12) {
            return new int[]{1};
        }
        return null;
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        if (side == 0 || side == 1) {
            return false;
        }
        return this.func_94041_b(slot, itemstack);
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        if (side == 0 || side == 1) {
            return false;
        }
        return this.func_94041_b(slot, itemstack);
    }

    @Override
    public void onNetworkPacket(int packetType, DataInputStream data) throws IOException {
        if (packetType == 2) {
            byte newMetadata = data.readByte();
            if (newMetadata == 11 || newMetadata == 12) {
                this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, (int)newMetadata, 2);
            }
        } else {
            super.onNetworkPacket(packetType, data);
        }
    }

    @Override
    public Object getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerReactorAccessPort(this, inventoryPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getGuiElement(InventoryPlayer inventoryPlayer) {
        return new GuiReactorAccessPort(new ContainerReactorAccessPort(this, inventoryPlayer), this);
    }

    protected ItemStack distributeItemToPipes(ItemStack itemToDistribute) {
        ForgeDirection[] dirsToCheck;
        for (ForgeDirection dir : dirsToCheck = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST}) {
            InventoryHelper helper;
            if (itemToDistribute == null) {
                return null;
            }
            TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l + dir.offsetX, this.field_70330_m + dir.offsetY, this.field_70327_n + dir.offsetZ);
            if (te instanceof IItemConduit) {
                IItemConduit conduit = (IItemConduit)te;
                itemToDistribute = conduit.sendItems(itemToDistribute, dir.getOpposite());
                continue;
            }
            if (te instanceof IPipeTile) {
                IPipeTile pipe = (IPipeTile)te;
                if (!pipe.isPipeConnected(dir.getOpposite())) continue;
                itemToDistribute.field_77994_a -= pipe.injectItem(itemToDistribute.func_77946_l(), true, dir.getOpposite());
                if (itemToDistribute.field_77994_a > 0) continue;
                return null;
            }
            if (!(te instanceof IInventory)) continue;
            if (te instanceof ISidedInventory) {
                helper = new SidedInventoryHelper((ISidedInventory)te, dir.getOpposite());
            } else {
                IInventory inv = (IInventory)te;
                if (this.field_70331_k.func_72798_a(this.field_70329_l + dir.offsetX, this.field_70330_m + dir.offsetY, this.field_70327_n + dir.offsetZ) == Block.field_72077_au.field_71990_ca) {
                    inv = StaticUtils.Inventory.checkForDoubleChest(this.field_70331_k, inv, this.field_70329_l + dir.offsetX, this.field_70330_m + dir.offsetY, this.field_70327_n + dir.offsetZ);
                }
                helper = new InventoryHelper(inv);
            }
            itemToDistribute = helper.addItem(itemToDistribute);
        }
        return itemToDistribute;
    }

    public void onItemsReceived() {
        if (12 == this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n)) {
            this._inventories[1] = this.distributeItemToPipes(this._inventories[1]);
        }
        this.func_70296_d();
    }
}

