/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.helpers;

import erogenousbeef.bigreactors.api.IReactorFuel;
import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.BRRegistry;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.multiblock.helpers.FluidHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FuelContainer
extends FluidHelper {
    private static final int FUEL = 0;
    private static final int WASTE = 1;
    private static final String[] tankNames = new String[]{"fuel", "waste"};
    private float radiationFuelUsage = 0.0f;

    public FuelContainer() {
        super(false);
    }

    public static boolean isAcceptedFuel(Fluid fuelType) {
        if (fuelType == null) {
            return false;
        }
        return BRRegistry.getReactorFluidInfo(fuelType.getName()) != null;
    }

    public static boolean isAcceptedWaste(Fluid wasteType) {
        if (wasteType == null) {
            return false;
        }
        return BRRegistry.getReactorFluidInfo(wasteType.getName()) != null;
    }

    public int getFuelAmount() {
        return this.getFluidAmount(0);
    }

    public int getWasteAmount() {
        return this.getFluidAmount(1);
    }

    public boolean canAddFuel(FluidStack incoming) {
        return this.canAddToStack(0, incoming);
    }

    public boolean canAddWaste(FluidStack incoming) {
        return this.canAddToStack(1, incoming);
    }

    public int addFuel(FluidStack incoming) {
        if (incoming == null) {
            return 0;
        }
        return this.fill(0, incoming, true);
    }

    public int addWaste(FluidStack incoming) {
        if (incoming == null) {
            return 0;
        }
        return this.fill(1, incoming, true);
    }

    private int addWaste(int wasteAmt) {
        if (this.getWasteType() == null) {
            BRLog.warning("System is using addWaste(int) when there's no waste present, defaulting to cyanite", new Object[0]);
            return this.fill(1, new FluidStack(BigReactors.fluidCyanite, wasteAmt), true);
        }
        return this.addFluidToStack(1, wasteAmt);
    }

    public int drainFuel(int amount) {
        return this.drainFluidFromStack(0, amount);
    }

    public int drainFuel(Fluid fuel, int amount) {
        return this.drainFluidFromStack(0, fuel, amount);
    }

    public int drainWaste(int amount) {
        return this.drainFluidFromStack(1, amount);
    }

    public int drainWaste(Fluid waste, int amount) {
        return this.drainFluidFromStack(1, waste, amount);
    }

    public Fluid getFuelType() {
        return this.getFluidType(0);
    }

    public Fluid getWasteType() {
        return this.getFluidType(1);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound destination) {
        super.writeToNBT(destination);
        destination.func_74776_a("fuelUsage", this.radiationFuelUsage);
        return destination;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b("fuelUsage")) {
            this.radiationFuelUsage = data.func_74760_g("fuelUsage");
        }
    }

    public void emptyFuel() {
        this.setFluid(0, null);
    }

    public void emptyWaste() {
        this.setFluid(1, null);
    }

    public void setFuel(FluidStack newFuel) {
        this.setFluid(0, newFuel);
    }

    public void setWaste(FluidStack newWaste) {
        this.setFluid(1, newWaste);
    }

    public void merge(FuelContainer other) {
        this.radiationFuelUsage = Math.max(this.radiationFuelUsage, other.radiationFuelUsage);
        super.merge(other);
    }

    public void onRadiationUsesFuel(float fuelUsed) {
        if (Float.isInfinite(fuelUsed) || Float.isNaN(fuelUsed)) {
            return;
        }
        this.radiationFuelUsage += fuelUsed;
        if (this.radiationFuelUsage < 1.0f) {
            return;
        }
        int fuelToConvert = Math.min(this.getFuelAmount(), (int)this.radiationFuelUsage);
        if (fuelToConvert <= 0) {
            return;
        }
        this.radiationFuelUsage = Math.max(0.0f, this.radiationFuelUsage - (float)fuelToConvert);
        Fluid fuelType = this.getFuelType();
        if (fuelType != null) {
            this.drainFuel(fuelToConvert);
            if (this.getWasteType() != null) {
                this.addWaste(fuelToConvert);
            } else {
                IReactorFuel fuelData = BRRegistry.getReactorFluidInfo(fuelType.getName());
                Fluid wasteFluid = null;
                if (fuelData != null) {
                    wasteFluid = fuelData.getProductFluid();
                }
                if (wasteFluid == null) {
                    BRLog.warning("Unable to locate waste for fuel type " + fuelType.getName() + "; using cyanite instead", new Object[0]);
                    wasteFluid = BigReactors.fluidCyanite;
                }
                this.addWaste(new FluidStack(wasteFluid, fuelToConvert));
            }
        } else {
            BRLog.warning("Attempting to use %d fuel and there's no fuel in the tank", fuelToConvert);
        }
    }

    public float getFuelReactivity() {
        return 1.05f;
    }

    @Override
    public int getNumberOfFluidTanks() {
        return 2;
    }

    @Override
    protected String[] getNBTTankNames() {
        return tankNames;
    }

    @Override
    protected boolean isFluidValidForStack(int stackIdx, Fluid fluid) {
        switch (stackIdx) {
            case 0: {
                return FuelContainer.isAcceptedFuel(fluid);
            }
            case 1: {
                return FuelContainer.isAcceptedWaste(fluid);
            }
        }
        return false;
    }
}

