/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import erogenousbeef.bigreactors.common.BRLoader;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.multiblock.interfaces.INeighborUpdatableEntity;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorAccessPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorComputerPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorCoolantPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPowerTap;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorRedNetPort;
import erogenousbeef.bigreactors.utils.StaticUtils;
import erogenousbeef.core.multiblock.IMultiblockPart;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import erogenousbeef.core.multiblock.MultiblockValidationException;
import java.util.List;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.minefactoryreloaded.api.rednet.IConnectableRedNet;
import powercrystals.minefactoryreloaded.api.rednet.RedNetConnectionType;

public class BlockReactorPart
extends BlockContainer
implements IConnectableRedNet,
IPeripheralProvider {
    public static final int CASING_METADATA_BASE = 0;
    public static final int CASING_CORNER = 1;
    public static final int CASING_CENTER = 2;
    public static final int CASING_VERTICAL = 3;
    public static final int CASING_EASTWEST = 4;
    public static final int CASING_NORTHSOUTH = 5;
    public static final int CONTROLLER_METADATA_BASE = 6;
    public static final int CONTROLLER_IDLE = 7;
    public static final int CONTROLLER_ACTIVE = 8;
    public static final int POWERTAP_METADATA_BASE = 9;
    public static final int ACCESSPORT_INLET = 11;
    public static final int ACCESSPORT_OUTLET = 12;
    public static final int REDNETPORT = 13;
    public static final int COMPUTERPORT = 14;
    public static final int COOLANTPORT = 15;
    private static String[] _subBlocks = new String[]{"casingDefault", "casingCorner", "casingCenter", "casingVertical", "casingEastWest", "casingNorthSouth", "controllerInactive", "controllerIdle", "controllerActive", "powerTapDisconnected", "powerTapConnected", "accessInlet", "accessOutlet", "redNetPort", "computerPort", "coolantPort"};
    protected static final int SUBICON_COOLANT_OUTLET = 0;
    private static String[] _subIconNames = new String[]{"coolantPort.outlet"};
    private Icon[] _icons = new Icon[_subBlocks.length];
    private Icon[] _redNetPortConfigIcons = new Icon[TileEntityReactorRedNetPort.CircuitType.values().length - 1];
    private Icon[] _subIcons = new Icon[_subIconNames.length];

    public static boolean isCasing(int metadata) {
        return metadata >= 0 && metadata < 6;
    }

    public static boolean isController(int metadata) {
        return metadata >= 6 && metadata < 9;
    }

    public static boolean isPowerTap(int metadata) {
        return metadata >= 9 && metadata < 11;
    }

    public static boolean isAccessPort(int metadata) {
        return metadata >= 11 && metadata < 13;
    }

    public static boolean isRedNetPort(int metadata) {
        return metadata == 13;
    }

    public static boolean isComputerPort(int metadata) {
        return metadata == 14;
    }

    public static boolean isCoolantPort(int metadata) {
        return metadata == 15;
    }

    public BlockReactorPart(int id, Material material) {
        super(id, material);
        this.func_71884_a(field_71977_i);
        this.func_71848_c(4.0f);
        this.func_71864_b("blockReactorPart");
        this.func_111022_d("bigreactors:blockReactorPart");
        this.func_71849_a(BigReactors.TAB);
    }

    public Icon func_71895_b(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntity te;
        int metadata = blockAccess.func_72805_g(x, y, z);
        if (BlockReactorPart.isCoolantPort(metadata) && (te = blockAccess.func_72796_p(x, y, z)) instanceof TileEntityReactorCoolantPort) {
            TileEntityReactorCoolantPort cp = (TileEntityReactorCoolantPort)te;
            if (cp.isConnected() && cp.getReactorController().isAssembled()) {
                if (cp.getOutwardsDir().ordinal() == side) {
                    if (cp.isInlet()) {
                        return this._icons[metadata];
                    }
                    return this._subIcons[0];
                }
                return this._icons[0];
            }
            if (side == 0 || side == 1) {
                return this._icons[0];
            }
            if (cp.isInlet()) {
                return this._icons[metadata];
            }
            return this._subIcons[0];
        }
        return this.func_71858_a(side, metadata);
    }

    public Icon func_71858_a(int side, int metadata) {
        switch (metadata) {
            case 0: 
            case 1: 
            case 2: {
                return this._icons[metadata];
            }
            case 3: {
                if (side == 0 || side == 1) {
                    return this._icons[0];
                }
                return this._icons[metadata];
            }
            case 4: {
                if (side == 4 || side == 5) {
                    return this._icons[0];
                }
                return this._icons[metadata];
            }
            case 5: {
                if (side == 2 || side == 3) {
                    return this._icons[0];
                }
                if (side == 4 || side == 5) {
                    return this._icons[4];
                }
                return this._icons[metadata];
            }
        }
        if (side == 0 || side == 1) {
            return this._icons[0];
        }
        metadata = Math.max(0, Math.min(15, metadata));
        return this._icons[metadata];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        int i;
        this.field_94336_cN = par1IconRegister.func_94245_a("bigreactors:" + this.func_71917_a());
        for (i = 0; i < _subBlocks.length; ++i) {
            this._icons[i] = par1IconRegister.func_94245_a("bigreactors:" + this.func_71917_a() + "." + _subBlocks[i]);
        }
        for (i = 0; i < _subIconNames.length; ++i) {
            this._subIcons[i] = par1IconRegister.func_94245_a("bigreactors:" + this.func_71917_a() + "." + _subIconNames[i]);
        }
        TileEntityReactorRedNetPort.CircuitType[] circuitTypes = TileEntityReactorRedNetPort.CircuitType.values();
        for (int i2 = 1; i2 < circuitTypes.length; ++i2) {
            this._redNetPortConfigIcons[i2 - 1] = par1IconRegister.func_94245_a("bigreactors:redNet/" + circuitTypes[i2].name());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getRedNetConfigIcon(TileEntityReactorRedNetPort.CircuitType circuitType) {
        if (circuitType == TileEntityReactorRedNetPort.CircuitType.DISABLED) {
            return null;
        }
        return this._redNetPortConfigIcons[circuitType.ordinal() - 1];
    }

    public TileEntity func_72274_a(World world) {
        return null;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (BlockReactorPart.isPowerTap(metadata)) {
            return new TileEntityReactorPowerTap();
        }
        if (BlockReactorPart.isAccessPort(metadata)) {
            return new TileEntityReactorAccessPort();
        }
        if (BlockReactorPart.isRedNetPort(metadata)) {
            return new TileEntityReactorRedNetPort();
        }
        if (BlockReactorPart.isComputerPort(metadata)) {
            return new TileEntityReactorComputerPort();
        }
        if (BlockReactorPart.isCoolantPort(metadata)) {
            return new TileEntityReactorCoolantPort();
        }
        return new TileEntityReactorPart();
    }

    public void func_71863_a(World world, int x, int y, int z, int neighborBlockID) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof INeighborUpdatableEntity) {
            ((INeighborUpdatableEntity)te).onNeighborBlockChange(world, x, y, z, neighborBlockID);
        }
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (player.func_70093_af()) {
            return false;
        }
        int metadata = world.func_72805_g(x, y, z);
        if (!(BlockReactorPart.isController(metadata) || BlockReactorPart.isAccessPort(metadata) || BlockReactorPart.isRedNetPort(metadata))) {
            if (!world.field_72995_K) {
                TileEntity te;
                ItemStack currentEquippedItem = player.func_71045_bC();
                if (BlockReactorPart.isCoolantPort(metadata) && (StaticUtils.Inventory.isPlayerHoldingWrench(player) || currentEquippedItem == null)) {
                    TileEntity te2 = world.func_72796_p(x, y, z);
                    if (te2 instanceof TileEntityReactorCoolantPort) {
                        TileEntityReactorCoolantPort cp;
                        cp.setInlet(!(cp = (TileEntityReactorCoolantPort)te2).isInlet());
                        return true;
                    }
                } else if (currentEquippedItem == null && (te = world.func_72796_p(x, y, z)) instanceof IMultiblockPart) {
                    MultiblockControllerBase controller = ((IMultiblockPart)te).getMultiblockController();
                    if (controller != null) {
                        MultiblockValidationException e = controller.getLastValidationException();
                        if (e != null) {
                            player.func_70006_a(ChatMessageComponent.func_111066_d((String)e.getMessage()));
                            return true;
                        }
                    } else {
                        player.func_70006_a(ChatMessageComponent.func_111066_d((String)"Block is not connected to a reactor. This could be due to lag, or a bug. If the problem persists, try breaking and re-placing the block."));
                        return true;
                    }
                }
            }
            return false;
        }
        if (metadata == 6) {
            return false;
        }
        if (!world.field_72995_K) {
            player.openGui((Object)BRLoader.instance, 0, world, x, y, z);
        }
        return true;
    }

    public boolean func_71926_d() {
        return true;
    }

    public boolean func_71886_c() {
        return true;
    }

    public int func_71899_b(int metadata) {
        if (BlockReactorPart.isCasing(metadata)) {
            return 0;
        }
        if (BlockReactorPart.isController(metadata)) {
            return 6;
        }
        if (BlockReactorPart.isPowerTap(metadata)) {
            return 9;
        }
        if (BlockReactorPart.isAccessPort(metadata)) {
            return 11;
        }
        if (BlockReactorPart.isRedNetPort(metadata)) {
            return 13;
        }
        if (BlockReactorPart.isComputerPort(metadata)) {
            return 14;
        }
        if (BlockReactorPart.isCoolantPort(metadata)) {
            return 15;
        }
        return 0;
    }

    public ItemStack getReactorCasingItemStack() {
        return new ItemStack(this.field_71990_ca, 1, 0);
    }

    public ItemStack getReactorControllerItemStack() {
        return new ItemStack(this.field_71990_ca, 1, 6);
    }

    public ItemStack getReactorPowerTapItemStack() {
        return new ItemStack(this.field_71990_ca, 1, 9);
    }

    public ItemStack getAccessPortItemStack() {
        return new ItemStack(this.field_71990_ca, 1, 11);
    }

    public ItemStack getRedNetPortItemStack() {
        return new ItemStack(this.field_71990_ca, 1, 13);
    }

    public ItemStack getComputerPortItemStack() {
        return new ItemStack(this.field_71990_ca, 1, 14);
    }

    public ItemStack getCoolantPortItemStack() {
        return new ItemStack(this.field_71990_ca, 1, 15);
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(this.getReactorCasingItemStack());
        par3List.add(this.getReactorControllerItemStack());
        par3List.add(this.getReactorPowerTapItemStack());
        par3List.add(this.getAccessPortItemStack());
        par3List.add(this.getRedNetPortItemStack());
        par3List.add(this.getComputerPortItemStack());
        par3List.add(this.getCoolantPortItemStack());
    }

    public void func_71852_a(World world, int x, int y, int z, int blockId, int meta) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof IInventory) {
            IInventory inventory = (IInventory)te;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack itemstack = inventory.func_70301_a(i);
                if (itemstack == null) continue;
                float xOffset = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float yOffset = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float zOffset = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int amountToDrop = world.field_73012_v.nextInt(21) + 10;
                    if (amountToDrop > itemstack.field_77994_a) {
                        amountToDrop = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= amountToDrop;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + xOffset), (double)((float)y + yOffset), (double)((float)z + zOffset), new ItemStack(itemstack.field_77993_c, amountToDrop, itemstack.func_77960_j()));
                    if (itemstack.func_77978_p() != null) {
                        entityitem.func_92059_d().func_77982_d(itemstack.func_77978_p());
                    }
                    float motionMultiplier = 0.05f;
                    entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * motionMultiplier;
                    entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * motionMultiplier + 0.2f;
                    entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * motionMultiplier;
                    world.func_72838_d((Entity)entityitem);
                }
            }
        }
        super.func_71852_a(world, x, y, z, blockId, meta);
    }

    @Override
    public RedNetConnectionType getConnectionType(World world, int x, int y, int z, ForgeDirection side) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityReactorRedNetPort) {
            return RedNetConnectionType.CableAll;
        }
        return RedNetConnectionType.None;
    }

    @Override
    public int[] getOutputValues(World world, int x, int y, int z, ForgeDirection side) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityReactorRedNetPort) {
            return ((TileEntityReactorRedNetPort)te).getOutputValues();
        }
        int[] values = new int[16];
        for (int i = 0; i < 16; ++i) {
            values[i] = 0;
        }
        return values;
    }

    @Override
    public int getOutputValue(World world, int x, int y, int z, ForgeDirection side, int subnet) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityReactorRedNetPort) {
            return ((TileEntityReactorRedNetPort)te).getValueForChannel(subnet);
        }
        return 0;
    }

    @Override
    public void onInputsChanged(World world, int x, int y, int z, ForgeDirection side, int[] inputValues) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityReactorRedNetPort) {
            ((TileEntityReactorRedNetPort)te).onInputValuesChanged(inputValues);
        }
    }

    @Override
    public void onInputChanged(World world, int x, int y, int z, ForgeDirection side, int inputValue) {
    }

    @Override
    public IPeripheral getPeripheral(World world, int x, int y, int z, int side) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityReactorComputerPort) {
            return (IPeripheral)te;
        }
        return null;
    }
}

