/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorGlass;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePartGlass;
import erogenousbeef.bigreactors.utils.StaticUtils;
import erogenousbeef.core.multiblock.IMultiblockPart;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import erogenousbeef.core.multiblock.MultiblockValidationException;
import java.util.List;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockMultiblockGlass
extends BlockContainer {
    public static final int METADATA_REACTOR = 0;
    public static final int METADATA_TURBINE = 1;
    private static String[] subBlocks = new String[]{"reactor", "turbine"};
    private Icon[][] icons = new Icon[subBlocks.length][16];
    private Icon transparentIcon;

    public BlockMultiblockGlass(int par1, Material par2Material) {
        super(par1, par2Material);
        this.func_71884_a(field_71974_j);
        this.func_71848_c(4.0f);
        this.func_71864_b("multiblockGlass");
        this.func_111022_d("bigreactors:multiblockGlass");
        this.func_71849_a(BigReactors.TAB);
    }

    public TileEntity func_72274_a(World world) {
        return null;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new TileEntityReactorGlass();
            }
            case 1: {
                return new TileEntityTurbinePartGlass();
            }
        }
        throw new IllegalArgumentException("Unrecognized metadata");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        this.transparentIcon = par1IconRegister.func_94245_a("bigreactors:" + this.func_71917_a() + ".transparent");
        for (int metadata = 0; metadata < subBlocks.length; ++metadata) {
            for (int i = 0; i < 16; ++i) {
                this.icons[metadata][i] = par1IconRegister.func_94245_a("bigreactors:" + this.func_71917_a() + "." + subBlocks[metadata] + "." + Integer.toString(i));
            }
        }
    }

    public Icon func_71895_b(IBlockAccess blockAccess, int x, int y, int z, int side) {
        ForgeDirection[] dirsToCheck = StaticUtils.neighborsBySide[side];
        int myBlockId = blockAccess.func_72798_a(x, y, z);
        int myBlockMetadata = blockAccess.func_72805_g(x, y, z);
        ForgeDirection out = ForgeDirection.getOrientation((int)side);
        if (blockAccess.func_72798_a(x + out.offsetX, y + out.offsetY, z + out.offsetZ) == myBlockId && blockAccess.func_72805_g(x + out.offsetX, y + out.offsetY, z + out.offsetZ) == myBlockMetadata) {
            return this.transparentIcon;
        }
        int iconIdx = 0;
        for (int i = 0; i < dirsToCheck.length; ++i) {
            ForgeDirection dir = dirsToCheck[i];
            if (blockAccess.func_72798_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ) != myBlockId || blockAccess.func_72805_g(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ) != myBlockMetadata) continue;
            iconIdx |= 1 << i;
        }
        return this.icons[myBlockMetadata][iconIdx];
    }

    public Icon func_71858_a(int side, int metadata) {
        return this.icons[metadata][0];
    }

    public boolean func_71926_d() {
        return false;
    }

    public int func_71899_b(int metadata) {
        return metadata;
    }

    public ItemStack getItemStack(String name) {
        int metadata = -1;
        for (int i = 0; i < subBlocks.length; ++i) {
            if (!subBlocks[i].equals(name)) continue;
            metadata = i;
            break;
        }
        if (metadata < 0) {
            throw new IllegalArgumentException("Unable to find a block with the name " + name);
        }
        return new ItemStack(this.field_71990_ca, 1, metadata);
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < subBlocks.length; ++i) {
            par3List.add(new ItemStack(this.field_71990_ca, 1, i));
        }
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        TileEntity te;
        if (player.func_70093_af()) {
            return false;
        }
        if (!world.field_72995_K && player.func_71045_bC() == null && (te = world.func_72796_p(x, y, z)) instanceof IMultiblockPart) {
            MultiblockControllerBase controller = ((IMultiblockPart)te).getMultiblockController();
            if (controller == null) {
                player.func_70006_a(ChatMessageComponent.func_111066_d((String)String.format("SERIOUS ERROR - server part @ %d, %d, %d has no controller!", x, y, z)));
            } else {
                MultiblockValidationException e = controller.getLastValidationException();
                if (e != null) {
                    player.func_70006_a(ChatMessageComponent.func_111066_d((String)e.getMessage()));
                    return true;
                }
            }
        }
        return false;
    }
}

