/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock;

import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.BRRegistry;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.data.RadiationData;
import erogenousbeef.bigreactors.common.interfaces.IMultipleFluidHandler;
import erogenousbeef.bigreactors.common.interfaces.IReactorFuelInfo;
import erogenousbeef.bigreactors.common.multiblock.block.BlockReactorPart;
import erogenousbeef.bigreactors.common.multiblock.helpers.CoolantContainer;
import erogenousbeef.bigreactors.common.multiblock.helpers.FuelContainer;
import erogenousbeef.bigreactors.common.multiblock.helpers.RadiationHelper;
import erogenousbeef.bigreactors.common.multiblock.interfaces.ITickableMultiblockPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorAccessPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorControlRod;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorCoolantPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorFuelRod;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPowerTap;
import erogenousbeef.bigreactors.net.PacketWrapper;
import erogenousbeef.bigreactors.utils.StaticUtils;
import erogenousbeef.core.common.CoordTriplet;
import erogenousbeef.core.multiblock.IMultiblockPart;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import erogenousbeef.core.multiblock.MultiblockValidationException;
import erogenousbeef.core.multiblock.rectangular.RectangularMultiblockControllerBase;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.oredict.OreDictionary;

public class MultiblockReactor
extends RectangularMultiblockControllerBase
implements IEnergyHandler,
IReactorFuelInfo,
IMultipleFluidHandler {
    public static final int AmountPerIngot = 1000;
    public static final int FuelCapacityPerFuelRod = 4000;
    public static final int FLUID_SUPERHEATED = 0;
    public static final int FLUID_COOLANT = 1;
    private static final float passiveCoolingPowerEfficiency = 0.5f;
    private static final float passiveCoolingTransferEfficiency = 0.2f;
    private static final float reactorHeatLossConductivity = 0.001f;
    protected boolean active = false;
    private float reactorHeat = 0.0f;
    private float fuelHeat = 0.0f;
    private WasteEjectionSetting wasteEjection = WasteEjectionSetting.kAutomatic;
    private float energyStored = 0.0f;
    protected FuelContainer fuelContainer;
    protected RadiationHelper radiationHelper;
    protected CoolantContainer coolantContainer;
    protected float fuelToReactorHeatTransferCoefficient = 0.0f;
    protected float reactorToCoolantSystemHeatTransferCoefficient = 0.0f;
    protected float reactorHeatLossCoefficient = 0.0f;
    protected Iterator<TileEntityReactorFuelRod> currentFuelRod = null;
    int reactorVolume = 0;
    private float energyGeneratedLastTick = 0.0f;
    private float fuelConsumedLastTick = 0.0f;
    private Set<TileEntityReactorPowerTap> attachedPowerTaps = new HashSet<TileEntityReactorPowerTap>();
    private Set<ITickableMultiblockPart> attachedTickables = new HashSet<ITickableMultiblockPart>();
    private Set<TileEntityReactorControlRod> attachedControlRods = new HashSet<TileEntityReactorControlRod>();
    private Set<TileEntityReactorAccessPort> attachedAccessPorts = new HashSet<TileEntityReactorAccessPort>();
    private Set<TileEntityReactorPart> attachedControllers = new HashSet<TileEntityReactorPart>();
    private Set<TileEntityReactorFuelRod> attachedFuelRods = new HashSet<TileEntityReactorFuelRod>();
    private Set<TileEntityReactorCoolantPort> attachedCoolantPorts = new HashSet<TileEntityReactorCoolantPort>();
    private Set<EntityPlayer> updatePlayers = new HashSet<EntityPlayer>();
    private int ticksSinceLastUpdate = 0;
    private static final int ticksBetweenUpdates = 3;
    private static final int maxEnergyStored = 10000000;
    private static final FluidTankInfo[] emptyTankInfo = new FluidTankInfo[0];

    public MultiblockReactor(World world) {
        super(world);
        this.fuelContainer = new FuelContainer();
        this.radiationHelper = new RadiationHelper();
        this.coolantContainer = new CoolantContainer();
    }

    public void beginUpdatingPlayer(EntityPlayer playerToUpdate) {
        this.updatePlayers.add(playerToUpdate);
        this.sendIndividualUpdate(playerToUpdate);
    }

    public void stopUpdatingPlayer(EntityPlayer playerToRemove) {
        this.updatePlayers.remove(playerToRemove);
    }

    @Override
    protected void onBlockAdded(IMultiblockPart part) {
        TileEntityReactorPart reactorPart;
        if (part instanceof TileEntityReactorAccessPort) {
            this.attachedAccessPorts.add((TileEntityReactorAccessPort)part);
        }
        if (part instanceof TileEntityReactorControlRod) {
            TileEntityReactorControlRod controlRod = (TileEntityReactorControlRod)part;
            this.attachedControlRods.add(controlRod);
            if (controlRod.getCachedFuel() != null) {
                this.fuelContainer.addFuel(controlRod.getCachedFuel());
                this.worldObj.func_72944_b(controlRod.field_70329_l, controlRod.field_70330_m, controlRod.field_70327_n, (TileEntity)controlRod);
            }
        }
        if (part instanceof TileEntityReactorPowerTap) {
            this.attachedPowerTaps.add((TileEntityReactorPowerTap)part);
        }
        if (part instanceof TileEntityReactorPart && BlockReactorPart.isController((reactorPart = (TileEntityReactorPart)part).func_70322_n())) {
            this.attachedControllers.add(reactorPart);
        }
        if (part instanceof ITickableMultiblockPart) {
            this.attachedTickables.add((ITickableMultiblockPart)((Object)part));
        }
        if (part instanceof TileEntityReactorFuelRod) {
            TileEntityReactorFuelRod fuelRod = (TileEntityReactorFuelRod)part;
            this.attachedFuelRods.add(fuelRod);
            this.currentFuelRod = this.attachedFuelRods.iterator();
            if (this.worldObj.field_72995_K) {
                this.worldObj.func_72845_h(fuelRod.field_70329_l, fuelRod.field_70330_m, fuelRod.field_70327_n);
            }
        }
        if (part instanceof TileEntityReactorCoolantPort) {
            this.attachedCoolantPorts.add((TileEntityReactorCoolantPort)part);
        }
    }

    @Override
    protected void onBlockRemoved(IMultiblockPart part) {
        TileEntityReactorPart reactorPart;
        if (part instanceof TileEntityReactorAccessPort) {
            this.attachedAccessPorts.remove((TileEntityReactorAccessPort)part);
        }
        if (part instanceof TileEntityReactorControlRod) {
            this.attachedControlRods.remove((TileEntityReactorControlRod)part);
        }
        if (part instanceof TileEntityReactorPowerTap) {
            this.attachedPowerTaps.remove((TileEntityReactorPowerTap)part);
        }
        if (part instanceof TileEntityReactorPart && BlockReactorPart.isController((reactorPart = (TileEntityReactorPart)part).func_70322_n())) {
            this.attachedControllers.remove(reactorPart);
        }
        if (part instanceof ITickableMultiblockPart) {
            this.attachedTickables.remove((ITickableMultiblockPart)((Object)part));
        }
        if (part instanceof TileEntityReactorFuelRod) {
            this.attachedFuelRods.remove((Object)part);
            this.currentFuelRod = this.attachedFuelRods.iterator();
        }
        if (part instanceof TileEntityReactorCoolantPort) {
            this.attachedCoolantPorts.remove((TileEntityReactorCoolantPort)part);
        }
    }

    @Override
    protected void isMachineWhole() throws MultiblockValidationException {
        if (this.attachedControlRods.size() < 1) {
            throw new MultiblockValidationException("Not enough control rods. Reactors require at least 1.");
        }
        if (this.attachedControllers.size() < 1) {
            throw new MultiblockValidationException("Not enough controllers. Reactors require at least 1.");
        }
        super.isMachineWhole();
    }

    @Override
    public void updateClient() {
    }

    @Override
    public boolean updateServer() {
        int energyAvailable;
        if (Float.isNaN(this.getReactorHeat())) {
            this.setReactorHeat(0.0f);
        }
        float oldHeat = this.getReactorHeat();
        float oldEnergy = this.getEnergyStored();
        this.energyGeneratedLastTick = 0.0f;
        this.fuelConsumedLastTick = 0.0f;
        float newHeat = 0.0f;
        if (this.isActive()) {
            RadiationData radData;
            if (!this.currentFuelRod.hasNext()) {
                this.currentFuelRod = this.attachedFuelRods.iterator();
            }
            TileEntityReactorFuelRod source = this.currentFuelRod.next();
            TileEntityReactorControlRod sourceControlRod = (TileEntityReactorControlRod)this.worldObj.func_72796_p(source.field_70329_l, this.getMaximumCoord().y, source.field_70327_n);
            if (source != null && sourceControlRod != null && (radData = this.radiationHelper.radiate(this.worldObj, this.fuelContainer, source, sourceControlRod, this.getFuelHeat(), this.getReactorHeat(), this.attachedControlRods.size())) != null) {
                this.addFuelHeat(radData.getFuelHeatChange(this.attachedFuelRods.size()));
                this.addReactorHeat(radData.getEnvironmentHeatChange(this.getReactorVolume()));
                this.fuelConsumedLastTick += radData.fuelUsage;
            }
        }
        this.radiationHelper.tick(this.isActive());
        if (this.wasteEjection == WasteEjectionSetting.kAutomatic) {
            this.ejectWaste(false, null);
        }
        this.refuel();
        float tempDiff = this.fuelHeat - this.reactorHeat;
        if (tempDiff > 0.01f) {
            float rfTransferred = tempDiff * this.fuelToReactorHeatTransferCoefficient;
            float fuelRf = StaticUtils.Energy.getRFFromVolumeAndTemp(this.attachedFuelRods.size(), this.fuelHeat);
            this.setFuelHeat(StaticUtils.Energy.getTempFromVolumeAndRF(this.attachedFuelRods.size(), fuelRf -= rfTransferred));
            float reactorRf = StaticUtils.Energy.getRFFromVolumeAndTemp(this.getReactorVolume(), this.getReactorHeat());
            this.setReactorHeat(StaticUtils.Energy.getTempFromVolumeAndRF(this.getReactorVolume(), reactorRf += rfTransferred));
        }
        if ((tempDiff = this.getReactorHeat() - this.getCoolantTemperature()) > 0.01f) {
            float rfTransferred = tempDiff * this.reactorToCoolantSystemHeatTransferCoefficient;
            float reactorRf = StaticUtils.Energy.getRFFromVolumeAndTemp(this.getReactorVolume(), this.getReactorHeat());
            if (this.isPassivelyCooled()) {
                this.generateEnergy((rfTransferred *= 0.2f) * 0.5f);
            } else {
                rfTransferred -= this.coolantContainer.onAbsorbHeat(rfTransferred);
                this.energyGeneratedLastTick = this.coolantContainer.getFluidVaporizedLastTick();
            }
            this.setReactorHeat(StaticUtils.Energy.getTempFromVolumeAndRF(this.getReactorVolume(), reactorRf -= rfTransferred));
        }
        if ((tempDiff = this.getReactorHeat() - this.getPassiveCoolantTemperature()) > 1.0E-6f) {
            float rfLost = Math.max(1.0f, tempDiff * this.reactorHeatLossCoefficient);
            float reactorNewRf = Math.max(0.0f, StaticUtils.Energy.getRFFromVolumeAndTemp(this.getReactorVolume(), this.getReactorHeat()) - rfLost);
            this.setReactorHeat(StaticUtils.Energy.getTempFromVolumeAndRF(this.getReactorVolume(), reactorNewRf));
        }
        if (this.reactorHeat < 0.0f) {
            this.setReactorHeat(0.0f);
        }
        if (this.fuelHeat < 0.0f) {
            this.setFuelHeat(0.0f);
        }
        int energyRemaining = energyAvailable = (int)this.getEnergyStored();
        if (this.attachedPowerTaps.size() > 0 && energyRemaining > 0) {
            int splitEnergy = energyRemaining / this.attachedPowerTaps.size();
            for (TileEntityReactorPowerTap powerTap : this.attachedPowerTaps) {
                if (energyRemaining <= 0) break;
                if (powerTap == null || !powerTap.isConnected()) continue;
                energyRemaining -= splitEnergy - powerTap.onProvidePower(splitEnergy);
            }
            if (energyRemaining > 0) {
                for (TileEntityReactorPowerTap powerTap : this.attachedPowerTaps) {
                    if (energyRemaining <= 0) break;
                    if (powerTap == null || !powerTap.isConnected()) continue;
                    energyRemaining = powerTap.onProvidePower(energyRemaining);
                }
            }
        }
        if (energyAvailable != energyRemaining) {
            this.reduceStoredEnergy(energyAvailable - energyRemaining);
        }
        ++this.ticksSinceLastUpdate;
        if (this.ticksSinceLastUpdate >= 3) {
            this.ticksSinceLastUpdate = 0;
            this.sendTickUpdate();
        }
        for (ITickableMultiblockPart tickable : this.attachedTickables) {
            if (tickable == null) continue;
            tickable.onMultiblockServerTick();
        }
        if (this.fuelContainer.shouldSendFuelingUpdate() || this.coolantContainer.shouldSendFuelingUpdate()) {
            this.markReferenceCoordForUpdate();
        }
        return oldHeat != this.getReactorHeat() || oldEnergy != this.getEnergyStored();
    }

    public void setStoredEnergy(float oldEnergy) {
        this.energyStored = oldEnergy;
        if ((double)this.energyStored < 0.0 || Float.isNaN(this.energyStored)) {
            this.energyStored = 0.0f;
        } else if (this.energyStored > 1.0E7f) {
            this.energyStored = 1.0E7f;
        }
    }

    protected void generateEnergy(float newEnergy) {
        this.energyGeneratedLastTick += newEnergy * BigReactors.powerProductionMultiplier;
        this.addStoredEnergy(newEnergy * BigReactors.powerProductionMultiplier);
    }

    protected void addStoredEnergy(float newEnergy) {
        if (Float.isNaN(newEnergy)) {
            return;
        }
        this.energyStored += newEnergy;
        if (this.energyStored > 1.0E7f) {
            this.energyStored = 1.0E7f;
        }
        if (-1.0E-5f < this.energyStored && this.energyStored < 1.0E-5f) {
            this.energyStored = 0.0f;
        }
    }

    protected void reduceStoredEnergy(float energy) {
        this.addStoredEnergy(-1.0f * energy);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean act) {
        if (act == this.active) {
            return;
        }
        this.active = act;
        for (IMultiblockPart part : this.connectedParts) {
            if (this.active) {
                part.onMachineActivated();
                continue;
            }
            part.onMachineDeactivated();
        }
    }

    protected void addReactorHeat(float newCasingHeat) {
        if (Float.isNaN(newCasingHeat)) {
            return;
        }
        this.reactorHeat += newCasingHeat;
        if (-1.0E-5f < this.reactorHeat && this.reactorHeat < 1.0E-5f) {
            this.reactorHeat = 0.0f;
        }
    }

    public float getReactorHeat() {
        return this.reactorHeat;
    }

    public void setReactorHeat(float newHeat) {
        this.reactorHeat = Float.isNaN(newHeat) ? 0.0f : newHeat;
    }

    protected void addFuelHeat(float additionalHeat) {
        if (Float.isNaN(additionalHeat)) {
            return;
        }
        this.fuelHeat += additionalHeat;
        if (-1.0E-5f < this.fuelHeat & this.fuelHeat < 1.0E-5f) {
            this.fuelHeat = 0.0f;
        }
    }

    public float getFuelHeat() {
        return this.fuelHeat;
    }

    public void setFuelHeat(float newFuelHeat) {
        this.fuelHeat = Float.isNaN(newFuelHeat) ? 0.0f : newFuelHeat;
    }

    @Override
    public int getFuelRodCount() {
        return this.attachedControlRods.size();
    }

    @Override
    protected void isBlockGoodForInterior(World world, int x, int y, int z) throws MultiblockValidationException {
        if (world.func_72799_c(x, y, z)) {
            return;
        }
        Material material = world.func_72803_f(x, y, z);
        if (material == MaterialLiquid.field_76244_g) {
            return;
        }
        int blockId = world.func_72798_a(x, y, z);
        if (blockId == Block.field_72083_ai.field_71990_ca || blockId == Block.field_72105_ah.field_71990_ca || blockId == Block.field_72071_ax.field_71990_ca || blockId == Block.field_72076_bV.field_71990_ca) {
            return;
        }
        int metadata = world.func_72805_g(x, y, z);
        int oreId = OreDictionary.getOreID((ItemStack)new ItemStack(blockId, 1, metadata));
        if (oreId >= 0 && BRRegistry.getReactorInteriorBlockData(OreDictionary.getOreName((int)oreId)) != null) {
            return;
        }
        if (blockId > 0 && blockId < Block.field_71973_m.length) {
            Block blockClass = Block.field_71973_m[blockId];
            if (blockClass instanceof IFluidBlock) {
                Fluid fluid = ((IFluidBlock)blockClass).getFluid();
                String fluidName = fluid.getName();
                if (BRRegistry.getReactorInteriorFluidData(fluidName) != null) {
                    return;
                }
                throw new MultiblockValidationException(String.format("%d, %d, %d - The fluid %s is not valid for the reactor's interior", x, y, z, fluidName));
            }
            throw new MultiblockValidationException(String.format("%d, %d, %d - %s is not valid for the reactor's interior", x, y, z, blockClass.func_71931_t()));
        }
        throw new MultiblockValidationException(String.format("%d, %d, %d - Unrecognized block with ID %d, not valid for the reactor's interior", x, y, z, blockId));
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        data.func_74757_a("reactorActive", this.active);
        data.func_74776_a("heat", this.reactorHeat);
        data.func_74776_a("fuelHeat", this.fuelHeat);
        data.func_74776_a("storedEnergy", this.energyStored);
        data.func_74768_a("wasteEjection2", this.wasteEjection.ordinal());
        data.func_74766_a("fuelContainer", this.fuelContainer.writeToNBT(new NBTTagCompound()));
        data.func_74766_a("radiation", this.radiationHelper.writeToNBT(new NBTTagCompound()));
        data.func_74766_a("coolantContainer", this.coolantContainer.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        if (data.func_74764_b("reactorActive")) {
            this.setActive(data.func_74767_n("reactorActive"));
        }
        if (data.func_74764_b("heat")) {
            this.setReactorHeat(Math.max(this.getReactorHeat(), data.func_74760_g("heat")));
        }
        if (data.func_74764_b("storedEnergy")) {
            this.setStoredEnergy(Math.max(this.getEnergyStored(), data.func_74760_g("storedEnergy")));
        }
        if (data.func_74764_b("wasteEjection2")) {
            this.wasteEjection = WasteEjectionSetting.values()[data.func_74762_e("wasteEjection2")];
        } else if (data.func_74764_b("wasteEjection")) {
            int translatedSetting = data.func_74762_e("wasteEjection");
            translatedSetting = translatedSetting == 2 ? 1 : 0;
            this.wasteEjection = WasteEjectionSetting.values()[translatedSetting];
        }
        if (data.func_74764_b("fuelHeat")) {
            this.setFuelHeat(data.func_74760_g("fuelHeat"));
        }
        if (data.func_74764_b("fuelContainer")) {
            this.fuelContainer.readFromNBT(data.func_74775_l("fuelContainer"));
        }
        if (data.func_74764_b("radiation")) {
            this.radiationHelper.readFromNBT(data.func_74775_l("radiation"));
        }
        if (data.func_74764_b("coolantContainer")) {
            this.coolantContainer.readFromNBT(data.func_74775_l("coolantContainer"));
        }
    }

    @Override
    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return 26;
    }

    @Override
    public void formatDescriptionPacket(NBTTagCompound data) {
        data.func_74768_a("wasteEjection2", this.wasteEjection.ordinal());
        data.func_74776_a("energy", this.energyStored);
        data.func_74776_a("heat", this.reactorHeat);
        data.func_74757_a("isActive", this.isActive());
        data.func_74776_a("fuelHeat", this.fuelHeat);
        data.func_74766_a("fuelContainer", this.fuelContainer.writeToNBT(new NBTTagCompound()));
        data.func_74766_a("radiation", this.radiationHelper.writeToNBT(new NBTTagCompound()));
        data.func_74766_a("coolantContainer", this.coolantContainer.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public void decodeDescriptionPacket(NBTTagCompound data) {
        if (data.func_74764_b("wasteEjection2")) {
            this.wasteEjection = WasteEjectionSetting.values()[data.func_74762_e("wasteEjection2")];
        }
        if (data.func_74764_b("isActive")) {
            this.setActive(data.func_74767_n("isActive"));
        }
        if (data.func_74764_b("energy")) {
            this.energyStored = data.func_74760_g("energy");
        }
        if (data.func_74764_b("heat")) {
            this.setReactorHeat(data.func_74760_g("heat"));
        }
        if (data.func_74764_b("fuelHeat")) {
            this.setFuelHeat(data.func_74760_g("fuelHeat"));
        }
        if (data.func_74764_b("fuelContainer")) {
            this.fuelContainer.readFromNBT(data.func_74775_l("fuelContainer"));
        }
        if (data.func_74764_b("radiation")) {
            this.radiationHelper.readFromNBT(data.func_74775_l("radiation"));
        }
        if (data.func_74764_b("coolantContainer")) {
            this.coolantContainer.readFromNBT(data.func_74775_l("coolantContainer"));
        }
        this.onFuelStatusChanged();
    }

    protected Packet getUpdatePacket() {
        Fluid fuelType = this.fuelContainer.getFuelType();
        Fluid wasteType = this.fuelContainer.getWasteType();
        Fluid coolantType = this.coolantContainer.getCoolantType();
        Fluid vaporType = this.coolantContainer.getVaporType();
        int fuelTypeID = fuelType == null ? -1 : fuelType.getID();
        int wasteTypeID = wasteType == null ? -1 : wasteType.getID();
        int coolantTypeID = coolantType == null ? -1 : coolantType.getID();
        int vaporTypeID = vaporType == null ? -1 : vaporType.getID();
        CoordTriplet coord = this.getReferenceCoord();
        return PacketWrapper.createPacket("BigReactors", 1, new Object[]{coord.x, coord.y, coord.z, this.active, Float.valueOf(this.reactorHeat), Float.valueOf(this.energyStored), Float.valueOf(this.energyGeneratedLastTick), Float.valueOf(this.fuelConsumedLastTick), Float.valueOf(this.fuelHeat), fuelTypeID, this.fuelContainer.getFuelAmount(), wasteTypeID, this.fuelContainer.getWasteAmount(), Float.valueOf(this.radiationHelper.getFertility()), coolantTypeID, this.coolantContainer.getCoolantAmount(), vaporTypeID, this.coolantContainer.getVaporAmount()});
    }

    public void receiveReactorUpdate(DataInputStream data) throws IOException {
        boolean active = data.readBoolean();
        float heat = data.readFloat();
        float storedEnergy = data.readFloat();
        float energyGeneratedLastTick = data.readFloat();
        float fuelConsumedLastTick = data.readFloat();
        float fuelHeat = data.readFloat();
        int fuelTypeID = data.readInt();
        int fuelAmt = data.readInt();
        int wasteTypeID = data.readInt();
        int wasteAmt = data.readInt();
        float fertility = data.readFloat();
        int coolantTypeID = data.readInt();
        int coolantAmt = data.readInt();
        int vaporTypeID = data.readInt();
        int vaporAmt = data.readInt();
        this.setActive(active);
        this.setReactorHeat(heat);
        this.setStoredEnergy(storedEnergy);
        this.setEnergyGeneratedLastTick(energyGeneratedLastTick);
        this.setFuelConsumedLastTick(fuelConsumedLastTick);
        this.setFuelHeat(fuelHeat);
        this.radiationHelper.setFertility(fertility);
        if (fuelTypeID == -1) {
            this.fuelContainer.emptyFuel();
        } else {
            this.fuelContainer.setFuel(new FluidStack(FluidRegistry.getFluid((int)fuelTypeID), fuelAmt));
        }
        if (wasteTypeID == -1) {
            this.fuelContainer.emptyWaste();
        } else {
            this.fuelContainer.setWaste(new FluidStack(FluidRegistry.getFluid((int)wasteTypeID), wasteAmt));
        }
        if (coolantTypeID == -1) {
            this.coolantContainer.emptyCoolant();
        } else {
            this.coolantContainer.setCoolant(new FluidStack(FluidRegistry.getFluid((int)coolantTypeID), coolantAmt));
        }
        if (vaporTypeID == -1) {
            this.coolantContainer.emptyVapor();
        } else {
            this.coolantContainer.setVapor(new FluidStack(FluidRegistry.getFluid((int)vaporTypeID), vaporAmt));
        }
    }

    protected void sendIndividualUpdate(EntityPlayer player) {
        if (this.worldObj.field_72995_K) {
            return;
        }
        PacketDispatcher.sendPacketToPlayer((Packet)this.getUpdatePacket(), (Player)((Player)player));
    }

    protected void sendTickUpdate() {
        if (this.worldObj.field_72995_K) {
            return;
        }
        if (this.updatePlayers.size() <= 0) {
            return;
        }
        Packet data = this.getUpdatePacket();
        for (EntityPlayer player : this.updatePlayers) {
            PacketDispatcher.sendPacketToPlayer((Packet)data, (Player)((Player)player));
        }
    }

    private int tryDistributeItems(TileEntityReactorAccessPort port, ItemStack itemsToDistribute, boolean distributeToInputs) {
        ItemStack existingStack = port.func_70301_a(1);
        CoordTriplet coord = port.getWorldLocation();
        int initialWasteAmount = itemsToDistribute.field_77994_a;
        int metadata = this.worldObj.func_72805_g(coord.x, coord.y, coord.z);
        if (metadata == 12 || distributeToInputs || this.attachedAccessPorts.size() < 2) {
            if (existingStack == null) {
                if (itemsToDistribute.field_77994_a > port.func_70297_j_()) {
                    ItemStack newStack = itemsToDistribute.func_77979_a(port.func_70297_j_());
                    port.func_70299_a(1, newStack);
                } else {
                    port.func_70299_a(1, itemsToDistribute.func_77946_l());
                    itemsToDistribute.field_77994_a = 0;
                }
            } else if (existingStack.func_77969_a(itemsToDistribute)) {
                if (existingStack.field_77994_a + itemsToDistribute.field_77994_a <= existingStack.func_77976_d()) {
                    existingStack.field_77994_a += itemsToDistribute.field_77994_a;
                    itemsToDistribute.field_77994_a = 0;
                } else {
                    int amt = existingStack.func_77976_d() - existingStack.field_77994_a;
                    itemsToDistribute.field_77994_a -= existingStack.func_77976_d() - existingStack.field_77994_a;
                    existingStack.field_77994_a += amt;
                }
            }
            port.onItemsReceived();
        }
        return initialWasteAmount - itemsToDistribute.field_77994_a;
    }

    @Override
    protected void onAssimilated(MultiblockControllerBase otherMachine) {
        this.attachedPowerTaps.clear();
        this.attachedTickables.clear();
        this.attachedAccessPorts.clear();
        this.attachedControllers.clear();
        this.attachedControlRods.clear();
        this.currentFuelRod = null;
    }

    @Override
    protected void onAssimilate(MultiblockControllerBase otherMachine) {
        if (!(otherMachine instanceof MultiblockReactor)) {
            BRLog.warning("[%s] Reactor @ %s is attempting to assimilate a non-Reactor machine! That machine's data will be lost!", this.worldObj.field_72995_K ? "CLIENT" : "SERVER", this.getReferenceCoord());
            return;
        }
        MultiblockReactor otherReactor = (MultiblockReactor)otherMachine;
        if (otherReactor.reactorHeat > this.reactorHeat) {
            this.setReactorHeat(otherReactor.reactorHeat);
        }
        if (otherReactor.fuelHeat > this.fuelHeat) {
            this.setFuelHeat(otherReactor.fuelHeat);
        }
        if (otherReactor.getEnergyStored() > this.getEnergyStored()) {
            this.setStoredEnergy(otherReactor.getEnergyStored());
        }
        this.fuelContainer.merge(otherReactor.fuelContainer);
        this.radiationHelper.merge(otherReactor.radiationHelper);
        this.coolantContainer.merge(otherReactor.coolantContainer);
    }

    @Override
    public void onAttachedPartWithMultiblockData(IMultiblockPart part, NBTTagCompound data) {
        this.readFromNBT(data);
    }

    public float getEnergyStored() {
        return this.energyStored;
    }

    public void setWasteEjection(WasteEjectionSetting newSetting) {
        if (this.wasteEjection != newSetting) {
            this.wasteEjection = newSetting;
            if (!this.worldObj.field_72995_K && this.updatePlayers.size() > 0) {
                CoordTriplet coord = this.getReferenceCoord();
                Packet250CustomPayload updatePacket = PacketWrapper.createPacket("BigReactors", 10, new Object[]{coord.x, coord.y, coord.z, this.wasteEjection.ordinal()});
                for (EntityPlayer player : this.updatePlayers) {
                    PacketDispatcher.sendPacketToPlayer((Packet)updatePacket, (Player)((Player)player));
                }
            }
        }
    }

    public WasteEjectionSetting getWasteEjection() {
        return this.wasteEjection;
    }

    protected void refuel() {
        int freeFuelSpace = this.fuelContainer.getCapacity() - this.fuelContainer.getTotalAmount();
        if (freeFuelSpace <= 0) {
            return;
        }
        ItemStack inputItem = null;
        FluidStack inputFluid = null;
        Fluid currentFuelType = this.fuelContainer.getFuelType();
        for (TileEntityReactorAccessPort port : this.attachedAccessPorts) {
            FluidStack mappedFluid;
            ItemStack contents;
            if (port == null || !port.isConnected() || (contents = port.func_70301_a(0)) == null || contents.field_77994_a <= 0 || (mappedFluid = BRRegistry.getReactorMappingForFuel(contents)) == null || mappedFluid.getFluid() == null || (currentFuelType == null || mappedFluid.getFluid() == null || !mappedFluid.getFluid().getName().equals(currentFuelType.getName())) && currentFuelType != null) continue;
            if (inputFluid == null) {
                inputItem = contents.func_77946_l();
                inputFluid = mappedFluid.copy();
                continue;
            }
            if (inputFluid.isFluidStackIdentical(mappedFluid)) {
                if (inputItem != null) {
                    inputItem.field_77994_a += contents.field_77994_a;
                    continue;
                }
                inputItem = contents.func_77946_l();
                continue;
            }
            if (mappedFluid.amount >= freeFuelSpace || inputFluid.amount >= mappedFluid.amount) continue;
            inputItem = contents.func_77946_l();
            inputFluid = mappedFluid.copy();
        }
        if (inputItem == null || inputFluid == null) {
            return;
        }
        if (freeFuelSpace < inputItem.field_77994_a * inputFluid.amount) {
            inputItem.field_77994_a = freeFuelSpace / inputFluid.amount;
            if (inputItem.field_77994_a <= 0) {
                return;
            }
        }
        FluidStack fuelAdded = new FluidStack(inputFluid, 0);
        for (TileEntityReactorAccessPort port : this.attachedAccessPorts) {
            if (port == null || !port.isConnected()) continue;
            if (inputItem == null || inputItem.field_77994_a <= 0) break;
            ItemStack fuelStack = port.func_70301_a(0);
            if (fuelStack == null || !fuelStack.func_77969_a(inputItem)) continue;
            if (fuelStack.field_77994_a >= inputItem.field_77994_a) {
                fuelStack = StaticUtils.Inventory.consumeItem(fuelStack, inputItem.field_77994_a);
                fuelAdded.amount += inputItem.field_77994_a * inputFluid.amount;
                inputItem = null;
            } else {
                fuelAdded.amount += fuelStack.field_77994_a * inputFluid.amount;
                inputItem.field_77994_a -= fuelStack.field_77994_a;
                fuelStack = StaticUtils.Inventory.consumeItem(fuelStack, fuelStack.field_77994_a);
                if (inputItem.field_77994_a <= 0) {
                    inputItem = null;
                }
            }
            port.func_70299_a(0, fuelStack);
        }
        if (fuelAdded != null && fuelAdded.amount > 0) {
            this.fuelContainer.addFuel(fuelAdded);
        }
    }

    public void ejectWaste(boolean dumpAll, CoordTriplet destination) {
        Fluid fuelType;
        int numIngots = this.fuelContainer.getWasteAmount() / 1000;
        if (numIngots <= 0 && !dumpAll) {
            return;
        }
        if (numIngots > 0 && (fuelType = this.fuelContainer.getWasteType()) != null) {
            ItemStack ingotsToDistribute = BRRegistry.getReactorSolidForFluid(fuelType.getName());
            if (ingotsToDistribute == null) {
                BRLog.warning("Unable to eject items for waste type %s, dumping all waste instead", fuelType.getName());
                dumpAll = true;
            } else {
                ingotsToDistribute = ingotsToDistribute.func_77946_l();
                ingotsToDistribute.field_77994_a = numIngots;
                int ingotsDistributed = 0;
                for (TileEntityReactorAccessPort port : this.attachedAccessPorts) {
                    if (ingotsToDistribute == null || ingotsToDistribute.field_77994_a <= 0) break;
                    if (port == null || !port.isConnected() || destination != null && (destination.x != port.field_70329_l || destination.y != port.field_70330_m || destination.z != port.field_70327_n)) continue;
                    ingotsDistributed += this.tryDistributeItems(port, ingotsToDistribute, destination == null);
                    if (ingotsToDistribute.field_77994_a > 0) continue;
                    ingotsToDistribute = null;
                }
                if (ingotsToDistribute != null && ingotsToDistribute.field_77994_a > 0 && destination == null) {
                    for (TileEntityReactorAccessPort port : this.attachedAccessPorts) {
                        if (ingotsToDistribute == null || ingotsToDistribute.field_77994_a <= 0) break;
                        if (port == null || !port.isConnected()) continue;
                        ingotsDistributed += this.tryDistributeItems(port, ingotsToDistribute, true);
                    }
                }
                this.fuelContainer.drainWaste(ingotsDistributed * 1000);
            }
        }
        if (dumpAll) {
            this.fuelContainer.setWaste(null);
        }
        this.markReferenceCoordForUpdate();
        this.markReferenceCoordDirty();
    }

    public void ejectFuel(boolean dumpAll, CoordTriplet destination) {
        Fluid fuelType;
        int numIngots = this.fuelContainer.getFuelAmount() / 1000;
        if (numIngots <= 0 && !dumpAll) {
            return;
        }
        if (numIngots > 0 && (fuelType = this.fuelContainer.getFuelType()) != null) {
            ItemStack ingotsToDistribute = BRRegistry.getReactorSolidForFluid(fuelType.getName());
            if (ingotsToDistribute == null) {
                BRLog.warning("Unable to eject items for fuel type %s, dumping all fuel instead", fuelType.getName());
                dumpAll = true;
            } else {
                ingotsToDistribute = ingotsToDistribute.func_77946_l();
                ingotsToDistribute.field_77994_a = numIngots;
                int ingotsDistributed = 0;
                for (TileEntityReactorAccessPort port : this.attachedAccessPorts) {
                    if (ingotsToDistribute == null || ingotsToDistribute.field_77994_a <= 0) break;
                    if (port == null || !port.isConnected() || destination != null && (destination.x != port.field_70329_l || destination.y != port.field_70330_m || destination.z != port.field_70327_n)) continue;
                    ingotsDistributed += this.tryDistributeItems(port, ingotsToDistribute, true);
                }
                this.fuelContainer.drainFuel(ingotsDistributed * 1000);
            }
        }
        if (dumpAll) {
            this.fuelContainer.setFuel(null);
        }
        this.markReferenceCoordForUpdate();
        this.markReferenceCoordDirty();
    }

    @Override
    protected void onMachineAssembled() {
        this.recalculateDerivedValues();
    }

    @Override
    protected void onMachineRestored() {
        this.recalculateDerivedValues();
    }

    @Override
    protected void onMachinePaused() {
    }

    @Override
    protected void onMachineDisassembled() {
        this.active = false;
    }

    private void recalculateDerivedValues() {
        CoordTriplet minCoord = this.getMinimumCoord();
        CoordTriplet maxCoord = this.getMaximumCoord();
        this.fuelContainer.setCapacity(this.attachedFuelRods.size() * 4000);
        this.fuelToReactorHeatTransferCoefficient = 0.0f;
        for (TileEntityReactorFuelRod fuelRod : this.attachedFuelRods) {
            this.fuelToReactorHeatTransferCoefficient += fuelRod.getHeatTransferRate();
        }
        int maxFuelRodY = maxCoord.y - 1;
        int minFuelRodY = minCoord.y + 1;
        this.currentFuelRod = this.attachedFuelRods.iterator();
        int xSize = maxCoord.x - minCoord.x - 1;
        int ySize = maxCoord.y - minCoord.y - 1;
        int zSize = maxCoord.z - minCoord.z - 1;
        int surfaceArea = 2 * (xSize * ySize + xSize * zSize + ySize * zSize);
        this.reactorToCoolantSystemHeatTransferCoefficient = 0.6f * (float)surfaceArea;
        surfaceArea = 2 * ((xSize += 2) * (ySize += 2) + xSize * (zSize += 2) + ySize * zSize);
        this.reactorHeatLossCoefficient = 0.001f * (float)surfaceArea;
        if (this.worldObj.field_72995_K) {
            this.onFuelStatusChanged();
        } else {
            this.markReferenceCoordForUpdate();
        }
        this.calculateReactorVolume();
        if (this.attachedCoolantPorts.size() > 0) {
            int outerVolume = StaticUtils.ExtraMath.Volume(minCoord, maxCoord) - this.reactorVolume;
            this.coolantContainer.setCapacity(Math.max(0, Math.min(50000, outerVolume * 100)));
        } else {
            this.coolantContainer.setCapacity(0);
        }
    }

    @Override
    protected int getMaximumXSize() {
        return BigReactors.maximumReactorSize;
    }

    @Override
    protected int getMaximumZSize() {
        return BigReactors.maximumReactorSize;
    }

    @Override
    protected int getMaximumYSize() {
        return BigReactors.maximumReactorHeight;
    }

    public void setEnergyGeneratedLastTick(float energyGeneratedLastTick) {
        this.energyGeneratedLastTick = energyGeneratedLastTick;
    }

    public float getEnergyGeneratedLastTick() {
        return this.energyGeneratedLastTick;
    }

    public void setFuelConsumedLastTick(float fuelConsumed) {
        this.fuelConsumedLastTick = fuelConsumed;
    }

    public float getFuelConsumedLastTick() {
        return this.fuelConsumedLastTick;
    }

    public float getFuelRichness() {
        int amtWaste;
        int amtFuel = this.fuelContainer.getFuelAmount();
        if ((float)(amtFuel + (amtWaste = this.fuelContainer.getWasteAmount())) <= 0.0f) {
            return 0.0f;
        }
        return (float)amtFuel / (float)(amtFuel + amtWaste);
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        int amtReceived = (int)Math.min((double)maxReceive, Math.floor(1.0E7f - this.energyStored));
        if (!simulate) {
            this.addStoredEnergy(amtReceived);
        }
        return amtReceived;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        int amtRemoved = (int)Math.min((float)maxExtract, this.energyStored);
        if (!simulate) {
            this.reduceStoredEnergy(amtRemoved);
        }
        return amtRemoved;
    }

    @Override
    public boolean canInterface(ForgeDirection from) {
        return false;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return (int)this.energyStored;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return 10000000;
    }

    public int getMaxEnergyPerTick() {
        return 10000000;
    }

    public void setAllControlRodInsertionValues(int newValue) {
        if (this.assemblyState != MultiblockControllerBase.AssemblyState.Assembled) {
            return;
        }
        for (TileEntityReactorControlRod cr : this.attachedControlRods) {
            if (cr == null || !cr.isConnected()) continue;
            cr.setControlRodInsertion((short)newValue);
        }
    }

    public void changeAllControlRodInsertionValues(short delta) {
        if (this.assemblyState != MultiblockControllerBase.AssemblyState.Assembled) {
            return;
        }
        for (TileEntityReactorControlRod cr : this.attachedControlRods) {
            if (cr == null || !cr.isConnected()) continue;
            cr.setControlRodInsertion((short)(cr.getControlRodInsertion() + delta));
        }
    }

    public CoordTriplet[] getControlRodLocations() {
        CoordTriplet[] coords = new CoordTriplet[this.attachedControlRods.size()];
        int i = 0;
        for (TileEntityReactorControlRod cr : this.attachedControlRods) {
            coords[i++] = cr.getWorldLocation();
        }
        return coords;
    }

    @Override
    public int getFuelAmount() {
        return this.fuelContainer.getFuelAmount();
    }

    @Override
    public int getWasteAmount() {
        return this.fuelContainer.getWasteAmount();
    }

    public Fluid getFuelType() {
        return this.fuelContainer.getFuelType();
    }

    public Fluid getWasteType() {
        return this.fuelContainer.getWasteType();
    }

    public int getEnergyStoredPercentage() {
        return (int)(this.energyStored / 1.0E7f * 100.0f);
    }

    @Override
    public int getCapacity() {
        if (this.worldObj.field_72995_K && this.assemblyState != MultiblockControllerBase.AssemblyState.Assembled) {
            return this.attachedFuelRods.size() * 4000;
        }
        return this.fuelContainer.getCapacity();
    }

    public float getFuelFertility() {
        return this.radiationHelper.getFertilityModifier();
    }

    public CoolantContainer getCoolantContainer() {
        return this.coolantContainer;
    }

    protected float getPassiveCoolantTemperature() {
        return 20.0f;
    }

    protected float getCoolantTemperature() {
        if (this.isPassivelyCooled()) {
            return this.getPassiveCoolantTemperature();
        }
        return this.coolantContainer.getCoolantTemperature(this.getReactorHeat());
    }

    public boolean isPassivelyCooled() {
        return this.coolantContainer == null || this.coolantContainer.getCapacity() <= 0;
    }

    protected int getReactorVolume() {
        return this.reactorVolume;
    }

    protected void calculateReactorVolume() {
        CoordTriplet minInteriorCoord = this.getMinimumCoord();
        ++minInteriorCoord.x;
        ++minInteriorCoord.y;
        ++minInteriorCoord.z;
        CoordTriplet maxInteriorCoord = this.getMaximumCoord();
        --maxInteriorCoord.x;
        --maxInteriorCoord.y;
        --maxInteriorCoord.z;
        this.reactorVolume = StaticUtils.ExtraMath.Volume(minInteriorCoord, maxInteriorCoord);
    }

    protected void onFuelStatusChanged() {
        if (this.worldObj.field_72995_K) {
            for (TileEntityReactorFuelRod fuelRod : this.attachedFuelRods) {
                this.worldObj.func_72845_h(fuelRod.field_70329_l, fuelRod.field_70330_m, fuelRod.field_70327_n);
            }
        }
    }

    @Override
    public FluidTankInfo[] getTankInfo() {
        if (this.isPassivelyCooled()) {
            return emptyTankInfo;
        }
        return this.coolantContainer.getTankInfo(-1);
    }

    protected void markReferenceCoordForUpdate() {
        CoordTriplet rc = this.getReferenceCoord();
        if (this.worldObj != null && rc != null) {
            this.worldObj.func_72845_h(rc.x, rc.y, rc.z);
        }
    }

    protected void markReferenceCoordDirty() {
        if (this.worldObj == null || this.worldObj.field_72995_K) {
            return;
        }
        CoordTriplet referenceCoord = this.getReferenceCoord();
        if (referenceCoord == null) {
            return;
        }
        TileEntity saveTe = this.worldObj.func_72796_p(referenceCoord.x, referenceCoord.y, referenceCoord.z);
        this.worldObj.func_72944_b(referenceCoord.x, referenceCoord.y, referenceCoord.z, saveTe);
    }

    public static enum WasteEjectionSetting {
        kAutomatic,
        kManual;

    }
}

