/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erogenousbeef.bigreactors.common.BRConfig;
import erogenousbeef.bigreactors.common.BREventHandler;
import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.BRRegistry;
import erogenousbeef.bigreactors.common.BigReactorsTickHandler;
import erogenousbeef.bigreactors.common.CreativeTabBR;
import erogenousbeef.bigreactors.common.block.BlockBRGenericFluid;
import erogenousbeef.bigreactors.common.block.BlockBRMetal;
import erogenousbeef.bigreactors.common.block.BlockBROre;
import erogenousbeef.bigreactors.common.block.BlockBRSmallMachine;
import erogenousbeef.bigreactors.common.data.ReactorFuel;
import erogenousbeef.bigreactors.common.data.ReactorSolidMapping;
import erogenousbeef.bigreactors.common.item.ItemBRBucket;
import erogenousbeef.bigreactors.common.item.ItemBlockBigReactors;
import erogenousbeef.bigreactors.common.item.ItemBlockReactorPart;
import erogenousbeef.bigreactors.common.item.ItemIngot;
import erogenousbeef.bigreactors.common.multiblock.block.BlockFuelRod;
import erogenousbeef.bigreactors.common.multiblock.block.BlockMBCreativePart;
import erogenousbeef.bigreactors.common.multiblock.block.BlockMultiblockGlass;
import erogenousbeef.bigreactors.common.multiblock.block.BlockReactorControlRod;
import erogenousbeef.bigreactors.common.multiblock.block.BlockReactorPart;
import erogenousbeef.bigreactors.common.multiblock.block.BlockReactorRedstonePort;
import erogenousbeef.bigreactors.common.multiblock.block.BlockTurbinePart;
import erogenousbeef.bigreactors.common.multiblock.block.BlockTurbineRotorPart;
import erogenousbeef.bigreactors.common.multiblock.helpers.RadiationHelper;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorAccessPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorComputerPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorControlRod;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorCoolantPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorFuelRod;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorGlass;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPowerTap;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorRedNetPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorRedstonePort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineComputerPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineFluidPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePartGlass;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePartStandard;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePowerTap;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineRotorBearing;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineRotorPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.creative.TileEntityReactorCreativeCoolantPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.creative.TileEntityTurbineCreativeSteamGenerator;
import erogenousbeef.bigreactors.common.tileentity.TileEntityCyaniteReprocessor;
import erogenousbeef.bigreactors.world.BRSimpleOreGenerator;
import erogenousbeef.bigreactors.world.BRWorldGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.Icon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class BigReactors {
    public static final String NAME = "Big Reactors";
    public static final String CHANNEL = "BigReactors";
    public static final String RESOURCE_PATH = "/assets/bigreactors/";
    public static final CreativeTabs TAB = new CreativeTabBR(CreativeTabs.getNextID(), "BigReactors");
    public static final String TEXTURE_NAME_PREFIX = "bigreactors:";
    public static final String TEXTURE_DIRECTORY = "/assets/bigreactors/textures/";
    public static final String GUI_DIRECTORY = "bigreactors:textures/gui/";
    public static final String BLOCK_TEXTURE_DIRECTORY = "/assets/bigreactors/textures/blocks/";
    public static final String ITEM_TEXTURE_DIRECTORY = "/assets/bigreactors/textures/items/";
    public static final String MODEL_TEXTURE_DIRECTORY = "/assets/bigreactors/textures/models/";
    public static final String LANGUAGE_PATH = "/assets/bigreactors/languages/";
    private static final String[] LANGUAGES_SUPPORTED = new String[]{"de_DE", "en_US", "es_SP", "nl_NL", "pl_PL", "pt_BR", "ru_RU", "sv_SE", "zh_CN"};
    public static final int BLOCK_ID_PREFIX = 1750;
    public static Block blockYelloriteOre;
    public static BlockBRMetal blockMetal;
    public static Block blockYelloriumFuelRod;
    public static BlockReactorPart blockReactorPart;
    public static Block blockReactorControlRod;
    public static Block blockReactorRedstonePort;
    public static BlockTurbinePart blockTurbinePart;
    public static BlockTurbineRotorPart blockTurbineRotorPart;
    public static BlockMultiblockGlass blockMultiblockGlass;
    public static BlockMBCreativePart blockMultiblockCreativePart;
    public static Block blockRadiothermalGen;
    public static Block blockSmallMachine;
    public static Block fluidYelloriumStill;
    public static Block fluidCyaniteStill;
    public static Block fluidFuelColumnStill;
    public static Item fluidYelloriumBucketItem;
    public static Item fluidCyaniteBucketItem;
    public static Fluid fluidYellorium;
    public static Fluid fluidCyanite;
    public static Fluid fluidFuelColumn;
    public static Fluid fluidSteam;
    public static boolean registeredOwnSteam;
    public static final int defaultFluidColorFuel = 12368464;
    public static final int defaultFluidColorWaste = 5083829;
    public static final int ITEM_ID_PREFIX = 17750;
    public static ItemIngot ingotGeneric;
    public static BRSimpleOreGenerator yelloriteOreGeneration;
    public static boolean INITIALIZED;
    public static boolean enableWorldGen;
    public static boolean enableWorldGenInNegativeDimensions;
    public static boolean enableWorldRegeneration;
    public static int userWorldGenVersion;
    public static BREventHandler eventHandler;
    public static BigReactorsTickHandler tickHandler;
    public static BRWorldGenerator worldGenerator;
    private static boolean registeredTileEntities;
    public static int maximumReactorSize;
    public static int maximumReactorHeight;
    public static int ticksPerRedstoneUpdate;
    public static int maximumTurbineSize;
    public static int maximumTurbineHeight;
    public static float powerProductionMultiplier;
    public static float fuelUsageMultiplier;
    public static boolean isValentinesDay;
    protected static Icon iconSteamStill;
    protected static Icon iconSteamFlowing;
    protected static Icon iconFuelColumnStill;
    protected static Icon iconFuelColumnFlowing;
    private static boolean registerYelloriteSmeltToUranium;
    private static boolean registerYelloriumAsUranium;

    public static void register(Object modInstance) {
        if (!INITIALIZED) {
            ItemStack reactorPartStack;
            BigReactors.loadLanguages(LANGUAGE_PATH, LANGUAGES_SUPPORTED);
            BRConfig.CONFIGURATION.load();
            enableWorldGen = BRConfig.CONFIGURATION.get("WorldGen", "enableWorldGen", true, "If false, disables all world gen from Big Reactors; all other worldgen settings are automatically overridden").getBoolean(true);
            enableWorldGenInNegativeDimensions = BRConfig.CONFIGURATION.get("WorldGen", "enableWorldGenInNegativeDims", false, "Run BR world generation in negative dimension IDs? (default: false) If you don't know what this is, leave it alone.").getBoolean(false);
            enableWorldRegeneration = BRConfig.CONFIGURATION.get("WorldGen", "enableWorldRegeneration", false, "Run BR World Generation in chunks that have already been generated, but have not been modified by Big Reactors before. This is largely useful for worlds that existed before BigReactors was released.").getBoolean(false);
            userWorldGenVersion = BRConfig.CONFIGURATION.get("WorldGen", "userWorldGenVersion", 0, "User-set world generation version. Increase this by 1 if you want Big Reactors to re-run world generation in your world.").getInt();
            boolean registerCoalFurnaceRecipe = BRConfig.CONFIGURATION.get("Recipes", "registerCoalForSmelting", true, "If set, coal will be smeltable into graphite bars. Disable this if other mods need to smelt coal into their own products. (Default: true)").getBoolean(true);
            boolean registerCharcoalFurnaceRecipe = BRConfig.CONFIGURATION.get("Recipes", "registerCharcoalForSmelting", true, "If set, charcoal will be smeltable into graphite bars. Disable this if other mods need to smelt charcoal into their own products. (Default: true)").getBoolean(true);
            boolean registerCoalCraftingRecipe = BRConfig.CONFIGURATION.get("Recipes", "registerGraphiteCoalCraftingRecipes", false, "If set, graphite bars can be crafted from 2 gravel, 1 coal. Use this if other mods interfere with the smelting recipe. (Default: false)").getBoolean(false);
            boolean registerCharcoalCraftingRecipe = BRConfig.CONFIGURATION.get("Recipes", "registerGraphiteCharcoalCraftingRecipes", false, "If set, graphite bars can be crafted from 2 gravel, 1 charcoal. Use this if other mods interfere with the smelting recipe. (Default: false)").getBoolean(false);
            registerYelloriteSmeltToUranium = BRConfig.CONFIGURATION.get("Recipes", "registerYelloriteSmeltToUranium", true, "If set, yellorite ore will smelt into whichever item is registered as ingotUranium in the ore dictionary. If false, it will smelt into ingotYellorium. (Default: true)").getBoolean(true);
            boolean useSteelForIron = BRConfig.CONFIGURATION.get("Recipes", "requireSteelInsteadOfIron", false, "If set, then all Big Reactors components will require steel ingots (ingotSteel) in place of iron ingots. Will be ignored if no other mod registers steel ingots. (default: false)").getBoolean(false);
            boolean useExpensiveGlass = BRConfig.CONFIGURATION.get("Recipes", "requireObsidianGlass", false, "If set, then Big Reactors will require hardened or reinforced glass (glassHardened or glassReinforced) instead of plain glass. Will be ignored if no other mod registers those glass types. (default: false)").getBoolean(false);
            boolean enableReactorPowerTapRecipe = BRConfig.CONFIGURATION.get("Recipes", "enableReactorPowerTapRecipe", true, "If set, reactor power taps can be crafted, allowing players to use passive-cooled reactors.").getBoolean(true);
            maximumReactorSize = BRConfig.CONFIGURATION.get("General", "maxReactorSize", 32, "The maximum valid size of a reactor in the X/Z plane, in blocks. Lower this if your server's players are building ginormous reactors.").getInt();
            maximumReactorHeight = BRConfig.CONFIGURATION.get("General", "maxReactorHeight", 48, "The maximum valid size of a reactor in the Y dimension, in blocks. Lower this if your server's players are building ginormous reactors. Bigger Y sizes have far less performance impact than X/Z sizes.").getInt();
            ticksPerRedstoneUpdate = BRConfig.CONFIGURATION.get("General", "ticksPerRedstoneUpdate", 20, "Number of ticks between updates for redstone/rednet ports.").getInt();
            powerProductionMultiplier = (float)BRConfig.CONFIGURATION.get("General", "powerProductionMultiplier", 1.0, "A multiplier for balancing overall power production from Big Reactors. Defaults to 1.").getDouble(1.0);
            fuelUsageMultiplier = (float)BRConfig.CONFIGURATION.get("General", "fuelUsageMultiplier", 1.0, "A multiplier for balancing fuel consumption. Defaults to 1.").getDouble(1.0);
            maximumTurbineSize = BRConfig.CONFIGURATION.get("General", "maxTurbineSize", 16, "The maximum valid size of a turbine in the X/Z plane, in blocks. Lower this for smaller turbines, which means lower max output. Turbines will be limited to twice this value in height.").getInt();
            maximumTurbineHeight = maximumTurbineSize * 2;
            BRConfig.CONFIGURATION.save();
            if (enableWorldGen) {
                worldGenerator = new BRWorldGenerator();
                GameRegistry.registerWorldGenerator((IWorldGenerator)worldGenerator);
            }
            if (OreDictionary.getOres((String)"ingotIron").size() <= 0) {
                OreDictionary.registerOre((String)"ingotIron", (Item)Item.field_77703_o);
            }
            if (OreDictionary.getOres((String)"ingotGold").size() <= 0) {
                OreDictionary.registerOre((String)"ingotGold", (Item)Item.field_77717_p);
            }
            if (OreDictionary.getOres((String)"blockSnow").size() <= 0) {
                OreDictionary.registerOre((String)"blockSnow", (Block)Block.field_72037_aS);
            }
            if (OreDictionary.getOres((String)"blockIce").size() <= 0) {
                OreDictionary.registerOre((String)"blockIce", (Block)Block.field_72036_aT);
            }
            if (OreDictionary.getOreID((ItemStack)new ItemStack(Block.field_71946_M)) < 0) {
                OreDictionary.registerOre((String)"glass", (Block)Block.field_71946_M);
            }
            String ironOrSteelIngot = "ingotIron";
            if (useSteelForIron && OreDictionary.getOres((String)"ingotSteel").size() > 0) {
                ironOrSteelIngot = "ingotSteel";
            }
            String yelloriumIngot = "ingotYellorium";
            String blutoniumIngot = "ingotBlutonium";
            if (registerYelloriumAsUranium) {
                yelloriumIngot = "ingotUranium";
                blutoniumIngot = "ingotPlutonium";
            }
            if (blockYelloriteOre != null) {
                ItemStack product = registerYelloriteSmeltToUranium ? ((ItemStack)OreDictionary.getOres((String)"ingotUranium").get(0)).func_77946_l() : ((ItemStack)OreDictionary.getOres((String)"ingotYellorium").get(0)).func_77946_l();
                FurnaceRecipes.func_77602_a().addSmelting(BigReactors.blockYelloriteOre.field_71990_ca, 0, product, 0.5f);
            }
            if (blockMetal != null && ingotGeneric != null) {
                blockMetal.registerIngotRecipes(ingotGeneric);
            }
            if (ingotGeneric != null) {
                for (int i = 0; i < 4; ++i) {
                    FurnaceRecipes.func_77602_a().addSmelting(BigReactors.ingotGeneric.field_77779_bT, i + 4, new ItemStack((Item)ingotGeneric, 1, i), 0.0f);
                }
            }
            ItemStack ingotGraphite = ((ItemStack)OreDictionary.getOres((String)"ingotGraphite").get(0)).func_77946_l();
            if (registerCoalFurnaceRecipe) {
                FurnaceRecipes.func_77602_a().addSmelting(Item.field_77705_m.field_77779_bT, 0, ingotGraphite, 1.0f);
            }
            if (registerCharcoalFurnaceRecipe) {
                FurnaceRecipes.func_77602_a().addSmelting(Item.field_77705_m.field_77779_bT, 1, ingotGraphite, 1.0f);
            }
            if (registerCoalCraftingRecipe) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ingotGraphite, new Object[]{"GCG", Character.valueOf('G'), Block.field_71940_F, Character.valueOf('C'), new ItemStack(Item.field_77705_m, 1, 0)}));
            }
            if (registerCharcoalCraftingRecipe) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ingotGraphite, new Object[]{"GCG", Character.valueOf('G'), Block.field_71940_F, Character.valueOf('C'), new ItemStack(Item.field_77705_m, 1, 1)}));
            }
            if (blockYelloriumFuelRod != null) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockYelloriumFuelRod, 1), new Object[]{"ICI", "IUI", "ICI", Character.valueOf('I'), ironOrSteelIngot, Character.valueOf('C'), "ingotGraphite", Character.valueOf('U'), yelloriumIngot}));
            }
            if (blockReactorPart != null) {
                reactorPartStack = blockReactorPart.getReactorCasingItemStack();
                reactorPartStack.field_77994_a = 4;
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(reactorPartStack, new Object[]{"ICI", "CUC", "ICI", Character.valueOf('I'), ironOrSteelIngot, Character.valueOf('C'), "ingotGraphite", Character.valueOf('U'), yelloriumIngot}));
            }
            if (blockReactorPart != null) {
                reactorPartStack = blockReactorPart.getReactorControllerItemStack();
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(reactorPartStack, new Object[]{"C C", "GDG", "CRC", Character.valueOf('D'), Item.field_77702_n, Character.valueOf('G'), yelloriumIngot, Character.valueOf('C'), "reactorCasing", Character.valueOf('R'), Item.field_77767_aC}));
                if (enableReactorPowerTapRecipe) {
                    reactorPartStack = blockReactorPart.getReactorPowerTapItemStack();
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(reactorPartStack, new Object[]{"CRC", "R R", "CRC", Character.valueOf('C'), "reactorCasing", Character.valueOf('R'), Item.field_77767_aC}));
                }
                reactorPartStack = blockReactorPart.getAccessPortItemStack();
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(reactorPartStack, new Object[]{"C C", " V ", "CPC", Character.valueOf('C'), "reactorCasing", Character.valueOf('V'), Block.field_72077_au, Character.valueOf('P'), Block.field_71963_Z}));
                reactorPartStack = blockReactorPart.getCoolantPortItemStack();
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(reactorPartStack, new Object[]{"C C", "IVI", "CPC", Character.valueOf('C'), "reactorCasing", Character.valueOf('V'), Item.field_77788_aw, Character.valueOf('P'), Block.field_71963_Z, Character.valueOf('I'), ironOrSteelIngot}));
                if (Loader.isModLoaded((String)"MineFactoryReloaded")) {
                    reactorPartStack = blockReactorPart.getRedNetPortItemStack();
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(reactorPartStack, new Object[]{"CRC", "RGR", "CRC", Character.valueOf('C'), "reactorCasing", Character.valueOf('R'), "cableRedNet", Character.valueOf('G'), "ingotGold"}));
                }
                if (Loader.isModLoaded((String)"ComputerCraft") || Loader.isModLoaded((String)"OpenComputers")) {
                    reactorPartStack = blockReactorPart.getComputerPortItemStack();
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(reactorPartStack, new Object[]{"CRC", "GPG", "CRC", Character.valueOf('C'), "reactorCasing", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('G'), "ingotGold", Character.valueOf('P'), Item.field_77742_bb}));
                }
            }
            if (blockMultiblockGlass != null) {
                ItemStack reactorGlassStack = blockMultiblockGlass.getItemStack("reactor");
                ItemStack turbineGlassStack = blockMultiblockGlass.getItemStack("turbine");
                if (useExpensiveGlass && (OreDictionary.getOres((String)"glassReinforced").size() > 0 || OreDictionary.getOres((String)"glassHardened").size() > 0)) {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(reactorGlassStack, new Object[]{"GCG", Character.valueOf('G'), "glassReinforced", Character.valueOf('C'), "reactorCasing"}));
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(reactorGlassStack, new Object[]{"GCG", Character.valueOf('G'), "glassHardened", Character.valueOf('C'), "reactorCasing"}));
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(turbineGlassStack, new Object[]{"GCG", Character.valueOf('G'), "glassReinforced", Character.valueOf('C'), "turbineHousing"}));
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(turbineGlassStack, new Object[]{"GCG", Character.valueOf('G'), "glassHardened", Character.valueOf('C'), "turbineHousing"}));
                } else {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(reactorGlassStack, new Object[]{"GCG", Character.valueOf('G'), "glass", Character.valueOf('C'), "reactorCasing"}));
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(turbineGlassStack, new Object[]{"GCG", Character.valueOf('G'), "glass", Character.valueOf('C'), "turbineHousing"}));
                }
            }
            if (blockReactorControlRod != null) {
                ItemStack reactorControlRodStack = new ItemStack(blockReactorControlRod, 1);
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(reactorControlRodStack, new Object[]{"CGC", "GRG", "CUC", Character.valueOf('G'), "ingotGraphite", Character.valueOf('C'), "reactorCasing", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('U'), yelloriumIngot}));
            }
            if (blockSmallMachine != null) {
                ItemStack cyaniteReprocessorStack = ((BlockBRSmallMachine)blockSmallMachine).getCyaniteReprocessorItemStack();
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(cyaniteReprocessorStack, new Object[]{"CIC", "PFP", "CRC", Character.valueOf('C'), "reactorCasing", Character.valueOf('I'), ironOrSteelIngot, Character.valueOf('F'), blockYelloriumFuelRod, Character.valueOf('P'), Block.field_71963_Z, Character.valueOf('R'), Item.field_77767_aC}));
            }
            if (blockReactorRedstonePort != null) {
                ItemStack redstonePortStack = new ItemStack(blockReactorRedstonePort, 1);
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(redstonePortStack, new Object[]{"CRC", "RGR", "CRC", Character.valueOf('C'), "reactorCasing", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('G'), Item.field_77717_p}));
            }
            if (blockTurbinePart != null) {
                ItemStack turbineHousing = blockTurbinePart.getItemStack("housing");
                ItemStack turbineController = blockTurbinePart.getItemStack("controller");
                ItemStack turbinePowerTap = blockTurbinePart.getItemStack("powerTap");
                ItemStack turbineFluidPort = blockTurbinePart.getItemStack("fluidPort");
                ItemStack turbineBearing = blockTurbinePart.getItemStack("bearing");
                turbineHousing.field_77994_a = 4;
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(turbineHousing, new Object[]{"IGI", "QCQ", "IGI", Character.valueOf('C'), "ingotCyanite", Character.valueOf('I'), ironOrSteelIngot, Character.valueOf('Q'), Item.field_94583_ca, Character.valueOf('G'), "ingotGraphite"}));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(turbineController, new Object[]{"H H", "BDB", "H H", Character.valueOf('H'), "turbineHousing", Character.valueOf('D'), Item.field_77702_n, Character.valueOf('B'), blutoniumIngot}));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(turbinePowerTap, new Object[]{"HRH", "R R", "HRH", Character.valueOf('H'), "turbineHousing", Character.valueOf('R'), Item.field_77767_aC}));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(turbineFluidPort, new Object[]{"H H", "IVI", "HPH", Character.valueOf('H'), "turbineHousing", Character.valueOf('I'), ironOrSteelIngot, Character.valueOf('V'), Item.field_77788_aw, Character.valueOf('P'), Block.field_71963_Z}));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(turbineBearing, new Object[]{"HRH", "DDD", "HRH", Character.valueOf('H'), "turbineHousing", Character.valueOf('D'), Item.field_77702_n, Character.valueOf('R'), "turbineRotorShaft"}));
                if (Loader.isModLoaded((String)"ComputerCraft") || Loader.isModLoaded((String)"OpenComputers")) {
                    ItemStack turbineComputerPort = blockTurbinePart.getItemStack("computerPort");
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(turbineComputerPort, new Object[]{"HRH", "GPG", "HRH", Character.valueOf('H'), "turbineHousing", Character.valueOf('G'), "ingotGold", Character.valueOf('R'), "turbineRotorShaft"}));
                }
            }
            if (blockTurbineRotorPart != null) {
                ItemStack rotorShaft = blockTurbineRotorPart.getItemStack("rotor");
                ItemStack rotorBlade = blockTurbineRotorPart.getItemStack("blade");
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(rotorShaft, new Object[]{"ICI", Character.valueOf('C'), "ingotCyanite", Character.valueOf('I'), ironOrSteelIngot}));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(rotorBlade, new Object[]{"CII", Character.valueOf('C'), "ingotCyanite", Character.valueOf('I'), ironOrSteelIngot}));
            }
            BigReactors.registerGameBalanceData();
        }
        INITIALIZED = true;
    }

    public static void registerTileEntities() {
        if (!registeredTileEntities) {
            GameRegistry.registerTileEntity(TileEntityReactorPowerTap.class, (String)"BRReactorPowerTap");
            GameRegistry.registerTileEntity(TileEntityReactorPart.class, (String)"BRReactorPart");
            GameRegistry.registerTileEntity(TileEntityReactorAccessPort.class, (String)"BRReactorAccessPort");
            GameRegistry.registerTileEntity(TileEntityReactorGlass.class, (String)"BRReactorGlass");
            GameRegistry.registerTileEntity(TileEntityReactorFuelRod.class, (String)"BRFuelRod");
            GameRegistry.registerTileEntity(TileEntityCyaniteReprocessor.class, (String)"BRCyaniteReprocessor");
            GameRegistry.registerTileEntity(TileEntityReactorControlRod.class, (String)"BRReactorControlRod");
            GameRegistry.registerTileEntity(TileEntityReactorRedNetPort.class, (String)"BRReactorRedNetPort");
            GameRegistry.registerTileEntity(TileEntityReactorRedstonePort.class, (String)"BRReactorRedstonePort");
            GameRegistry.registerTileEntity(TileEntityReactorComputerPort.class, (String)"BRReactorComputerPort");
            GameRegistry.registerTileEntity(TileEntityReactorCoolantPort.class, (String)"BRReactorCoolantPort");
            GameRegistry.registerTileEntity(TileEntityReactorCreativeCoolantPort.class, (String)"BRReactorCreativeCoolantPort");
            GameRegistry.registerTileEntity(TileEntityTurbinePartStandard.class, (String)"BRTurbinePart");
            GameRegistry.registerTileEntity(TileEntityTurbinePowerTap.class, (String)"BRTurbinePowerTap");
            GameRegistry.registerTileEntity(TileEntityTurbineFluidPort.class, (String)"BRTurbineFluidPort");
            GameRegistry.registerTileEntity(TileEntityTurbineComputerPort.class, (String)"BRTurbineComputerPort");
            GameRegistry.registerTileEntity(TileEntityTurbinePartGlass.class, (String)"BRTurbineGlass");
            GameRegistry.registerTileEntity(TileEntityTurbineRotorBearing.class, (String)"BRTurbineRotorBearing");
            GameRegistry.registerTileEntity(TileEntityTurbineRotorPart.class, (String)"BRTurbineRotorPart");
            GameRegistry.registerTileEntity(TileEntityTurbineCreativeSteamGenerator.class, (String)"BRTurbineCreativeSteamGenerator");
            registeredTileEntities = true;
        }
    }

    public static ItemStack registerOres(int i, boolean b) {
        BRConfig.CONFIGURATION.load();
        if (blockYelloriteOre == null) {
            blockYelloriteOre = new BlockBROre(BRConfig.CONFIGURATION.getBlock("YelloriteOre", 1750).getInt());
            GameRegistry.registerBlock((Block)blockYelloriteOre, ItemBlockBigReactors.class, (String)"YelloriteOre");
            OreDictionary.registerOre((String)"oreYellorite", (Block)blockYelloriteOre);
        }
        if (blockMetal == null) {
            blockMetal = new BlockBRMetal(BRConfig.CONFIGURATION.getBlock("MetalBlock", 1763).getInt());
            GameRegistry.registerBlock((Block)blockMetal, ItemBlockBigReactors.class, (String)"BRMetalBlock");
            blockMetal.registerOreDictEntries();
        }
        boolean genYelloriteOre = BRConfig.CONFIGURATION.get("WorldGen", "GenerateYelloriteOre", true, "Add yellorite ore during world generation?").getBoolean(true);
        if (yelloriteOreGeneration == null && genYelloriteOre) {
            int clustersPerChunk = BRConfig.CONFIGURATION.get("WorldGen", "MaxYelloriteClustersPerChunk", 5, "Maximum number of clusters per chunk; will generate at least half this number, rounded down").getInt();
            int orePerCluster = BRConfig.CONFIGURATION.get("WorldGen", "MaxYelloriteOrePerCluster", 10, "Maximum number of blocks to generate in each cluster; will usually generate at least half this number").getInt();
            int maxY = BRConfig.CONFIGURATION.get("WorldGen", "YelloriteMaxY", 50, "Maximum height (Y coordinate) in the world to generate yellorite ore").getInt();
            int[] dimensionBlacklist = BRConfig.CONFIGURATION.get("WorldGen", "YelloriteDimensionBlacklist", new int[0], "Dimensions in which yellorite ore should not be generated; Nether/End automatically included").getIntList();
            yelloriteOreGeneration = new BRSimpleOreGenerator(BigReactors.blockYelloriteOre.field_71990_ca, 0, Block.field_71981_t.field_71990_ca, clustersPerChunk / 2, clustersPerChunk, 4, maxY, orePerCluster);
            BRSimpleOreGenerator yelloriteOreGeneration2 = new BRSimpleOreGenerator(BigReactors.blockYelloriteOre.field_71990_ca, 0, Block.field_71981_t.field_71990_ca, 1, 2, 11, 13, orePerCluster);
            if (dimensionBlacklist != null) {
                for (int dimension : dimensionBlacklist) {
                    yelloriteOreGeneration.blacklistDimension(dimension);
                    yelloriteOreGeneration2.blacklistDimension(dimension);
                }
            }
            BRWorldGenerator.addGenerator(yelloriteOreGeneration);
            BRWorldGenerator.addGenerator(yelloriteOreGeneration2);
        }
        BRConfig.CONFIGURATION.save();
        return new ItemStack(blockYelloriteOre);
    }

    public static ItemStack registerIngots(int id) {
        if (ingotGeneric == null) {
            BRConfig.CONFIGURATION.load();
            registerYelloriumAsUranium = BRConfig.CONFIGURATION.get("Recipes", "registerYelloriumAsUranium", true, "If set, yellorium will be registered in the ore dictionary as ingotUranium as well as ingotYellorium. Otherwise, it will only be registered as ingotYellorium. (Default: true)").getBoolean(true);
            ingotGeneric = new ItemIngot(BRConfig.CONFIGURATION.getItem("IngotYellorium", 17750).getInt());
            for (int i = 0; i < ItemIngot.TYPES.length; ++i) {
                String itemName = ItemIngot.TYPES[i];
                OreDictionary.registerOre((String)itemName, (ItemStack)ingotGeneric.getItemStackForType(itemName));
            }
            if (registerYelloriumAsUranium) {
                OreDictionary.registerOre((String)"ingotUranium", (ItemStack)ingotGeneric.getItemStackForType("ingotYellorium"));
                OreDictionary.registerOre((String)"ingotPlutonium", (ItemStack)ingotGeneric.getItemStackForType("ingotBlutonium"));
                OreDictionary.registerOre((String)"dustUranium", (ItemStack)ingotGeneric.getItemStackForType("dustYellorium"));
                OreDictionary.registerOre((String)"dustPlutonium", (ItemStack)ingotGeneric.getItemStackForType("dustBlutonium"));
            }
            BRConfig.CONFIGURATION.save();
        }
        return new ItemStack((Item)ingotGeneric);
    }

    public static void registerFuelRods(int id, boolean require) {
        if (blockReactorControlRod == null) {
            BRConfig.CONFIGURATION.load();
            blockReactorControlRod = new BlockReactorControlRod(BRConfig.CONFIGURATION.getBlock("ReactorControlRod", 1753).getInt(), Material.field_76243_f);
            GameRegistry.registerBlock((Block)blockReactorControlRod, ItemBlock.class, (String)"ReactorControlRod");
            BRConfig.CONFIGURATION.save();
        }
        if (blockYelloriumFuelRod == null) {
            BRConfig.CONFIGURATION.load();
            blockYelloriumFuelRod = new BlockFuelRod(BRConfig.CONFIGURATION.getBlock("YelloriumFuelRod", 1751).getInt(), Material.field_76243_f);
            GameRegistry.registerBlock((Block)blockYelloriumFuelRod, ItemBlock.class, (String)"YelloriumFuelRod");
            BRConfig.CONFIGURATION.save();
        }
    }

    public static void registerReactorPartBlocks(int id, boolean require) {
        if (blockReactorPart == null) {
            BRConfig.CONFIGURATION.load();
            blockReactorPart = new BlockReactorPart(BRConfig.CONFIGURATION.getBlock("ReactorPart", 1752).getInt(), Material.field_76243_f);
            GameRegistry.registerBlock((Block)blockReactorPart, ItemBlockReactorPart.class, (String)"BRReactorPart");
            OreDictionary.registerOre((String)"reactorCasing", (ItemStack)blockReactorPart.getReactorCasingItemStack());
            OreDictionary.registerOre((String)"reactorController", (ItemStack)blockReactorPart.getReactorControllerItemStack());
            OreDictionary.registerOre((String)"reactorPowerTap", (ItemStack)blockReactorPart.getReactorPowerTapItemStack());
            OreDictionary.registerOre((String)"reactorRedNetPort", (ItemStack)blockReactorPart.getRedNetPortItemStack());
            OreDictionary.registerOre((String)"reactorComputerPort", (ItemStack)blockReactorPart.getComputerPortItemStack());
            OreDictionary.registerOre((String)"reactorCoolantPort", (ItemStack)blockReactorPart.getCoolantPortItemStack());
            BRConfig.CONFIGURATION.save();
        }
        if (blockMultiblockGlass == null) {
            BRConfig.CONFIGURATION.load();
            blockMultiblockGlass = new BlockMultiblockGlass(BRConfig.CONFIGURATION.getBlock("ReactorGlass", 1757).getInt(), Material.field_76264_q);
            GameRegistry.registerBlock((Block)blockMultiblockGlass, ItemBlockBigReactors.class, (String)"BRMultiblockGlass");
            OreDictionary.registerOre((String)"glassReactor", (ItemStack)blockMultiblockGlass.getItemStack("reactor"));
            OreDictionary.registerOre((String)"glassTurbine", (ItemStack)blockMultiblockGlass.getItemStack("turbine"));
            BRConfig.CONFIGURATION.save();
        }
        if (blockReactorRedstonePort == null) {
            BRConfig.CONFIGURATION.load();
            blockReactorRedstonePort = new BlockReactorRedstonePort(BRConfig.CONFIGURATION.getBlock("ReactorRedstonePort", 1759).getInt(), Material.field_76243_f);
            GameRegistry.registerBlock((Block)blockReactorRedstonePort, ItemBlock.class, (String)"BRReactorRedstonePort");
            OreDictionary.registerOre((String)"reactorRedstonePort", (ItemStack)new ItemStack(blockReactorRedstonePort, 1));
            BRConfig.CONFIGURATION.save();
        }
    }

    public static void registerTurbineParts() {
        if (blockTurbinePart == null) {
            BRConfig.CONFIGURATION.load();
            blockTurbinePart = new BlockTurbinePart(BRConfig.CONFIGURATION.getBlock("TurbinePart", 1760).getInt(), Material.field_76243_f);
            GameRegistry.registerBlock((Block)blockTurbinePart, ItemBlockBigReactors.class, (String)"BRTurbinePart");
            OreDictionary.registerOre((String)"turbineHousing", (ItemStack)blockTurbinePart.getItemStack("housing"));
            OreDictionary.registerOre((String)"turbineController", (ItemStack)blockTurbinePart.getItemStack("controller"));
            OreDictionary.registerOre((String)"turbinePowerTap", (ItemStack)blockTurbinePart.getItemStack("powerTap"));
            OreDictionary.registerOre((String)"turbineFluidPort", (ItemStack)blockTurbinePart.getItemStack("fluidPort"));
            OreDictionary.registerOre((String)"turbineBearing", (ItemStack)blockTurbinePart.getItemStack("bearing"));
            BRConfig.CONFIGURATION.save();
        }
        if (blockTurbineRotorPart == null) {
            BRConfig.CONFIGURATION.load();
            blockTurbineRotorPart = new BlockTurbineRotorPart(BRConfig.CONFIGURATION.getBlock("TurbineRotorPart", 1761).getInt(), Material.field_76243_f);
            GameRegistry.registerBlock((Block)blockTurbineRotorPart, ItemBlockBigReactors.class, (String)"BRTurbineRotorPart");
            OreDictionary.registerOre((String)"turbineRotorShaft", (ItemStack)blockTurbineRotorPart.getItemStack("rotor"));
            OreDictionary.registerOre((String)"turbineRotorBlade", (ItemStack)blockTurbineRotorPart.getItemStack("blade"));
            BRConfig.CONFIGURATION.save();
        }
    }

    public static void registerSmallMachines(int id, boolean require) {
        if (blockSmallMachine == null) {
            BRConfig.CONFIGURATION.load();
            blockSmallMachine = new BlockBRSmallMachine(BRConfig.CONFIGURATION.getBlock("SmallMachine", 1758).getInt(), Material.field_76243_f);
            GameRegistry.registerBlock((Block)blockSmallMachine, ItemBlockBigReactors.class, (String)"BRSmallMachine");
            OreDictionary.registerOre((String)"brSmallMachineCyaniteProcessor", (ItemStack)((BlockBRSmallMachine)blockSmallMachine).getCyaniteReprocessorItemStack());
            BRConfig.CONFIGURATION.save();
        }
    }

    public static void registerCreativeParts(int id, boolean require) {
        BRConfig.CONFIGURATION.load();
        boolean regCreativeParts = BRConfig.CONFIGURATION.get("General", "registerCreativeMultiblockParts", true, "If true, creative parts for reactors, turbines and other multiblocks will be registered.").getBoolean(true);
        if (regCreativeParts && blockMultiblockCreativePart == null) {
            blockMultiblockCreativePart = new BlockMBCreativePart(BRConfig.CONFIGURATION.getBlock("MultiblockCreativePart", 1762).getInt(), Material.field_76243_f);
            GameRegistry.registerBlock((Block)blockMultiblockCreativePart, ItemBlockBigReactors.class, (String)"BRMultiblockCreativePart");
        }
        BRConfig.CONFIGURATION.save();
    }

    public static void registerFluids(int id, boolean require) {
        if (fluidYelloriumStill == null) {
            BRConfig.CONFIGURATION.load();
            int fluidYelloriumID = BRConfig.CONFIGURATION.getBlock("LiquidYelloriumStill", 1754).getInt();
            fluidYellorium = FluidRegistry.getFluid((String)"yellorium");
            if (fluidYellorium == null) {
                fluidYellorium = new Fluid("yellorium");
                fluidYellorium.setBlockID(fluidYelloriumID);
                fluidYellorium.setDensity(100);
                fluidYellorium.setGaseous(false);
                fluidYellorium.setLuminosity(10);
                fluidYellorium.setRarity(EnumRarity.uncommon);
                fluidYellorium.setTemperature(295);
                fluidYellorium.setViscosity(100);
                fluidYellorium.setUnlocalizedName("bigreactors.yellorium.still");
                FluidRegistry.registerFluid((Fluid)fluidYellorium);
            }
            BlockBRGenericFluid liqY = new BlockBRGenericFluid(fluidYelloriumID, fluidYellorium, "yellorium");
            fluidYelloriumStill = liqY;
            GameRegistry.registerBlock((Block)fluidYelloriumStill, ItemBlock.class, (String)fluidYelloriumStill.func_71917_a());
            fluidYelloriumBucketItem = new ItemBRBucket(BRConfig.CONFIGURATION.getItem("BucketYellorium", 17751).getInt(), liqY.field_71990_ca).func_77655_b("bucket.yellorium").func_77625_d(1).func_77642_a(Item.field_77788_aw);
            BRConfig.CONFIGURATION.save();
        }
        if (fluidCyaniteStill == null) {
            BRConfig.CONFIGURATION.load();
            int fluidCyaniteID = BRConfig.CONFIGURATION.getBlock("LiquidCyaniteStill", 1755).getInt();
            fluidCyanite = FluidRegistry.getFluid((String)"cyanite");
            if (fluidCyanite == null) {
                fluidCyanite = new Fluid("cyanite");
                fluidCyanite.setBlockID(fluidCyaniteID);
                fluidCyanite.setDensity(100);
                fluidCyanite.setGaseous(false);
                fluidCyanite.setLuminosity(6);
                fluidCyanite.setRarity(EnumRarity.uncommon);
                fluidCyanite.setTemperature(295);
                fluidCyanite.setViscosity(100);
                fluidCyanite.setUnlocalizedName("bigreactors.cyanite.still");
                FluidRegistry.registerFluid((Fluid)fluidCyanite);
            }
            BlockBRGenericFluid liqDY = new BlockBRGenericFluid(fluidCyaniteID, fluidCyanite, "cyanite");
            fluidCyaniteStill = liqDY;
            GameRegistry.registerBlock((Block)fluidCyaniteStill, ItemBlock.class, (String)fluidCyaniteStill.func_71917_a());
            fluidCyaniteBucketItem = new ItemBRBucket(BRConfig.CONFIGURATION.getItem("BucketCyanite", 17752).getInt(), liqDY.field_71990_ca).func_77655_b("bucket.cyanite").func_77625_d(1).func_77642_a(Item.field_77788_aw);
            BRConfig.CONFIGURATION.save();
        }
        if (fluidFuelColumnStill == null) {
            BRConfig.CONFIGURATION.load();
            fluidFuelColumn = FluidRegistry.getFluid((String)"fuelColumn");
            if (fluidFuelColumn == null) {
                fluidFuelColumn = new Fluid("fuelColumn");
                fluidFuelColumn.setUnlocalizedName("bigreactors.fuelColumn.still");
                FluidRegistry.registerFluid((Fluid)fluidFuelColumn);
            }
            BRConfig.CONFIGURATION.save();
        }
        fluidSteam = FluidRegistry.getFluid((String)"steam");
        registeredOwnSteam = false;
        if (fluidSteam == null) {
            BRConfig.CONFIGURATION.load();
            fluidSteam = new Fluid("steam");
            fluidSteam.setUnlocalizedName("steam");
            fluidSteam.setTemperature(1000);
            fluidSteam.setGaseous(true);
            fluidSteam.setLuminosity(0);
            fluidSteam.setRarity(EnumRarity.common);
            fluidSteam.setDensity(6);
            registeredOwnSteam = true;
            FluidRegistry.registerFluid((Fluid)fluidSteam);
            BRConfig.CONFIGURATION.save();
        }
    }

    protected static void registerGameBalanceData() {
        ItemStack yelloriumStack = ingotGeneric.getItemStackForType("ingotYellorium");
        ItemStack cyaniteStack = ingotGeneric.getItemStackForType("ingotCyanite");
        ItemStack blutoniumStack = ingotGeneric.getItemStackForType("ingotBlutonium");
        BRRegistry.registerReactorFluidData("yellorium", new ReactorFuel(fluidYellorium, 12368464, true, false, fluidCyanite));
        BRRegistry.registerReactorFluidData("cyanite", new ReactorFuel(fluidCyanite, 5083829, false, true));
        BRRegistry.registerReactorSolidToFuelMapping(new ReactorSolidMapping(yelloriumStack, new FluidStack(fluidYellorium, 1000)));
        BRRegistry.registerReactorSolidToWasteMapping(new ReactorSolidMapping(cyaniteStack, new FluidStack(fluidCyanite, 1000)));
        ItemStack blockYellorium = blockMetal.getItemStackForMaterial("Yellorium");
        BRRegistry.registerReactorSolidToFuelMapping(new ReactorSolidMapping(blockYellorium, new FluidStack(fluidYellorium, 9000)));
        BRRegistry.registerReactorFluidToSolidMapping(fluidYellorium.getName(), yelloriumStack);
        BRRegistry.registerReactorFluidToSolidMapping(fluidCyanite.getName(), cyaniteStack);
        Fluid fluidBlutonium = fluidYellorium;
        BRRegistry.registerReactorSolidToFuelMapping(new ReactorSolidMapping(blutoniumStack, new FluidStack(fluidBlutonium, 1000)));
        ItemStack blockBlutonium = blockMetal.getItemStackForMaterial("Blutonium");
        BRRegistry.registerReactorSolidToFuelMapping(new ReactorSolidMapping(blockBlutonium, new FluidStack(fluidBlutonium, 9000)));
        BRConfig.CONFIGURATION.load();
        boolean enableFantasyMetals = BRConfig.CONFIGURATION.get("General", "enableMetallurgyFantasyMetalsInTurbines", true, "If true, allows Metallurgy's fantasy metals to be used as part of turbine coils. Default: true").getBoolean(true);
        boolean enableComedy = BRConfig.CONFIGURATION.get("General", "enableComedy", true, "If true, allows weird stuff inside reactors, like MFR sewage and pink slime. Default: true").getBoolean(true);
        BRConfig.CONFIGURATION.save();
        BRRegistry.registerCoilPart("blockIron", 1.0f, 1.0f, 1.0f);
        BRRegistry.registerCoilPart("blockGold", 2.0f, 1.0f, 1.75f);
        BRRegistry.registerCoilPart("blockCopper", 1.2f, 1.0f, 1.2f);
        BRRegistry.registerCoilPart("blockOsmium", 1.2f, 1.0f, 1.2f);
        BRRegistry.registerCoilPart("blockBrass", 1.4f, 1.0f, 1.2f);
        BRRegistry.registerCoilPart("blockBronze", 1.4f, 1.0f, 1.2f);
        BRRegistry.registerCoilPart("blockAluminum", 1.5f, 1.0f, 1.3f);
        BRRegistry.registerCoilPart("blockSteel", 1.5f, 1.0f, 1.3f);
        BRRegistry.registerCoilPart("blockInvar", 1.5f, 1.0f, 1.4f);
        BRRegistry.registerCoilPart("blockSilver", 1.7f, 1.0f, 1.5f);
        BRRegistry.registerCoilPart("blockElectrum", 2.5f, 1.0f, 2.0f);
        BRRegistry.registerCoilPart("blockElectrumFlux", 2.5f, 1.01f, 2.2f);
        BRRegistry.registerCoilPart("blockPlatinum", 3.0f, 1.0f, 2.5f);
        BRRegistry.registerCoilPart("blockShiny", 3.0f, 1.0f, 2.5f);
        BRRegistry.registerCoilPart("blockTitanium", 3.1f, 1.0f, 2.7f);
        BRRegistry.registerCoilPart("blockEnderium", 3.0f, 1.02f, 3.0f);
        if (enableFantasyMetals) {
            BRRegistry.registerCoilPart("blockMithril", 2.2f, 1.0f, 1.5f);
            BRRegistry.registerCoilPart("blockOrichalcum", 2.3f, 1.0f, 1.7f);
            BRRegistry.registerCoilPart("blockQuicksilver", 2.6f, 1.0f, 1.8f);
            BRRegistry.registerCoilPart("blockHaderoth", 3.0f, 1.0f, 2.0f);
            BRRegistry.registerCoilPart("blockCelenegil", 3.3f, 1.0f, 2.25f);
            BRRegistry.registerCoilPart("blockTartarite", 3.5f, 1.0f, 2.5f);
        }
        BRRegistry.registerReactorInteriorBlock("blockIron", 0.5f, 0.75f, 1.4f, 0.6f);
        BRRegistry.registerReactorInteriorBlock("blockGold", 0.52f, 0.8f, 1.45f, 2.0f);
        BRRegistry.registerReactorInteriorBlock("blockDiamond", 0.55f, 0.85f, 1.5f, 3.0f);
        BRRegistry.registerReactorInteriorBlock("blockEmerald", 0.55f, 0.85f, 1.5f, 2.5f);
        BRRegistry.registerReactorInteriorBlock("blockGraphite", 0.1f, 0.5f, 2.0f, 2.0f);
        BRRegistry.registerReactorInteriorBlock("glass", 0.2f, 0.25f, 1.1f, 0.3f);
        BRRegistry.registerReactorInteriorBlock("blockIce", 0.33f, 0.33f, 1.15f, 0.1f);
        BRRegistry.registerReactorInteriorBlock("blockSnow", 0.15f, 0.33f, 1.05f, 0.05f);
        BRRegistry.registerReactorInteriorBlock("blockCopper", 0.5f, 0.75f, 1.4f, 1.0f);
        BRRegistry.registerReactorInteriorBlock("blockOsmium", 0.51f, 0.77f, 1.41f, 1.0f);
        BRRegistry.registerReactorInteriorBlock("blockBrass", 0.51f, 0.77f, 1.41f, 1.0f);
        BRRegistry.registerReactorInteriorBlock("blockBronze", 0.51f, 0.77f, 1.41f, 1.0f);
        BRRegistry.registerReactorInteriorBlock("blockAluminum", 0.5f, 0.78f, 1.42f, 0.6f);
        BRRegistry.registerReactorInteriorBlock("blockSteel", 0.5f, 0.78f, 1.42f, 0.6f);
        BRRegistry.registerReactorInteriorBlock("blockInvar", 0.5f, 0.79f, 1.43f, 0.6f);
        BRRegistry.registerReactorInteriorBlock("blockSilver", 0.51f, 0.79f, 1.43f, 1.5f);
        BRRegistry.registerReactorInteriorBlock("blockElectrum", 0.53f, 0.82f, 1.47f, 2.2f);
        BRRegistry.registerReactorInteriorBlock("blockElectrumFlux", 0.54f, 0.83f, 1.48f, 2.4f);
        BRRegistry.registerReactorInteriorBlock("blockPlatinum", 0.57f, 0.86f, 1.58f, 2.5f);
        BRRegistry.registerReactorInteriorBlock("blockShiny", 0.57f, 0.86f, 1.58f, 2.5f);
        BRRegistry.registerReactorInteriorBlock("blockTitanium", 0.58f, 0.87f, 1.59f, 2.7f);
        BRRegistry.registerReactorInteriorBlock("blockEnderium", 0.6f, 0.88f, 1.6f, 3.0f);
        if (enableFantasyMetals) {
            BRRegistry.registerReactorInteriorBlock("blockMithril", 0.53f, 0.81f, 1.45f, 1.5f);
            BRRegistry.registerReactorInteriorBlock("blockOrichalcum", 0.52f, 0.83f, 1.46f, 1.7f);
            BRRegistry.registerReactorInteriorBlock("blockQuicksilver", 0.53f, 0.84f, 1.48f, 2.0f);
            BRRegistry.registerReactorInteriorBlock("blockHaderoth", 0.54f, 0.84f, 1.49f, 2.5f);
            BRRegistry.registerReactorInteriorBlock("blockCelenegil", 0.54f, 0.84f, 1.49f, 3.0f);
            BRRegistry.registerReactorInteriorBlock("blockTartarite", 0.65f, 0.9f, 1.62f, 4.0f);
        }
        BRRegistry.registerReactorInteriorFluid("water", RadiationHelper.waterData.absorption, RadiationHelper.waterData.heatEfficiency, RadiationHelper.waterData.moderation, 0.1f);
        BRRegistry.registerReactorInteriorFluid("redstone", 0.75f, 0.55f, 1.6f, 2.5f);
        BRRegistry.registerReactorInteriorFluid("glowstone", 0.2f, 0.6f, 1.75f, 1.0f);
        BRRegistry.registerReactorInteriorFluid("cryotheum", 0.66f, 0.95f, 6.0f, 3.0f);
        BRRegistry.registerReactorInteriorFluid("ender", 0.9f, 0.75f, 2.0f, 2.0f);
        BRRegistry.registerReactorInteriorFluid("pyrotheum", 0.66f, 0.9f, 1.0f, 0.6f);
        BRRegistry.registerReactorInteriorFluid("life essence", 0.7f, 0.55f, 1.75f, 2.0f);
        if (enableComedy) {
            BRRegistry.registerReactorInteriorBlock("blockMeat", 0.5f, 0.33f, 1.33f, 0.15f);
            BRRegistry.registerReactorInteriorBlock("blockMeatRaw", 0.4f, 0.5f, 1.5f, 0.15f);
            BRRegistry.registerReactorInteriorFluid("meat", 0.4f, 0.6f, 1.33f, 0.15f);
            BRRegistry.registerReactorInteriorFluid("pinkSlime", 0.45f, 0.7f, 1.5f, 0.6f);
            BRRegistry.registerReactorInteriorFluid("sewage", 0.5f, 0.65f, 1.44f, 0.6f);
        }
    }

    public static int loadLanguages(String languagePath, String[] languageSupported) {
        int languages = 0;
        for (String language : languageSupported) {
            LanguageRegistry.instance().loadLocalization(languagePath + language + ".properties", language, false);
            if (LanguageRegistry.instance().getStringLocalization("children", language) != "") {
                try {
                    String[] children;
                    for (String child : children = LanguageRegistry.instance().getStringLocalization("children", language).split(",")) {
                        if (child == "" && child == null) continue;
                        LanguageRegistry.instance().loadLocalization(languagePath + language + ".properties", child, false);
                        ++languages;
                    }
                }
                catch (Exception e) {
                    BRLog.severe("Failed to load a child language file.", new Object[0]);
                    e.printStackTrace();
                }
            }
            ++languages;
        }
        return languages;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerNonBlockFluidIcons(TextureMap map) {
        iconFuelColumnStill = map.func_94245_a("bigreactors:fluid.fuelColumn.still");
        iconFuelColumnFlowing = map.func_94245_a("bigreactors:fluid.fuelColumn.flowing");
        if (registeredOwnSteam) {
            iconSteamStill = map.func_94245_a("bigreactors:fluid.steam.still");
            iconSteamFlowing = map.func_94245_a("bigreactors:fluid.steam.flowing");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void setNonBlockFluidIcons() {
        fluidFuelColumn.setIcons(iconFuelColumnStill, iconFuelColumnFlowing);
        if (registeredOwnSteam) {
            fluidSteam.setIcons(iconSteamStill, iconSteamFlowing);
        }
    }

    static {
        INITIALIZED = false;
        enableWorldGen = true;
        enableWorldGenInNegativeDimensions = false;
        enableWorldRegeneration = true;
        userWorldGenVersion = 0;
        eventHandler = null;
        tickHandler = null;
        worldGenerator = null;
        registeredTileEntities = false;
        maximumReactorSize = -1;
        maximumReactorHeight = -1;
        ticksPerRedstoneUpdate = 20;
        maximumTurbineSize = 16;
        maximumTurbineHeight = 32;
        powerProductionMultiplier = 1.0f;
        fuelUsageMultiplier = 1.0f;
        isValentinesDay = false;
        registerYelloriteSmeltToUranium = true;
        registerYelloriumAsUranium = true;
    }
}

