/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.compatibility.foresty;

import exnihilo.compatibility.foresty.Hive;
import forestry.api.apiculture.FlowerManager;
import forestry.api.core.BlockInterface;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.FluidRegistry;

public class HiveList {
    public static ItemStack beehives;
    public static ItemStack extraBeesHives;
    public static ItemStack magicBeesHives;
    public static Hive forest;
    public static Hive meadow;
    public static Hive desert;
    public static Hive jungle;
    public static Hive end;
    public static Hive snow;
    public static Hive swamp;
    public static Hive water;
    public static Hive rock;
    public static Hive nether;
    public static Hive curious;
    public static Hive resonating;
    public static Hive unusual;
    public static Hive deep;
    public static Hive oblivion;
    public static Hive infernal;

    public static boolean generateForestryHives() {
        beehives = BlockInterface.getBlock((String)"beehives");
        if (beehives != null) {
            HiveList.generateForestHive();
            HiveList.generateMeadowHive();
            HiveList.generateDesertHive();
            HiveList.generateJungleHive();
            HiveList.generateEndHive();
            HiveList.generateSnowHive();
            HiveList.generateSwampHive();
            return true;
        }
        return false;
    }

    public static boolean generateExtreBeesHives() {
        Block ebHives = null;
        for (Block b : Block.field_71973_m) {
            if (b == null || !b.getClass().getName().contains("binnie.extrabees.worldgen.BlockExtraBeeHive")) continue;
            ebHives = b;
        }
        if (ebHives != null) {
            extraBeesHives = new ItemStack(ebHives, 1, 0);
            HiveList.generateWaterHive();
            HiveList.generateRockHive();
            HiveList.generateNetherHive();
            return true;
        }
        return false;
    }

    public static boolean generateMagicBeesHives() {
        Block magicHives = null;
        for (Block b : Block.field_71973_m) {
            if (b == null || !b.getClass().getName().contains("magicbees.block.BlockHive")) continue;
            magicHives = b;
        }
        if (magicHives != null) {
            magicBeesHives = new ItemStack(magicHives, 1, 0);
            HiveList.generateCuriousHive();
            HiveList.generateResonatingHive();
            HiveList.generateUnusualHive();
            HiveList.generateDeepHive();
            HiveList.generateOblivionHive();
            HiveList.generateInfernalHive();
            return true;
        }
        return false;
    }

    private static void generateForestHive() {
        forest = new Hive(HiveList.beehives.field_77993_c, 1);
        HiveList.forest.requiredCanSeeSky = true;
        HiveList.forest.requiresTree = true;
        HiveList.forest.biomeTypes.add(BiomeDictionary.Type.FOREST);
        HiveList.forest.defaultSpawnBonus = 20;
    }

    private static void generateMeadowHive() {
        meadow = new Hive(HiveList.beehives.field_77993_c, 2);
        HiveList.meadow.requiredCanSeeSky = true;
        HiveList.meadow.biomeTypes.add(BiomeDictionary.Type.PLAINS);
        for (ItemStack item : FlowerManager.plainFlowers) {
            HiveList.meadow.flowers.add(item.field_77993_c + ":" + item.func_77960_j());
        }
    }

    private static void generateDesertHive() {
        desert = new Hive(HiveList.beehives.field_77993_c, 3);
        HiveList.desert.requiredCanSeeSky = true;
        HiveList.desert.biomeTypes.add(BiomeDictionary.Type.DESERT);
        HiveList.desert.flowers.add(Block.field_72038_aV.field_71990_ca + ":0");
    }

    public static void generateJungleHive() {
        jungle = new Hive(HiveList.beehives.field_77993_c, 4);
        HiveList.jungle.requiredCanSeeSky = true;
        HiveList.jungle.requiresTree = true;
        HiveList.jungle.biomeTypes.add(BiomeDictionary.Type.JUNGLE);
        HiveList.jungle.flowers.add(Block.field_71998_bu.field_71990_ca + ":0");
        HiveList.jungle.flowers.add(Block.field_71998_bu.field_71990_ca + ":1");
        HiveList.jungle.flowers.add(Block.field_71998_bu.field_71990_ca + ":2");
        HiveList.jungle.flowers.add(Block.field_71998_bu.field_71990_ca + ":3");
        HiveList.jungle.flowers.add(Block.field_71998_bu.field_71990_ca + ":4");
        HiveList.jungle.flowers.add(Block.field_71998_bu.field_71990_ca + ":5");
        HiveList.jungle.flowers.add(Block.field_71998_bu.field_71990_ca + ":6");
        HiveList.jungle.flowers.add(Block.field_71998_bu.field_71990_ca + ":7");
        HiveList.jungle.flowers.add(Block.field_71998_bu.field_71990_ca + ":8");
        HiveList.jungle.flowers.add(Block.field_71998_bu.field_71990_ca + ":9");
        HiveList.jungle.flowers.add(Block.field_71998_bu.field_71990_ca + ":10");
        HiveList.jungle.flowers.add(Block.field_71998_bu.field_71990_ca + ":11");
        HiveList.jungle.flowers.add(Block.field_71998_bu.field_71990_ca + ":12");
        HiveList.jungle.flowers.add(Block.field_71998_bu.field_71990_ca + ":13");
        HiveList.jungle.flowers.add(Block.field_71998_bu.field_71990_ca + ":14");
        HiveList.jungle.flowers.add(Block.field_71998_bu.field_71990_ca + ":15");
    }

    public static void generateEndHive() {
        end = new Hive(HiveList.beehives.field_77993_c, 5);
        HiveList.end.requiredCanSeeSky = true;
        HiveList.end.requiredSubstrate = Block.field_72082_bJ.field_71990_ca + ":0";
        HiveList.end.biomeTypes.add(BiomeDictionary.Type.END);
        HiveList.end.defaultSpawnBonus = -40;
    }

    public static void generateSnowHive() {
        snow = new Hive(HiveList.beehives.field_77993_c, 6);
        HiveList.snow.requiredCanSeeSky = true;
        HiveList.snow.requiredSubstrate = Block.field_72037_aS.field_71990_ca + ":0";
        HiveList.snow.biomeTypes.add(BiomeDictionary.Type.FROZEN);
        for (ItemStack item : FlowerManager.plainFlowers) {
            HiveList.snow.flowers.add(item.field_77993_c + ":" + item.func_77960_j());
        }
    }

    public static void generateSwampHive() {
        swamp = new Hive(HiveList.beehives.field_77993_c, 7);
        HiveList.swamp.requiredCanSeeSky = true;
        HiveList.swamp.biomeTypes.add(BiomeDictionary.Type.SWAMP);
        HiveList.swamp.flowers.add(Block.field_72109_af.field_71990_ca + ":0");
        HiveList.swamp.flowers.add(Block.field_72103_ag.field_71990_ca + ":0");
    }

    public static void generateWaterHive() {
        water = new Hive(HiveList.extraBeesHives.field_77993_c, 0);
        HiveList.water.biomeTypes.add(BiomeDictionary.Type.WATER);
        HiveList.water.requiredSubstrate = FluidRegistry.WATER.getBlockID() + ":0";
        HiveList.water.requiresBlockAbove = FluidRegistry.WATER.getBlockID() + ":0";
        HiveList.water.flowers.add(Block.field_71991_bz.field_71990_ca + ":0");
    }

    public static void generateRockHive() {
        rock = new Hive(HiveList.extraBeesHives.field_77993_c, 1);
        HiveList.rock.requiredCanSeeSky = false;
        HiveList.rock.requiredSubstrate = Block.field_71981_t.field_71990_ca + ":0";
        HiveList.rock.defaultSpawnBonus = -20;
    }

    public static void generateNetherHive() {
        nether = new Hive(HiveList.extraBeesHives.field_77993_c, 2);
        HiveList.nether.requiredCanSeeSky = false;
        HiveList.nether.biomeTypes.add(BiomeDictionary.Type.NETHER);
        HiveList.nether.requiredSubstrate = Block.field_72012_bb.field_71990_ca + ":0";
        HiveList.nether.flowers.add(Block.field_72094_bD.field_71990_ca + ":0");
        HiveList.nether.flowers.add(Block.field_72094_bD.field_71990_ca + ":1");
        HiveList.nether.flowers.add(Block.field_72094_bD.field_71990_ca + ":2");
        HiveList.nether.flowers.add(Block.field_72094_bD.field_71990_ca + ":4");
    }

    public static void generateCuriousHive() {
        curious = new Hive(HiveList.magicBeesHives.field_77993_c, 0);
        HiveList.curious.requiredCanSeeSky = true;
        HiveList.curious.biomeTypes.add(BiomeDictionary.Type.FOREST);
        HiveList.curious.requiresTree = true;
        for (ItemStack item : FlowerManager.plainFlowers) {
            HiveList.curious.flowers.add(item.field_77993_c + ":" + item.func_77960_j());
        }
    }

    public static void generateResonatingHive() {
        resonating = new Hive(HiveList.magicBeesHives.field_77993_c, 2);
        HiveList.resonating.requiredCanSeeSky = true;
        HiveList.resonating.biomeTypes.add(BiomeDictionary.Type.DESERT);
        for (ItemStack item : FlowerManager.plainFlowers) {
            HiveList.resonating.flowers.add(item.field_77993_c + ":" + item.func_77960_j());
        }
    }

    public static void generateUnusualHive() {
        unusual = new Hive(HiveList.magicBeesHives.field_77993_c, 1);
        HiveList.unusual.requiredCanSeeSky = true;
        HiveList.unusual.biomeTypes.add(BiomeDictionary.Type.JUNGLE);
        for (ItemStack item : FlowerManager.plainFlowers) {
            HiveList.unusual.flowers.add(item.field_77993_c + ":" + item.func_77960_j());
        }
    }

    public static void generateDeepHive() {
        deep = new Hive(HiveList.magicBeesHives.field_77993_c, 3);
        HiveList.deep.requiredCanSeeSky = false;
        HiveList.deep.biomeTypes.add(BiomeDictionary.Type.MOUNTAIN);
        HiveList.deep.maxYLevel = Float.valueOf(15.0f);
        for (ItemStack item : FlowerManager.plainFlowers) {
            HiveList.deep.flowers.add(item.field_77993_c + ":" + item.func_77960_j());
        }
    }

    public static void generateOblivionHive() {
        oblivion = new Hive(HiveList.magicBeesHives.field_77993_c, 5);
        HiveList.oblivion.requiredCanSeeSky = false;
        HiveList.oblivion.biomeTypes.add(BiomeDictionary.Type.END);
        HiveList.oblivion.requiredSubstrate = Block.field_72082_bJ.field_71990_ca + ":0";
        HiveList.oblivion.defaultSpawnBonus = -40;
    }

    public static void generateInfernalHive() {
        infernal = new Hive(HiveList.magicBeesHives.field_77993_c, 4);
        HiveList.infernal.requiredCanSeeSky = false;
        HiveList.infernal.biomeTypes.add(BiomeDictionary.Type.NETHER);
        HiveList.infernal.maxYLevel = Float.valueOf(15.0f);
        HiveList.infernal.requiredSubstrate = Block.field_72012_bb.field_71990_ca + ":0";
        HiveList.oblivion.defaultSpawnBonus = -40;
    }
}

