/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.blocks.renderers.blockItems;

import exnihilo.blocks.BlockSieve;
import exnihilo.blocks.models.ModelSieve;
import exnihilo.blocks.models.ModelSieveMesh;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemRenderSieve
implements IItemRenderer {
    private ModelSieve model;
    private ModelSieveMesh mesh;

    public ItemRenderSieve(ModelSieve model, ModelSieveMesh mesh) {
        this.model = model;
        this.mesh = mesh;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: {
                break;
            }
            case EQUIPPED: {
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                break;
            }
            case FIRST_PERSON_MAP: {
                return false;
            }
        }
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        switch (type) {
            case ENTITY: {
                break;
            }
            case EQUIPPED: {
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                break;
            }
            case FIRST_PERSON_MAP: {
                return false;
            }
        }
        switch (helper) {
            case BLOCK_3D: {
                break;
            }
            case ENTITY_BOBBING: {
                break;
            }
            case ENTITY_ROTATION: {
                break;
            }
            case EQUIPPED_BLOCK: {
                break;
            }
            case INVENTORY_BLOCK: {
                break;
            }
        }
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        this.renderTable(type, item);
        this.renderMesh(type);
    }

    private void renderTable(IItemRenderer.ItemRenderType type, ItemStack item) {
        GL11.glPushMatrix();
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        switch (type) {
            case EQUIPPED: {
                GL11.glTranslatef((float)-0.5f, (float)-1.5f, (float)0.5f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                GL11.glTranslatef((float)0.0f, (float)-1.6f, (float)0.6f);
                break;
            }
            case ENTITY: {
                GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
                break;
            }
            case INVENTORY: {
                GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
                break;
            }
            default: {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
            }
        }
        this.bindTexture(item.func_77960_j());
        this.model.simpleRender(0.0625f);
        GL11.glPopMatrix();
    }

    private void renderMesh(IItemRenderer.ItemRenderType type) {
        GL11.glPushMatrix();
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        switch (type) {
            case EQUIPPED: {
                GL11.glTranslatef((float)-0.5f, (float)-0.69f, (float)0.5f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                GL11.glTranslatef((float)-0.5f, (float)-0.79f, (float)0.5f);
                break;
            }
            case ENTITY: {
                GL11.glTranslatef((float)0.0f, (float)-0.2f, (float)0.0f);
                break;
            }
            case INVENTORY: {
                GL11.glTranslatef((float)0.0f, (float)-0.2f, (float)0.0f);
                break;
            }
            default: {
                GL11.glTranslatef((float)0.0f, (float)-0.2f, (float)0.0f);
            }
        }
        this.bindMeshTexture();
        this.mesh.render(BlockSieve.meshIcon);
        GL11.glPopMatrix();
    }

    protected void bindTexture(int meta) {
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        if (texturemanager != null && meta >= 0) {
            texturemanager.func_110577_a(ModelSieve.textures[meta]);
        }
    }

    protected void bindMeshTexture() {
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        if (texturemanager != null) {
            texturemanager.func_110577_a(TextureMap.field_110575_b);
        }
    }
}

