/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.blocks.renderers;

import exnihilo.blocks.BlockBarrel;
import exnihilo.blocks.BlockBeeTrapTreated;
import exnihilo.blocks.models.ModelBarrel;
import exnihilo.blocks.models.ModelBarrelInternal;
import exnihilo.blocks.tileentities.TileEntityBarrel;
import exnihilo.registries.ColorRegistry;
import exnihilo.registries.helpers.Color;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

public class RenderBarrel
extends TileEntitySpecialRenderer {
    private ModelBarrel barrel;
    private ModelBarrelInternal internal;

    public RenderBarrel(ModelBarrel model) {
        this.barrel = model;
        this.internal = new ModelBarrelInternal();
    }

    public void func_76894_a(TileEntity tileentity, double x, double y, double z, float f) {
        this.drawBarrel(tileentity, x, y, z, f);
        this.drawBarrelContents(tileentity, x, y, z, f);
    }

    private void drawBarrel(TileEntity tileentity, double x, double y, double z, float f) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GL11.glScalef((float)-0.8f, (float)-1.0f, (float)0.8f);
        this.bindBarrelTexture(tileentity.func_70311_o().field_71990_ca, tileentity.func_70322_n());
        this.barrel.simpleRender(0.0625f);
        GL11.glPopMatrix();
    }

    private void drawBarrelContents(TileEntity tileentity, double x, double y, double z, float f) {
        TileEntityBarrel barrel = (TileEntityBarrel)tileentity;
        if (barrel.getMode() != TileEntityBarrel.BarrelMode.EMPTY) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + barrel.getAdjustedVolume()), (float)((float)z + 0.5f));
            GL11.glScalef((float)0.8f, (float)1.0f, (float)0.8f);
            this.bindInternalTexture();
            Fluid content = barrel.fluid.getFluid();
            Icon icon = content.getIcon();
            Color color = barrel.color;
            boolean transparency = false;
            boolean clouds = false;
            boolean trap = false;
            switch (barrel.getMode()) {
                case COMPOST: {
                    icon = BlockBarrel.iconCompost;
                    break;
                }
                case FLUID: {
                    color = new Color(content.getColor());
                    transparency = true;
                    break;
                }
                case DIRT: {
                    icon = Block.field_71979_v.func_71858_a(0, 0);
                    break;
                }
                case CLAY: {
                    icon = Block.field_72041_aW.func_71858_a(0, 0);
                    break;
                }
                case SPORED: {
                    clouds = true;
                    transparency = true;
                    break;
                }
                case SLIME: {
                    clouds = true;
                    transparency = true;
                    break;
                }
                case NETHERRACK: {
                    icon = Block.field_72012_bb.func_71858_a(0, 0);
                    break;
                }
                case ENDSTONE: {
                    icon = Block.field_72082_bJ.func_71858_a(0, 0);
                    break;
                }
                case MILKED: {
                    transparency = true;
                    clouds = true;
                    break;
                }
                case BEETRAP: {
                    transparency = true;
                    trap = true;
                    break;
                }
                case SOULSAND: {
                    icon = Block.field_72013_bc.func_71858_a(0, 0);
                    break;
                }
                case OBSIDIAN: {
                    icon = Block.field_72089_ap.func_71858_a(0, 0);
                    break;
                }
                case COBBLESTONE: {
                    icon = Block.field_71978_w.func_71858_a(0, 0);
                    break;
                }
                case BLAZE_COOKING: {
                    color = new Color(content.getColor());
                    transparency = true;
                    break;
                }
                case BLAZE: {
                    color = new Color(content.getColor());
                    transparency = true;
                    break;
                }
                case ENDER_COOKING: {
                    color = new Color(content.getColor());
                    transparency = true;
                    break;
                }
                case ENDER: {
                    color = new Color(content.getColor());
                    transparency = true;
                    break;
                }
            }
            if (clouds) {
                GL11.glTranslatef((float)0.0f, (float)-1.0E-4f, (float)0.0f);
                this.internal.render(ColorRegistry.color("black"), BlockBarrel.iconClouds, transparency);
                GL11.glTranslatef((float)0.0f, (float)1.0E-4f, (float)0.0f);
            }
            if (trap) {
                GL11.glTranslatef((float)0.0f, (float)-0.05f, (float)0.0f);
                this.internal.render(ColorRegistry.color("white"), BlockBeeTrapTreated.topIcon, false);
                GL11.glTranslatef((float)0.0f, (float)0.05f, (float)0.0f);
            }
            this.internal.render(color, icon, transparency);
            GL11.glPopMatrix();
        }
    }

    public void bindBarrelTexture(int blockID, int meta) {
        if (meta >= 0) {
            this.func_110628_a(this.barrel.getBarrelTexture(blockID, meta));
        }
    }

    public void bindInternalTexture() {
        ResourceLocation fluidTexture = TextureMap.field_110575_b;
        this.func_110628_a(fluidTexture);
    }
}

