/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.worldgen.retro;

import java.io.Serializable;
import mods.natura.worldgen.retro.BlockHelper;
import net.minecraft.tileentity.TileEntity;

public final class BlockCoord
implements Comparable<BlockCoord>,
Serializable {
    public int x;
    public int y;
    public int z;

    public BlockCoord(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockCoord(TileEntity tile) {
        this.x = tile.field_70329_l;
        this.y = tile.field_70330_m;
        this.z = tile.field_70327_n;
    }

    public void step(int dir) {
        this.x += BlockHelper.SIDE_COORD_MOD[dir][0];
        this.y += BlockHelper.SIDE_COORD_MOD[dir][1];
        this.z += BlockHelper.SIDE_COORD_MOD[dir][2];
    }

    public void step(int dir, int dist) {
        switch (dir) {
            case 0: {
                this.y -= dist;
                break;
            }
            case 1: {
                this.y += dist;
                break;
            }
            case 2: {
                this.z -= dist;
                break;
            }
            case 3: {
                this.z += dist;
                break;
            }
            case 4: {
                this.x -= dist;
                break;
            }
            case 5: {
                this.x += dist;
                break;
            }
        }
    }

    public BlockCoord copy() {
        return new BlockCoord(this.x, this.y, this.z);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlockCoord)) {
            return false;
        }
        BlockCoord other = (BlockCoord)obj;
        return this.x == other.x && this.y == other.y && this.z == other.z;
    }

    public int hashCode() {
        int hash = this.x;
        hash *= 31 + this.y;
        return hash *= 31 + this.z;
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    @Override
    public int compareTo(BlockCoord other) {
        return this.x == other.x ? (this.y == other.y ? this.z - other.z : this.y - other.y) : this.x - other.x;
    }
}

