/*
 * Decompiled with CFR 0.152.
 */
package squeek.tictooltips;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import squeek.tictooltips.ModTiCTooltips;
import squeek.tictooltips.helpers.ArmorHelper;
import squeek.tictooltips.helpers.ColorHelper;
import squeek.tictooltips.helpers.KeyHelper;
import squeek.tictooltips.helpers.PatternHelper;
import squeek.tictooltips.helpers.StringHelper;
import squeek.tictooltips.helpers.ToolHelper;
import squeek.tictooltips.helpers.ToolPartHelper;
import squeek.tictooltips.proxy.ProxyIguanaTweaks;
import tconstruct.items.Bowstring;
import tconstruct.items.Fletching;
import tconstruct.items.ToolPart;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.armor.ArmorCore;
import tconstruct.library.tools.ArrowMaterial;
import tconstruct.library.tools.BowMaterial;
import tconstruct.library.tools.BowstringMaterial;
import tconstruct.library.tools.FletchingMaterial;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.util.IPattern;
import tconstruct.library.util.IToolPart;

public class TooltipHandler {
    @ForgeSubscribe
    public void onItemTooltip(ItemTooltipEvent event) {
        if (event.entityPlayer == null) {
            return;
        }
        Item item = event.itemStack.func_77973_b();
        if (item instanceof IToolPart) {
            if (ToolPartHelper.isShard(item)) {
                return;
            }
            if (ModTiCTooltips.hasIguanaTweaks) {
                if (ToolPartHelper.isArrowFletching(item) || ToolPartHelper.isBowString(item)) {
                    event.toolTip.addAll(this.getMaterialTooltip(event.itemStack));
                } else if (ProxyIguanaTweaks.isModdedPart(item)) {
                    event.toolTip.addAll(ProxyIguanaTweaks.getPartTooltip(event.itemStack, event.entityPlayer, event.showAdvancedItemTooltips));
                }
            } else {
                event.toolTip.addAll(this.getMaterialTooltip(event.itemStack));
            }
        } else if (item instanceof IPattern && !ModTiCTooltips.hasIguanaTweaks) {
            event.toolTip.addAll(this.getPatternTooltip(event.itemStack));
        } else if (item instanceof ToolCore && ToolHelper.hasToolTag(event.itemStack)) {
            ArrayList tinkersTooltip = new ArrayList();
            String plusPrefix = "\u00a79+";
            int toolTipIndex = 0;
            if (event.toolTip.size() > 1) {
                toolTipIndex = -1;
                if (((String)event.toolTip.get(event.toolTip.size() - 1)).startsWith(plusPrefix)) {
                    toolTipIndex = event.toolTip.size() - 1;
                } else if (event.itemStack.func_77948_v()) {
                    NBTTagList enchantTagList = event.itemStack.func_77986_q();
                    short enchantID = ((NBTTagCompound)enchantTagList.func_74743_b(0)).func_74765_d("id");
                    short enchantLevel = ((NBTTagCompound)enchantTagList.func_74743_b(0)).func_74765_d("lvl");
                    String enchantName = Enchantment.field_77331_b[enchantID].func_77316_c((int)enchantLevel);
                    toolTipIndex = event.toolTip.indexOf(enchantName);
                } else {
                    for (int toolTipSearchIndex = 0; toolTipSearchIndex < event.toolTip.size(); ++toolTipSearchIndex) {
                        if (!((String)event.toolTip.get(toolTipSearchIndex)).startsWith(plusPrefix)) continue;
                        toolTipIndex = toolTipSearchIndex;
                        break;
                    }
                }
                if (toolTipIndex == -1) {
                    ((ToolCore)item).func_77624_a(event.itemStack, event.entityPlayer, tinkersTooltip, event.showAdvancedItemTooltips);
                    int n = toolTipIndex = tinkersTooltip.size() > 0 ? Math.min(event.toolTip.size(), event.toolTip.indexOf(tinkersTooltip.get(0)) + tinkersTooltip.size()) : event.toolTip.size();
                }
            }
            while (toolTipIndex > 1 && ((String)event.toolTip.get(toolTipIndex - 1)).startsWith(plusPrefix)) {
                --toolTipIndex;
            }
            while (toolTipIndex > 1 && ((String)event.toolTip.get(toolTipIndex - 1)).equals("")) {
                event.toolTip.remove(toolTipIndex - 1);
                --toolTipIndex;
            }
            boolean ctrlDown = KeyHelper.isCtrlKeyDown();
            boolean shiftDown = KeyHelper.isShiftKeyDown();
            if (shiftDown && !ctrlDown) {
                if (toolTipIndex > 1) {
                    event.toolTip.add(toolTipIndex++, "");
                }
                List<String> toolStats = this.getToolStatsTooltip(event.itemStack);
                event.toolTip.addAll(toolTipIndex, toolStats);
                if ((toolTipIndex += toolStats.size()) >= event.toolTip.size() || !((String)event.toolTip.get(toolTipIndex)).equals("")) {
                    event.toolTip.add(toolTipIndex++, "");
                }
            } else if (ctrlDown) {
                while (event.toolTip.size() > 1) {
                    event.toolTip.remove(1);
                }
                toolTipIndex = event.toolTip.size();
                List<String> toolMaterials = this.getToolMaterialsTooltip(event.itemStack);
                event.toolTip.addAll(toolTipIndex, toolMaterials);
                toolTipIndex += toolMaterials.size();
            } else {
                event.toolTip.add(toolTipIndex++, StatCollector.func_74837_a((String)"tictooltips.hold.key.for.stats", (Object[])new Object[]{EnumChatFormatting.YELLOW.toString() + EnumChatFormatting.ITALIC + "Shift" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY}));
                event.toolTip.add(toolTipIndex++, StatCollector.func_74837_a((String)"tictooltips.hold.key.for.materials", (Object[])new Object[]{EnumChatFormatting.DARK_AQUA.toString() + EnumChatFormatting.ITALIC + "Ctrl" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY}));
            }
        } else if (item instanceof ArmorCore && ArmorHelper.hasArmorTag(event.itemStack)) {
            int toolTipIndex;
            for (toolTipIndex = Math.min(1, event.toolTip.size()); toolTipIndex < event.toolTip.size() && !((String)event.toolTip.get(toolTipIndex)).equals(""); ++toolTipIndex) {
            }
            event.toolTip.addAll(toolTipIndex, this.getArmorStatsTooltip(event.itemStack));
        }
    }

    private List<String> getMaterialTooltip(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        int matID = ((IToolPart)item).getMaterialID(itemStack);
        return this.getMaterialTooltip(matID, item);
    }

    private List<String> getMaterialTooltip(int matID, Item item) {
        return this.getMaterialTooltip(matID, item, null);
    }

    private List<String> getMaterialTooltip(int matID, Item item, ToolCore tool) {
        boolean hasTool;
        ArrayList<String> toolTip = new ArrayList<String>();
        ToolMaterial mat = TConstructRegistry.getMaterial((int)matID);
        boolean bl = hasTool = tool != null;
        if (mat == null) {
            return toolTip;
        }
        if (!mat.ability().equals("")) {
            toolTip.add(mat.style() + mat.ability());
        }
        if (mat.shoddy() != 0.0f) {
            for (int index = 0; index < toolTip.size(); ++index) {
                if (!((String)toolTip.get(index)).contains(StringHelper.getShoddinessTypeString(mat.shoddy()))) continue;
                toolTip.set(index, (String)toolTip.get(index) + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"tictooltips.material.shoddiness.modifier", (Object[])new Object[]{ToolPartHelper.getShoddinessString(mat.shoddy()) + EnumChatFormatting.RESET + EnumChatFormatting.GRAY}));
                break;
            }
        }
        if (ToolPartHelper.isArrowHead(item)) {
            ArrowMaterial arrowMat = TConstructRegistry.getArrowMaterial((int)matID);
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation3") + ToolPartHelper.getAttackString(mat.attack()));
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation9") + ToolPartHelper.getAccuracyString(arrowMat.accuracy));
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation8") + ToolPartHelper.getWeightString(arrowMat.mass / 5.0f));
        } else if (ToolPartHelper.isArrowFletching(item)) {
            FletchingMaterial fletchingMat = (FletchingMaterial)TConstructRegistry.getCustomMaterial((int)matID, FletchingMaterial.class);
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation9") + ToolPartHelper.getAccuracyString(fletchingMat.accuracy));
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation8") + ToolPartHelper.getWeightString(fletchingMat.mass));
        } else if (ToolPartHelper.isBowString(item)) {
            BowstringMaterial bowstringMat = (BowstringMaterial)TConstructRegistry.getCustomMaterial((int)matID, BowstringMaterial.class);
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation6") + ToolPartHelper.getBowStringDrawspeedModifierString(bowstringMat.drawspeedModifier));
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation2") + ToolPartHelper.getBowStringDurabilityModifierString(bowstringMat.durabilityModifier));
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation7") + ToolPartHelper.getBowStringArrowSpeedModifierString(bowstringMat.flightSpeedModifier));
        } else {
            if (mat.reinforced() > 0) {
                toolTip.add(mat.style() + StringHelper.getReinforcedString(mat.reinforced()));
            }
            if (ToolPartHelper.isRod(item)) {
                boolean isToolABow;
                boolean isArrowMat = ToolPartHelper.isArrowRod(item);
                boolean isToolAnArrow = hasTool && ToolHelper.isAmmoTool(tool);
                boolean bl2 = isToolABow = hasTool && ToolHelper.isBowTool(tool);
                if (hasTool && (isToolAnArrow || isToolABow) || isArrowMat && KeyHelper.isShiftKeyDown()) {
                    String prefix;
                    if (TConstructRegistry.validBowMaterial((int)matID) && (!hasTool || isToolABow)) {
                        prefix = hasTool ? "" : "Bow ";
                        BowMaterial bowMat = TConstructRegistry.getBowMaterial((int)matID);
                        toolTip.add(prefix + StringHelper.getLocalizedString("gui.toolstation3") + ToolPartHelper.getAttackString(mat.attack()));
                        toolTip.add(prefix + StringHelper.getLocalizedString("gui.toolstation6") + ToolPartHelper.getBowDrawSpeedString(bowMat.drawspeed));
                        toolTip.add(prefix + StringHelper.getLocalizedString("gui.toolstation2") + ToolPartHelper.getBowDurabilityString(bowMat.durability));
                        toolTip.add(prefix + StringHelper.getLocalizedString("gui.toolstation7") + ToolPartHelper.getBowArrowSpeedModifierString(bowMat.flightSpeedMax));
                    }
                    if (TConstructRegistry.validArrowMaterial((int)matID) && (!hasTool || isToolAnArrow)) {
                        prefix = hasTool ? "" : StringHelper.getLocalizedString("item.InfiTool.Arrow.name") + " ";
                        ArrowMaterial arrowMat = TConstructRegistry.getArrowMaterial((int)matID);
                        toolTip.add(prefix + StringHelper.getLocalizedString("gui.toolstation8") + ToolPartHelper.getWeightString(arrowMat.mass));
                    }
                } else {
                    toolTip.add(StringHelper.getLocalizedString("gui.partcrafter5") + ToolPartHelper.getHandleModifierString(mat.handleModifier));
                    if (!hasTool && isArrowMat) {
                        toolTip.add(StatCollector.func_74837_a((String)"tictooltips.hold.key.for.bow.stats", (Object[])new Object[]{EnumChatFormatting.YELLOW.toString() + EnumChatFormatting.ITALIC + "Shift" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY}));
                    }
                }
            } else if (ToolPartHelper.isToolHead(item)) {
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation2") + ToolPartHelper.getDurabilityString(mat.durability()));
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation14") + ToolPartHelper.getMiningSpeedString(mat.toolSpeed()));
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation15") + ToolPartHelper.getHarvestLevelString(mat.harvestLevel()));
            } else if (ToolPartHelper.isWeaponMiningHead(item)) {
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation2") + ToolPartHelper.getDurabilityString(mat.durability()));
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation14") + ToolPartHelper.getMiningSpeedString(mat.toolSpeed()));
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation15") + ToolPartHelper.getHarvestLevelString(mat.harvestLevel()));
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation3") + ToolPartHelper.getAttackString(mat.attack()));
            } else if (ToolPartHelper.isWeaponToolHead(item)) {
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation2") + ToolPartHelper.getDurabilityString(mat.durability()));
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation16") + ToolPartHelper.getMiningSpeedString(mat.toolSpeed()));
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation3") + ToolPartHelper.getAttackString(mat.attack()));
            } else if (ToolPartHelper.isChiselHead(item)) {
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation2") + ToolPartHelper.getDurabilityString(mat.durability()));
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation16") + ToolPartHelper.getMiningSpeedString(mat.toolSpeed()));
            } else if (ToolPartHelper.isWeaponHead(item)) {
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation3") + ToolPartHelper.getAttackString(mat.attack()));
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation2") + ToolPartHelper.getDurabilityString(mat.durability()));
            } else if (ToolPartHelper.isPlate(item)) {
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation2") + ToolPartHelper.getDurabilityString(mat.durability()));
                if (!hasTool || ToolHelper.isHarvestTool(tool)) {
                    toolTip.add(StringHelper.getLocalizedString("gui.toolstation14") + ToolPartHelper.getMiningSpeedString(mat.toolSpeed()));
                }
                if (!hasTool || ToolHelper.isWeaponTool(tool)) {
                    toolTip.add(StringHelper.getLocalizedString("gui.toolstation3") + ToolPartHelper.getAttackString(mat.attack()));
                }
            }
        }
        return toolTip;
    }

    private List<String> getPatternTooltip(ItemStack itemStack) {
        List<String> validMats = null;
        ArrayList<String> toolTip = new ArrayList<String>();
        if (PatternHelper.isBowstringPattern(itemStack.func_77973_b(), itemStack.func_77960_j())) {
            validMats = PatternHelper.getValidCustomMaterialsOfType(BowstringMaterial.class);
        } else if (PatternHelper.isFletchingPattern(itemStack.func_77973_b(), itemStack.func_77960_j())) {
            validMats = PatternHelper.getValidCustomMaterialsOfType(FletchingMaterial.class);
        }
        if (validMats != null && !validMats.isEmpty()) {
            toolTip.add(StatCollector.func_74838_a((String)"tictooltips.pattern.valid.materials"));
            for (String matName : validMats) {
                if (toolTip.size() < 7 || KeyHelper.isShiftKeyDown()) {
                    toolTip.add(" - " + matName);
                    continue;
                }
                toolTip.add(StatCollector.func_74837_a((String)"tictooltips.hold.key.for.more", (Object[])new Object[]{EnumChatFormatting.YELLOW.toString() + EnumChatFormatting.ITALIC + "Shift" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY}));
                break;
            }
        }
        return toolTip;
    }

    private List<String> getToolStatsTooltip(ItemStack itemStack) {
        boolean hasModifiers;
        int mineSpeed;
        String bonusOrLoss;
        int damage;
        ArrayList<String> toolTip = new ArrayList<String>();
        ToolCore tool = (ToolCore)itemStack.func_77973_b();
        NBTTagCompound toolTag = ToolHelper.getToolTag(itemStack);
        float shoddiness = ToolHelper.getStonebound(toolTag);
        boolean isShoddy = shoddiness != 0.0f;
        String shoddinessType = StringHelper.getShoddinessTypeString(shoddiness);
        ToolMaterial repairMat = ToolHelper.getHeadMaterial(toolTag);
        toolTip.add(StatCollector.func_74838_a((String)"tictooltips.tool.repair.material") + repairMat.style() + repairMat.displayName);
        int maxDurability = ToolHelper.getMaxDurability(toolTag);
        if (maxDurability > 0) {
            int curDurability = maxDurability - ToolHelper.getUsedDurability(toolTag);
            boolean isUnbreakable = ToolHelper.isUnbreakable(toolTag);
            int effectiveDurability = isUnbreakable ? -1 : ToolHelper.getEffectiveDurability(toolTag);
            String curOfMax = curDurability == maxDurability ? StringHelper.getDurabilityString(maxDurability) : StringHelper.getDurabilityString(curDurability) + " / " + StringHelper.getDurabilityString(maxDurability);
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation2") + ColorHelper.getRelativeColor(curDurability, 0.0, maxDurability) + curOfMax);
            if (maxDurability != effectiveDurability) {
                toolTip.add(StatCollector.func_74837_a((String)"tictooltips.tool.effective.durability", (Object[])new Object[]{StringHelper.getLocalizedString("gui.toolstation2")}) + ColorHelper.getRelativeColor(ToolHelper.getReinforcedLevel(toolTag), ToolPartHelper.minReinforcedLevel - 3, ToolPartHelper.maxReinforcedLevel) + StringHelper.getDurabilityString(effectiveDurability));
            }
        }
        if (isShoddy) {
            toolTip.add(StatCollector.func_74837_a((String)"tictooltips.tool.shoddiness.modifier", (Object[])new Object[]{shoddinessType}) + ToolPartHelper.getShoddinessString(shoddiness));
        }
        if (ToolHelper.isWeaponTool(tool)) {
            String bonusOrLoss2;
            EnumChatFormatting textColor;
            damage = ToolHelper.getDamage(tool, toolTag);
            float stoneboundDamage = ToolHelper.getShoddinessDamageBonus(toolTag);
            float maxStoneboundDamage = ToolHelper.getMaxShoddinessDamageBonus(toolTag);
            int[] smiteDamageRange = ToolHelper.getSmiteDamageRange(tool, toolTag);
            int[] antiSpiderDamageRange = ToolHelper.getAntiSpiderDamageRange(tool, toolTag);
            int burnDuration = ToolHelper.getBurnDuration(tool, toolTag);
            float chanceToBehead = ToolHelper.getChanceToBehead(tool, toolTag);
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation3") + ColorHelper.getRelativeColor((float)ToolHelper.getRawDamage(tool, toolTag) + stoneboundDamage, ToolPartHelper.minAttack, ToolPartHelper.maxAttack) + StringHelper.getDamageString(damage));
            if (stoneboundDamage != 0.0f) {
                textColor = stoneboundDamage > 0.0f ? EnumChatFormatting.DARK_GREEN : EnumChatFormatting.DARK_RED;
                bonusOrLoss2 = (stoneboundDamage > 0.0f ? StringHelper.getLocalizedString("gui.toolstation4") : StringHelper.getLocalizedString("gui.toolstation5")) + textColor;
                String maxString = "";
                if (stoneboundDamage == maxStoneboundDamage) {
                    bonusOrLoss2 = bonusOrLoss2 + EnumChatFormatting.BOLD;
                } else {
                    maxString = EnumChatFormatting.RESET + " " + EnumChatFormatting.DARK_GRAY + "[" + StatCollector.func_74838_a((String)"tictooltips.maximum") + ": " + StringHelper.getDamageNumberString((int)maxStoneboundDamage) + EnumChatFormatting.RESET + EnumChatFormatting.DARK_GRAY + "]";
                }
                toolTip.add(EnumChatFormatting.DARK_GRAY + "- " + shoddinessType + " " + bonusOrLoss2 + StringHelper.getDamageString((int)stoneboundDamage) + maxString);
            } else if (maxStoneboundDamage != 0.0f && stoneboundDamage != maxStoneboundDamage) {
                bonusOrLoss = maxStoneboundDamage > 0.0f ? StringHelper.getLocalizedString("gui.toolstation4") + EnumChatFormatting.DARK_GREEN : StringHelper.getLocalizedString("gui.toolstation5") + EnumChatFormatting.DARK_RED;
                toolTip.add(EnumChatFormatting.DARK_GRAY + "- " + StatCollector.func_74838_a((String)"tictooltips.maximum") + " " + shoddinessType + " " + bonusOrLoss + StringHelper.getDamageString((int)maxStoneboundDamage));
            }
            if (smiteDamageRange[1] != 0 && smiteDamageRange[0] != 0) {
                textColor = smiteDamageRange[0] >= 0 ? EnumChatFormatting.DARK_GREEN : EnumChatFormatting.DARK_RED;
                bonusOrLoss2 = smiteDamageRange[0] >= 0 ? StringHelper.getLocalizedString("gui.toolstation4") : StringHelper.getLocalizedString("gui.toolstation5");
                bonusOrLoss2 = bonusOrLoss2.substring(0, bonusOrLoss2.length() - 2);
                toolTip.add(EnumChatFormatting.DARK_GRAY + "- " + StatCollector.func_74837_a((String)"tictooltips.tool.bonus.vs.undead", (Object[])new Object[]{bonusOrLoss2}) + textColor + StringHelper.getDamageNumberString(smiteDamageRange[0]) + "-" + StringHelper.getDamageString(smiteDamageRange[1]));
            }
            if (antiSpiderDamageRange[1] != 0 && antiSpiderDamageRange[0] != 0) {
                textColor = antiSpiderDamageRange[0] >= 0 ? EnumChatFormatting.DARK_GREEN : EnumChatFormatting.DARK_RED;
                bonusOrLoss2 = antiSpiderDamageRange[0] >= 0 ? StringHelper.getLocalizedString("gui.toolstation4") : StringHelper.getLocalizedString("gui.toolstation5");
                bonusOrLoss2 = bonusOrLoss2.substring(0, bonusOrLoss2.length() - 2);
                toolTip.add(EnumChatFormatting.DARK_GRAY + "- " + StatCollector.func_74837_a((String)"tictooltips.tool.bonus.vs.spiders", (Object[])new Object[]{bonusOrLoss2}) + textColor + StringHelper.getDamageNumberString(antiSpiderDamageRange[0]) + "-" + StringHelper.getDamageString(antiSpiderDamageRange[1]));
            }
            if (burnDuration != 0) {
                textColor = EnumChatFormatting.DARK_RED;
                toolTip.add(EnumChatFormatting.DARK_GRAY + "- " + StatCollector.func_74838_a((String)"tictooltips.tool.burn.duration") + textColor + StringHelper.getDurationString(burnDuration));
            }
            if (chanceToBehead != 0.0f) {
                toolTip.add(EnumChatFormatting.DARK_GRAY + "- " + StatCollector.func_74838_a((String)"tictooltips.tool.chance.to.behead") + ColorHelper.getRelativeColor(chanceToBehead, 0.0, 1.0) + StringHelper.getPercentageString(chanceToBehead));
            }
        }
        if (ToolHelper.isBowTool(tool)) {
            int drawSpeed = ToolHelper.getDrawSpeed(toolTag);
            float arrowSpeedModifier = ToolHelper.getArrowSpeedModifier(toolTag);
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation6") + ToolPartHelper.getBowDrawSpeedString(drawSpeed));
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation7") + ToolPartHelper.getBowArrowSpeedModifierString(arrowSpeedModifier));
        }
        if (ToolHelper.isAmmoTool(tool)) {
            damage = ToolHelper.getAmmoDamage(toolTag);
            float weight = ToolHelper.getWeight(toolTag);
            float accuracy = ToolHelper.getAccuracy(toolTag);
            String damageColor = ColorHelper.getRelativeColor(ToolHelper.getRawDamage(tool, toolTag), ToolPartHelper.minAttack, ToolPartHelper.maxAttack);
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation10") + " " + damageColor + StringHelper.getDamageString(damage));
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation11") + " " + damageColor + StringHelper.getAmmoDamageRangeString(damage));
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation8") + ToolPartHelper.getWeightString(weight));
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation9") + ToolPartHelper.getAccuracyString(accuracy));
        }
        if (ToolHelper.isDualHarvestTool(tool)) {
            int mineSpeed1 = ToolHelper.getPrimaryMiningSpeed(tool, toolTag);
            int mineSpeed2 = ToolHelper.getSecondaryMiningSpeed(tool, toolTag);
            float stoneboundSpeed = ToolHelper.getShoddinessSpeedBonus(tool, toolTag);
            float maxStoneboundSpeed = ToolHelper.getMaxShoddinessSpeedBonus(tool, toolTag);
            mineSpeed1 = (int)((float)mineSpeed1 + stoneboundSpeed * 100.0f);
            mineSpeed2 = (int)((float)mineSpeed2 + stoneboundSpeed * 100.0f);
            int harvestLevel1 = ToolHelper.getPrimaryHarvestLevel(toolTag);
            int harvestLevel2 = ToolHelper.getSecondaryHarvestLevel(toolTag);
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation12") + ToolPartHelper.getMiningSpeedString(mineSpeed1) + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + ", " + ToolPartHelper.getMiningSpeedString(mineSpeed2));
            if (stoneboundSpeed != 0.0f) {
                EnumChatFormatting textColor = stoneboundSpeed > 0.0f ? EnumChatFormatting.DARK_GREEN : EnumChatFormatting.DARK_RED;
                bonusOrLoss = (stoneboundSpeed > 0.0f ? StringHelper.getLocalizedString("gui.toolstation4") : StringHelper.getLocalizedString("gui.toolstation5")) + textColor;
                String maxString = "";
                if (stoneboundSpeed == maxStoneboundSpeed) {
                    bonusOrLoss = bonusOrLoss + EnumChatFormatting.BOLD;
                } else {
                    maxString = EnumChatFormatting.RESET + " " + EnumChatFormatting.DARK_GRAY + "[" + StatCollector.func_74838_a((String)"tictooltips.maximum") + ": " + StringHelper.getSpeedString((int)(maxStoneboundSpeed * 100.0f)) + EnumChatFormatting.RESET + EnumChatFormatting.DARK_GRAY + "]";
                }
                toolTip.add(EnumChatFormatting.DARK_GRAY + "- " + shoddinessType + " " + bonusOrLoss + StringHelper.getSpeedString((int)(stoneboundSpeed * 100.0f)) + maxString);
            } else if (maxStoneboundSpeed != 0.0f && stoneboundSpeed != maxStoneboundSpeed) {
                String bonusOrLoss3 = maxStoneboundSpeed > 0.0f ? StringHelper.getLocalizedString("gui.toolstation4") + EnumChatFormatting.DARK_GREEN : StringHelper.getLocalizedString("gui.toolstation5") + EnumChatFormatting.DARK_RED;
                toolTip.add(EnumChatFormatting.DARK_GRAY + "- " + StatCollector.func_74838_a((String)"tictooltips.maximum") + " " + shoddinessType + " " + bonusOrLoss3 + StringHelper.getSpeedString((int)(maxStoneboundSpeed * 100.0f)));
            }
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation13") + " " + ToolPartHelper.getHarvestLevelString(harvestLevel1) + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + ", " + ToolPartHelper.getHarvestLevelString(harvestLevel2));
        } else if (ToolHelper.isHarvestTool(tool)) {
            mineSpeed = ToolHelper.getTotalMiningSpeed(tool, toolTag);
            float stoneboundSpeed = ToolHelper.getShoddinessSpeedBonus(tool, toolTag);
            float maxStoneboundSpeed = ToolHelper.getMaxShoddinessSpeedBonus(tool, toolTag);
            mineSpeed = (int)((float)mineSpeed + stoneboundSpeed * 100.0f);
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation14") + ToolPartHelper.getMiningSpeedString(mineSpeed));
            if (stoneboundSpeed != 0.0f) {
                EnumChatFormatting textColor = stoneboundSpeed > 0.0f ? EnumChatFormatting.DARK_GREEN : EnumChatFormatting.DARK_RED;
                String bonusOrLoss4 = (stoneboundSpeed > 0.0f ? StringHelper.getLocalizedString("gui.toolstation4") : StringHelper.getLocalizedString("gui.toolstation5")) + textColor;
                String maxString = "";
                if (stoneboundSpeed == maxStoneboundSpeed) {
                    bonusOrLoss4 = bonusOrLoss4 + EnumChatFormatting.BOLD;
                } else {
                    maxString = EnumChatFormatting.RESET + " " + EnumChatFormatting.DARK_GRAY + "[" + StatCollector.func_74838_a((String)"tictooltips.maximum") + ": " + StringHelper.getSpeedString((int)(maxStoneboundSpeed * 100.0f)) + EnumChatFormatting.RESET + EnumChatFormatting.DARK_GRAY + "]";
                }
                toolTip.add(EnumChatFormatting.DARK_GRAY + "- " + shoddinessType + " " + bonusOrLoss4 + StringHelper.getSpeedString((int)(stoneboundSpeed * 100.0f)) + maxString);
            } else if (maxStoneboundSpeed != 0.0f && stoneboundSpeed != maxStoneboundSpeed) {
                String bonusOrLoss5 = maxStoneboundSpeed > 0.0f ? StringHelper.getLocalizedString("gui.toolstation4") + EnumChatFormatting.DARK_GREEN : StringHelper.getLocalizedString("gui.toolstation5") + EnumChatFormatting.DARK_RED;
                toolTip.add(EnumChatFormatting.DARK_GRAY + "- " + StatCollector.func_74838_a((String)"tictooltips.maximum") + " " + shoddinessType + " " + bonusOrLoss5 + StringHelper.getSpeedString((int)(maxStoneboundSpeed * 100.0f)));
            }
            if (!ModTiCTooltips.hasIguanaTweaks) {
                int harvestLevel = ToolHelper.getPrimaryHarvestLevel(toolTag);
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation15") + ToolPartHelper.getHarvestLevelString(harvestLevel));
            }
        } else if (ToolHelper.isUtilityTool(tool)) {
            mineSpeed = ToolHelper.getPrimaryMiningSpeed(tool, toolTag);
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation16") + ToolPartHelper.getMiningSpeedString(mineSpeed));
        }
        int modifiersAvailable = toolTag.func_74762_e("Modifiers");
        if (modifiersAvailable > 0) {
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation18") + EnumChatFormatting.WHITE + modifiersAvailable);
        }
        boolean bl = hasModifiers = toolTag.func_74764_b("ModifierTip1") && !toolTag.func_74779_i("ModifierTip1").trim().equals("");
        if (hasModifiers) {
            toolTip.add(StatCollector.func_74838_a((String)"gui.toolstation17") + ":");
        }
        boolean displayToolTips = true;
        int tipNum = 0;
        while (hasModifiers && displayToolTips) {
            String tooltip = "ModifierTip" + ++tipNum;
            if (toolTag.func_74764_b(tooltip)) {
                String tipName = toolTag.func_74779_i(tooltip);
                if (tipName.trim().equals("")) continue;
                toolTip.add(EnumChatFormatting.DARK_GRAY + "- " + tipName);
                continue;
            }
            displayToolTips = false;
        }
        return toolTip;
    }

    private List<String> getToolMaterialsTooltip(ItemStack itemStack) {
        int matID;
        ArrayList<String> toolTip = new ArrayList<String>();
        ToolCore tool = (ToolCore)itemStack.func_77973_b();
        NBTTagCompound toolTag = ToolHelper.getToolTag(itemStack);
        Item itemPart = tool.getHeadItem();
        if (itemPart != null) {
            matID = toolTag.func_74762_e("Head");
            toolTip.addAll(this.getToolPartTooltip(itemPart, matID, tool));
            toolTip.add("");
        }
        if ((itemPart = tool.getAccessoryItem()) != null) {
            matID = toolTag.func_74762_e("Accessory");
            toolTip.addAll(this.getToolPartTooltip(itemPart, matID, tool));
            toolTip.add("");
        }
        if ((itemPart = tool.getExtraItem()) != null) {
            matID = toolTag.func_74762_e("Extra");
            toolTip.addAll(this.getToolPartTooltip(itemPart, matID, tool));
            toolTip.add("");
        }
        if ((itemPart = tool.getHandleItem()) != null) {
            matID = toolTag.func_74762_e("Handle");
            toolTip.addAll(this.getToolPartTooltip(itemPart, matID, tool));
        }
        return toolTip;
    }

    private List<String> getToolPartTooltip(Item itemPart, int matID, ToolCore tool) {
        ArrayList<String> toolTip = new ArrayList<String>();
        if (itemPart instanceof ToolPart) {
            ToolPart part = (ToolPart)itemPart;
            ToolMaterial mat = TConstructRegistry.getMaterial((int)matID);
            toolTip.add(mat.style() + EnumChatFormatting.UNDERLINE + StringHelper.getLocalizedString("toolpart." + part.partName).replaceAll("%%material", mat.displayName.trim()));
        } else if (itemPart instanceof Bowstring) {
            Bowstring bowstring = (Bowstring)itemPart;
            ItemStack tempStack = new ItemStack((Item)bowstring, 1, matID);
            toolTip.add(EnumChatFormatting.UNDERLINE + tempStack.func_82833_r());
        } else if (itemPart instanceof Fletching) {
            Fletching fletching = (Fletching)itemPart;
            ItemStack tempStack = new ItemStack((Item)fletching, 1, matID);
            toolTip.add(EnumChatFormatting.UNDERLINE + tempStack.func_82833_r());
        } else {
            toolTip.add(EnumChatFormatting.WHITE.toString() + EnumChatFormatting.UNDERLINE + StatCollector.func_74838_a((String)"tictooltips.unknown.part"));
        }
        List<String> partStats = this.getMaterialTooltip(matID, itemPart, tool);
        toolTip.addAll(partStats);
        return toolTip;
    }

    private List<String> getArmorStatsTooltip(ItemStack itemStack) {
        ArrayList<String> toolTip = new ArrayList<String>();
        NBTTagCompound armorTag = ArmorHelper.getArmorTag(itemStack);
        int modifiersAvailable = armorTag.func_74762_e("Modifiers");
        toolTip.add(StringHelper.getLocalizedString("gui.toolstation18") + EnumChatFormatting.WHITE + modifiersAvailable);
        return toolTip;
    }
}

